/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.cmd;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.HistoryService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntityImpl;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ChangeActivityStateBuilder;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.variable.api.history.HistoricVariableInstance;

public class RestartProcessInstanceCmd
implements Command<ProcessInstance> {
    protected String processInstanceId;
    protected List<String> activityIds;
    protected Map<String, String> variableMap;

    public ProcessInstance execute(CommandContext commandContext) {
        ProcessEngineConfigurationImpl engineConfig = CommandContextUtil.getProcessEngineConfiguration((CommandContext)commandContext);
        HistoryService historyService = engineConfig.getHistoryService();
        HistoricProcessInstance historicProcessInstance = this.checkAndGetHistoricProcessInstance(historyService);
        this.checkActivityIds(historicProcessInstance.getProcessDefinitionId());
        ProcessDefinition processDefinition = ProcessDefinitionUtil.getProcessDefinition((String)historicProcessInstance.getProcessDefinitionId());
        if (processDefinition == null) {
            throw new FlowableException("\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728");
        }
        Process process = ProcessDefinitionUtil.getProcess((String)processDefinition.getId());
        StartEvent initialFlowElement = (StartEvent)process.getInitialFlowElement();
        ExecutionEntity processInstance = this.recreateProcessInstance(processDefinition, initialFlowElement, historicProcessInstance);
        ExecutionEntity childExecution = CommandContextUtil.getExecutionEntityManager().createChildExecution(processInstance);
        childExecution.setCurrentFlowElement((FlowElement)initialFlowElement);
        ((HistoricProcessInstanceEntityImpl)historicProcessInstance).setEndActivityId(null);
        ((HistoricProcessInstanceEntityImpl)historicProcessInstance).setEndTime(null);
        Map<String, Object> gloablVariables = this.collectVariables(historyService, historicProcessInstance);
        ChangeActivityStateBuilder builder = engineConfig.getRuntimeService().createChangeActivityStateBuilder().processInstanceId(processInstance.getProcessInstanceId()).moveSingleExecutionToActivityIds(childExecution.getId(), this.activityIds).processVariables(gloablVariables);
        for (String activityId : this.activityIds) {
            String variableData = this.variableMap.get(activityId);
            if (!StrUtil.isNotBlank((CharSequence)variableData)) continue;
            builder.localVariables(activityId, (Map)JSON.parseObject((String)variableData));
        }
        builder.changeState();
        return (ProcessInstance)engineConfig.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
    }

    private HistoricProcessInstance checkAndGetHistoricProcessInstance(HistoryService historyService) {
        if (StrUtil.isBlank((CharSequence)this.processInstanceId)) {
            throw new FlowableIllegalArgumentException("processInstanceId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            throw new FlowableException("id\u4e3a" + this.processInstanceId + "\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        if (historicProcessInstance.getEndTime() == null) {
            throw new FlowableException("id\u4e3a" + this.processInstanceId + "\u7684\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u7ed3\u675f");
        }
        return historicProcessInstance;
    }

    private void checkActivityIds(String processDefinitionId) {
        if (CollUtil.isEmpty(this.activityIds)) {
            throw new FlowableIllegalArgumentException("activityIds\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)processDefinitionId);
        ArrayList<String> notExistedFlowElements = new ArrayList<String>();
        for (String activityId : this.activityIds) {
            if (bpmnModel.getMainProcess().containsFlowElementId(activityId)) continue;
            notExistedFlowElements.add(activityId);
        }
        if (!CollUtil.isEmpty(notExistedFlowElements)) {
            throw new FlowableIllegalArgumentException("Id\u4e3a" + String.join((CharSequence)"\u3001", notExistedFlowElements) + "\u8282\u70b9\u4e0d\u5b58\u5728");
        }
    }

    private ExecutionEntity recreateProcessInstance(ProcessDefinition processDefinition, StartEvent initialFlowElement, HistoricProcessInstance historicProcessInstance) {
        ExecutionEntity executionEntity = CommandContextUtil.getExecutionEntityManager().createProcessInstanceExecution(processDefinition, historicProcessInstance.getId(), historicProcessInstance.getBusinessKey(), historicProcessInstance.getBusinessStatus(), historicProcessInstance.getName(), historicProcessInstance.getCallbackId(), historicProcessInstance.getCallbackType(), historicProcessInstance.getReferenceId(), historicProcessInstance.getReferenceType(), null, historicProcessInstance.getTenantId(), initialFlowElement.getInitiator(), historicProcessInstance.getStartActivityId());
        executionEntity.setStartTime(historicProcessInstance.getStartTime());
        return executionEntity;
    }

    private Map<String, Object> collectVariables(HistoryService historyService, HistoricProcessInstance historicProcessInstance) {
        HashMap<String, Object> variables = new HashMap<String, Object>(10);
        List historicVariables = historyService.createHistoricVariableInstanceQuery().processInstanceId(historicProcessInstance.getId()).executionId(historicProcessInstance.getId()).list();
        for (HistoricVariableInstance historicVariable : historicVariables) {
            variables.put(historicVariable.getVariableName(), historicVariable.getValue());
        }
        return variables;
    }

    public RestartProcessInstanceCmd(String processInstanceId, List<String> activityIds, Map<String, String> variableMap) {
        this.processInstanceId = processInstanceId;
        this.activityIds = activityIds;
        this.variableMap = variableMap;
    }
}

