/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.DisableDataFilter;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.controller.FlowOperationController;
import com.dic.bid.common.flow.dto.FlowTaskCommentDto;
import com.dic.bid.common.flow.dto.FlowWorkOrderDto;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.service.FlowApiOperationService;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.FlowOperationHelper;
import com.dic.bid.common.flow.vo.FlowTaskVo;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.github.pagehelper.page.PageMethod;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u4ec5\u4f9bAPI\u8c03\u7528\u7684\u5de5\u4f5c\u6d41\u6d41\u7a0b\u64cd\u4f5c\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/api/flowOperation"})
public class FlowApiOperationController
extends FlowOperationController {
    private static final Logger log = LoggerFactory.getLogger(FlowApiOperationController.class);
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowOperationHelper flowOperationHelper;
    @Autowired
    private FlowApiOperationService flowApiOperationService;

    @DisableDataFilter
    @OperationLog(type=100)
    @PostMapping(value={"/start/{processDefinitionKey}"})
    public ResponseResult<FlowWorkOrderVo> start(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody FlowTaskCommentDto flowTaskCommentDto, @MyRequestBody JSONObject taskVariableData, @MyRequestBody(required=true) String dataId, @MyRequestBody(required=true) Boolean takeFirstTask, @MyRequestBody JSONObject copyData) {
        FlowWorkOrder flowWorkOrder;
        ResponseResult<FlowEntry> flowEntryResult = this.flowOperationHelper.verifyFullAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        if (this.flowWorkOrderService.existUnfinished(processDefinitionKey, dataId)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.FLOW_WORK_ORDER_EXIST);
        }
        String processDefinitionId = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish().getProcessDefinitionId();
        if (MapUtil.isNotEmpty((Map)copyData)) {
            if (taskVariableData == null) {
                taskVariableData = new JSONObject();
            }
            taskVariableData.put("copyDataKey", (Object)copyData);
        }
        if (BooleanUtil.isTrue((Boolean)takeFirstTask)) {
            FlowTaskComment comment = (FlowTaskComment)MyModelUtil.copyTo((Object)flowTaskCommentDto, FlowTaskComment.class);
            flowWorkOrder = this.flowApiOperationService.startAndTakeFirst(processDefinitionId, dataId, comment, taskVariableData);
        } else {
            flowWorkOrder = this.flowApiOperationService.startWithBusinessKey(processDefinitionId, dataId, taskVariableData);
        }
        FlowWorkOrderVo workOrderVo = (FlowWorkOrderVo)MyModelUtil.copyTo((Object)flowWorkOrder, FlowWorkOrderVo.class);
        return ResponseResult.success((Object)workOrderVo);
    }

    @DisableDataFilter
    @OperationLog(type=100)
    @PostMapping(value={"/startAndSaveDraft/{processDefinitionKey}"})
    public ResponseResult<FlowTaskVo> startAndSaveDraft(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody String processInstanceId, @MyRequestBody String dataId, @MyRequestBody String masterData, @MyRequestBody String slaveData) {
        FlowWorkOrder flowWorkOrder;
        ResponseResult<FlowEntry> flowEntryResult = this.flowOperationHelper.verifyFullAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        if (this.flowWorkOrderService.existUnfinished(processDefinitionKey, dataId)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.FLOW_WORK_ORDER_EXIST);
        }
        if (processInstanceId == null) {
            String processDefinitionId = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish().getProcessDefinitionId();
            flowWorkOrder = this.flowApiOperationService.startAndSaveNewDraft(processDefinitionId, dataId, masterData, slaveData);
        } else {
            ResponseResult<FlowWorkOrder> flowWorkOrderResult = this.flowOperationHelper.verifyAndGetFlowWorkOrderWithDraft(processDefinitionKey, processInstanceId);
            if (!flowWorkOrderResult.isSuccess()) {
                return ResponseResult.errorFrom(flowEntryResult);
            }
            flowWorkOrder = (FlowWorkOrder)flowWorkOrderResult.getData();
            this.flowWorkOrderService.updateDraft(flowWorkOrder.getWorkOrderId(), masterData, slaveData);
        }
        List<Task> taskList = this.flowApiService.getProcessInstanceActiveTaskList(flowWorkOrder.getProcessInstanceId());
        List<FlowTaskVo> flowTaskVoList = this.flowApiService.convertToFlowTaskList(taskList);
        return ResponseResult.success((Object)flowTaskVoList.get(0));
    }

    @DisableDataFilter
    @OperationLog(type=120)
    @PostMapping(value={"/submitUserTask/{processDefinitionKey}"})
    public ResponseResult<Void> submitUserTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) FlowTaskCommentDto flowTaskCommentDto, @MyRequestBody JSONObject taskVariableData, @MyRequestBody JSONObject copyData) {
        ResponseResult<Task> taskResult = this.flowOperationHelper.verifySubmitAndGetTask(processInstanceId, taskId, flowTaskCommentDto);
        if (!taskResult.isSuccess()) {
            return ResponseResult.errorFrom(taskResult);
        }
        Task task = (Task)taskResult.getData();
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        if (!StrUtil.equals((CharSequence)instance.getProcessDefinitionKey(), (CharSequence)processDefinitionKey)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u6d41\u7a0b\u6807\u8bc6\u4e0e\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowTaskComment flowTaskComment = (FlowTaskComment)MyModelUtil.copyTo((Object)flowTaskCommentDto, FlowTaskComment.class);
        boolean forUpdate = StrUtil.isNotBlank((CharSequence)instance.getBusinessKey());
        if (MapUtil.isNotEmpty((Map)copyData)) {
            if (taskVariableData == null) {
                taskVariableData = new JSONObject();
            }
            taskVariableData.put("copyDataKey", (Object)copyData);
        }
        if (!forUpdate) {
            this.flowApiOperationService.takeFirstTask(instance, task, flowTaskComment, taskVariableData);
        } else {
            this.flowApiOperationService.takeTask(instance, task, flowTaskComment, taskVariableData);
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/listWorkOrder/{processDefinitionKey}"})
    public ResponseResult<MyPageData<FlowWorkOrderVo>> listWorkOrder(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody FlowWorkOrderDto flowWorkOrderDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        String orderBy;
        FlowWorkOrder flowWorkOrderFilter;
        List<FlowWorkOrder> flowWorkOrderList;
        MyPageData resultData;
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize());
        }
        if (CollUtil.isEmpty((Collection)(resultData = MyPageUtil.makeResponseData(flowWorkOrderList = this.flowWorkOrderService.getFlowWorkOrderList(flowWorkOrderFilter = this.flowOperationHelper.makeWorkOrderFilter(flowWorkOrderDtoFilter, processDefinitionKey), orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowWorkOrder.class)), FlowWorkOrderVo.class)).getDataList())) {
            return ResponseResult.success((Object)resultData);
        }
        this.flowOperationHelper.buildWorkOrderApprovalStatus(processDefinitionKey, resultData.getDataList());
        this.flowOperationHelper.buildWorkOrderTaskInfo(resultData.getDataList());
        List<FlowWorkOrderVo> draftWorkOrderList = resultData.getDataList().stream().filter(c -> c.getFlowStatus().equals(FlowTaskStatus.DRAFT)).collect(Collectors.toList());
        this.flowApiOperationService.buildDraftData(draftWorkOrderList);
        return ResponseResult.success((Object)resultData);
    }

    @PostMapping(value={"/rejectToStartUserTask/{processDefinitionKey}"})
    public ResponseResult<FlowWorkOrderVo> rejectToStartUserTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody JSONObject taskVariableData) {
        ResponseResult<Void> responseResult = super.rejectToStartUserTask(processInstanceId, taskId, taskComment, taskVariableData);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        return this.createResponseResultWithFlowWorkOrder(processInstanceId);
    }

    @PostMapping(value={"/rejectRuntimeTask/{processDefinitionKey}"})
    public ResponseResult<FlowWorkOrderVo> rejectRuntimeTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody String targetTaskKey, @MyRequestBody JSONObject taskVariableData) {
        ResponseResult<Void> responseResult = super.rejectRuntimeTask(processInstanceId, taskId, taskComment, targetTaskKey, taskVariableData);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        return this.createResponseResultWithFlowWorkOrder(processInstanceId);
    }

    @PostMapping(value={"/revokeHistoricTask/{processDefinitionKey}"})
    public ResponseResult<FlowWorkOrderVo> revokeHistoricTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey, @MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody JSONObject taskVariableData) {
        ResponseResult<Void> responseResult = super.revokeHistoricTask(processInstanceId, taskId, taskComment, taskVariableData);
        if (!responseResult.isSuccess()) {
            return ResponseResult.errorFrom(responseResult);
        }
        return this.createResponseResultWithFlowWorkOrder(processInstanceId);
    }

    private ResponseResult<FlowWorkOrderVo> createResponseResultWithFlowWorkOrder(String processInstanceId) {
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(processInstanceId);
        return ResponseResult.success((Object)MyModelUtil.copyTo((Object)flowWorkOrder, FlowWorkOrderVo.class));
    }
}

