/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.MyCommonUtil;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.core.validator.UpdateGroup;
import com.dic.bid.common.flow.dto.FlowCategoryDto;
import com.dic.bid.common.flow.model.FlowCategory;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.service.FlowCategoryService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.vo.FlowCategoryVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.github.pagehelper.page.PageMethod;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5206\u7c7b\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowCategory"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowCategoryController {
    private static final Logger log = LoggerFactory.getLogger(FlowCategoryController.class);
    @Autowired
    private FlowCategoryService flowCategoryService;
    @Autowired
    private FlowEntryService flowEntryService;

    @ApiOperationSupport(ignoreParameters={"flowCategoryDto.categoryId"})
    @SaCheckPermission(value={"flowCategory.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody FlowCategoryDto flowCategoryDto) {
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowCategoryDto, (Class[])new Class[0]);
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowCategory flowCategory = (FlowCategory)MyModelUtil.copyTo((Object)flowCategoryDto, FlowCategory.class);
        if (this.flowCategoryService.existByCode(flowCategory.getCode())) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DUPLICATED_UNIQUE_KEY, (String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5206\u7c7b\u5df2\u7ecf\u5b58\u5728\uff01");
        }
        flowCategory = this.flowCategoryService.saveNew(flowCategory);
        return ResponseResult.success((Object)flowCategory.getCategoryId());
    }

    @SaCheckPermission(value={"flowCategory.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody FlowCategoryDto flowCategoryDto) {
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowCategoryDto, (Class[])new Class[]{Default.class, UpdateGroup.class});
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowCategory flowCategory = (FlowCategory)MyModelUtil.copyTo((Object)flowCategoryDto, FlowCategory.class);
        ResponseResult<FlowCategory> verifyResult = this.doVerifyAndGet(flowCategory.getCategoryId());
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowCategory originalFlowCategory = (FlowCategory)verifyResult.getData();
        if (!StrUtil.equals((CharSequence)flowCategory.getCode(), (CharSequence)originalFlowCategory.getCode())) {
            FlowEntry filter = new FlowEntry();
            filter.setCategoryId(flowCategory.getCategoryId());
            filter.setStatus(1);
            List flowEntryList = this.flowEntryService.getListByFilter(filter);
            if (CollUtil.isNotEmpty((Collection)flowEntryList)) {
                errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5206\u7c7b\u5b58\u5728\u5df2\u7ecf\u53d1\u5e03\u7684\u6d41\u7a0b\u6570\u636e\uff0c\u56e0\u6b64\u5206\u7c7b\u6807\u8bc6\u4e0d\u80fd\u4fee\u6539\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            if (this.flowCategoryService.existByCode(flowCategory.getCode())) {
                errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5206\u7c7b\u5df2\u7ecf\u5b58\u5728\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DUPLICATED_UNIQUE_KEY, (String)errorMessage);
            }
        }
        if (!this.flowCategoryService.update(flowCategory, originalFlowCategory)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowCategory.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long categoryId) {
        ResponseResult<FlowCategory> verifyResult = this.doVerifyAndGet(categoryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry filter = new FlowEntry();
        filter.setCategoryId(categoryId);
        List flowEntryList = this.flowEntryService.getListByFilter(filter);
        if (CollUtil.isNotEmpty((Collection)flowEntryList)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u5148\u5220\u9664\u5f53\u524d\u6d41\u7a0b\u5206\u7c7b\u5173\u8054\u7684\u6d41\u7a0b\u6570\u636e\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowCategoryService.remove(categoryId)) {
            String errorMessage = "\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u5220\u9664\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowCategory.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<FlowCategoryVo>> list(@MyRequestBody FlowCategoryDto flowCategoryDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize());
        }
        FlowCategory flowCategoryFilter = (FlowCategory)MyModelUtil.copyTo((Object)flowCategoryDtoFilter, FlowCategory.class);
        String orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowCategory.class);
        List<FlowCategory> flowCategoryList = this.flowCategoryService.getFlowCategoryListWithRelation(flowCategoryFilter, orderBy);
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowCategoryList, FlowCategoryVo.class));
    }

    @SaCheckPermission(value={"flowCategory.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<FlowCategoryVo> view(@RequestParam Long categoryId) {
        ResponseResult<FlowCategory> verifyResult = this.doVerifyAndGet(categoryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        return ResponseResult.success((Object)verifyResult.getData(), FlowCategoryVo.class);
    }

    @GetMapping(value={"/listDict"})
    public ResponseResult<List<Map<String, Object>>> listDict(@ParameterObject FlowCategoryDto filter) {
        List<FlowCategory> resultList = this.flowCategoryService.getFlowCategoryList((FlowCategory)MyModelUtil.copyTo((Object)filter, FlowCategory.class), null);
        return ResponseResult.success((Object)MyCommonUtil.toDictDataList(resultList, FlowCategory::getCategoryId, FlowCategory::getName));
    }

    @GetMapping(value={"/listDictByIds"})
    public ResponseResult<List<Map<String, Object>>> listDictByIds(@RequestParam List<Long> dictIds) {
        List resultList = this.flowCategoryService.getInList(new HashSet<Long>(dictIds));
        return ResponseResult.success((Object)MyCommonUtil.toDictDataList((Collection)resultList, FlowCategory::getCategoryId, FlowCategory::getName));
    }

    private ResponseResult<FlowCategory> doVerifyAndGet(Long categoryId) {
        if (MyCommonUtil.existBlankArgument((Object[])new Object[]{categoryId})) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.ARGUMENT_NULL_EXIST);
        }
        FlowCategory flowCategory = (FlowCategory)this.flowCategoryService.getById(categoryId);
        if (flowCategory == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        TokenData tokenData = TokenData.takeFromRequest();
        if (!StrUtil.equals((CharSequence)flowCategory.getAppCode(), (CharSequence)tokenData.getAppCode())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u5e76\u4e0d\u5b58\u5728\u8be5\u6d41\u7a0b\u5206\u7c7b\u7684\u5b9a\u4e49\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (ObjectUtil.notEqual((Object)flowCategory.getTenantId(), (Object)tokenData.getTenantId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u79df\u6237\u5e76\u4e0d\u5b58\u5728\u8be5\u6d41\u7a0b\u5206\u7c7b\u7684\u5b9a\u4e49\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)flowCategory);
    }
}

