/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.MyCommonUtil;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.core.validator.UpdateGroup;
import com.dic.bid.common.flow.dto.FlowEntryDto;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowCategoryService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowEntryVariableService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.vo.FlowEntryPublishVo;
import com.dic.bid.common.flow.vo.FlowEntryVo;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.github.pagehelper.page.PageMethod;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.groups.Default;
import javax.xml.stream.XMLStreamException;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.UserTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u6d41\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowEntry"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowEntryController {
    private static final Logger log = LoggerFactory.getLogger(FlowEntryController.class);
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private FlowCategoryService flowCategoryService;
    @Autowired
    private FlowEntryVariableService flowEntryVariableService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowTaskExtService flowTaskExtService;

    @ApiOperationSupport(ignoreParameters={"flowEntryDto.entryId"})
    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody FlowEntryDto flowEntryDto) {
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowEntryDto, (Class[])new Class[0]);
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntry flowEntry = (FlowEntry)MyModelUtil.copyTo((Object)flowEntryDto, FlowEntry.class);
        if (this.flowEntryService.existByProcessDefinitionKey(flowEntry.getProcessDefinitionKey())) {
            errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5b9a\u4e49\u6807\u8bc6\u5df2\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        CallResult callResult = this.flowEntryService.verifyRelatedData(flowEntry, null);
        if (!callResult.isSuccess()) {
            errorMessage = callResult.getErrorMessage();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        flowEntry = this.flowEntryService.saveNew(flowEntry);
        return ResponseResult.success((Object)flowEntry.getEntryId());
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody FlowEntryDto flowEntryDto) {
        CallResult callResult;
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowEntryDto, (Class[])new Class[]{Default.class, UpdateGroup.class});
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntry flowEntry = (FlowEntry)MyModelUtil.copyTo((Object)flowEntryDto, FlowEntry.class);
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(flowEntry.getEntryId());
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry originalFlowEntry = (FlowEntry)verifyResult.getData();
        if (ObjectUtil.notEqual((Object)flowEntry.getProcessDefinitionKey(), (Object)originalFlowEntry.getProcessDefinitionKey())) {
            if (originalFlowEntry.getStatus().equals(1)) {
                errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u4e3a\u53d1\u5e03\u72b6\u6001\uff0c\u6d41\u7a0b\u6807\u8bc6\u4e0d\u80fd\u4fee\u6539\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            if (this.flowEntryService.existByProcessDefinitionKey(flowEntry.getProcessDefinitionKey())) {
                errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5b9a\u4e49\u6807\u8bc6\u5df2\u5b58\u5728\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        }
        if (!(callResult = this.flowEntryService.verifyRelatedData(flowEntry, originalFlowEntry)).isSuccess()) {
            errorMessage = callResult.getErrorMessage();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowEntryService.update(flowEntry, originalFlowEntry)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long entryId) {
        if (MyCommonUtil.existBlankArgument((Object[])new Object[]{entryId})) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.ARGUMENT_NULL_EXIST);
        }
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry originalFlowEntry = (FlowEntry)verifyResult.getData();
        if (originalFlowEntry.getStatus().equals(1)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u4e3a\u53d1\u5e03\u72b6\u6001\uff0c\u4e0d\u80fd\u5220\u9664\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowEntryService.remove(entryId)) {
            String errorMessage = "\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u5220\u9664\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=65)
    @PostMapping(value={"/publish"})
    public ResponseResult<Void> publish(@MyRequestBody(required=true) Long entryId) throws XMLStreamException {
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry flowEntry = (FlowEntry)verifyResult.getData();
        if (StrUtil.isBlank((CharSequence)flowEntry.getBpmnXml())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u6ca1\u6709\u6d41\u7a0b\u56fe\u4e0d\u80fd\u88ab\u53d1\u5e03\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        ResponseResult<TaskInfoVo> taskInfoResult = this.verifyAndGetInitialTaskInfo(flowEntry);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        String taskInfo = taskInfoResult.getData() == null ? null : JSON.toJSONString((Object)taskInfoResult.getData());
        this.flowEntryService.publish(flowEntry, taskInfo);
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<FlowEntryVo>> list(@MyRequestBody FlowEntryDto flowEntryDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize());
        }
        FlowEntry flowEntryFilter = (FlowEntry)MyModelUtil.copyTo((Object)flowEntryDtoFilter, FlowEntry.class);
        String orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowEntry.class);
        List<FlowEntry> flowEntryList = this.flowEntryService.getFlowEntryListWithRelation(flowEntryFilter, orderBy);
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowEntryList, FlowEntryVo.class));
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<FlowEntryVo> view(@RequestParam Long entryId) {
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry flowEntry = (FlowEntry)this.flowEntryService.getByIdWithRelation(entryId, MyRelationParam.full());
        if (flowEntry == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success((Object)flowEntry, FlowEntryVo.class);
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @GetMapping(value={"/listFlowEntryPublish"})
    public ResponseResult<List<FlowEntryPublishVo>> listFlowEntryPublish(@RequestParam Long entryId) {
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(entryId);
        return ResponseResult.success((Object)MyModelUtil.copyCollectionTo(flowEntryPublishList, FlowEntryPublishVo.class));
    }

    @GetMapping(value={"/listDict"})
    public ResponseResult<List<Map<String, Object>>> listDict(@ParameterObject FlowEntryDto filter) {
        List<FlowEntry> resultList = this.flowEntryService.getFlowEntryList((FlowEntry)MyModelUtil.copyTo((Object)filter, FlowEntry.class), null);
        return ResponseResult.success((Object)MyCommonUtil.toDictDataList(resultList, FlowEntry::getEntryId, FlowEntry::getProcessDefinitionName));
    }

    @GetMapping(value={"/listAll"})
    public ResponseResult<JSONObject> listAll() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("flowEntryList", this.flowEntryService.getFlowEntryList(null, null));
        jsonObject.put("flowCategoryList", this.flowCategoryService.getFlowCategoryList(null, null));
        return ResponseResult.success((Object)jsonObject);
    }

    @GetMapping(value={"/viewDict"})
    public ResponseResult<Map<String, Object>> viewDict(@RequestParam Long entryId) {
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntry flowEntry = (FlowEntry)verifyResult.getData();
        HashMap<String, String> resultMap = new HashMap<String, String>(2);
        resultMap.put("processDefinitionKey", flowEntry.getProcessDefinitionKey());
        resultMap.put("processDefinitionName", flowEntry.getProcessDefinitionName());
        return ResponseResult.success(resultMap);
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/updateMainVersion"})
    public ResponseResult<Void> updateMainVersion(@MyRequestBody(required=true) Long entryId, @MyRequestBody(required=true) Long newEntryPublishId) {
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(entryId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        FlowEntryPublish flowEntryPublish = this.flowEntryService.getFlowEntryPublishFromCache(newEntryPublishId);
        if (flowEntryPublish == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7248\u672c\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (ObjectUtil.notEqual((Object)entryId, (Object)flowEntryPublish.getEntryId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5de5\u4f5c\u6d41\u5e76\u4e0d\u5305\u542b\u8be5\u5de5\u4f5c\u6d41\u53d1\u5e03\u7248\u672c\u6570\u636e\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (BooleanUtil.isTrue((Boolean)flowEntryPublish.getMainVersion())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u7248\u672c\u5df2\u7ecf\u4e3a\u5f53\u524d\u5de5\u4f5c\u6d41\u7684\u53d1\u5e03\u4e3b\u7248\u672c\uff0c\u4e0d\u80fd\u91cd\u590d\u8bbe\u7f6e\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowEntryService.updateFlowEntryMainVersion((FlowEntry)this.flowEntryService.getById(entryId), flowEntryPublish);
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=75)
    @PostMapping(value={"/suspendFlowEntryPublish"})
    public ResponseResult<Void> suspendFlowEntryPublish(@MyRequestBody(required=true) Long entryPublishId) {
        FlowEntryPublish flowEntryPublish = this.flowEntryService.getFlowEntryPublishFromCache(entryPublishId);
        if (flowEntryPublish == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7248\u672c\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(flowEntryPublish.getEntryId());
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        if (BooleanUtil.isFalse((Boolean)flowEntryPublish.getActiveStatus())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7248\u672c\u5df2\u5904\u4e8e\u6302\u8d77\u72b6\u6001\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowEntryService.suspendFlowEntryPublish(flowEntryPublish);
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=80)
    @PostMapping(value={"/activateFlowEntryPublish"})
    public ResponseResult<Void> activateFlowEntryPublish(@MyRequestBody(required=true) Long entryPublishId) {
        FlowEntryPublish flowEntryPublish = this.flowEntryService.getFlowEntryPublishFromCache(entryPublishId);
        if (flowEntryPublish == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7248\u672c\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        ResponseResult<FlowEntry> verifyResult = this.doVerifyAndGet(flowEntryPublish.getEntryId());
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        if (BooleanUtil.isTrue((Boolean)flowEntryPublish.getActiveStatus())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7248\u672c\u5df2\u5904\u4e8e\u6fc0\u6d3b\u72b6\u6001\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowEntryService.activateFlowEntryPublish(flowEntryPublish);
        return ResponseResult.success();
    }

    private ResponseResult<FlowEntry> doVerifyAndGet(Long entryId) {
        if (MyCommonUtil.existBlankArgument((Object[])new Object[]{entryId})) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.ARGUMENT_NULL_EXIST);
        }
        FlowEntry flowEntry = (FlowEntry)this.flowEntryService.getById(entryId);
        if (flowEntry == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        TokenData tokenData = TokenData.takeFromRequest();
        if (!StrUtil.equals((CharSequence)flowEntry.getAppCode(), (CharSequence)tokenData.getAppCode())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5e94\u7528\u5e76\u4e0d\u5b58\u5728\u8be5\u6d41\u7a0b\u5b9a\u4e49\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (ObjectUtil.notEqual((Object)flowEntry.getTenantId(), (Object)tokenData.getTenantId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u79df\u6237\u5e76\u4e0d\u5b58\u5728\u8be5\u6d41\u7a0b\u5b9a\u4e49\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)flowEntry);
    }

    private ResponseResult<TaskInfoVo> verifyAndGetInitialTaskInfo(FlowEntry flowEntry) throws XMLStreamException {
        TaskInfoVo taskInfoVo;
        BpmnModel bpmnModel = this.flowApiService.convertToBpmnModel(flowEntry.getBpmnXml());
        Process process = bpmnModel.getMainProcess();
        if (process == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u6807\u8bc6 [" + flowEntry.getProcessDefinitionKey() + "] \u5173\u8054\u7684\u6d41\u7a0b\u6a21\u578b\u5e76\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        Collection elementList = process.getFlowElements();
        FlowElement startEvent = null;
        for (FlowElement flowElement : elementList) {
            if (!(flowElement instanceof StartEvent)) continue;
            startEvent = flowElement;
            break;
        }
        if (startEvent == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u56fe\u6ca1\u6709\u5305\u542b [\u5f00\u59cb\u4e8b\u4ef6] \u8282\u70b9\uff0c\u8bf7\u4fee\u6539\u6d41\u7a0b\u56fe\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowElement firstTask = this.findFirstTask(elementList, startEvent);
        if (firstTask == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u56fe\u6ca1\u6709\u5305\u542b [\u5f00\u59cb\u4e8b\u4ef6] \u8282\u70b9\u6ca1\u6709\u4efb\u4f55\u8fde\u7ebf\uff0c\u8bf7\u4fee\u6539\u6d41\u7a0b\u56fe\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (firstTask instanceof UserTask) {
            UserTask userTask = (UserTask)firstTask;
            String formKey = userTask.getFormKey();
            taskInfoVo = StrUtil.isNotBlank((CharSequence)formKey) ? (TaskInfoVo)JSON.parseObject((String)formKey, TaskInfoVo.class) : new TaskInfoVo();
            taskInfoVo.setAssignee(userTask.getAssignee());
            taskInfoVo.setTaskKey(userTask.getId());
            taskInfoVo.setTaskType(1);
            Map extensionMap = userTask.getExtensionElements();
            if (MapUtil.isNotEmpty((Map)extensionMap)) {
                taskInfoVo.setOperationList(this.flowTaskExtService.buildOperationListExtensionElement(extensionMap));
                taskInfoVo.setVariableList(this.flowTaskExtService.buildVariableListExtensionElement(extensionMap));
            }
        } else {
            taskInfoVo = new TaskInfoVo();
            taskInfoVo.setTaskType(0);
        }
        return ResponseResult.success((Object)taskInfoVo);
    }

    private FlowElement findFirstTask(Collection<FlowElement> elementList, FlowElement startEvent) {
        for (FlowElement flowElement : elementList) {
            SequenceFlow sequenceFlow;
            if (!(flowElement instanceof SequenceFlow) || !(sequenceFlow = (SequenceFlow)flowElement).getSourceFlowElement().equals(startEvent)) continue;
            return sequenceFlow.getTargetFlowElement();
        }
        return null;
    }
}

