/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.util.MyCommonUtil;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.core.validator.UpdateGroup;
import com.dic.bid.common.flow.dto.FlowEntryVariableDto;
import com.dic.bid.common.flow.model.FlowEntryVariable;
import com.dic.bid.common.flow.service.FlowEntryVariableService;
import com.dic.bid.common.flow.vo.FlowEntryVariableVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.github.pagehelper.page.PageMethod;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u6d41\u6d41\u7a0b\u53d8\u91cf\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowEntryVariable"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowEntryVariableController {
    private static final Logger log = LoggerFactory.getLogger(FlowEntryVariableController.class);
    @Autowired
    private FlowEntryVariableService flowEntryVariableService;

    @ApiOperationSupport(ignoreParameters={"flowEntryVariableDto.variableId"})
    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody FlowEntryVariableDto flowEntryVariableDto) {
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowEntryVariableDto, (Class[])new Class[0]);
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntryVariable flowEntryVariable = (FlowEntryVariable)MyModelUtil.copyTo((Object)flowEntryVariableDto, FlowEntryVariable.class);
        flowEntryVariable = this.flowEntryVariableService.saveNew(flowEntryVariable);
        return ResponseResult.success((Object)flowEntryVariable.getVariableId());
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody FlowEntryVariableDto flowEntryVariableDto) {
        String errorMessage = MyCommonUtil.getModelValidationError((Object)flowEntryVariableDto, (Class[])new Class[]{Default.class, UpdateGroup.class});
        if (errorMessage != null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntryVariable flowEntryVariable = (FlowEntryVariable)MyModelUtil.copyTo((Object)flowEntryVariableDto, FlowEntryVariable.class);
        FlowEntryVariable originalFlowEntryVariable = (FlowEntryVariable)this.flowEntryVariableService.getById(flowEntryVariable.getVariableId());
        if (originalFlowEntryVariable == null) {
            errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d [\u6570\u636e] \u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (!this.flowEntryVariableService.update(flowEntryVariable, originalFlowEntryVariable)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long variableId) {
        if (MyCommonUtil.existBlankArgument((Object[])new Object[]{variableId})) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.ARGUMENT_NULL_EXIST);
        }
        FlowEntryVariable originalFlowEntryVariable = (FlowEntryVariable)this.flowEntryVariableService.getById(variableId);
        if (originalFlowEntryVariable == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d [\u5bf9\u8c61] \u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (!this.flowEntryVariableService.remove(variableId)) {
            String errorMessage = "\u6570\u636e\u64cd\u4f5c\u5931\u8d25\uff0c\u5220\u9664\u7684\u5bf9\u8c61\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<FlowEntryVariableVo>> list(@MyRequestBody FlowEntryVariableDto flowEntryVariableDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize());
        }
        FlowEntryVariable flowEntryVariableFilter = (FlowEntryVariable)MyModelUtil.copyTo((Object)flowEntryVariableDtoFilter, FlowEntryVariable.class);
        String orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowEntryVariable.class);
        List<FlowEntryVariable> flowEntryVariableList = this.flowEntryVariableService.getFlowEntryVariableListWithRelation(flowEntryVariableFilter, orderBy);
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowEntryVariableList, FlowEntryVariableVo.class));
    }

    @SaCheckPermission(value={"flowEntry.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<FlowEntryVariableVo> view(@RequestParam Long variableId) {
        if (MyCommonUtil.existBlankArgument((Object[])new Object[]{variableId})) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.ARGUMENT_NULL_EXIST);
        }
        FlowEntryVariable flowEntryVariable = (FlowEntryVariable)this.flowEntryVariableService.getByIdWithRelation(variableId, MyRelationParam.full());
        if (flowEntryVariable == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success((Object)flowEntryVariable, FlowEntryVariableVo.class);
    }
}

