/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.flow.model.FlowMessage;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.vo.FlowMessageVo;
import com.github.pagehelper.page.PageMethod;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u6d41\u6d88\u606f\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowMessage"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowMessageController {
    private static final Logger log = LoggerFactory.getLogger(FlowMessageController.class);
    @Autowired
    private FlowMessageService flowMessageService;

    @GetMapping(value={"/getMessageCount"})
    public ResponseResult<JSONObject> getMessageCount() {
        JSONObject resultData = new JSONObject();
        resultData.put("remindingMessageCount", (Object)this.flowMessageService.countRemindingMessageListByUser());
        resultData.put("copyMessageCount", (Object)this.flowMessageService.countCopyMessageByUser());
        return ResponseResult.success((Object)resultData);
    }

    @PostMapping(value={"/listRemindingTask"})
    public ResponseResult<MyPageData<FlowMessageVo>> listRemindingTask(@MyRequestBody MyPageParam pageParam) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize(), (boolean)pageParam.getCount());
        }
        List<FlowMessage> flowMessageList = this.flowMessageService.getRemindingMessageListByUser();
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowMessageList, FlowMessageVo.class));
    }

    @PostMapping(value={"/listCopyMessage"})
    public ResponseResult<MyPageData<FlowMessageVo>> listCopyMessage(@MyRequestBody MyPageParam pageParam, @MyRequestBody Boolean read) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize(), (boolean)pageParam.getCount());
        }
        List<FlowMessage> flowMessageList = this.flowMessageService.getCopyMessageListByUser(read);
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowMessageList, FlowMessageVo.class));
    }

    @PostMapping(value={"/readCopyTask"})
    public ResponseResult<Void> readCopyTask(@MyRequestBody Long messageId) {
        FlowMessage flowMessage = (FlowMessage)this.flowMessageService.getById(messageId);
        if (flowMessage == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (flowMessage.getMessageType() != 1) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e0d\u662f\u6284\u9001\u7c7b\u578b\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowMessageService.isCandidateIdentityOnMessage(messageId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowMessageService.readCopyTask(messageId);
        return ResponseResult.success();
    }
}

