/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.DisableDataFilter;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.MyPrintInfo;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.MyCommonUtil;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.flow.config.FlowProperties;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowMessage;
import com.dic.bid.common.flow.model.FlowMultiInstanceTrans;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.model.FlowTransProducer;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.model.FlowWorkOrderExt;
import com.dic.bid.common.flow.object.FlowEntryExtensionData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.service.FlowMultiInstanceTransService;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.service.FlowTransProducerService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.util.FlowOperationHelper;
import com.dic.bid.common.flow.vo.FlowTaskCommentVo;
import com.dic.bid.common.flow.vo.FlowTaskVo;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.redis.cache.SessionCacheHelper;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5de5\u4f5c\u6d41\u6d41\u7a0b\u64cd\u4f5c\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-flow.urlPrefix}/flowOperation"})
@ConditionalOnProperty(name={"common-flow.operationEnabled"}, havingValue="true")
public class FlowOperationController {
    private static final Logger log = LoggerFactory.getLogger(FlowOperationController.class);
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private FlowTaskCommentService flowTaskCommentService;
    @Autowired
    private FlowTaskExtService flowTaskExtService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowMessageService flowMessageService;
    @Autowired
    private FlowOperationHelper flowOperationHelper;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private FlowMultiInstanceTransService flowMultiInstanceTransService;
    @Autowired
    private FlowTransProducerService flowTransProducerService;
    @Autowired
    private SessionCacheHelper sessionCacheHelper;
    @Autowired
    private FlowProperties flowProperties;
    private static final String ACTIVE_MULTI_INST_TASK = "activeMultiInstanceTask";
    private static final String SHOW_NAME = "showName";
    private static final String INSTANCE_ID = "processInstanceId";

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=100)
    @PostMapping(value={"/startOnly"})
    public ResponseResult<Void> startOnly(@MyRequestBody(required=true) String processDefinitionKey) {
        ResponseResult<FlowEntry> flowEntryResult = this.flowOperationHelper.verifyAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        FlowEntryPublish flowEntryPublish = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish();
        ResponseResult<TaskInfoVo> taskInfoResult = this.flowOperationHelper.verifyAndGetInitialTaskInfo(flowEntryPublish, false);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        this.flowApiService.start(flowEntryPublish.getProcessDefinitionId(), null);
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=128)
    @PostMapping(value={"/revive"})
    public ResponseResult<Void> revive(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) List<String> taskKeys, @MyRequestBody(required=true) String taskComment) {
        DateTime expiredDate;
        HistoricProcessInstance instance = this.flowApiService.getHistoricProcessInstance(processInstanceId);
        if (instance == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u6216\u5c1a\u672a\u7ed3\u675f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(CollUtil.newHashSet((Object[])new String[]{instance.getProcessDefinitionId()}));
        if (StrUtil.isBlank((CharSequence)flowEntryPublishList.get(0).getExtensionData())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u4e0d\u652f\u6301\u6d41\u7a0b\u590d\u6d3b\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntryExtensionData extData = (FlowEntryExtensionData)JSON.parseObject((String)flowEntryPublishList.get(0).getExtensionData(), FlowEntryExtensionData.class);
        if (BooleanUtil.isFalse((Boolean)extData.getSupportRevive())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u4e0d\u652f\u6301\u6d41\u7a0b\u590d\u6d3b\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (extData.getKeptReviveDays() > 0 && (expiredDate = DateUtil.offset((Date)instance.getEndTime(), (DateField)DateField.DAY_OF_MONTH, (int)extData.getKeptReviveDays())).before(new Date())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u6d41\u7a0b\u590d\u6d3b\u5df2\u8fc7\u671f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        try {
            this.flowApiService.revive(processInstanceId, taskKeys, taskComment);
            return ResponseResult.success();
        }
        catch (FlowableException e) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)e.getMessage());
        }
    }

    @GetMapping(value={"/viewInitialTaskInfo"})
    public ResponseResult<TaskInfoVo> viewInitialTaskInfo(@RequestParam String processDefinitionKey) {
        TaskInfoVo taskInfo;
        ResponseResult<FlowEntry> flowEntryResult = this.flowOperationHelper.verifyAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        FlowEntryPublish flowEntryPublish = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish();
        String initTaskInfo = flowEntryPublish.getInitTaskInfo();
        TaskInfoVo taskInfoVo = taskInfo = StrUtil.isBlank((CharSequence)initTaskInfo) ? null : (TaskInfoVo)JSON.parseObject((String)initTaskInfo, TaskInfoVo.class);
        if (taskInfo != null) {
            String loginName = TokenData.takeFromRequest().getLoginName();
            taskInfo.setAssignedMe(StrUtil.equalsAny((CharSequence)taskInfo.getAssignee(), (CharSequence[])new CharSequence[]{loginName, "${startUserName}"}));
        }
        return ResponseResult.success((Object)taskInfo);
    }

    @GetMapping(value={"/viewRuntimeTaskInfo"})
    public ResponseResult<TaskInfoVo> viewRuntimeTaskInfo(@RequestParam String processDefinitionId, @RequestParam String processInstanceId, @RequestParam String taskId) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        ResponseResult<TaskInfoVo> taskInfoResult = this.flowOperationHelper.verifyAndGetRuntimeTaskInfo(task);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        TaskInfoVo taskInfoVo = (TaskInfoVo)taskInfoResult.getData();
        FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(processDefinitionId, taskInfoVo.getTaskKey());
        if (flowTaskExt != null) {
            if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getOperationListJson())) {
                taskInfoVo.setOperationList(JSON.parseArray((String)flowTaskExt.getOperationListJson(), JSONObject.class));
            }
            if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getVariableListJson())) {
                taskInfoVo.setVariableList(JSON.parseArray((String)flowTaskExt.getVariableListJson(), JSONObject.class));
            }
        }
        return ResponseResult.success((Object)taskInfoVo);
    }

    @GetMapping(value={"/viewHistoricTaskInfo"})
    public ResponseResult<TaskInfoVo> viewHistoricTaskInfo(@RequestParam String processDefinitionId, @RequestParam String processInstanceId, @RequestParam String taskId) {
        HistoricTaskInstance taskInstance = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
        String loginName = TokenData.takeFromRequest().getLoginName();
        if (!StrUtil.equals((CharSequence)taskInstance.getAssignee(), (CharSequence)loginName)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6307\u6d3e\u4eba\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        TaskInfoVo taskInfoVo = (TaskInfoVo)JSON.parseObject((String)taskInstance.getFormKey(), TaskInfoVo.class);
        FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(processDefinitionId, taskInstance.getTaskDefinitionKey());
        if (flowTaskExt != null) {
            if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getOperationListJson())) {
                taskInfoVo.setOperationList(JSON.parseArray((String)flowTaskExt.getOperationListJson(), JSONObject.class));
            }
            if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getVariableListJson())) {
                taskInfoVo.setVariableList(JSON.parseArray((String)flowTaskExt.getVariableListJson(), JSONObject.class));
            }
        }
        return ResponseResult.success((Object)taskInfoVo);
    }

    @GetMapping(value={"/viewInitialHistoricTaskInfo"})
    public ResponseResult<TaskInfoVo> viewInitialHistoricTaskInfo(@RequestParam String processInstanceId) {
        List<FlowTaskComment> taskCommentList = this.flowTaskCommentService.getFlowTaskCommentList(processInstanceId);
        if (CollUtil.isEmpty(taskCommentList)) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        FlowTaskComment taskComment = taskCommentList.get(0);
        HistoricTaskInstance task = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskComment.getTaskId());
        if (StrUtil.isBlank((CharSequence)task.getFormKey())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u4efb\u52a1\u7684formKey\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u6d41\u7a0b\u56fe\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)JSON.parseObject((String)task.getFormKey(), TaskInfoVo.class);
        taskInfo.setTaskKey(task.getTaskDefinitionKey());
        return ResponseResult.success((Object)taskInfo);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewTaskUserInfo"})
    public ResponseResult<List<FlowUserInfoVo>> viewTaskUserInfo(@RequestParam String processDefinitionId, @RequestParam String processInstanceId, @RequestParam String taskId, @RequestParam Boolean historic) {
        HistoricTaskInstance hisotricTask;
        Task taskInfo;
        if (BooleanUtil.isFalse((Boolean)historic)) {
            taskInfo = this.flowApiService.getTaskById(taskId);
            if (taskInfo == null) {
                hisotricTask = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
                taskInfo = hisotricTask;
                historic = true;
            }
        } else {
            hisotricTask = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
            taskInfo = hisotricTask;
        }
        if (taskInfo == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4efb\u52a1Id\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        String taskKey = taskInfo.getTaskDefinitionKey();
        FlowTaskExt taskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(processDefinitionId, taskKey);
        boolean isMultiInstanceTask = this.flowApiService.isMultiInstanceTask(taskInfo.getProcessDefinitionId(), taskKey);
        List<FlowUserInfoVo> resultUserInfoList = this.flowTaskExtService.getCandidateUserInfoList(processInstanceId, taskExt, (TaskInfo)taskInfo, isMultiInstanceTask, historic);
        if (BooleanUtil.isTrue((Boolean)historic) || isMultiInstanceTask) {
            List<FlowTaskComment> taskCommentList = this.buildApprovedFlowTaskCommentList((TaskInfo)taskInfo, isMultiInstanceTask);
            Map<String, FlowUserInfoVo> resultUserInfoMap = resultUserInfoList.stream().collect(Collectors.toMap(FlowUserInfoVo::getLoginName, c -> c));
            for (FlowTaskComment taskComment : taskCommentList) {
                FlowUserInfoVo flowUserInfoVo = resultUserInfoMap.get(taskComment.getCreateLoginName());
                if (flowUserInfoVo == null) continue;
                flowUserInfoVo.setLastApprovalTime(taskComment.getCreateTime());
            }
        }
        return ResponseResult.success(resultUserInfoList);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewDraftData"})
    public ResponseResult<JSONObject> viewDraftData(@RequestParam String processDefinitionKey, @RequestParam String processInstanceId) {
        ResponseResult<FlowWorkOrder> flowWorkOrderResult = this.flowOperationHelper.verifyAndGetFlowWorkOrderWithDraft(processDefinitionKey, processInstanceId);
        if (!flowWorkOrderResult.isSuccess()) {
            return ResponseResult.errorFrom(flowWorkOrderResult);
        }
        FlowWorkOrder flowWorkOrder = (FlowWorkOrder)flowWorkOrderResult.getData();
        if (StrUtil.isBlank((CharSequence)flowWorkOrder.getTableName())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5de5\u5355\u4e0d\u662f\u9759\u6001\u8def\u7531\u8868\u5355\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowWorkOrderExt flowWorkOrderExt = this.flowWorkOrderService.getFlowWorkOrderExtByWorkOrderId(flowWorkOrder.getWorkOrderId());
        if (StrUtil.isBlank((CharSequence)flowWorkOrderExt.getDraftData())) {
            return ResponseResult.success(null);
        }
        JSONObject masterData = JSON.parseObject((String)flowWorkOrderExt.getDraftData()).getJSONObject("masterData");
        JSONObject slaveData = JSON.parseObject((String)flowWorkOrderExt.getDraftData()).getJSONObject("slaveData");
        String normalizedDraftData = this.flowCustomExtFactory.getBusinessDataExtHelper().getNormalizedDraftData(processDefinitionKey, processInstanceId, masterData, slaveData);
        JSONObject draftObject = null;
        if (StrUtil.isNotBlank((CharSequence)normalizedDraftData)) {
            draftObject = JSON.parseObject((String)normalizedDraftData);
        }
        return ResponseResult.success(draftObject);
    }

    @DisableDataFilter
    @GetMapping(value={"/viewCopyBusinessData"})
    public ResponseResult<JSONObject> viewCopyBusinessData(@RequestParam Long messageId, @RequestParam(required=false) Boolean snapshot) {
        FlowMessage flowMessage = (FlowMessage)this.flowMessageService.getById(messageId);
        if (flowMessage == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (flowMessage.getMessageType() != 1) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e0d\u662f\u6284\u9001\u7c7b\u578b\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (flowMessage.getOnlineFormData() == null || flowMessage.getOnlineFormData().booleanValue()) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e3a\u5728\u7ebf\u8868\u5355\u6570\u636e\uff0c\u4e0d\u80fd\u901a\u8fc7\u8be5\u63a5\u53e3\u83b7\u53d6\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowMessageService.isCandidateIdentityOnMessage(messageId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u8be5\u6d88\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        JSONObject businessObject = null;
        if (snapshot != null && snapshot.booleanValue()) {
            if (StrUtil.isNotBlank((CharSequence)flowMessage.getBusinessDataShot())) {
                businessObject = JSON.parseObject((String)flowMessage.getBusinessDataShot());
            }
            return ResponseResult.success(businessObject);
        }
        HistoricProcessInstance instance = this.flowApiService.getHistoricProcessInstance(flowMessage.getProcessInstanceId());
        if (StrUtil.isBlank((CharSequence)instance.getBusinessKey())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d88\u606f\u4e3a\u6240\u5c5e\u6d41\u7a0b\u5b9e\u4f8b\u6ca1\u6709\u5305\u542b\u4e1a\u52a1\u4e3b\u952eId\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        String businessData = this.flowCustomExtFactory.getBusinessDataExtHelper().getBusinessData(flowMessage.getProcessDefinitionKey(), flowMessage.getProcessInstanceId(), instance.getBusinessKey());
        if (StrUtil.isNotBlank((CharSequence)businessData)) {
            businessObject = JSON.parseObject((String)businessData);
        }
        this.flowMessageService.readCopyTask(messageId);
        return ResponseResult.success((Object)businessObject);
    }

    @GetMapping(value={"/listMultiSignAssignees"})
    public ResponseResult<List<JSONObject>> listMultiSignAssignees(@RequestParam String processInstanceId, @RequestParam String taskId) {
        ResponseResult<JSONObject> verifyResult = this.doVerifyMultiSign(processInstanceId, taskId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        Task activeMultiInstanceTask = (Task)((JSONObject)verifyResult.getData()).getObject(ACTIVE_MULTI_INST_TASK, Task.class);
        String multiInstanceExecId = this.flowApiService.getExecutionVariableStringWithSafe(activeMultiInstanceTask.getExecutionId(), "taskExecutionId");
        FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
        List<FlowTaskComment> commentList = this.flowTaskCommentService.getFlowTaskCommentListByMultiInstanceExecId(multiInstanceExecId);
        List assigneeList = StrUtil.split((CharSequence)trans.getAssigneeList(), (CharSequence)",");
        Set approvedAssigneeSet = commentList.stream().map(FlowTaskComment::getCreateLoginName).collect(Collectors.toSet());
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        Map<String, String> usernameMap = this.flowCustomExtFactory.getFlowIdentityExtHelper().mapUserShowNameByLoginName(new HashSet<String>(assigneeList));
        for (String assignee : assigneeList) {
            JSONObject resultData = new JSONObject();
            resultData.put("assignee", (Object)assignee);
            resultData.put(SHOW_NAME, (Object)usernameMap.get(assignee));
            resultData.put("approved", (Object)approvedAssigneeSet.contains(assignee));
            resultList.add(resultData);
        }
        return ResponseResult.success(resultList);
    }

    @PostMapping(value={"/submitSequenceConsign"})
    public ResponseResult<Void> submitSequenceConsign(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String newAssignees, @MyRequestBody(required=true) Boolean before) {
        ResponseResult<Task> verifyResult = this.doVerifySequenceMultiSign(processInstanceId, taskId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        Task activeMultiInstanceTask = (Task)verifyResult.getData();
        ResponseResult<Void> assigneeVerifyResult = this.doVerifyConsignAssignee(activeMultiInstanceTask, newAssignees, true);
        if (!assigneeVerifyResult.isSuccess()) {
            return ResponseResult.errorFrom(assigneeVerifyResult);
        }
        try {
            this.flowApiService.submitSequenceConsign(activeMultiInstanceTask, newAssignees, before);
        }
        catch (FlowOperationException e) {
            String errorMessage = e.getMessage();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    @PostMapping(value={"/submitConsign"})
    public ResponseResult<Void> submitConsign(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String newAssignees, @MyRequestBody Boolean isAdd) {
        ResponseResult<Void> assigneeVerifyResult;
        ResponseResult<JSONObject> verifyResult = this.doVerifyMultiSign(processInstanceId, taskId);
        if (!verifyResult.isSuccess()) {
            return ResponseResult.errorFrom(verifyResult);
        }
        HistoricTaskInstance taskInstance = (HistoricTaskInstance)((JSONObject)verifyResult.getData()).getObject("taskInstance", HistoricTaskInstance.class);
        Task activeMultiInstanceTask = (Task)((JSONObject)verifyResult.getData()).getObject(ACTIVE_MULTI_INST_TASK, Task.class);
        String multiInstanceExecId = this.flowApiService.getExecutionVariableStringWithSafe(activeMultiInstanceTask.getExecutionId(), "taskExecutionId");
        JSONArray assigneeArray = JSON.parseArray((String)newAssignees);
        if (isAdd == null) {
            isAdd = true;
        }
        if (!(assigneeVerifyResult = this.doVerifyConsignAssignee(activeMultiInstanceTask, newAssignees, isAdd)).isSuccess()) {
            return ResponseResult.errorFrom(assigneeVerifyResult);
        }
        try {
            this.flowApiService.submitConsign(taskInstance, activeMultiInstanceTask, newAssignees, isAdd);
        }
        catch (FlowOperationException e) {
            String errorMessage = e.getMessage();
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    @DisableDataFilter
    @PostMapping(value={"/listRuntimeTask"})
    public ResponseResult<MyPageData<FlowTaskVo>> listRuntimeTask(@MyRequestBody String processDefinitionKey, @MyRequestBody String processDefinitionName, @MyRequestBody String taskName, @MyRequestBody(required=true) MyPageParam pageParam) {
        String username = TokenData.takeFromRequest().getLoginName();
        MyPageData<Task> pageData = this.flowApiService.getTaskListByUserName(username, processDefinitionKey, processDefinitionName, taskName, pageParam);
        List<FlowTaskVo> flowTaskVoList = this.flowApiService.convertToFlowTaskList(pageData.getDataList());
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(flowTaskVoList, (Long)pageData.getTotalCount()));
    }

    @PostMapping(value={"/countRuntimeTask"})
    public ResponseResult<Long> countRuntimeTask() {
        String username = TokenData.takeFromRequest().getLoginName();
        long totalCount = this.flowApiService.getTaskCountByUserName(username);
        return ResponseResult.success((Object)totalCount);
    }

    @GetMapping(value={"/listRejectCandidateUserTask"})
    public ResponseResult<List<FlowTaskVo>> listRejectCandidateUserTask(@RequestParam String processInstanceId, @RequestParam String taskId) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        if (task == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u7684\u4efb\u52a1Id\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        List<UserTask> userTaskList = this.flowApiService.getRejectCandidateUserTaskList(task);
        LinkedList<FlowTaskVo> resultList = new LinkedList<FlowTaskVo>();
        if (CollUtil.isNotEmpty(userTaskList)) {
            for (UserTask userTask : userTaskList) {
                FlowTaskVo flowTaskVo = new FlowTaskVo();
                flowTaskVo.setTaskKey(userTask.getId());
                flowTaskVo.setShowName(userTask.getName());
                resultList.add(flowTaskVo);
            }
        }
        return ResponseResult.success(resultList);
    }

    @PostMapping(value={"/freeJumpTo"})
    public ResponseResult<Void> freeJumpTo(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String sourceTaskId, @MyRequestBody(required=true) String targetTaskKey, @MyRequestBody(required=true) String taskComment, @MyRequestBody String delegateAssignee) {
        ResponseResult<Task> taskResult = this.flowOperationHelper.verifySubmitAndGetTask(processInstanceId, sourceTaskId, null);
        if (!taskResult.isSuccess()) {
            return ResponseResult.errorFrom(taskResult);
        }
        CallResult result = this.flowApiService.freeJumpTo((Task)taskResult.getData(), targetTaskKey, taskComment, delegateAssignee);
        return ResponseResult.from((CallResult)result);
    }

    @PostMapping(value={"/rejectToStartUserTask"})
    public ResponseResult<Void> rejectToStartUserTask(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody JSONObject taskVariableData) {
        ResponseResult<Task> taskResult = this.flowOperationHelper.verifySubmitAndGetTask(processInstanceId, taskId, null);
        if (!taskResult.isSuccess()) {
            return ResponseResult.errorFrom(taskResult);
        }
        FlowTaskComment firstTaskComment = this.flowTaskCommentService.getFirstFlowTaskComment(processInstanceId);
        CallResult result = this.flowApiService.backToRuntimeTask((Task)taskResult.getData(), firstTaskComment.getTaskKey(), 0, taskComment, taskVariableData);
        return ResponseResult.from((CallResult)result);
    }

    @PostMapping(value={"/rejectRuntimeTask"})
    public ResponseResult<Void> rejectRuntimeTask(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody String targetTaskKey, @MyRequestBody JSONObject taskVariableData) {
        ResponseResult<Task> taskResult = this.flowOperationHelper.verifySubmitAndGetTask(processInstanceId, taskId, null);
        if (!taskResult.isSuccess()) {
            return ResponseResult.errorFrom(taskResult);
        }
        CallResult result = this.flowApiService.backToRuntimeTask((Task)taskResult.getData(), targetTaskKey, 0, taskComment, taskVariableData);
        return ResponseResult.from((CallResult)result);
    }

    @PostMapping(value={"/revokeHistoricTask"})
    public ResponseResult<Void> revokeHistoricTask(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody JSONObject taskVariableData) {
        List<Object> childActivitiIds;
        if (!this.flowApiService.existActiveProcessInstance(processInstanceId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u64a4\u56de\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        HistoricTaskInstance taskInstance = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
        if (taskInstance == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!StrUtil.equals((CharSequence)taskInstance.getAssignee(), (CharSequence)TokenData.takeFromRequest().getLoginName())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4efb\u52a1\u6307\u6d3e\u4eba\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowTaskComment latestComment = this.flowTaskCommentService.getLatestFlowTaskComment(processInstanceId);
        if (latestComment == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5b9e\u4f8b\u6ca1\u6709\u4efb\u4f55\u5ba1\u6279\u63d0\u4ea4\u8bb0\u5f55\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!latestComment.getTaskId().equals(taskId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u5ba1\u6279\u4efb\u52a1\u5df2\u88ab\u529e\u7406\uff0c\u4e0d\u80fd\u64a4\u56de\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        List<Task> activeTaskList = this.flowApiService.getProcessInstanceActiveTaskList(processInstanceId);
        if (CollUtil.isEmpty(activeTaskList)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u6ca1\u6709\u4efb\u4f55\u5f85\u529e\u4efb\u52a1\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (latestComment.getApprovalType().equals("transfer")) {
            if (activeTaskList.size() > 1) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8f6c\u529e\u4efb\u52a1\u6570\u91cf\u4e0d\u80fd\u591a\u4e8e1\u4e2a\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            Task task = activeTaskList.get(0);
            task.setAssignee(TokenData.takeFromRequest().getLoginName());
            return ResponseResult.success();
        }
        List<String> activitiIds = activeTaskList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
        String rejectBackTargetKey = this.flowTaskCommentService.getRefectBackTypeTargetKey(latestComment);
        String targetKey = null;
        if (StrUtil.isNotBlank((CharSequence)rejectBackTargetKey)) {
            childActivitiIds = CollUtil.newArrayList((Object[])new String[]{rejectBackTargetKey});
            targetKey = taskInstance.getTaskDefinitionKey();
        } else {
            childActivitiIds = this.flowApiService.getChildActivitiIdList(taskInstance.getProcessDefinitionId(), taskInstance.getTaskDefinitionKey(), activitiIds);
            if (CollUtil.isEmpty((Collection)childActivitiIds)) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u7684\u5f85\u64a4\u9500\u4efb\u52a1\u5e76\u4e0d\u5b58\u5728\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        }
        Task revokedTask = activeTaskList.stream().filter(t -> childActivitiIds.contains(t.getTaskDefinitionKey())).findFirst().orElse(null);
        CallResult result = this.flowApiService.backToRuntimeTask(revokedTask, targetKey, 1, taskComment, taskVariableData);
        return ResponseResult.from((CallResult)result);
    }

    @GetMapping(value={"/listFlowTaskComment"})
    public ResponseResult<List<FlowTaskCommentVo>> listFlowTaskComment(@RequestParam String processInstanceId) {
        List<FlowTaskComment> flowTaskCommentList = this.flowTaskCommentService.getFlowTaskCommentList(processInstanceId);
        List resultList = MyModelUtil.copyCollectionTo(flowTaskCommentList, FlowTaskCommentVo.class);
        return ResponseResult.success((Object)resultList);
    }

    @GetMapping(value={"/viewProcessBpmn"})
    public ResponseResult<String> viewProcessBpmn(@RequestParam String processDefinitionId) throws IOException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        BpmnModel bpmnModel = this.flowApiService.getBpmnModelByDefinitionId(processDefinitionId);
        byte[] xmlBytes = converter.convertToXML(bpmnModel);
        ByteArrayInputStream in = new ByteArrayInputStream(xmlBytes);
        return ResponseResult.success((Object)StreamUtils.copyToString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    @GetMapping(value={"/viewTaskFormKey"})
    public ResponseResult<String> viewTaskFormKey(@RequestParam String processInstanceId, @RequestParam String taskId) throws IOException {
        Task task = this.flowApiService.getTaskById(taskId);
        if (task == null && (task = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId)) == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        UserTask userTask = this.flowApiService.getUserTask(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (userTask == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        return ResponseResult.success((Object)userTask.getFormKey());
    }

    @GetMapping(value={"/viewHighlightFlowData"})
    public ResponseResult<JSONObject> viewHighlightFlowData(@RequestParam String processInstanceId) {
        List<HistoricActivityInstance> activityInstanceList = this.flowApiService.getHistoricActivityInstanceList(processInstanceId);
        Set finishedTaskSet = activityInstanceList.stream().filter(s -> !StrUtil.equals((CharSequence)s.getActivityType(), (CharSequence)"sequenceFlow")).map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        Set finishedSequenceFlowSet = activityInstanceList.stream().filter(s -> StrUtil.equals((CharSequence)s.getActivityType(), (CharSequence)"sequenceFlow")).map(HistoricActivityInstance::getActivityId).collect(Collectors.toSet());
        List<HistoricActivityInstance> unfinishedInstanceList = this.flowApiService.getHistoricUnfinishedInstanceList(processInstanceId);
        LinkedHashSet<String> unfinishedTaskSet = new LinkedHashSet<String>();
        for (HistoricActivityInstance unfinishedActivity : unfinishedInstanceList) {
            unfinishedTaskSet.add(unfinishedActivity.getActivityId());
        }
        JSONObject jsonData = new JSONObject();
        jsonData.put("finishedTaskSet", finishedTaskSet);
        jsonData.put("finishedSequenceFlowSet", finishedSequenceFlowSet);
        jsonData.put("unfinishedTaskSet", unfinishedTaskSet);
        return ResponseResult.success((Object)jsonData);
    }

    @DisableDataFilter
    @PostMapping(value={"/listHistoricTask"})
    public ResponseResult<MyPageData<Map<String, Object>>> listHistoricTask(@MyRequestBody String processDefinitionName, @MyRequestBody String beginDate, @MyRequestBody String endDate, @MyRequestBody(required=true) MyPageParam pageParam) throws ParseException {
        MyPageData<HistoricTaskInstance> pageData = this.flowApiService.getHistoricTaskInstanceFinishedList(processDefinitionName, beginDate, endDate, pageParam);
        LinkedList resultList = new LinkedList();
        pageData.getDataList().forEach(instance -> resultList.add(BeanUtil.beanToMap((Object)instance, (String[])new String[0])));
        List taskInstanceList = pageData.getDataList();
        if (CollUtil.isNotEmpty((Collection)taskInstanceList)) {
            Set<String> instanceIdSet = taskInstanceList.stream().map(TaskInfo::getProcessInstanceId).collect(Collectors.toSet());
            List<HistoricProcessInstance> instanceList = this.flowApiService.getHistoricProcessInstanceList(instanceIdSet);
            Set<String> loginNameSet = instanceList.stream().map(HistoricProcessInstance::getStartUserId).collect(Collectors.toSet());
            List<FlowUserInfoVo> userInfoList = this.flowCustomExtFactory.getFlowIdentityExtHelper().getUserInfoListByUsernameSet(loginNameSet);
            Map<String, FlowUserInfoVo> userInfoMap = userInfoList.stream().collect(Collectors.toMap(FlowUserInfoVo::getLoginName, c -> c));
            Map<String, HistoricProcessInstance> instanceMap = instanceList.stream().collect(Collectors.toMap(HistoricProcessInstance::getId, c -> c));
            List workOrderList = this.flowWorkOrderService.getInList(INSTANCE_ID, instanceIdSet);
            Map<String, FlowWorkOrder> workOrderMap = workOrderList.stream().collect(Collectors.toMap(FlowWorkOrder::getProcessInstanceId, c -> c));
            resultList.forEach(result -> {
                String instanceId = result.get(INSTANCE_ID).toString();
                HistoricProcessInstance instance = (HistoricProcessInstance)instanceMap.get(instanceId);
                result.put("processDefinitionKey", instance.getProcessDefinitionKey());
                result.put("processDefinitionName", instance.getProcessDefinitionName());
                result.put("startUser", instance.getStartUserId());
                FlowUserInfoVo userInfo = (FlowUserInfoVo)userInfoMap.get(instance.getStartUserId());
                result.put(SHOW_NAME, userInfo.getShowName());
                result.put("headImageUrl", userInfo.getHeadImageUrl());
                result.put("businessKey", instance.getBusinessKey());
                FlowWorkOrder flowWorkOrder = (FlowWorkOrder)workOrderMap.get(instanceId);
                if (flowWorkOrder != null) {
                    result.put("workOrderCode", flowWorkOrder.getWorkOrderCode());
                }
            });
            Set<String> taskIdSet = taskInstanceList.stream().map(TaskInfo::getId).collect(Collectors.toSet());
            List<FlowTaskComment> commentList = this.flowTaskCommentService.getFlowTaskCommentListByTaskIds(taskIdSet);
            Map<String, List<FlowTaskComment>> commentMap = commentList.stream().collect(Collectors.groupingBy(FlowTaskComment::getTaskId));
            resultList.forEach(result -> {
                List comments = (List)commentMap.get(result.get("id").toString());
                if (CollUtil.isNotEmpty((Collection)comments)) {
                    result.put("approvalType", ((FlowTaskComment)comments.get(0)).getApprovalType());
                    comments.remove(0);
                }
            });
        }
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(resultList, (Long)pageData.getTotalCount()));
    }

    @DisableDataFilter
    @PostMapping(value={"/listHistoricProcessInstance"})
    public ResponseResult<MyPageData<Map<String, Object>>> listHistoricProcessInstance(@MyRequestBody String processDefinitionName, @MyRequestBody String beginDate, @MyRequestBody String endDate, @MyRequestBody(required=true) MyPageParam pageParam) throws ParseException {
        String loginName = TokenData.takeFromRequest().getLoginName();
        MyPageData<HistoricProcessInstance> pageData = this.flowApiService.getHistoricProcessInstanceList(null, processDefinitionName, loginName, beginDate, endDate, pageParam, true);
        Set<String> loginNameSet = pageData.getDataList().stream().map(HistoricProcessInstance::getStartUserId).collect(Collectors.toSet());
        List<FlowUserInfoVo> userInfoList = this.flowCustomExtFactory.getFlowIdentityExtHelper().getUserInfoListByUsernameSet(loginNameSet);
        if (CollUtil.isEmpty(userInfoList)) {
            userInfoList = new LinkedList<FlowUserInfoVo>();
        }
        Map<String, FlowUserInfoVo> userInfoMap = userInfoList.stream().collect(Collectors.toMap(FlowUserInfoVo::getLoginName, c -> c));
        Set instanceIdSet = pageData.getDataList().stream().map(HistoricProcessInstance::getId).collect(Collectors.toSet());
        List workOrderList = this.flowWorkOrderService.getInList(INSTANCE_ID, instanceIdSet);
        Map<String, FlowWorkOrder> workOrderMap = workOrderList.stream().collect(Collectors.toMap(FlowWorkOrder::getProcessInstanceId, c -> c));
        LinkedList resultList = new LinkedList();
        pageData.getDataList().forEach(instance -> {
            FlowWorkOrder workOrder;
            Map data = BeanUtil.beanToMap((Object)instance, (String[])new String[0]);
            FlowUserInfoVo userInfo = (FlowUserInfoVo)userInfoMap.get(instance.getStartUserId());
            if (userInfo != null) {
                data.put(SHOW_NAME, userInfo.getShowName());
                data.put("headImageUrl", userInfo.getHeadImageUrl());
            }
            if ((workOrder = (FlowWorkOrder)workOrderMap.get(instance.getId())) != null) {
                data.put("workOrderCode", workOrder.getWorkOrderCode());
                data.put("flowStatus", workOrder.getFlowStatus());
            }
            resultList.add(data);
        });
        return ResponseResult.success((Object)MyPageUtil.makeResponseData(resultList, (Long)pageData.getTotalCount()));
    }

    @PostMapping(value={"/listAllHistoricProcessInstance"})
    public ResponseResult<MyPageData<Map<String, Object>>> listAllHistoricProcessInstance(@MyRequestBody String processDefinitionName, @MyRequestBody String startUser, @MyRequestBody String beginDate, @MyRequestBody String endDate, @MyRequestBody(required=true) MyPageParam pageParam) throws ParseException {
        MyPageData<HistoricProcessInstance> pageData = this.flowApiService.getHistoricProcessInstanceList(null, processDefinitionName, startUser, beginDate, endDate, pageParam, false);
        LinkedList resultList = new LinkedList();
        pageData.getDataList().forEach(instance -> resultList.add(BeanUtil.beanToMap((Object)instance, (String[])new String[0])));
        List<String> unfinishedProcessInstanceIds = pageData.getDataList().stream().filter(c -> c.getEndTime() == null).map(HistoricProcessInstance::getId).collect(Collectors.toList());
        MyPageData pageResultData = MyPageUtil.makeResponseData(resultList, (Long)pageData.getTotalCount());
        if (CollUtil.isEmpty(unfinishedProcessInstanceIds)) {
            return ResponseResult.success((Object)pageResultData);
        }
        Set<String> processInstanceIds = pageData.getDataList().stream().map(HistoricProcessInstance::getId).collect(Collectors.toSet());
        List<FlowTransProducer> transProducerList = this.flowTransProducerService.getListByProcessInstanceIds(processInstanceIds);
        Map<String, List<FlowTransProducer>> flowTransProducerMap = null;
        if (CollUtil.isNotEmpty(transProducerList)) {
            flowTransProducerMap = transProducerList.stream().collect(Collectors.groupingBy(FlowTransProducer::getProcessInstanceId));
        }
        List<Task> taskList = this.flowApiService.getTaskListByProcessInstanceIds(unfinishedProcessInstanceIds);
        Map<String, List<Task>> taskMap = taskList.stream().collect(Collectors.groupingBy(TaskInfo::getProcessInstanceId));
        for (Map result : resultList) {
            List<FlowTransProducer> list;
            String processInstanceId = result.get(INSTANCE_ID).toString();
            List<Task> instanceTaskList = taskMap.get(processInstanceId);
            if (instanceTaskList == null) continue;
            JSONArray taskArray = new JSONArray();
            for (Task task : instanceTaskList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskName", (Object)task.getName());
                jsonObject.put("taskKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("assignee", (Object)task.getAssignee());
                taskArray.add((Object)jsonObject);
            }
            if (flowTransProducerMap != null && CollUtil.isNotEmpty(list = flowTransProducerMap.get(processInstanceId))) {
                result.put("flowTransList", list);
            }
            result.put("runtimeTaskInfoList", taskArray);
        }
        return ResponseResult.success((Object)pageResultData);
    }

    @DisableDataFilter
    @OperationLog(type=125)
    @PostMapping(value={"/remindRuntimeTask"})
    public ResponseResult<Void> remindRuntimeTask(@MyRequestBody(required=true) Long workOrderId) {
        FlowWorkOrder flowWorkOrder = (FlowWorkOrder)this.flowWorkOrderService.getById(workOrderId);
        if (flowWorkOrder == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (!flowWorkOrder.getCreateUserId().equals(TokenData.takeFromRequest().getUserId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u53ea\u6709\u6d41\u7a0b\u53d1\u8d77\u4eba\u624d\u80fd\u50ac\u529e\u5de5\u5355!";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (flowWorkOrder.getFlowStatus().equals(3) || flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.CANCELLED) || flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.STOPPED)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5df2\u7ecf\u7ed3\u675f\u7684\u6d41\u7a0b\uff0c\u4e0d\u80fd\u50ac\u529e\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.DRAFT)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6d41\u7a0b\u8349\u7a3f\u4e0d\u80fd\u50ac\u529e\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        this.flowMessageService.saveNewRemindMessage(flowWorkOrder);
        return ResponseResult.success();
    }

    @OperationLog(type=115)
    @DisableDataFilter
    @PostMapping(value={"/cancelWorkOrder"})
    public ResponseResult<Void> cancelWorkOrder(@MyRequestBody(required=true) Long workOrderId, @MyRequestBody(required=true) String cancelReason) {
        FlowWorkOrder flowWorkOrder = (FlowWorkOrder)this.flowWorkOrderService.getById(workOrderId);
        if (flowWorkOrder == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (!flowWorkOrder.getFlowStatus().equals(0) && !flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.DRAFT)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5df2\u7ecf\u8fdb\u5165\u5ba1\u6279\u72b6\u6001\uff0c\u4e0d\u80fd\u64a4\u9500\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!flowWorkOrder.getCreateUserId().equals(TokenData.takeFromRequest().getUserId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5de5\u5355\u6240\u6709\u8005\uff0c\u4e0d\u80fd\u64a4\u9500\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        CallResult result = flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.DRAFT) ? this.flowWorkOrderService.removeDraft(flowWorkOrder) : this.flowApiService.stopProcessInstance(flowWorkOrder.getProcessInstanceId(), cancelReason, true);
        if (!result.isSuccess()) {
            return ResponseResult.errorFrom((CallResult)result);
        }
        return ResponseResult.success();
    }

    @DisableDataFilter
    @PostMapping(value={"/printWorkOrder"})
    public ResponseResult<String> printWorkOrder(@MyRequestBody(required=true) Long workOrderId, @MyRequestBody(required=true) Long printId, @MyRequestBody(required=true) List<JSONArray> printParams) {
        FlowWorkOrder flowWorkOrder = (FlowWorkOrder)this.flowWorkOrderService.getById(workOrderId);
        if (flowWorkOrder == null) {
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST);
        }
        if (!flowWorkOrder.getCreateUserId().equals(TokenData.takeFromRequest().getUserId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u5de5\u5355\u6240\u6709\u8005\uff0c\u4e0d\u80fd\u64a4\u9500\u5de5\u5355\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        String token = MyCommonUtil.generateUuid();
        this.sessionCacheHelper.putSessionPrintTokenAndInfo(token, new MyPrintInfo(printId, printParams));
        return ResponseResult.success((Object)(this.flowProperties.getPrintUrlPath() + "?printToken=" + token));
    }

    @GetMapping(value={"/listAllUserTask"})
    public ResponseResult<List<JSONObject>> listAllUserTask(@RequestParam String processDefinitionId) {
        Map<String, UserTask> taskMap = this.flowApiService.getAllUserTaskMap(processDefinitionId);
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        for (UserTask t : taskMap.values()) {
            JSONObject data = new JSONObject();
            data.put("id", (Object)t.getId());
            data.put("name", (Object)t.getName());
            resultList.add(data);
        }
        return ResponseResult.success(resultList);
    }

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=126)
    @DisableDataFilter
    @PostMapping(value={"/interveneRuntimeTask"})
    public ResponseResult<Void> interveneRuntimeTask(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String taskId, @MyRequestBody(required=true) String taskComment, @MyRequestBody String targetTaskKey, @MyRequestBody String delegateAssignee) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        if (task == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5b9e\u4f8b\u7684\u5f85\u529e\u4efb\u52a1Id\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{targetTaskKey, delegateAssignee})) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u6d3e\u4eba\u548c\u8df3\u8f6c\u4efb\u52a1\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (StrUtil.isBlank((CharSequence)targetTaskKey)) {
            FlowTaskComment flowTaskComment = new FlowTaskComment();
            flowTaskComment.setDelegateAssignee(delegateAssignee);
            flowTaskComment.setApprovalType("intervene");
            this.flowApiService.transferTo(task, flowTaskComment);
            return ResponseResult.success();
        }
        CallResult result = this.flowApiService.interveneTo(task, targetTaskKey, taskComment, delegateAssignee);
        return ResponseResult.from((CallResult)result);
    }

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=105)
    @DisableDataFilter
    @PostMapping(value={"/stopProcessInstance"})
    public ResponseResult<Void> stopProcessInstance(@MyRequestBody(required=true) String processInstanceId, @MyRequestBody(required=true) String stopReason) {
        CallResult result = this.flowApiService.stopProcessInstance(processInstanceId, stopReason, false);
        if (!result.isSuccess()) {
            return ResponseResult.errorFrom((CallResult)result);
        }
        return ResponseResult.success();
    }

    @SaCheckPermission(value={"flowOperation.all"})
    @OperationLog(type=110)
    @PostMapping(value={"/deleteProcessInstance"})
    public ResponseResult<Void> deleteProcessInstance(@MyRequestBody(required=true) String processInstanceId) {
        this.flowApiService.deleteProcessInstance(processInstanceId);
        return ResponseResult.success();
    }

    private List<FlowTaskComment> buildApprovedFlowTaskCommentList(TaskInfo taskInfo, boolean isMultiInstanceTask) {
        List<FlowTaskComment> taskCommentList;
        if (isMultiInstanceTask) {
            FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getByExecutionId(taskInfo.getExecutionId(), taskInfo.getId());
            String multiInstanceExecId = trans != null ? trans.getMultiInstanceExecId() : this.flowApiService.getExecutionVariableStringWithSafe(taskInfo.getExecutionId(), "taskExecutionId");
            taskCommentList = this.flowTaskCommentService.getFlowTaskCommentListByMultiInstanceExecId(multiInstanceExecId);
        } else {
            taskCommentList = this.flowTaskCommentService.getFlowTaskCommentListByExecutionId(taskInfo.getProcessInstanceId(), taskInfo.getId(), taskInfo.getExecutionId());
        }
        return taskCommentList;
    }

    private ResponseResult<Void> doVerifyConsignAssignee(Task activeMultiInstanceTask, String newAssignees, Boolean isAdd) {
        String multiInstanceExecId = this.flowApiService.getExecutionVariableStringWithSafe(activeMultiInstanceTask.getExecutionId(), "taskExecutionId");
        JSONArray assigneeArray = JSON.parseArray((String)newAssignees);
        if (BooleanUtil.isFalse((Boolean)isAdd)) {
            Set<String> approvedAssigneeSet;
            String existAssignee;
            List<FlowTaskComment> commentList = this.flowTaskCommentService.getFlowTaskCommentListByMultiInstanceExecId(multiInstanceExecId);
            if (CollUtil.isNotEmpty(commentList) && (existAssignee = this.findExistAssignee(approvedAssigneeSet = commentList.stream().map(FlowTaskComment::getCreateLoginName).collect(Collectors.toSet()), assigneeArray)) != null) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u7528\u6237 [" + existAssignee + "] \u5df2\u7ecf\u5ba1\u6279\uff0c\u4e0d\u80fd\u51cf\u7b7e\u8be5\u7528\u6237\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        } else {
            FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
            HashSet<String> assigneeSet = new HashSet<String>(StrUtil.split((CharSequence)trans.getAssigneeList(), (CharSequence)","));
            String existAssignee = this.findExistAssignee(assigneeSet, assigneeArray);
            if (existAssignee != null) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u7528\u6237 [" + existAssignee + "] \u5df2\u7ecf\u662f\u4f1a\u7b7e\u4eba\uff0c\u4e0d\u80fd\u91cd\u590d\u6307\u5b9a\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        }
        return ResponseResult.success();
    }

    private ResponseResult<Task> doVerifySequenceMultiSign(String processInstanceId, String taskId) {
        if (!this.flowApiService.existActiveProcessInstance(processInstanceId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u52a0\u7b7e\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        List<Task> activeTaskList = this.flowApiService.getProcessInstanceActiveTaskList(processInstanceId);
        Task task = activeTaskList.stream().filter(t -> t.getId().equals(taskId)).findFirst().orElse(null);
        if (task == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u5df2\u7ecf\u4e0d\u662f\u5f85\u5ba1\u6279\u4efb\u52a1\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        Map<String, UserTask> userTaskMap = this.flowApiService.getAllUserTaskMap(task.getProcessDefinitionId());
        UserTask userTask = userTaskMap.get(task.getTaskDefinitionKey());
        if (!userTask.hasMultiInstanceLoopCharacteristics() || !userTask.getLoopCharacteristics().isSequential()) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u4e0d\u662f\u4e32\u884c\u4f1a\u7b7e\u591a\u5b9e\u4f8b\u4efb\u52a1\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)task);
    }

    private ResponseResult<JSONObject> doVerifyMultiSign(String processInstanceId, String taskId) {
        if (!this.flowApiService.existActiveProcessInstance(processInstanceId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u7ed3\u675f\uff0c\u4e0d\u80fd\u6267\u884c\u52a0\u7b7e\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        HistoricTaskInstance taskInstance = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
        if (taskInstance == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        String loginName = TokenData.takeFromRequest().getLoginName();
        if (!StrUtil.equals((CharSequence)taskInstance.getAssignee(), (CharSequence)loginName)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4efb\u52a1\u6307\u6d3e\u4eba\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        List<Task> activeTaskList = this.flowApiService.getProcessInstanceActiveTaskList(processInstanceId);
        Task activeMultiInstanceTask = null;
        Map<String, UserTask> userTaskMap = this.flowApiService.getAllUserTaskMap(taskInstance.getProcessDefinitionId());
        for (Task activeTask : activeTaskList) {
            UserTask userTask = userTaskMap.get(activeTask.getTaskDefinitionKey());
            if (!userTask.hasMultiInstanceLoopCharacteristics()) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u4efb\u52a1\u4e0d\u662f\u4f1a\u7b7e\u591a\u5b9e\u4f8b\u4efb\u52a1\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            String startTaskId = this.flowApiService.getTaskVariableStringWithSafe(activeTask.getId(), "multiSignStartTask");
            if (!StrUtil.equals((CharSequence)startTaskId, (CharSequence)taskId)) continue;
            activeMultiInstanceTask = activeTask;
            break;
        }
        if (activeMultiInstanceTask == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u52a0\u7b7e\u4efb\u52a1\u4e0d\u5b58\u5728\u6216\u5df2\u5ba1\u6279\u5b8c\u6bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        JSONObject resultData = new JSONObject();
        resultData.put("taskInstance", (Object)taskInstance);
        resultData.put(ACTIVE_MULTI_INST_TASK, activeMultiInstanceTask);
        return ResponseResult.success((Object)resultData);
    }

    private String findExistAssignee(Set<String> assigneeSet, JSONArray assigneeArray) {
        for (int i = 0; i < assigneeArray.size(); ++i) {
            String existAssignee = assigneeArray.getString(i);
            if (!assigneeSet.contains(existAssignee)) continue;
            return existAssignee;
        }
        return null;
    }
}

