/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrFormatter;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.ApplicationContextHolder;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.object.FlowTaskOperation;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoSkipTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(AutoSkipTaskListener.class);
    private final transient FlowTaskCommentService flowTaskCommentService = (FlowTaskCommentService)ApplicationContextHolder.getBean(FlowTaskCommentService.class);
    private final transient FlowApiService flowApiService = (FlowApiService)ApplicationContextHolder.getBean(FlowApiService.class);
    private final transient FlowTaskExtService flowTaskExtService = (FlowTaskExtService)ApplicationContextHolder.getBean(FlowTaskExtService.class);
    private static final String EQ_START_USER = "0";
    private static final String EQ_PREV_SUBMIT_USER = "1";
    private static final String EQ_HISTORIC_SUBMIT_USER = "2";

    public void notify(DelegateTask t) {
        UserTask userTask = this.flowApiService.getUserTask(t.getProcessDefinitionId(), t.getTaskDefinitionKey());
        List attributes = (List)userTask.getAttributes().get("autoSkipType");
        HashSet skipTypes = new HashSet(StrUtil.split((CharSequence)((ExtensionAttribute)attributes.get(0)).getValue(), (CharSequence)","));
        String assignedUser = this.getAssignedUser(userTask, t.getProcessDefinitionId(), t.getExecutionId());
        if (StrUtil.isBlank((CharSequence)assignedUser)) {
            return;
        }
        for (String skipType : skipTypes) {
            if (!this.verifyAndHandle(userTask, t, skipType, assignedUser)) continue;
            return;
        }
    }

    private boolean verifyAndHandle(UserTask userTask, DelegateTask task, String skipType, String assignedUser) {
        FlowTaskComment comment = null;
        switch (skipType) {
            case "0": {
                Object v = task.getVariable("startUserName");
                if (!ObjectUtil.equal((Object)v, (Object)assignedUser)) break;
                comment = this.flowTaskCommentService.getFirstFlowTaskComment(task.getProcessInstanceId());
                break;
            }
            case "1": {
                Object v2 = task.getVariable("submitUser");
                if (!ObjectUtil.equal((Object)v2, (Object)assignedUser)) break;
                TokenData tokenData = TokenData.takeFromRequest();
                comment = new FlowTaskComment();
                comment.setCreateUserId(tokenData.getUserId());
                comment.setCreateLoginName(tokenData.getLoginName());
                comment.setCreateUsername(tokenData.getShowName());
                break;
            }
            case "2": {
                List<FlowTaskComment> comments = this.flowTaskCommentService.getFlowTaskCommentList(task.getProcessInstanceId());
                LinkedList<FlowTaskComment> resultComments = new LinkedList<FlowTaskComment>();
                for (FlowTaskComment c : comments) {
                    if (!StrUtil.equals((CharSequence)c.getCreateLoginName(), (CharSequence)assignedUser)) continue;
                    resultComments.add(c);
                }
                if (!CollUtil.isNotEmpty(resultComments)) break;
                comment = (FlowTaskComment)resultComments.get(0);
                break;
            }
        }
        if (comment != null) {
            FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(task.getProcessDefinitionId(), userTask.getId());
            JSONObject taskVariableData = new JSONObject();
            if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getOperationListJson())) {
                List taskOperationList = JSONArray.parseArray((String)flowTaskExt.getOperationListJson(), FlowTaskOperation.class);
                taskOperationList.stream().filter(op -> op.getType().equals("agree")).findFirst().ifPresent(op -> taskVariableData.put("latestApprovalStatus", (Object)op.getLatestApprovalStatus()));
            }
            Task t = this.flowApiService.getTaskById(task.getId());
            comment.fillWith((TaskInfo)t);
            comment.setApprovalType("agree");
            comment.setTaskComment(StrFormatter.format((String)"\u81ea\u52a8\u8df3\u8fc7\u5ba1\u6279\u3002\u5ba1\u6279\u4eba [{}], \u8df3\u8fc7\u539f\u56e0 [{}]\u3002", (Object[])new Object[]{assignedUser, this.getMessageBySkipType(skipType)}));
            this.flowApiService.completeTask(t, comment, taskVariableData, null);
        }
        return comment != null;
    }

    private String getAssignedUser(UserTask userTask, String processDefinitionId, String executionId) {
        String assignedUser = userTask.getAssignee();
        if (StrUtil.isNotBlank((CharSequence)assignedUser)) {
            if (assignedUser.startsWith("${") && assignedUser.endsWith("}")) {
                String variableName = assignedUser.substring(2, assignedUser.length() - 1);
                assignedUser = this.flowApiService.getExecutionVariableStringWithSafe(executionId, variableName);
            }
        } else {
            List candidateUsernames;
            FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(processDefinitionId, userTask.getId());
            if (StrUtil.isBlank((CharSequence)flowTaskExt.getCandidateUsernames())) {
                candidateUsernames = Collections.emptyList();
            } else if (!StrUtil.equals((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)"${appointedAssignee}")) {
                candidateUsernames = StrUtil.split((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)",");
            } else {
                String value = this.flowApiService.getExecutionVariableStringWithSafe(executionId, "appointedAssignee");
                List list = candidateUsernames = value == null ? null : StrUtil.split((CharSequence)value, (CharSequence)",");
            }
            if (candidateUsernames != null && candidateUsernames.size() == 1) {
                assignedUser = (String)candidateUsernames.get(0);
            }
        }
        return assignedUser;
    }

    private String getMessageBySkipType(String skipType) {
        switch (skipType) {
            case "1": {
                return "\u5ba1\u6279\u4eba\u4e0e\u4e0a\u4e00\u5ba1\u6279\u8282\u70b9\u5904\u7406\u4eba\u76f8\u540c";
            }
            case "0": {
                return "\u5ba1\u6279\u4eba\u4e3a\u53d1\u8d77\u4eba";
            }
            case "2": {
                return "\u5ba1\u6279\u4eba\u5ba1\u6279\u8fc7";
            }
        }
        return "";
    }
}

