/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dic.bid.common.core.util.ApplicationContextHolder;
import com.dic.bid.common.flow.exception.FlowEmptyUserException;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.object.FlowUserTaskExtData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import java.util.List;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowEmptyUserHandleListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(FlowEmptyUserHandleListener.class);
    private final transient FlowTaskExtService flowTaskExtService = (FlowTaskExtService)ApplicationContextHolder.getBean(FlowTaskExtService.class);
    private final transient FlowApiService flowApiService = (FlowApiService)ApplicationContextHolder.getBean(FlowApiService.class);

    public void notify(DelegateTask t) {
        FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(t.getProcessDefinitionId(), t.getTaskDefinitionKey());
        Task task = this.flowApiService.getTaskById(t.getId());
        List<FlowUserInfoVo> userInfoVoList = this.flowTaskExtService.getCandidateUserInfoList(t.getProcessInstanceId(), flowTaskExt, (TaskInfo)task, this.flowApiService.isMultiInstanceTask(t.getProcessDefinitionId(), t.getTaskDefinitionKey()), false);
        if (CollUtil.isNotEmpty(userInfoVoList)) {
            return;
        }
        FlowUserTaskExtData taskExtData = (FlowUserTaskExtData)JSON.parseObject((String)flowTaskExt.getExtraDataJson(), FlowUserTaskExtData.class);
        if (StrUtil.isBlank((CharSequence)taskExtData.getEmptyUserHandleWay())) {
            taskExtData.setEmptyUserHandleWay("autoComplete");
        }
        switch (taskExtData.getEmptyUserHandleWay()) {
            case "toAssignee": {
                t.setAssignee(taskExtData.getEmptyUserToAssignee());
                break;
            }
            case "autoReject": 
            case "autoComplete": {
                FlowTaskComment comment = new FlowTaskComment();
                comment.fillWith((TaskInfo)task);
                if (taskExtData.getEmptyUserHandleWay().equals("autoReject")) {
                    comment.setApprovalType("empty_user_auto_reject");
                    comment.setTaskComment("\u7a7a\u5ba1\u6279\u4eba\u81ea\u52a8\u56de\u9000\u5ba1\u6279");
                    throw new FlowEmptyUserException(JSON.toJSONString((Object)comment));
                }
                comment.setApprovalType("empty_user_auto_complete");
                comment.setTaskComment("\u7a7a\u5ba1\u6279\u4eba\u81ea\u52a8\u8df3\u8fc7\u5ba1\u6279");
                this.flowApiService.completeTask(task, comment, null, null);
                break;
            }
        }
    }
}

