/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.listener;

import cn.hutool.core.util.StrUtil;
import com.dic.bid.common.core.object.GlobalThreadLocal;
import com.dic.bid.common.core.util.ApplicationContextHolder;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.service.FlowTaskTimeoutJobService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowFinishedListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(FlowFinishedListener.class);
    private final transient FlowWorkOrderService flowWorkOrderService = (FlowWorkOrderService)ApplicationContextHolder.getBean(FlowWorkOrderService.class);
    private final transient FlowCustomExtFactory flowCustomExtFactory = (FlowCustomExtFactory)ApplicationContextHolder.getBean(FlowCustomExtFactory.class);
    private final transient FlowTaskTimeoutJobService flowTaskTimeoutJobService = (FlowTaskTimeoutJobService)ApplicationContextHolder.getBean(FlowTaskTimeoutJobService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notify(DelegateExecution execution) {
        if (!StrUtil.equals((CharSequence)"end", (CharSequence)execution.getEventName())) {
            return;
        }
        boolean enabled = GlobalThreadLocal.setDataFilter((boolean)false);
        try {
            String processInstanceId = execution.getProcessInstanceId();
            FlowWorkOrder workOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(processInstanceId);
            if (workOrder == null) {
                return;
            }
            int flowStatus = 3;
            if (workOrder.getFlowStatus().equals(FlowTaskStatus.CANCELLED) || workOrder.getFlowStatus().equals(FlowTaskStatus.STOPPED)) {
                flowStatus = workOrder.getFlowStatus();
            }
            workOrder.setFlowStatus(flowStatus);
            this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(processInstanceId, flowStatus);
            if (workOrder.getOnlineTableId() != null) {
                this.flowCustomExtFactory.getOnlineBusinessDataExtHelper().updateFlowStatus(workOrder);
            } else {
                this.flowCustomExtFactory.getBusinessDataExtHelper().updateFlowStatus(workOrder);
            }
            if (flowStatus == 3) {
                this.flowCustomExtFactory.getBusinessDataExtHelper().triggerSync(workOrder);
            }
            this.flowTaskTimeoutJobService.deleteByProcessInstanceId(execution.getProcessInstanceId());
        }
        finally {
            GlobalThreadLocal.setDataFilter((boolean)enabled);
        }
    }
}

