/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.dic.bid.common.core.util.ApplicationContextHolder;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.object.FlowUserTaskExtData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.util.BaseFlowNotifyExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.FlowTaskVo;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import java.util.List;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowTaskNotifyListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskNotifyListener.class);
    private final transient FlowTaskExtService flowTaskExtService = (FlowTaskExtService)ApplicationContextHolder.getBean(FlowTaskExtService.class);
    private final transient FlowApiService flowApiService = (FlowApiService)ApplicationContextHolder.getBean(FlowApiService.class);
    private final transient FlowCustomExtFactory flowCustomExtFactory = (FlowCustomExtFactory)ApplicationContextHolder.getBean(FlowCustomExtFactory.class);

    public void notify(DelegateTask delegateTask) {
        String definitionId = delegateTask.getProcessDefinitionId();
        String instanceId = delegateTask.getProcessInstanceId();
        String taskId = delegateTask.getId();
        String taskKey = delegateTask.getTaskDefinitionKey();
        FlowTaskExt taskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(definitionId, taskKey);
        if (StrUtil.isBlank((CharSequence)taskExt.getExtraDataJson())) {
            return;
        }
        FlowUserTaskExtData extData = (FlowUserTaskExtData)JSON.parseObject((String)taskExt.getExtraDataJson(), FlowUserTaskExtData.class);
        if (CollUtil.isEmpty(extData.getFlowNotifyTypeList())) {
            return;
        }
        ProcessInstance instance = this.flowApiService.getProcessInstance(instanceId);
        Object initiator = this.flowApiService.getProcessInstanceVariable(instanceId, "initiator");
        boolean isMultiInstanceTask = this.flowApiService.isMultiInstanceTask(definitionId, taskKey);
        Task task = this.flowApiService.getProcessInstanceActiveTask(instanceId, taskId);
        List<FlowUserInfoVo> userInfoList = this.flowTaskExtService.getCandidateUserInfoList(instanceId, taskExt, (TaskInfo)task, isMultiInstanceTask, false);
        if (CollUtil.isEmpty(userInfoList)) {
            log.warn("ProcessDefinition [{}] Task [{}] don't find the candidate users for notification.", (Object)instance.getProcessDefinitionName(), (Object)task.getName());
            return;
        }
        BaseFlowNotifyExtHelper helper = this.flowCustomExtFactory.getFlowNotifyExtHelper();
        Assert.notNull((Object)helper);
        for (String notifyType : extData.getFlowNotifyTypeList()) {
            FlowTaskVo flowTaskVo = new FlowTaskVo();
            flowTaskVo.setProcessDefinitionId(definitionId);
            flowTaskVo.setProcessInstanceId(instanceId);
            flowTaskVo.setTaskKey(taskKey);
            flowTaskVo.setTaskName(delegateTask.getName());
            flowTaskVo.setTaskId(delegateTask.getId());
            flowTaskVo.setBusinessKey(instance.getBusinessKey());
            flowTaskVo.setProcessInstanceInitiator(initiator.toString());
            helper.doNotify(notifyType, userInfoList, flowTaskVo);
        }
    }
}

