/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateField;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSON;
import com.dic.bid.common.core.util.ApplicationContextHolder;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowVariableLog;
import com.dic.bid.common.flow.object.FlowEntryExtensionData;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowVariableLogService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.task.service.delegate.DelegateTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowTaskReviveListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskReviveListener.class);
    private final transient FlowVariableLogService flowVariableLogService = (FlowVariableLogService)ApplicationContextHolder.getBean(FlowVariableLogService.class);
    private final transient FlowEntryService flowEntryService = (FlowEntryService)ApplicationContextHolder.getBean(FlowEntryService.class);

    public void notify(DelegateTask delegateTask) {
        Map variables = delegateTask.getVariables();
        if (MapUtil.isNotEmpty((Map)variables)) {
            List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(CollUtil.newHashSet((Object[])new String[]{delegateTask.getProcessDefinitionId()}));
            FlowEntryExtensionData flowEntryExtensionData = (FlowEntryExtensionData)JSON.parseObject((String)flowEntryPublishList.get(0).getExtensionData(), FlowEntryExtensionData.class);
            FlowVariableLog o = new FlowVariableLog();
            if (flowEntryExtensionData.getKeptReviveDays() > 0) {
                o.setExpiredTime((Date)DateUtil.offset((Date)new Date(), (DateField)DateField.DAY_OF_MONTH, (int)flowEntryExtensionData.getKeptReviveDays()));
            }
            o.setProcessDefinitionKey(delegateTask.getProcessDefinitionId());
            o.setProcessInstanceId(delegateTask.getProcessInstanceId());
            o.setTaskKey(delegateTask.getTaskDefinitionKey());
            o.setVariableData(JSON.toJSONString((Object)variables));
            this.flowVariableLogService.saveNew(o);
        }
    }
}

