/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.object;

import java.util.LinkedList;
import java.util.List;

public class FlowTaskPostCandidateGroup {
    private String id;
    private String type;
    private String postId;
    private String deptPostId;

    public static List<String> buildCandidateGroupList(List<FlowTaskPostCandidateGroup> groupDataList) {
        LinkedList<String> candidateGroupList = new LinkedList<String>();
        for (FlowTaskPostCandidateGroup groupData : groupDataList) {
            switch (groupData.getType()) {
                case "allDeptPost": {
                    candidateGroupList.add(groupData.getPostId());
                    break;
                }
                case "deptPost": {
                    candidateGroupList.add(groupData.getDeptPostId());
                    break;
                }
                case "selfDeptPost": {
                    candidateGroupList.add("${SELF_DEPT_" + groupData.getPostId() + "}");
                    break;
                }
                case "siblingDeptPost": {
                    candidateGroupList.add("${SIBLING_DEPT_" + groupData.getPostId() + "}");
                    break;
                }
                case "upDeptPost": {
                    candidateGroupList.add("${UP_DEPT_" + groupData.getPostId() + "}");
                    break;
                }
            }
        }
        return candidateGroupList;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getPostId() {
        return this.postId;
    }

    public String getDeptPostId() {
        return this.deptPostId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public void setDeptPostId(String deptPostId) {
        this.deptPostId = deptPostId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowTaskPostCandidateGroup)) {
            return false;
        }
        FlowTaskPostCandidateGroup other = (FlowTaskPostCandidateGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$postId = this.getPostId();
        String other$postId = other.getPostId();
        if (this$postId == null ? other$postId != null : !this$postId.equals(other$postId)) {
            return false;
        }
        String this$deptPostId = this.getDeptPostId();
        String other$deptPostId = other.getDeptPostId();
        return !(this$deptPostId == null ? other$deptPostId != null : !this$deptPostId.equals(other$deptPostId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowTaskPostCandidateGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $postId = this.getPostId();
        result = result * 59 + ($postId == null ? 43 : $postId.hashCode());
        String $deptPostId = this.getDeptPostId();
        result = result * 59 + ($deptPostId == null ? 43 : $deptPostId.hashCode());
        return result;
    }

    public String toString() {
        return "FlowTaskPostCandidateGroup(id=" + this.getId() + ", type=" + this.getType() + ", postId=" + this.getPostId() + ", deptPostId=" + this.getDeptPostId() + ")";
    }
}

