/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.model.FlowWorkOrderExt;
import com.dic.bid.common.flow.service.FlowApiOperationService;
import com.dic.bid.common.flow.service.FlowApiRequestLogService;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowApiOperationService")
public class FlowApiOperationServiceImpl
implements FlowApiOperationService {
    private static final Logger log = LoggerFactory.getLogger(FlowApiOperationServiceImpl.class);
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowApiRequestLogService flowApiRequestLogService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder startWithBusinessKey(String processDefinitionId, String dataId, JSONObject variables) {
        if (this.flowApiRequestLogService.exists()) {
            return this.getFlowWorkOrder(processDefinitionId, dataId);
        }
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId, variables);
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.saveNew(instance, dataId, null, null);
        this.flowApiRequestLogService.saveNewFromProcessInstance(instance);
        return flowWorkOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder startAndTakeFirst(String processDefinitionId, String dataId, FlowTaskComment comment, JSONObject variables) {
        if (this.flowApiRequestLogService.exists()) {
            return this.getFlowWorkOrder(processDefinitionId, dataId);
        }
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId);
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.saveNew(instance, dataId, null, null);
        this.flowApiService.takeFirstTask(instance.getProcessInstanceId(), comment, variables);
        Integer approvalStatus = MapUtil.getInt((Map)variables, (Object)"latestApprovalStatus");
        this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(instance.getId(), approvalStatus);
        this.flowApiRequestLogService.saveNewFromProcessInstance(instance);
        return flowWorkOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder startAndSaveNewDraft(String processDefinitionId, String dataId, String masterData, String slaveData) {
        if (this.flowApiRequestLogService.exists()) {
            return this.getFlowWorkOrder(processDefinitionId, dataId);
        }
        ProcessInstance instance = this.flowApiService.start(processDefinitionId, dataId);
        Map<String, Object> variableMap = this.flowApiService.initAndGetProcessInstanceVariables(processDefinitionId);
        this.flowApiService.setProcessInstanceVariables(instance.getProcessInstanceId(), variableMap);
        this.flowApiRequestLogService.saveNewFromProcessInstance(instance);
        return this.flowWorkOrderService.saveNewWithDraft(instance, null, null, masterData, slaveData);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder takeFirstTask(ProcessInstance instance, Task task, FlowTaskComment comment, JSONObject variables) {
        if (this.flowApiRequestLogService.exists()) {
            return this.getFlowWorkOrder(instance.getProcessDefinitionId(), instance.getBusinessKey());
        }
        String dataId = instance.getBusinessKey();
        this.flowApiService.setBusinessKeyForProcessInstance(instance.getProcessInstanceId(), dataId);
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(instance.getProcessInstanceId());
        this.flowApiService.completeTask(task, comment, variables, null);
        if (flowWorkOrder == null) {
            this.flowWorkOrderService.saveNew(instance, dataId, null, null);
        } else {
            flowWorkOrder.setBusinessKey(dataId);
            flowWorkOrder.setUpdateTime(new Date());
            flowWorkOrder.setFlowStatus(0);
            this.flowWorkOrderService.updateById(flowWorkOrder);
        }
        this.flowApiRequestLogService.saveNewFromProcessInstanceAndTask(instance, task);
        return flowWorkOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder takeTask(ProcessInstance instance, Task task, FlowTaskComment comment, JSONObject variables) {
        if (this.flowApiRequestLogService.exists()) {
            return this.getFlowWorkOrder(instance.getProcessDefinitionId(), instance.getBusinessKey());
        }
        int flowStatus = 1;
        if (comment.getApprovalType().equals("refuse")) {
            flowStatus = 2;
        } else if (comment.getApprovalType().equals("stop")) {
            flowStatus = 3;
        }
        this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(task.getProcessInstanceId(), flowStatus);
        if (comment.getApprovalType().equals("stop")) {
            Integer s = MapUtil.getInt((Map)variables, (Object)"latestApprovalStatus");
            this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), s);
            CallResult stopResult = this.flowApiService.stopProcessInstance(task.getProcessInstanceId(), comment.getTaskComment(), flowStatus);
            if (!stopResult.isSuccess()) {
                throw new FlowOperationException(stopResult.getErrorMessage());
            }
        } else {
            this.flowApiService.completeTask(task, comment, variables, null);
        }
        this.flowApiRequestLogService.saveNewFromProcessInstanceAndTask(instance, task);
        return this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(instance.getProcessInstanceId());
    }

    @Override
    public void buildDraftData(List<FlowWorkOrderVo> draftWorkOrderList) {
        if (CollUtil.isEmpty(draftWorkOrderList)) {
            return;
        }
        Set<Long> workOrderIdSet = draftWorkOrderList.stream().map(FlowWorkOrderVo::getWorkOrderId).collect(Collectors.toSet());
        Map<Long, FlowWorkOrderExt> workOrderExtMap = this.flowWorkOrderService.getFlowWorkOrderExtByWorkOrderIds(workOrderIdSet).stream().collect(Collectors.toMap(FlowWorkOrderExt::getWorkOrderId, c -> c));
        for (FlowWorkOrderVo workOrder : draftWorkOrderList) {
            FlowWorkOrderExt workOrderExt = workOrderExtMap.get(workOrder.getWorkOrderId());
            if (workOrderExt == null) continue;
            workOrder.setDraftData(workOrderExt.getDraftData());
        }
    }

    private FlowWorkOrder getFlowWorkOrder(String processDefinitionId, String dataId) {
        ProcessInstance instance = this.flowApiService.getProcessInstanceByBusinessKey(processDefinitionId, dataId);
        return this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(instance.getProcessInstanceId());
    }
}

