/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.ContextUtil;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowApiRequestLogMapper;
import com.dic.bid.common.flow.model.FlowApiRequestLog;
import com.dic.bid.common.flow.service.FlowApiRequestLogService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Date;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowApiRequestLogService")
public class FlowApiRequestLogServiceImpl
extends BaseService<FlowApiRequestLog, Long>
implements FlowApiRequestLogService {
    private static final Logger log = LoggerFactory.getLogger(FlowApiRequestLogServiceImpl.class);
    @Autowired
    private FlowApiRequestLogMapper flowApiRequestLogMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowApiRequestLog> mapper() {
        return this.flowApiRequestLogMapper;
    }

    @Override
    public FlowApiRequestLog saveNewFromProcessInstance(ProcessInstance instance) {
        String flowRequestId = this.getRequestId();
        FlowApiRequestLog log = null;
        if (flowRequestId != null) {
            log = this.createBy(flowRequestId, instance);
            this.flowApiRequestLogMapper.insert(log);
        }
        return log;
    }

    @Override
    public FlowApiRequestLog saveNewFromProcessInstanceAndTask(ProcessInstance instance, Task task) {
        String flowRequestId = this.getRequestId();
        FlowApiRequestLog log = null;
        if (flowRequestId != null) {
            log = this.createBy(flowRequestId, instance);
            log.setTaskId(task.getId());
            log.setTaskKey(task.getTaskDefinitionKey());
            this.flowApiRequestLogMapper.insert(log);
        }
        return log;
    }

    @Override
    public boolean exists() {
        String flowRequestId = this.getRequestId();
        if (flowRequestId == null) {
            return false;
        }
        return this.flowApiRequestLogMapper.exists((Wrapper)new LambdaQueryWrapper().eq(FlowApiRequestLog::getRequestId, (Object)flowRequestId));
    }

    private String getRequestId() {
        return ContextUtil.getHttpRequest().getHeader("apiRequestId");
    }

    private FlowApiRequestLog createBy(String flowRequestId, ProcessInstance instance) {
        FlowApiRequestLog o = new FlowApiRequestLog();
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData != null) {
            o.setCreateUserId(tokenData.getUserId());
            o.setCreateTime(new Date());
        }
        o.setId(this.idGenerator.nextLongId());
        o.setRequestId(flowRequestId);
        o.setProcessInstanceId(instance.getProcessInstanceId());
        o.setBusinessKey(instance.getBusinessKey());
        return o;
    }
}

