/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MultiDatabaseWriteMethod;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.exception.MyRuntimeException;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.object.Tuple2;
import com.dic.bid.common.core.object.Tuple3;
import com.dic.bid.common.core.object.TypedCallResult;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.core.util.MyCommonUtil;
import com.dic.bid.common.flow.cmd.AddSequenceMultiInstanceCmd;
import com.dic.bid.common.flow.cmd.RestartProcessInstanceCmd;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.exception.FlowOperationException;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowMultiInstanceTrans;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.object.AnalyzedNode;
import com.dic.bid.common.flow.object.FlowApiOption;
import com.dic.bid.common.flow.object.FlowEntryExtensionData;
import com.dic.bid.common.flow.object.FlowRejectData;
import com.dic.bid.common.flow.object.FlowTaskCommentExtra;
import com.dic.bid.common.flow.object.FlowTaskMultiSignAssign;
import com.dic.bid.common.flow.object.FlowTaskOperation;
import com.dic.bid.common.flow.object.FlowTaskPostCandidateGroup;
import com.dic.bid.common.flow.object.FlowUserTaskExtData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.service.FlowMultiInstanceTransService;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.service.FlowTaskTimeoutJobService;
import com.dic.bid.common.flow.service.FlowTransProducerService;
import com.dic.bid.common.flow.service.FlowVariableLogService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.CustomChangeActivityStateBuilderImpl;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.FlowTaskVo;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.FlowableListener;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ReceiveTask;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.de.odysseus.el.ExpressionFactoryImpl;
import org.flowable.common.engine.impl.de.odysseus.el.util.SimpleContext;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ValueExpression;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ManagementService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.ExecutionListener;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.impl.RuntimeServiceImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ChangeActivityStateBuilder;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.variable.api.history.HistoricVariableInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowApiService")
public class FlowApiServiceImpl
implements FlowApiService {
    private static final Logger log = LoggerFactory.getLogger(FlowApiServiceImpl.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private FlowTaskCommentService flowTaskCommentService;
    @Autowired
    private FlowTaskExtService flowTaskExtService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowMessageService flowMessageService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private FlowMultiInstanceTransService flowMultiInstanceTransService;
    @Autowired
    private FlowTransProducerService flowTransProducerService;
    @Autowired
    private FlowVariableLogService flowVariableLogService;
    @Autowired
    private FlowTaskTimeoutJobService flowTaskTimeoutJobService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance start(String processDefinitionId, Object dataId) {
        return this.start(processDefinitionId, dataId, null);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance start(String processDefinitionId, Object dataId, JSONObject taskVariableData) {
        TokenData tokenData = TokenData.takeFromRequest();
        Map<String, Object> variableMap = this.initAndGetProcessInstanceVariables(processDefinitionId);
        if (MapUtil.isNotEmpty((Map)taskVariableData)) {
            variableMap.putAll((Map<String, Object>)taskVariableData);
        }
        Authentication.setAuthenticatedUserId((String)tokenData.getLoginName());
        String businessKey = dataId == null ? null : dataId.toString();
        ProcessInstanceBuilder builder = this.runtimeService.createProcessInstanceBuilder().processDefinitionId(processDefinitionId).businessKey(businessKey).variables(variableMap);
        if (tokenData.getTenantId() != null) {
            builder.tenantId(tokenData.getTenantId().toString());
        } else if (tokenData.getAppCode() != null) {
            builder.tenantId(tokenData.getAppCode());
        }
        return builder.start();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance revive(String processInstanceId, List<String> taskKeys, String taskComment) {
        FlowTaskComment comment = new FlowTaskComment();
        comment.setTargetTaskKey(StrUtil.join((CharSequence)",", taskKeys));
        comment.setProcessInstanceId(processInstanceId);
        comment.setApprovalType("revive");
        comment.setTaskComment(taskComment);
        this.flowTaskCommentService.saveNew(comment);
        Map<String, String> variableMap = this.flowVariableLogService.getVariableMap(processInstanceId, taskKeys);
        ProcessInstance instance = (ProcessInstance)this.managementService.executeCommand((Command)new RestartProcessInstanceCmd(processInstanceId, taskKeys, variableMap));
        this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(processInstanceId, 0);
        return instance;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public org.flowable.task.api.Task takeFirstTask(String processInstanceId, FlowTaskComment flowTaskComment, JSONObject taskVariableData) {
        String loginName = TokenData.takeFromRequest().getLoginName();
        org.flowable.task.api.Task task = (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().singleResult();
        if (StrUtil.equalsAny((CharSequence)task.getAssignee(), (CharSequence[])new CharSequence[]{loginName, "${startUserName}"})) {
            flowTaskComment.fillWith((TaskInfo)task);
            this.completeTask(task, flowTaskComment, taskVariableData, null);
        }
        return task;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ProcessInstance startAndTakeFirst(String processDefinitionId, Object dataId, FlowTaskComment flowTaskComment, JSONObject taskVariableData) {
        ProcessInstance instance = this.start(processDefinitionId, dataId);
        this.takeFirstTask(instance.getProcessInstanceId(), flowTaskComment, taskVariableData);
        return instance;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitConsign(HistoricTaskInstance startTaskInstance, org.flowable.task.api.Task multiInstanceActiveTask, String newAssignees, boolean isAdd) {
        JSONArray assigneeArray = JSON.parseArray((String)newAssignees);
        String multiInstanceExecId = this.getExecutionVariableStringWithSafe(multiInstanceActiveTask.getExecutionId(), "taskExecutionId");
        FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
        HashSet<String> assigneeSet = new HashSet<String>(StrUtil.split((CharSequence)trans.getAssigneeList(), (CharSequence)","));
        org.flowable.task.api.Task runtimeTask = null;
        for (int i = 0; i < assigneeArray.size(); ++i) {
            String assignee = assigneeArray.getString(i);
            if (isAdd) {
                assigneeSet.add(assignee);
            } else {
                assigneeSet.remove(assignee);
            }
            if (isAdd) {
                HashMap<String, String> variables = new HashMap<String, String>(2);
                variables.put("assignee", assigneeArray.getString(i));
                variables.put("multiSignStartTask", startTaskInstance.getId());
                this.runtimeService.addMultiInstanceExecution(multiInstanceActiveTask.getTaskDefinitionKey(), multiInstanceActiveTask.getProcessInstanceId(), variables);
                continue;
            }
            TaskQuery query = this.taskService.createTaskQuery().active();
            query.processInstanceId(multiInstanceActiveTask.getProcessInstanceId());
            query.taskDefinitionKey(multiInstanceActiveTask.getTaskDefinitionKey());
            query.taskAssignee(assignee);
            runtimeTask = (org.flowable.task.api.Task)query.singleResult();
            if (runtimeTask == null) {
                throw new FlowOperationException("\u5ba1\u6279\u4eba [" + assignee + "] \u5df2\u7ecf\u63d0\u4ea4\u5ba1\u6279\uff0c\u4e0d\u80fd\u6267\u884c\u51cf\u7b7e\u64cd\u4f5c\uff01");
            }
            this.runtimeService.deleteMultiInstanceExecution(runtimeTask.getExecutionId(), false);
        }
        if (!isAdd && runtimeTask != null) {
            this.doChangeTask(runtimeTask);
        }
        trans.setAssigneeList(StrUtil.join((CharSequence)",", assigneeSet));
        this.flowMultiInstanceTransService.updateById(trans);
        FlowTaskComment flowTaskComment = new FlowTaskComment();
        flowTaskComment.fillWith((TaskInfo)startTaskInstance);
        flowTaskComment.setApprovalType(isAdd ? "multi_consign" : "multi_minus_sign");
        String showName = TokenData.takeFromRequest().getLoginName();
        String comment = String.format("\u7528\u6237 [%s] [%s] [%s]\u3002", isAdd ? "\u52a0\u7b7e" : "\u51cf\u7b7e", showName, newAssignees);
        flowTaskComment.setTaskComment(comment);
        this.flowTaskCommentService.saveNew(flowTaskComment);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void submitSequenceConsign(org.flowable.task.api.Task multiInstanceActiveTask, String newAssignees, boolean before) {
        JSONArray assigneeArray = JSON.parseArray((String)newAssignees);
        LinkedList<String> newAssigneeList = new LinkedList<String>();
        for (int i = 0; i < assigneeArray.size(); ++i) {
            newAssigneeList.add(assigneeArray.getString(i));
        }
        String multiInstanceExecId = this.getExecutionVariableStringWithSafe(multiInstanceActiveTask.getExecutionId(), "taskExecutionId");
        FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
        List updatedAssignees = (List)this.managementService.executeCommand((Command)new AddSequenceMultiInstanceCmd(trans.getAssigneeList(), multiInstanceActiveTask.getId(), newAssigneeList, before));
        trans.setAssigneeList(StrUtil.join((CharSequence)",", (Iterable)updatedAssignees));
        this.flowMultiInstanceTransService.updateById(trans);
        FlowTaskComment flowTaskComment = new FlowTaskComment();
        flowTaskComment.fillWith((TaskInfo)multiInstanceActiveTask);
        flowTaskComment.setApprovalType(before ? "multi_before_consign" : "multi_after_consign");
        String showName = TokenData.takeFromRequest().getLoginName();
        String comment = String.format("\u7528\u6237 [%s] [%s] [%s]\u3002", before ? "\u524d\u52a0\u7b7e" : "\u540e\u52a0\u7b7e", showName, newAssignees);
        flowTaskComment.setTaskComment(comment);
        this.flowTaskCommentService.saveNew(flowTaskComment);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void completeTask(org.flowable.task.api.Task task, FlowTaskComment flowTaskComment, JSONObject taskVariableData, FlowApiOption option) {
        String value = this.getTaskVariableStringWithSafe(task.getId(), "rejectData");
        if (StrUtil.isNotBlank((CharSequence)value) && MyCommonUtil.equalsAny((Object)flowTaskComment.getApprovalType(), (Object[])new Object[]{"agree", "multi_sign"})) {
            FlowRejectData rejectData = (FlowRejectData)JSON.parseObject((String)value, FlowRejectData.class);
            flowTaskComment.fillWith((TaskInfo)task);
            flowTaskComment.enableRejectBackType(task.getId(), rejectData.getSourceTaskKey(), rejectData.getSourceUser());
            this.flowTaskCommentService.saveNew(flowTaskComment);
            Integer approvalStatus = MapUtil.getInt((Map)taskVariableData, (Object)"latestApprovalStatus");
            this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), approvalStatus);
            HashMap variables = MapUtil.newHashMap();
            variables.put("rejectBackData", rejectData.getSourceUser());
            this.doChangeState(task, CollUtil.newArrayList((Object[])new String[]{task.getTaskDefinitionKey()}), CollUtil.newArrayList((Object[])new String[]{rejectData.getSourceTaskKey()}), null, variables);
            this.flowMessageService.updateFinishedStatusByTaskId(task.getId());
            return;
        }
        if (taskVariableData == null) {
            taskVariableData = new JSONObject();
        }
        JSONObject passCopyData = (JSONObject)taskVariableData.remove((Object)"copyDataKey");
        Object copyData = this.runtimeService.getVariable(task.getProcessInstanceId(), "copyDataMap_" + task.getTaskDefinitionKey());
        if (copyData != null || passCopyData != null) {
            JSONObject copyDataJson = this.mergeCopyData(task.getId(), copyData, passCopyData);
            this.flowMessageService.saveNewCopyMessage(task, copyDataJson);
        }
        if (flowTaskComment != null) {
            if (flowTaskComment.getApprovalType().equals("multi_sign")) {
                String loginName = TokenData.takeFromRequest().getLoginName();
                String assigneeList = this.getMultiInstanceAssigneeList(task, taskVariableData);
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)assigneeList));
                taskVariableData.put("multiAgreeCount", (Object)0);
                taskVariableData.put("multiRefuseCount", (Object)0);
                taskVariableData.put("multiAbstainCount", (Object)0);
                taskVariableData.put("multiNumOfInstances", (Object)0);
                taskVariableData.put("multiSignStartTask", (Object)task.getId());
                String multiInstanceExecId = MyCommonUtil.generateUuid();
                taskVariableData.put("taskExecutionId", (Object)multiInstanceExecId);
                String comment = String.format("\u7528\u6237 [%s] \u4f1a\u7b7e [%s]\u3002", loginName, assigneeList);
                FlowMultiInstanceTrans multiInstanceTrans = new FlowMultiInstanceTrans((TaskInfo)task);
                multiInstanceTrans.setMultiInstanceExecId(multiInstanceExecId);
                multiInstanceTrans.setAssigneeList(assigneeList);
                this.flowMultiInstanceTransService.saveNew(multiInstanceTrans);
                flowTaskComment.setTaskComment(comment);
            }
            if ("transfer".equals(flowTaskComment.getApprovalType())) {
                this.transferTo(task, flowTaskComment);
                return;
            }
            this.handleMultiInstanceApprovalType(task.getExecutionId(), flowTaskComment.getApprovalType(), taskVariableData);
            taskVariableData.put("operationType", (Object)flowTaskComment.getApprovalType());
            this.setSubmitUserVar(taskVariableData, flowTaskComment);
            this.recordTaskCommentIdentityVariable(task, flowTaskComment);
            flowTaskComment.fillWith((TaskInfo)task);
            if (this.isMultiInstanceTask(task.getProcessDefinitionId(), task.getTaskDefinitionKey())) {
                String multiInstanceExecId = this.getExecutionVariableStringWithSafe(task.getExecutionId(), "taskExecutionId");
                FlowMultiInstanceTrans multiInstanceTrans = new FlowMultiInstanceTrans((TaskInfo)task);
                multiInstanceTrans.setMultiInstanceExecId(multiInstanceExecId);
                this.flowMultiInstanceTransService.saveNew(multiInstanceTrans);
                flowTaskComment.setMultiInstanceExecId(multiInstanceExecId);
            }
            this.flowTaskCommentService.saveNew(flowTaskComment);
        }
        taskVariableData.remove((Object)"startUserName");
        Integer approvalStatus = MapUtil.getInt((Map)taskVariableData, (Object)"latestApprovalStatus");
        this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), approvalStatus);
        this.taskService.complete(task.getId(), (Map)taskVariableData, (Map)this.makeTransientVariableMap(taskVariableData));
        this.flowMessageService.updateFinishedStatusByTaskId(task.getId());
        if (this.canDeleteTimeoutTaskJob(option)) {
            this.flowTaskTimeoutJobService.deleteByTaskId(task.getId());
        }
    }

    private void recordTaskCommentIdentityVariable(org.flowable.task.api.Task task, FlowTaskComment comment) {
        String identityVariable = this.getIdentityVariableName(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (identityVariable == null) {
            return;
        }
        FlowTaskCommentExtra extra = StrUtil.isNotBlank((CharSequence)comment.getCustomBusinessData()) ? (FlowTaskCommentExtra)JSON.parseObject((String)comment.getCustomBusinessData(), FlowTaskCommentExtra.class) : new FlowTaskCommentExtra();
        extra.setIdentityVariableName(identityVariable);
        extra.setIdentityVariableValue(this.getTaskVariableStringWithSafe(task.getId(), identityVariable));
        comment.setCustomBusinessData(JSON.toJSONString((Object)extra));
    }

    private void setSubmitUserVar(JSONObject taskVariableData, FlowTaskComment comment) {
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData != null) {
            taskVariableData.put("submitUser", (Object)tokenData.getLoginName());
        } else if (StrUtil.isNotBlank((CharSequence)comment.getCreateLoginName())) {
            taskVariableData.put("submitUser", (Object)comment.getCreateLoginName());
        }
    }

    private boolean canDeleteTimeoutTaskJob(FlowApiOption option) {
        return option == null || option.isDeleteTimeoutTaskJob();
    }

    private JSONObject makeTransientVariableMap(JSONObject taskVariableData) {
        Object masterTable;
        Object slaveData;
        JSONObject result = new JSONObject();
        if (taskVariableData == null) {
            return result;
        }
        Object masterData = taskVariableData.get((Object)"masterData");
        if (masterData != null) {
            result.put("masterData", masterData);
        }
        if ((slaveData = taskVariableData.get((Object)"slaveData")) != null) {
            result.put("slaveData", slaveData);
        }
        if ((masterTable = taskVariableData.get((Object)"masterTable")) != null) {
            result.put("masterTable", masterTable);
        }
        taskVariableData.remove((Object)"masterData");
        taskVariableData.remove((Object)"slaveData");
        taskVariableData.remove((Object)"masterTable");
        return result;
    }

    private String getMultiInstanceAssigneeList(org.flowable.task.api.Task task, JSONObject taskVariableData) {
        String assigneeList;
        JSONArray assigneeArray = taskVariableData.getJSONArray("assigneeList");
        if (CollUtil.isEmpty((Collection)assigneeArray)) {
            FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
            assigneeList = this.buildMutiSignAssigneeList(flowTaskExt.getOperationListJson());
            if (assigneeList != null) {
                taskVariableData.put("assigneeList", (Object)StrUtil.split((CharSequence)assigneeList, (char)','));
            }
        } else {
            assigneeList = CollUtil.join((Iterable)assigneeArray, (CharSequence)",");
        }
        return assigneeList;
    }

    private JSONObject mergeCopyData(String taskId, Object copyData, JSONObject passCopyData) {
        JSONObject resultCopyDataJson = passCopyData;
        if (resultCopyDataJson == null) {
            resultCopyDataJson = JSON.parseObject((String)copyData.toString());
        } else if (copyData != null) {
            JSONObject copyDataJson = JSON.parseObject((String)copyData.toString());
            for (Map.Entry entry : copyDataJson.entrySet()) {
                String value = resultCopyDataJson.getString((String)entry.getKey());
                if (value == null) {
                    resultCopyDataJson.put((String)entry.getKey(), entry.getValue());
                    continue;
                }
                List list1 = StrUtil.split((CharSequence)value, (CharSequence)",");
                List list2 = StrUtil.split((CharSequence)entry.getValue().toString(), (CharSequence)",");
                HashSet valueSet = new HashSet(list1);
                valueSet.addAll(list2);
                resultCopyDataJson.put((String)entry.getKey(), (Object)StrUtil.join((CharSequence)",", valueSet));
            }
        }
        this.processMergeCopyData(taskId, resultCopyDataJson);
        return resultCopyDataJson;
    }

    private void processMergeCopyData(String taskId, JSONObject resultCopyDataJson) {
        TokenData tokenData = TokenData.takeFromRequest();
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        for (Map.Entry entry : resultCopyDataJson.entrySet()) {
            String type;
            switch (type = (String)entry.getKey()) {
                case "user": {
                    entry.setValue(this.replaceUserVariable(taskId, entry.getValue().toString()));
                    break;
                }
                case "upDeptPostLeader": {
                    Long upLeaderDeptPostId = flowIdentityExtHelper.getUpLeaderDeptPostId(tokenData.getDeptId());
                    entry.setValue(upLeaderDeptPostId);
                    break;
                }
                case "deptPostLeader": {
                    Long leaderDeptPostId = flowIdentityExtHelper.getLeaderDeptPostId(tokenData.getDeptId());
                    entry.setValue(leaderDeptPostId);
                    break;
                }
                case "selfDeptPost": {
                    HashSet<String> selfPostIdSet = new HashSet<String>(StrUtil.split((CharSequence)entry.getValue().toString(), (CharSequence)","));
                    Map<String, String> deptPostIdMap = flowIdentityExtHelper.getDeptPostIdMap(tokenData.getDeptId(), selfPostIdSet);
                    String deptPostIdValues = "";
                    if (deptPostIdMap != null) {
                        deptPostIdValues = StrUtil.join((CharSequence)",", deptPostIdMap.values());
                    }
                    entry.setValue(deptPostIdValues);
                    break;
                }
                case "siblingDeptPost": {
                    HashSet<String> siblingPostIdSet = new HashSet<String>(StrUtil.split((CharSequence)entry.getValue().toString(), (CharSequence)","));
                    Map<String, String> siblingDeptPostIdMap = flowIdentityExtHelper.getSiblingDeptPostIdMap(tokenData.getDeptId(), siblingPostIdSet);
                    String siblingDeptPostIdValues = "";
                    if (siblingDeptPostIdMap != null) {
                        siblingDeptPostIdValues = StrUtil.join((CharSequence)",", siblingDeptPostIdMap.values());
                    }
                    entry.setValue(siblingDeptPostIdValues);
                    break;
                }
                case "upDeptPost": {
                    HashSet<String> upPostIdSet = new HashSet<String>(StrUtil.split((CharSequence)entry.getValue().toString(), (CharSequence)","));
                    Map<String, String> upDeptPostIdMap = flowIdentityExtHelper.getUpDeptPostIdMap(tokenData.getDeptId(), upPostIdSet);
                    String upDeptPostIdValues = "";
                    if (upDeptPostIdMap != null) {
                        upDeptPostIdValues = StrUtil.join((CharSequence)",", upDeptPostIdMap.values());
                    }
                    entry.setValue(upDeptPostIdValues);
                    break;
                }
            }
        }
    }

    private String replaceUserVariable(String taskId, String userNames) {
        HashSet users = new HashSet(StrUtil.split((CharSequence)userNames, (CharSequence)","));
        HashSet resultUsers = new HashSet();
        users.forEach(user -> {
            if (this.isVariableString((String)user)) {
                String v = this.getTaskVariableStringWithSafe(taskId, this.extractVariableName((String)user));
                if (v != null) {
                    resultUsers.add(v);
                }
            } else {
                resultUsers.add(user);
            }
        });
        return CollUtil.join(resultUsers, (CharSequence)",");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CallResult verifyAssigneeOrCandidateAndClaim(org.flowable.task.api.Task task) {
        String loginName = TokenData.takeFromRequest().getLoginName();
        if (task.getAssignee() == null) {
            if (!this.isAssigneeOrCandidate((TaskInfo)task)) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u8be5\u5f85\u529e\u4efb\u52a1\u7684\u5019\u9009\u4eba\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
                return CallResult.error((String)errorMessage);
            }
            this.taskService.claim(task.getId(), loginName);
        } else if (!task.getAssignee().equals(loginName)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u8be5\u5f85\u529e\u4efb\u52a1\u7684\u6307\u6d3e\u4eba\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return CallResult.error((String)errorMessage);
        }
        return CallResult.ok();
    }

    @Override
    public Map<String, Object> initAndGetProcessInstanceVariables(String processDefinitionId) {
        TokenData tokenData = TokenData.takeFromRequest();
        String loginName = tokenData.getLoginName();
        HashMap<String, Object> variableMap = new HashMap<String, Object>(4);
        variableMap.put("initiator", loginName);
        variableMap.put("startUserName", loginName);
        List<FlowTaskExt> flowTaskExtList = this.flowTaskExtService.getByProcessDefinitionId(processDefinitionId);
        boolean hasDeptPostLeader = false;
        boolean hasUpDeptPostLeader = false;
        boolean hasPostCandidateGroup = false;
        for (FlowTaskExt flowTaskExt : flowTaskExtList) {
            if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"UP_DEPT_POST_LEADER")) {
                hasUpDeptPostLeader = true;
                continue;
            }
            if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"DEPT_POST_LEADER")) {
                hasDeptPostLeader = true;
                continue;
            }
            if (!StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"POST")) continue;
            hasPostCandidateGroup = true;
        }
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        if (hasUpDeptPostLeader) {
            Assert.notNull((Object)flowIdentityExtHelper);
            Long upLeaderDeptPostId = flowIdentityExtHelper.getUpLeaderDeptPostId(tokenData.getDeptId());
            if (upLeaderDeptPostId == null) {
                variableMap.put("upDeptPostLeader", null);
            } else {
                variableMap.put("upDeptPostLeader", ((Object)upLeaderDeptPostId).toString());
            }
        }
        if (hasDeptPostLeader) {
            Assert.notNull((Object)flowIdentityExtHelper);
            Long leaderDeptPostId = flowIdentityExtHelper.getLeaderDeptPostId(tokenData.getDeptId());
            if (leaderDeptPostId == null) {
                variableMap.put("deptPostLeader", null);
            } else {
                variableMap.put("deptPostLeader", ((Object)leaderDeptPostId).toString());
            }
        }
        if (hasPostCandidateGroup) {
            Assert.notNull((Object)flowIdentityExtHelper);
            Map<String, Object> postGroupDataMap = this.buildPostCandidateGroupData(flowIdentityExtHelper, flowTaskExtList);
            variableMap.putAll(postGroupDataMap);
        }
        this.buildCopyData(flowTaskExtList, variableMap);
        return variableMap;
    }

    private void buildCopyData(List<FlowTaskExt> flowTaskExtList, Map<String, Object> variableMap) {
        for (FlowTaskExt flowTaskExt : flowTaskExtList) {
            if (StrUtil.isBlank((CharSequence)flowTaskExt.getCopyListJson())) continue;
            List copyDataList = JSON.parseArray((String)flowTaskExt.getCopyListJson(), JSONObject.class);
            HashMap<String, String> copyDataMap = new HashMap<String, String>(copyDataList.size());
            for (JSONObject copyData : copyDataList) {
                String type = copyData.getString("type");
                String id = copyData.getString("id");
                copyDataMap.put(type, id == null ? "" : id);
            }
            variableMap.put("copyDataMap_" + flowTaskExt.getTaskId(), JSON.toJSONString(copyDataMap));
        }
    }

    private Map<String, Object> buildPostCandidateGroupData(BaseFlowIdentityExtHelper flowIdentityExtHelper, List<FlowTaskExt> flowTaskExtList) {
        HashMap postVariableMap = MapUtil.newHashMap();
        HashSet<String> selfPostIdSet = new HashSet<String>();
        HashSet<String> siblingPostIdSet = new HashSet<String>();
        HashSet<String> upPostIdSet = new HashSet<String>();
        for (FlowTaskExt flowTaskExt : flowTaskExtList) {
            if (!flowTaskExt.getGroupType().equals("POST")) continue;
            Assert.notNull((Object)flowTaskExt.getDeptPostListJson());
            List groupDataList = JSONArray.parseArray((String)flowTaskExt.getDeptPostListJson(), FlowTaskPostCandidateGroup.class);
            for (FlowTaskPostCandidateGroup groupData : groupDataList) {
                switch (groupData.getType()) {
                    case "selfDeptPost": {
                        selfPostIdSet.add(groupData.getPostId());
                        break;
                    }
                    case "siblingDeptPost": {
                        siblingPostIdSet.add(groupData.getPostId());
                        break;
                    }
                    case "upDeptPost": {
                        upPostIdSet.add(groupData.getPostId());
                        break;
                    }
                }
            }
        }
        postVariableMap.putAll(this.buildSelfPostCandidateGroupData(flowIdentityExtHelper, selfPostIdSet));
        postVariableMap.putAll(this.buildSiblingPostCandidateGroupData(flowIdentityExtHelper, siblingPostIdSet));
        postVariableMap.putAll(this.buildUpPostCandidateGroupData(flowIdentityExtHelper, upPostIdSet));
        return postVariableMap;
    }

    private Map<String, Object> buildSelfPostCandidateGroupData(BaseFlowIdentityExtHelper flowIdentityExtHelper, Set<String> selfPostIdSet) {
        HashMap postVariableMap = MapUtil.newHashMap();
        if (CollUtil.isNotEmpty(selfPostIdSet)) {
            Map<String, String> deptPostIdMap = flowIdentityExtHelper.getDeptPostIdMap(TokenData.takeFromRequest().getDeptId(), selfPostIdSet);
            for (String postId : selfPostIdSet) {
                if (MapUtil.isNotEmpty(deptPostIdMap) && deptPostIdMap.containsKey(postId)) {
                    String deptPostId = deptPostIdMap.get(postId);
                    postVariableMap.put("SELF_DEPT_" + postId, deptPostId);
                    continue;
                }
                postVariableMap.put("SELF_DEPT_" + postId, "");
            }
        }
        return postVariableMap;
    }

    private Map<String, Object> buildSiblingPostCandidateGroupData(BaseFlowIdentityExtHelper flowIdentityExtHelper, Set<String> siblingPostIdSet) {
        HashMap postVariableMap = MapUtil.newHashMap();
        if (CollUtil.isNotEmpty(siblingPostIdSet)) {
            Map<String, String> siblingDeptPostIdMap = flowIdentityExtHelper.getSiblingDeptPostIdMap(TokenData.takeFromRequest().getDeptId(), siblingPostIdSet);
            for (String postId : siblingPostIdSet) {
                if (MapUtil.isNotEmpty(siblingDeptPostIdMap) && siblingDeptPostIdMap.containsKey(postId)) {
                    String siblingDeptPostId = siblingDeptPostIdMap.get(postId);
                    postVariableMap.put("SIBLING_DEPT_" + postId, siblingDeptPostId);
                    continue;
                }
                postVariableMap.put("SIBLING_DEPT_" + postId, "");
            }
        }
        return postVariableMap;
    }

    private Map<String, Object> buildUpPostCandidateGroupData(BaseFlowIdentityExtHelper flowIdentityExtHelper, Set<String> upPostIdSet) {
        HashMap postVariableMap = MapUtil.newHashMap();
        if (CollUtil.isNotEmpty(upPostIdSet)) {
            Map<String, String> upDeptPostIdMap = flowIdentityExtHelper.getUpDeptPostIdMap(TokenData.takeFromRequest().getDeptId(), upPostIdSet);
            for (String postId : upPostIdSet) {
                if (MapUtil.isNotEmpty(upDeptPostIdMap) && upDeptPostIdMap.containsKey(postId)) {
                    String upDeptPostId = upDeptPostIdMap.get(postId);
                    postVariableMap.put("UP_DEPT_" + postId, upDeptPostId);
                    continue;
                }
                postVariableMap.put("UP_DEPT_" + postId, "");
            }
        }
        return postVariableMap;
    }

    @Override
    public boolean isAssigneeOrCandidate(TaskInfo task) {
        String loginName = TokenData.takeFromRequest().getLoginName();
        if (StrUtil.isNotBlank((CharSequence)task.getAssignee())) {
            return StrUtil.equals((CharSequence)loginName, (CharSequence)task.getAssignee());
        }
        TaskQuery query = this.taskService.createTaskQuery();
        this.buildCandidateCondition(query, loginName);
        query.taskId(task.getId());
        return query.active().count() != 0L;
    }

    @Override
    public Collection<FlowElement> getProcessAllElements(String processDefinitionId) {
        Process process = (Process)this.repositoryService.getBpmnModel(processDefinitionId).getProcesses().get(0);
        return this.getAllElements(process.getFlowElements(), null);
    }

    @Override
    public boolean isProcessInstanceStarter(String processInstanceId) {
        String loginName = TokenData.takeFromRequest().getLoginName();
        return this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).startedBy(loginName).count() != 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setBusinessKeyForProcessInstance(String processInstanceId, Object dataId) {
        this.runtimeService.updateBusinessKey(processInstanceId, dataId.toString());
    }

    @Override
    public boolean existActiveProcessInstance(String processInstanceId) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).active().count() != 0L;
    }

    @Override
    public ProcessInstance getProcessInstance(String processInstanceId) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    @Override
    public ProcessInstance getProcessInstanceByBusinessKey(String processDefinitionId, String businessKey) {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinitionId).processInstanceBusinessKey(businessKey).singleResult();
    }

    @Override
    public org.flowable.task.api.Task getProcessInstanceActiveTask(String processInstanceId, String taskId) {
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId);
        if (StrUtil.isNotBlank((CharSequence)taskId)) {
            query.taskId(taskId);
        }
        return (org.flowable.task.api.Task)query.active().singleResult();
    }

    @Override
    public List<org.flowable.task.api.Task> getProcessInstanceActiveTaskList(String processInstanceId) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
    }

    @Override
    public List<FlowTaskVo> getProcessInstanceActiveTaskListAndConvert(String processInstanceId) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        return this.convertToFlowTaskList(taskList);
    }

    @Override
    public org.flowable.task.api.Task getTaskById(String taskId) {
        return (org.flowable.task.api.Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    @Override
    public MyPageData<org.flowable.task.api.Task> getTaskListByUserName(String username, String definitionKey, String definitionName, String taskName, MyPageParam pageParam) {
        TaskQuery query = this.createQuery();
        if (StrUtil.isNotBlank((CharSequence)definitionKey)) {
            query.processDefinitionKey(definitionKey);
        }
        if (StrUtil.isNotBlank((CharSequence)definitionName)) {
            query.processDefinitionNameLike("%" + definitionName + "%");
        }
        if (StrUtil.isNotBlank((CharSequence)taskName)) {
            query.taskNameLike("%" + taskName + "%");
        }
        this.buildCandidateCondition(query, username);
        long totalCount = query.count();
        ((TaskQuery)query.orderByTaskCreateTime()).desc();
        int firstResult = (pageParam.getPageNum() - 1) * pageParam.getPageSize();
        List taskList = query.listPage(firstResult, pageParam.getPageSize().intValue());
        return new MyPageData(taskList, Long.valueOf(totalCount));
    }

    @Override
    public long getTaskCountByUserName(String username) {
        TaskQuery query = this.createQuery();
        this.buildCandidateCondition(query, username);
        return query.count();
    }

    @Override
    public List<org.flowable.task.api.Task> getTaskListByProcessInstanceIds(List<String> processInstanceIdSet) {
        return ((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(processInstanceIdSet)).active().list();
    }

    @Override
    public List<ProcessInstance> getProcessInstanceList(Set<String> processInstanceIdSet) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceIds(processInstanceIdSet).list();
    }

    @Override
    public ProcessDefinition getProcessDefinitionById(String processDefinitionId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
    }

    @Override
    public List<ProcessDefinition> getProcessDefinitionList(Set<String> processDefinitionIdSet) {
        return this.repositoryService.createProcessDefinitionQuery().processDefinitionIds(processDefinitionIdSet).list();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void suspendProcessDefinition(String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activateProcessDefinition(String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
    }

    @Override
    public BpmnModel getBpmnModelByDefinitionId(String processDefinitionId) {
        return this.repositoryService.getBpmnModel(processDefinitionId);
    }

    @Override
    public boolean isMultiInstanceTask(String processDefinitionId, String taskKey) {
        BpmnModel model = this.getBpmnModelByDefinitionId(processDefinitionId);
        FlowElement flowElement = model.getFlowElement(taskKey);
        if (!(flowElement instanceof UserTask)) {
            return false;
        }
        UserTask userTask = (UserTask)flowElement;
        return userTask.hasMultiInstanceLoopCharacteristics();
    }

    @Override
    public ProcessDefinition getProcessDefinitionByDeployId(String deployId) {
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deployId).singleResult();
    }

    @Override
    public void setProcessInstanceVariables(String processInstanceId, Map<String, Object> variableMap) {
        this.runtimeService.setVariables(processInstanceId, variableMap);
    }

    @Override
    public Object getProcessInstanceVariable(String processInstanceId, String variableName) {
        return this.runtimeService.getVariable(processInstanceId, variableName);
    }

    @Override
    public List<FlowTaskVo> convertToFlowTaskList(List<org.flowable.task.api.Task> taskList) {
        LinkedList<FlowTaskVo> flowTaskVoList = new LinkedList<FlowTaskVo>();
        if (CollUtil.isEmpty(taskList)) {
            return flowTaskVoList;
        }
        Set<String> processDefinitionIdSet = taskList.stream().map(TaskInfo::getProcessDefinitionId).collect(Collectors.toSet());
        Set<String> procInstanceIdSet = taskList.stream().map(TaskInfo::getProcessInstanceId).collect(Collectors.toSet());
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(processDefinitionIdSet);
        Map<String, FlowEntryPublish> flowEntryPublishMap = flowEntryPublishList.stream().collect(Collectors.toMap(FlowEntryPublish::getProcessDefinitionId, c -> c));
        List<ProcessInstance> instanceList = this.getProcessInstanceList(procInstanceIdSet);
        Map<String, ProcessInstance> instanceMap = instanceList.stream().collect(Collectors.toMap(Execution::getId, c -> c));
        List<ProcessDefinition> definitionList = this.getProcessDefinitionList(processDefinitionIdSet);
        Map<String, ProcessDefinition> definitionMap = definitionList.stream().collect(Collectors.toMap(ProcessDefinition::getId, c -> c));
        List workOrderList = this.flowWorkOrderService.getInList("processInstanceId", procInstanceIdSet);
        Map<String, FlowWorkOrder> workOrderMap = workOrderList.stream().collect(Collectors.toMap(FlowWorkOrder::getProcessInstanceId, c -> c));
        for (org.flowable.task.api.Task task : taskList) {
            FlowTaskVo flowTaskVo = new FlowTaskVo();
            flowTaskVo.setTaskId(task.getId());
            flowTaskVo.setTaskName(task.getName());
            flowTaskVo.setTaskKey(task.getTaskDefinitionKey());
            flowTaskVo.setTaskFormKey(task.getFormKey());
            flowTaskVo.setTaskStartTime(task.getCreateTime());
            flowTaskVo.setEntryId(flowEntryPublishMap.get(task.getProcessDefinitionId()).getEntryId());
            ProcessDefinition processDefinition = definitionMap.get(task.getProcessDefinitionId());
            flowTaskVo.setProcessDefinitionId(processDefinition.getId());
            flowTaskVo.setProcessDefinitionName(processDefinition.getName());
            flowTaskVo.setProcessDefinitionKey(processDefinition.getKey());
            flowTaskVo.setProcessDefinitionVersion(processDefinition.getVersion());
            ProcessInstance processInstance = instanceMap.get(task.getProcessInstanceId());
            flowTaskVo.setProcessInstanceId(processInstance.getId());
            Object initiator = this.getProcessInstanceVariable(processInstance.getId(), "initiator");
            flowTaskVo.setProcessInstanceInitiator(initiator.toString());
            flowTaskVo.setProcessInstanceStartTime(processInstance.getStartTime());
            flowTaskVo.setBusinessKey(processInstance.getBusinessKey());
            FlowWorkOrder flowWorkOrder = workOrderMap.get(task.getProcessInstanceId());
            if (flowWorkOrder != null) {
                flowTaskVo.setIsDraft(flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.DRAFT));
                flowTaskVo.setWorkOrderCode(flowWorkOrder.getWorkOrderCode());
            }
            flowTaskVoList.add(flowTaskVo);
        }
        Set<String> loginNameSet = flowTaskVoList.stream().map(FlowTaskVo::getProcessInstanceInitiator).collect(Collectors.toSet());
        List<FlowUserInfoVo> flowUserInfos = this.flowCustomExtFactory.getFlowIdentityExtHelper().getUserInfoListByUsernameSet(loginNameSet);
        Map<String, FlowUserInfoVo> userInfoMap = flowUserInfos.stream().collect(Collectors.toMap(FlowUserInfoVo::getLoginName, c -> c));
        for (FlowTaskVo flowTaskVo : flowTaskVoList) {
            FlowUserInfoVo userInfo = userInfoMap.get(flowTaskVo.getProcessInstanceInitiator());
            flowTaskVo.setShowName(userInfo.getShowName());
            flowTaskVo.setHeadImageUrl(userInfo.getHeadImageUrl());
        }
        return flowTaskVoList;
    }

    @Override
    public void addProcessInstanceEndListener(BpmnModel bpmnModel, Class<? extends ExecutionListener> listenerClazz) {
        Assert.notNull(listenerClazz);
        Process process = bpmnModel.getMainProcess();
        FlowableListener listener = this.createListener("end", listenerClazz.getName());
        process.getExecutionListeners().add(listener);
    }

    @Override
    public void addExecutionListener(FlowElement flowElement, Class<? extends ExecutionListener> listenerClazz, String event, List<FieldExtension> fieldExtensions) {
        Assert.notNull(listenerClazz);
        FlowableListener listener = this.createListener(event, listenerClazz.getName());
        if (fieldExtensions != null) {
            listener.setFieldExtensions(fieldExtensions);
        }
        flowElement.getExecutionListeners().add(listener);
    }

    @Override
    public void addTaskCreateListener(UserTask userTask, Class<? extends TaskListener> listenerClazz) {
        Assert.notNull(listenerClazz);
        FlowableListener listener = this.createListener("create", listenerClazz.getName());
        userTask.getTaskListeners().add(listener);
    }

    @Override
    public HistoricProcessInstance getHistoricProcessInstance(String processInstanceId) {
        return (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
    }

    @Override
    public List<HistoricProcessInstance> getHistoricProcessInstanceList(Set<String> processInstanceIdSet) {
        return this.historyService.createHistoricProcessInstanceQuery().processInstanceIds(processInstanceIdSet).list();
    }

    @Override
    public MyPageData<HistoricProcessInstance> getHistoricProcessInstanceList(String processDefinitionKey, String processDefinitionName, String startUser, String beginDate, String endDate, MyPageParam pageParam, boolean finishedOnly) throws ParseException {
        TokenData tokenData;
        SimpleDateFormat sdf;
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        if (StrUtil.isNotBlank((CharSequence)processDefinitionKey)) {
            query.processDefinitionKey(processDefinitionKey);
        }
        if (StrUtil.isNotBlank((CharSequence)processDefinitionName)) {
            query.processDefinitionName(processDefinitionName);
        }
        if (StrUtil.isNotBlank((CharSequence)startUser)) {
            query.startedBy(startUser);
        }
        if (StrUtil.isNotBlank((CharSequence)beginDate)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            query.startedAfter(sdf.parse(beginDate));
        }
        if (StrUtil.isNotBlank((CharSequence)endDate)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            query.startedBefore(sdf.parse(endDate));
        }
        if ((tokenData = TokenData.takeFromRequest()).getTenantId() != null) {
            query.processInstanceTenantId(tokenData.getTenantId().toString());
        } else if (tokenData.getAppCode() == null) {
            query.processInstanceWithoutTenantId();
        } else {
            query.processInstanceTenantId(tokenData.getAppCode());
        }
        if (finishedOnly) {
            query.finished();
        }
        query.orderByProcessInstanceStartTime().desc();
        long totalCount = query.count();
        int firstResult = (pageParam.getPageNum() - 1) * pageParam.getPageSize();
        List instanceList = query.listPage(firstResult, pageParam.getPageSize().intValue());
        return new MyPageData(instanceList, Long.valueOf(totalCount));
    }

    @Override
    public MyPageData<HistoricTaskInstance> getHistoricTaskInstanceFinishedList(String processDefinitionName, String beginDate, String endDate, MyPageParam pageParam) throws ParseException {
        TokenData tokenData;
        SimpleDateFormat sdf;
        String loginName = TokenData.takeFromRequest().getLoginName();
        HistoricTaskInstanceQuery query = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskAssignee(loginName)).finished();
        if (StrUtil.isNotBlank((CharSequence)processDefinitionName)) {
            query.processDefinitionName(processDefinitionName);
        }
        if (StrUtil.isNotBlank((CharSequence)beginDate)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            query.taskCompletedAfter(sdf.parse(beginDate));
        }
        if (StrUtil.isNotBlank((CharSequence)endDate)) {
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            query.taskCompletedBefore(sdf.parse(endDate));
        }
        if ((tokenData = TokenData.takeFromRequest()).getTenantId() != null) {
            query.taskTenantId(tokenData.getTenantId().toString());
        } else if (StrUtil.isBlank((CharSequence)tokenData.getAppCode())) {
            query.taskWithoutTenantId();
        } else {
            query.taskTenantId(tokenData.getAppCode());
        }
        query.orderByHistoricTaskInstanceEndTime().desc();
        long totalCount = query.count();
        int firstResult = (pageParam.getPageNum() - 1) * pageParam.getPageSize();
        List instanceList = query.listPage(firstResult, pageParam.getPageSize().intValue());
        return new MyPageData(instanceList, Long.valueOf(totalCount));
    }

    @Override
    public List<HistoricActivityInstance> getHistoricActivityInstanceList(String processInstanceId) {
        return this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
    }

    @Override
    public List<HistoricActivityInstance> getHistoricActivityInstanceListOrderByStartTime(String processInstanceId) {
        return ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
    }

    @Override
    public HistoricTaskInstance getHistoricTaskInstance(String processInstanceId, String taskId) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskId(taskId)).singleResult();
    }

    @Override
    public List<HistoricActivityInstance> getHistoricUnfinishedInstanceList(String processInstanceId) {
        return this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).unfinished().list();
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public CallResult stopProcessInstance(String processInstanceId, String stopReason, boolean forCancel) {
        int status = FlowTaskStatus.STOPPED;
        if (forCancel) {
            status = FlowTaskStatus.CANCELLED;
        }
        return this.stopProcessInstance(processInstanceId, stopReason, status);
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public CallResult stopProcessInstance(String processInstanceId, String stopReason, int status) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        List<String> currentActivitiIds = executions.stream().map(Execution::getActivityId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollUtil.isEmpty(currentActivitiIds)) {
            return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5c1a\u672a\u5f00\u59cb\u6216\u5df2\u7ecf\u7ed3\u675f\uff01");
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(((org.flowable.task.api.Task)taskList.get(0)).getProcessDefinitionId());
        EndEvent endEvent = (EndEvent)bpmnModel.getMainProcess().findFlowElementsOfType(EndEvent.class, false).get(0);
        this.flowWorkOrderService.updateFlowStatusByProcessInstanceId(processInstanceId, status);
        for (org.flowable.task.api.Task task : taskList) {
            String currActivityId = task.getTaskDefinitionKey();
            FlowNode currFlow = (FlowNode)bpmnModel.getMainProcess().getFlowElement(currActivityId);
            if (currFlow == null) {
                List subProcessList = bpmnModel.getMainProcess().findFlowElementsOfType(SubProcess.class);
                for (SubProcess subProcess : subProcessList) {
                    FlowElement flowElement = subProcess.getFlowElement(currActivityId);
                    if (flowElement == null) continue;
                    currFlow = (FlowNode)flowElement;
                    break;
                }
            }
            org.springframework.util.Assert.notNull((Object)currFlow, (String)"currFlow can't be NULL");
            if (!currFlow.getParentContainer().equals(endEvent.getParentContainer())) {
                throw new FlowOperationException("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u4ece\u5b50\u6d41\u7a0b\u76f4\u63a5\u4e2d\u6b62\uff01");
            }
            FlowTaskComment taskComment = new FlowTaskComment((TaskInfo)task);
            taskComment.setApprovalType("stop");
            taskComment.setTaskComment(stopReason);
            this.flowTaskCommentService.saveNew(taskComment);
        }
        this.doChangeState((org.flowable.task.api.Task)taskList.get(0), currentActivitiIds, CollUtil.newArrayList((Object[])new String[]{endEvent.getId()}), null, null);
        this.flowMessageService.updateFinishedStatusByProcessInstanceId(processInstanceId);
        return CallResult.ok();
    }

    @Override
    @MultiDatabaseWriteMethod
    @Transactional(rollbackFor={Exception.class})
    public void deleteProcessInstance(String processInstanceId) {
        FlowEntryExtensionData extData;
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        this.flowMessageService.removeByProcessInstanceId(processInstanceId);
        FlowWorkOrder workOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(processInstanceId);
        if (workOrder == null) {
            return;
        }
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(workOrder.getProcessDefinitionKey());
        if (StrUtil.isNotBlank((CharSequence)flowEntry.getExtensionData()) && BooleanUtil.isTrue((Boolean)(extData = (FlowEntryExtensionData)JSON.parseObject((String)flowEntry.getExtensionData(), FlowEntryExtensionData.class)).getCascadeDeleteBusinessData())) {
            if (workOrder.getOnlineTableId() != null) {
                this.flowCustomExtFactory.getOnlineBusinessDataExtHelper().deleteBusinessData(workOrder);
            } else {
                this.flowCustomExtFactory.getBusinessDataExtHelper().deleteBusinessData(workOrder);
            }
        }
        this.flowWorkOrderService.removeByProcessInstanceId(processInstanceId);
    }

    @Override
    public Object getTaskVariable(String taskId, String variableName) {
        return this.taskService.getVariable(taskId, variableName);
    }

    @Override
    public String getTaskVariableStringWithSafe(String taskId, String variableName) {
        try {
            Object v = this.taskService.getVariable(taskId, variableName);
            if (v == null) {
                return null;
            }
            return v.toString();
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to getTaskVariable taskId [%s], variableName [%s]", taskId, variableName);
            log.error(errorMessage, (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getExecutionVariable(String executionId, String variableName) {
        return this.runtimeService.getVariable(executionId, variableName);
    }

    @Override
    public String getExecutionVariableStringWithSafe(String executionId, String variableName) {
        try {
            Object v = this.runtimeService.getVariable(executionId, variableName);
            if (v == null) {
                return null;
            }
            return v.toString();
        }
        catch (Exception e) {
            String errorMessage = String.format("Failed to getExecutionVariableStringWithSafe executionId [%s], variableName [%s]", executionId, variableName);
            log.error(errorMessage, (Throwable)e);
            return null;
        }
    }

    @Override
    public Object getHistoricProcessInstanceVariable(String processInstanceId, String variableName) {
        List hv = this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstanceId).variableName(variableName).list();
        if (CollUtil.isEmpty((Collection)hv)) {
            return null;
        }
        hv = hv.stream().sorted(Comparator.comparing(HistoricVariableInstance::getLastUpdatedTime, Comparator.reverseOrder())).collect(Collectors.toList());
        return ((HistoricVariableInstance)hv.get(0)).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BpmnModel convertToBpmnModel(String bpmnXml) throws XMLStreamException {
        BpmnXMLConverter converter = new BpmnXMLConverter();
        ByteArrayInputStream in = new ByteArrayInputStream(bpmnXml.getBytes(StandardCharsets.UTF_8));
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
        try {
            BpmnModel bpmnModel = converter.convertToBpmnModel(reader);
            return bpmnModel;
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @MultiDatabaseWriteMethod
    @Transactional
    public CallResult backToRuntimeTask(org.flowable.task.api.Task task, String targetKey, Integer backType, String reason, JSONObject taskVariableData) {
        try {
            Tuple3<List<String>, List<String>, Boolean> t = this.calculateCurrentAndTargetIds(task, targetKey);
            HashMap<String, Object> variables = null;
            if (BooleanUtil.isTrue((Boolean)((Boolean)t.getThird()))) {
                String rejectBackLoginName = this.calculateRejectBackSourceLoginName(task.getProcessInstanceId(), backType);
                variables = new HashMap<String, Object>(1);
                FlowRejectData rejectData = new FlowRejectData();
                rejectData.setSourceUser(rejectBackLoginName);
                rejectData.setSourceTaskKey(task.getTaskDefinitionKey());
                rejectData.setTargetTaskKeys((List)t.getSecond());
                variables.put("rejectData", JSON.toJSONString((Object)rejectData));
            }
            BpmnModel model = this.getBpmnModelByDefinitionId(task.getProcessDefinitionId());
            ArrayList allTaskIds = new ArrayList((Collection)t.getFirst());
            allTaskIds.addAll((Collection)t.getSecond());
            Set containerIdSet = allTaskIds.stream().map(taskId -> model.getFlowElement(taskId).getParentContainer().getId()).collect(Collectors.toSet());
            if (containerIdSet.size() > 1) {
                if (targetKey == null) {
                    this.doChangeState(task, (List)t.getFirst(), (List)t.getSecond(), null, variables);
                } else {
                    FlowTaskComment firstTaskComment = this.flowTaskCommentService.getFirstFlowTaskComment(task.getProcessInstanceId());
                    if (!targetKey.equals(firstTaskComment.getTaskKey())) return CallResult.error((String)"\u4e0d\u652f\u6301\u5b50\u6d41\u7a0b\u9a73\u56de\u5230\u4e3b\u6d41\u7a0b\u7684\u5176\u4ed6\u8282\u70b9\uff01");
                    this.doChangeState(task, (List)t.getFirst(), CollUtil.newArrayList((Object[])new String[]{targetKey}), null, variables);
                }
            } else {
                CallResult verifyResult = this.canRejectTo(model, task, (List)t.getFirst(), (List)t.getSecond());
                if (!verifyResult.isSuccess()) {
                    return verifyResult;
                }
                this.doChangeState(task, (List)t.getFirst(), (List)t.getSecond(), null, variables);
            }
            FlowTaskComment comment = new FlowTaskComment();
            comment.setTaskId(task.getId());
            comment.setTaskKey(task.getTaskDefinitionKey());
            comment.setTaskName(task.getName());
            switch (backType) {
                case 0: {
                    comment.setApprovalType("reject");
                    break;
                }
                case 1: {
                    comment.setApprovalType("revoke");
                    break;
                }
            }
            comment.setProcessInstanceId(task.getProcessInstanceId());
            comment.setTaskComment(reason);
            comment.setTargetTaskKey(JSON.toJSONString((Object)t.getSecond()));
            this.flowTaskCommentService.saveNew(comment);
            Integer approvalStatus = MapUtil.getInt((Map)taskVariableData, (Object)"latestApprovalStatus");
            this.flowWorkOrderService.updateLatestApprovalStatusByProcessInstanceId(task.getProcessInstanceId(), approvalStatus);
            this.flowMessageService.updateFinishedStatusByTaskId(task.getId());
            return CallResult.ok();
        }
        catch (MyRuntimeException e) {
            return CallResult.error((String)e.getMessage());
        }
    }

    private String calculateRejectBackSourceLoginName(String processInstanceId, Integer backType) {
        if (backType == 0) {
            return TokenData.takeFromRequest().getLoginName();
        }
        FlowTaskComment comment = this.flowTaskCommentService.getLatestFlowTaskComment(processInstanceId);
        if (StrUtil.isBlank((CharSequence)comment.getCustomBusinessData())) {
            return "";
        }
        FlowTaskCommentExtra extra = (FlowTaskCommentExtra)JSON.parseObject((String)comment.getCustomBusinessData(), FlowTaskCommentExtra.class);
        return extra.getRejectBackTargetUser();
    }

    private CallResult canRejectTo(BpmnModel model, org.flowable.task.api.Task task, List<String> currentIds, List<String> targetIds) {
        if (this.isRejectBackToSourceUserTask(task)) {
            return CallResult.ok();
        }
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(CollUtil.newHashSet((Object[])new String[]{task.getProcessDefinitionId()}));
        String parentContainerId = model.getFlowElement(task.getTaskDefinitionKey()).getParentContainer().getId();
        AnalyzedNode rootNode = this.calculateAnalyzeNode(flowEntryPublishList.get(0).getAnalyzedNodeJson(), model, parentContainerId);
        Map<String, AnalyzedNode> fullNodeMap = this.expandToAnalyzedNodeMap(rootNode);
        AnalyzedNode.UserTaskInfo sourceUserTaskInfo = this.deduceUserTaskInfo(fullNodeMap.values(), task.getTaskDefinitionKey());
        org.springframework.util.Assert.notNull((Object)sourceUserTaskInfo, (String)"sourceUserTaskInfo can't be NULL.");
        LinkedList<AnalyzedNode.UserTaskInfo> targetUserTaskInfos = new LinkedList<AnalyzedNode.UserTaskInfo>();
        for (String targetId : targetIds) {
            targetUserTaskInfos.add(this.deduceUserTaskInfo(fullNodeMap.values(), targetId));
        }
        AnalyzedNode sourceNode = fullNodeMap.get(sourceUserTaskInfo.getNodeId());
        LinkedList<AnalyzedNode> targetNodes = new LinkedList<AnalyzedNode>();
        for (AnalyzedNode.UserTaskInfo targetUserTaskInfo : targetUserTaskInfos) {
            targetNodes.add(fullNodeMap.get(targetUserTaskInfo.getNodeId()));
        }
        if (targetIds.size() == 1 && sourceNode == targetNodes.get(0)) {
            return CallResult.ok();
        }
        if (this.placedWithinParallelGateway(fullNodeMap, sourceNode)) {
            List<List<AnalyzedNode.UserTaskInfo>> allRoads = sourceNode.getUserTaskRoads();
            for (List<AnalyzedNode.UserTaskInfo> road : allRoads) {
                if (road.stream().filter(d -> currentIds.contains(d.getTaskId())).findFirst().orElse(null) != null) continue;
                return CallResult.error((String)"\u4e0d\u80fd\u6267\u884c\u9a73\u56de\u64cd\u4f5c\uff0c\u5176\u4ed6\u5e76\u884c\u7f51\u5173\u5206\u652f\u5df2\u7ecf\u5168\u90e8\u5ba1\u6279\u5b8c\u6210\uff01");
            }
        }
        return CallResult.ok();
    }

    private Tuple3<List<String>, List<String>, Boolean> calculateCurrentAndTargetIds(org.flowable.task.api.Task task, String targetKey) {
        List targetIds;
        List<org.flowable.task.api.Task> taskList = this.getProcessInstanceActiveTaskList(task.getProcessInstanceId());
        if (StrUtil.isNotBlank((CharSequence)targetKey)) {
            if (taskList.stream().anyMatch(t -> t.getTaskDefinitionKey().equals(targetKey))) {
                throw new MyRuntimeException("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u9a73\u56de\u5230\u5176\u4ed6\u5f85\u529e\u4efb\u52a1\uff01");
            }
            List<HistoricActivityInstance> histTaskList = this.getHistoricActivityInstanceList(task.getProcessInstanceId());
            if (histTaskList.stream().noneMatch(t -> t.getActivityId().equals(targetKey))) {
                throw new MyRuntimeException("\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u9a73\u56de\u5230\u6ca1\u6709\u6267\u884c\u8fc7\u7684\u6d41\u7a0b\u4efb\u52a1\u8282\u70b9\uff01");
            }
            targetIds = CollUtil.newArrayList((Object[])new String[]{targetKey});
        } else {
            TypedCallResult<List<String>> callResult = this.deduceBackTargetIds(task);
            if (!callResult.isSuccess()) {
                throw new MyRuntimeException(callResult.getErrorMessage());
            }
            targetIds = (List)callResult.getData();
        }
        if (this.isRejectBackToSourceUserTask(task) && (targetKey != null || targetIds.size() == 1)) {
            return new Tuple3((Object)CollUtil.newArrayList((Object[])new String[]{task.getTaskDefinitionKey()}), (Object)targetIds, (Object)true);
        }
        List<String> currentIds = taskList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
        if (targetKey == null) {
            currentIds = this.getChildActivitiIdList(task.getProcessDefinitionId(), (String)targetIds.get(0), currentIds);
        }
        return new Tuple3(currentIds, (Object)targetIds, (Object)false);
    }

    private boolean isRejectBackToSourceUserTask(org.flowable.task.api.Task task) {
        FlowTaskExt taskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        FlowUserTaskExtData extData = (FlowUserTaskExtData)JSON.parseObject((String)taskExt.getExtraDataJson(), FlowUserTaskExtData.class);
        return extData != null && StrUtil.equals((CharSequence)extData.getRejectType(), (CharSequence)"1");
    }

    private UserTask findUserTaskByTask(String processDefinitionId, String taskKey) {
        ProcessDefinition processDefinition = this.getProcessDefinitionById(processDefinitionId);
        Collection<FlowElement> allElements = this.getProcessAllElements(processDefinition.getId());
        return (UserTask)this.findFlement(allElements, taskKey);
    }

    private TypedCallResult<List<String>> deduceBackTargetIds(org.flowable.task.api.Task task) {
        UserTask source = this.findUserTaskByTask(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        List<UserTask> parentUserTaskList = this.getParentUserTaskList((FlowElement)source, new HashSet<String>(), new ArrayList<UserTask>(), false);
        if (CollUtil.isEmpty(parentUserTaskList)) {
            return TypedCallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u8282\u70b9\u4e3a\u521d\u59cb\u4efb\u52a1\u8282\u70b9\uff0c\u4e0d\u80fd\u9a73\u56de\uff01");
        }
        UserTask targetUserTask = this.getBackParentUserTask(parentUserTaskList, task);
        if (targetUserTask == null) {
            return TypedCallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u83b7\u53d6\u9a73\u56de\u8282\u70b9\uff01");
        }
        String parallelGatewayId = null;
        List outgoingFlows = targetUserTask.getOutgoingFlows();
        for (Object outgoingFlow : outgoingFlows) {
            if (!(outgoingFlow.getTargetFlowElement() instanceof ParallelGateway)) continue;
            parallelGatewayId = outgoingFlow.getTargetFlowElement().getId();
            break;
        }
        if (parallelGatewayId == null) {
            return TypedCallResult.ok((Object)CollUtil.newArrayList((Object[])new String[]{targetUserTask.getId()}));
        }
        ArrayList targetUserTasks = CollUtil.newArrayList((Object[])new UserTask[]{targetUserTask});
        for (UserTask parentTask : parentUserTaskList) {
            if (parentTask == targetUserTask) continue;
            for (SequenceFlow outgoingFlow : parentTask.getOutgoingFlows()) {
                if (!StrUtil.equals((CharSequence)outgoingFlow.getTargetFlowElement().getId(), (CharSequence)parallelGatewayId)) continue;
                targetUserTasks.add(parentTask);
            }
        }
        List targetIds = targetUserTasks.stream().map(BaseElement::getId).collect(Collectors.toList());
        return TypedCallResult.ok(targetIds);
    }

    @Override
    @Transactional
    public CallResult backToRuntimeTaskAndTransfer(org.flowable.task.api.Task task, String targetKey, Integer backType, String reason, String delegateAssignee) {
        CallResult result = this.backToRuntimeTask(task, targetKey, backType, reason, null);
        if (!result.isSuccess()) {
            return result;
        }
        FlowTaskComment flowTaskComment = new FlowTaskComment();
        flowTaskComment.setDelegateAssignee(delegateAssignee);
        flowTaskComment.setApprovalType("intervene");
        org.flowable.task.api.Task targetTask = this.getProcessInstanceActiveTaskList(task.getProcessInstanceId()).get(0);
        this.transferTo(targetTask, flowTaskComment);
        return result;
    }

    @Override
    public List<UserTask> getRejectCandidateUserTaskList(org.flowable.task.api.Task task) {
        LinkedList<UserTask> userTaskList = new LinkedList<UserTask>();
        ProcessDefinition processDefinition = this.getProcessDefinitionById(task.getProcessDefinitionId());
        Collection<FlowElement> allElements = this.getProcessAllElements(processDefinition.getId());
        if (CollUtil.isEmpty(allElements)) {
            return userTaskList;
        }
        List<FlowTaskComment> comments = this.flowTaskCommentService.getFlowTaskCommentList(task.getProcessInstanceId());
        Set taskIds = comments.stream().map(FlowTaskComment::getTaskKey).collect(Collectors.toCollection(LinkedHashSet::new));
        taskIds.remove(task.getTaskDefinitionKey());
        for (String taskId : taskIds) {
            allElements.stream().filter(el -> el.getId().equals(taskId)).findFirst().ifPresent(el -> userTaskList.add((UserTask)el));
        }
        return userTaskList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferTo(org.flowable.task.api.Task task, FlowTaskComment flowTaskComment) {
        List transferUserList = StrUtil.split((CharSequence)flowTaskComment.getDelegateAssignee(), (CharSequence)",");
        for (String transferUser : transferUserList) {
            if (!transferUser.equals("${startUserName}")) continue;
            String startUser = this.getProcessInstanceVariable(task.getProcessInstanceId(), "startUserName").toString();
            String newDelegateAssignee = StrUtil.replace((CharSequence)flowTaskComment.getDelegateAssignee(), (CharSequence)"${startUserName}", (CharSequence)startUser);
            flowTaskComment.setDelegateAssignee(newDelegateAssignee);
            transferUserList = StrUtil.split((CharSequence)flowTaskComment.getDelegateAssignee(), (CharSequence)",");
            break;
        }
        this.taskService.unclaim(task.getId());
        FlowTaskExt taskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (StrUtil.isNotBlank((CharSequence)taskExt.getCandidateUsernames())) {
            List<String> candidateUsernames = this.getCandidateUsernames(taskExt, task.getId());
            if (CollUtil.isNotEmpty(candidateUsernames)) {
                for (String username : candidateUsernames) {
                    this.taskService.deleteCandidateUser(task.getId(), username);
                }
            }
        } else if (StrUtil.equals((CharSequence)taskExt.getGroupType(), (CharSequence)"ASSIGNEE")) {
            List links = this.taskService.getIdentityLinksForTask(task.getId());
            for (IdentityLink link : links) {
                this.taskService.deleteUserIdentityLink(task.getId(), link.getUserId(), link.getType());
            }
        } else {
            this.removeCandidateGroup(taskExt, task);
        }
        transferUserList.forEach(u -> this.taskService.addCandidateUser(task.getId(), u));
        flowTaskComment.fillWith((TaskInfo)task);
        this.flowTaskCommentService.saveNew(flowTaskComment);
    }

    @Override
    public List<String> getCandidateUsernames(FlowTaskExt flowTaskExt, String taskId) {
        if (StrUtil.isBlank((CharSequence)flowTaskExt.getCandidateUsernames())) {
            return Collections.emptyList();
        }
        if (!StrUtil.equals((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)"${appointedAssignee}")) {
            return StrUtil.split((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)",");
        }
        String candidateUsernames = this.getTaskVariableStringWithSafe(taskId, "appointedAssignee");
        return candidateUsernames == null ? null : StrUtil.split((CharSequence)candidateUsernames.toString(), (CharSequence)",");
    }

    @Override
    public Tuple2<Set<String>, Set<String>> getDeptPostIdAndPostIds(FlowTaskExt flowTaskExt, String processInstanceId, boolean historic) {
        LinkedHashSet<String> postIdSet = new LinkedHashSet<String>();
        LinkedHashSet<String> deptPostIdSet = new LinkedHashSet<String>();
        if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"UP_DEPT_POST_LEADER")) {
            Object v = this.getProcessInstanceVariable(processInstanceId, "upDeptPostLeader", historic);
            if (ObjectUtil.isNotEmpty((Object)v)) {
                deptPostIdSet.add(v.toString());
            }
        } else if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"DEPT_POST_LEADER")) {
            Object v = this.getProcessInstanceVariable(processInstanceId, "deptPostLeader", historic);
            if (ObjectUtil.isNotEmpty((Object)v)) {
                deptPostIdSet.add(v.toString());
            }
        } else if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"POST") && StrUtil.isNotBlank((CharSequence)flowTaskExt.getDeptPostListJson())) {
            this.buildDeptPostIdAndPostIdsForPost(flowTaskExt, processInstanceId, historic, postIdSet, deptPostIdSet);
        }
        return new Tuple2(deptPostIdSet, postIdSet);
    }

    @Override
    public AnalyzedNode analyzeBpmnRoads(String processDefinitionId) {
        Process mainProcess = this.repositoryService.getBpmnModel(processDefinitionId).getMainProcess();
        Collection mainElements = mainProcess.getFlowElements();
        AnalyzedNode rootNode = this.doAnalyzeBpmnRoads(mainElements);
        rootNode.setContainerId(mainProcess.getId());
        LinkedList<SubProcess> subProcesses = new LinkedList<SubProcess>();
        this.calculateAllSubProcessList(mainElements, subProcesses);
        subProcesses.forEach(subProcess -> {
            AnalyzedNode subProcessNode = this.doAnalyzeBpmnRoads(subProcess.getFlowElements());
            subProcessNode.setContainerId(subProcess.getId());
            rootNode.getSubProcessNodes().add(subProcessNode);
        });
        return rootNode;
    }

    @Override
    @Transactional
    public CallResult freeJumpTo(org.flowable.task.api.Task task, String targetKey, String comment, String delegateAssignee) {
        BpmnModel model = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (!this.withinSameContainer(model, task.getTaskDefinitionKey(), targetKey)) {
            return CallResult.error((String)"\u4e0d\u652f\u6301\u4ece\u5b50\u6d41\u7a0b\u5185\u7684\u4efb\u52a1\u8282\u70b9\u8df3\u5165\u5230\u4e3b\u6d41\u7a0b\u6216\u5176\u4ed6\u5b50\u6d41\u7a0b\u5185\u7684\u4efb\u52a1\u8282\u70b9\uff01");
        }
        CallResult jumpResult = this.doJumpTo(model, task, targetKey, delegateAssignee);
        if (!jumpResult.isSuccess()) {
            return jumpResult;
        }
        FlowTaskComment taskComment = new FlowTaskComment();
        taskComment.fillWith((TaskInfo)task);
        taskComment.setApprovalType("free_jump");
        taskComment.setTaskComment(comment);
        taskComment.setTargetTaskKey(targetKey);
        this.flowTaskCommentService.saveNew(taskComment);
        return jumpResult;
    }

    @Override
    public CallResult interveneTo(org.flowable.task.api.Task task, String targetKey, String comment, String delegateAssignee) {
        BpmnModel model = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (!this.withinSameContainer(model, task.getTaskDefinitionKey(), targetKey)) {
            return CallResult.error((String)"\u4e0d\u652f\u6301\u4ece\u5b50\u6d41\u7a0b\u5185\u7684\u4efb\u52a1\u8282\u70b9\u8df3\u5165\u5230\u4e3b\u6d41\u7a0b\u6216\u5176\u4ed6\u5b50\u6d41\u7a0b\u5185\u7684\u4efb\u52a1\u8282\u70b9\uff01");
        }
        CallResult jumpResult = this.doJumpTo(model, task, targetKey, delegateAssignee);
        if (!jumpResult.isSuccess()) {
            return jumpResult;
        }
        FlowTaskComment taskComment = new FlowTaskComment();
        taskComment.fillWith((TaskInfo)task);
        taskComment.setTargetTaskKey(targetKey);
        taskComment.setTaskComment(comment);
        taskComment.setApprovalType("intervene");
        taskComment.setDelegateAssignee(delegateAssignee);
        this.flowTaskCommentService.saveNew(taskComment);
        return jumpResult;
    }

    @Override
    public List<String> getChildActivitiIdList(String processDefinitionId, String taskKey, List<String> allActivitiIds) {
        if (StrUtil.isBlank((CharSequence)taskKey) || CollUtil.isEmpty(allActivitiIds)) {
            return new LinkedList<String>();
        }
        UserTask source = this.findUserTaskByTask(processDefinitionId, taskKey);
        List<UserTask> childList = this.getChildUserTaskList((FlowElement)source, new HashSet<String>(), new ArrayList<UserTask>());
        Set childIds = childList.stream().map(BaseElement::getId).collect(Collectors.toSet());
        return allActivitiIds.stream().filter(childIds::contains).collect(Collectors.toList());
    }

    @Override
    public Map<String, UserTask> getAllUserTaskMap(String processDefinitionId) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        return process.findFlowElementsOfType(UserTask.class).stream().collect(Collectors.toMap(BaseElement::getId, a -> a, (k1, k2) -> k1));
    }

    @Override
    public UserTask getUserTask(String processDefinitionId, String taskKey) {
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        for (Process process : bpmnModel.getProcesses()) {
            UserTask userTask = process.findFlowElementsOfType(UserTask.class).stream().filter(t -> t.getId().equals(taskKey)).findFirst().orElse(null);
            if (userTask == null) continue;
            return userTask;
        }
        return null;
    }

    @Override
    public boolean isVariableString(String s) {
        if (StrUtil.isBlank((CharSequence)s)) {
            return false;
        }
        return StrUtil.startWith((CharSequence)s, (CharSequence)"${") && StrUtil.endWith((CharSequence)s, (CharSequence)"}");
    }

    @Override
    public String extractVariableName(String s) {
        if (StrUtil.isBlank((CharSequence)s)) {
            return s;
        }
        String v = StrUtil.removePrefix((CharSequence)s, (CharSequence)"${");
        return StrUtil.removeSuffix((CharSequence)v, (CharSequence)"}");
    }

    private AnalyzedNode doAnalyzeBpmnRoads(Collection<FlowElement> allElements) {
        StartEvent startEvent = allElements.stream().filter(StartEvent.class::isInstance).findFirst().orElse(null);
        org.springframework.util.Assert.notNull((Object)startEvent, (String)"StartEvent can't be NULL.");
        List<List<FlowElement>> roads = this.findForwardRoad((FlowElement)startEvent, new LinkedList<FlowElement>(), new HashSet<String>(), new LinkedList<List<FlowElement>>());
        LinkedList<List<FlowElement>> normalizedRoads = new LinkedList<List<FlowElement>>();
        for (List<FlowElement> road2 : roads) {
            LinkedList<FlowElement> normalizedRoad = new LinkedList<FlowElement>();
            for (FlowElement el : road2) {
                if (normalizedRoad.contains(el)) continue;
                normalizedRoad.add(el);
            }
            normalizedRoads.add(normalizedRoad);
        }
        roads = normalizedRoads;
        List<GatewayExt> gatewayExts = this.calculateGatewayPassCount(roads);
        Map<String, AnalyzedNode> gatewayNodeMap = this.analyzeGatewayPair(gatewayExts, new HashSet<String>());
        this.normalizeGatewayParentRelation(gatewayNodeMap, roads);
        AnalyzedNode rootNode = new AnalyzedNode();
        rootNode.setStartId(startEvent.getId());
        rootNode.setEndId("end");
        rootNode.setStartEvent(true);
        rootNode.setParallelGateway(false);
        for (AnalyzedNode node : gatewayNodeMap.values()) {
            if (node.getParentId() != null) continue;
            node.setParentId(startEvent.getId());
            rootNode.getChildList().add(node);
        }
        HashMap<String, AnalyzedNode> fullNodeMap = new HashMap<String, AnalyzedNode>(gatewayNodeMap);
        fullNodeMap.put(rootNode.getStartId(), rootNode);
        LinkedList<List<String>> allRoads = new LinkedList<List<String>>();
        roads.forEach(road -> allRoads.add(road.stream().map(BaseElement::getId).collect(Collectors.toList())));
        rootNode.setAllRoads(allRoads);
        this.analyzeRoadPath(fullNodeMap, roads, startEvent);
        return rootNode;
    }

    private void calculateAllSubProcessList(Collection<FlowElement> elements, List<SubProcess> resultList) {
        for (FlowElement element : elements) {
            if (!(element instanceof SubProcess)) continue;
            SubProcess subProcess = (SubProcess)element;
            resultList.add(subProcess);
            this.calculateAllSubProcessList(subProcess.getFlowElements(), resultList);
        }
    }

    private AnalyzedNode calculateAnalyzeNode(String analyzeNodeJson, BpmnModel model, String containerId) {
        AnalyzedNode rootNode = (AnalyzedNode)JSON.parseObject((String)analyzeNodeJson, AnalyzedNode.class);
        if (!model.getMainProcess().getId().equals(containerId)) {
            for (AnalyzedNode subProcessNode : rootNode.getSubProcessNodes()) {
                if (!containerId.equals(subProcessNode.getContainerId())) continue;
                rootNode = subProcessNode;
                break;
            }
        }
        return rootNode;
    }

    private boolean withinSameContainer(BpmnModel model, String sourceKey, String targetKey) {
        String sourceContainerId = model.getFlowElement(sourceKey).getParentContainer().getId();
        String targetContainerId = model.getFlowElement(targetKey).getParentContainer().getId();
        return sourceContainerId.equals(targetContainerId);
    }

    private CallResult doJumpTo(BpmnModel model, org.flowable.task.api.Task task, String targetKey, String delegateAssignee) {
        AnalyzedNode sourceParentNode;
        AnalyzedNode targetNode;
        String sourceContainerId = model.getFlowElement(task.getTaskDefinitionKey()).getParentContainer().getId();
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(CollUtil.newHashSet((Object[])new String[]{task.getProcessDefinitionId()}));
        AnalyzedNode rootNode = this.calculateAnalyzeNode(flowEntryPublishList.get(0).getAnalyzedNodeJson(), model, sourceContainerId);
        Map<String, AnalyzedNode> fullNodeMap = this.expandToAnalyzedNodeMap(rootNode);
        AnalyzedNode.UserTaskInfo sourceUserTaskInfo = this.deduceUserTaskInfo(fullNodeMap.values(), task.getTaskDefinitionKey());
        org.springframework.util.Assert.notNull((Object)sourceUserTaskInfo, (String)"sourceUserTaskInfo can't be NULL.");
        if (sourceUserTaskInfo.isMultiInstance()) {
            return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8df3\u8f6c\u7684\u6e90\u8282\u70b9\u4e0d\u80fd\u662f\u591a\u5b9e\u4f8b\u4f1a\u7b7e\u8282\u70b9\uff01");
        }
        AnalyzedNode.UserTaskInfo targetUserTaskInfo = this.deduceUserTaskInfo(fullNodeMap.values(), targetKey);
        if (targetUserTaskInfo == null) {
            return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8df3\u8f6c\u7684\u76ee\u6807\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        if (targetUserTaskInfo.isMultiInstance()) {
            return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8df3\u8f6c\u7684\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u662f\u591a\u5b9e\u4f8b\u4f1a\u7b7e\u8282\u70b9\uff01");
        }
        AnalyzedNode sourceNode = fullNodeMap.get(sourceUserTaskInfo.getNodeId());
        if (sourceNode == (targetNode = fullNodeMap.get(targetUserTaskInfo.getNodeId()))) {
            if (sourceNode.isParallelGateway() && sourceUserTaskInfo.getRoadIndex() != targetUserTaskInfo.getRoadIndex()) {
                return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u76f8\u540c\u5e76\u884c\u7f51\u5173\u5185\u4e0d\u540c\u7ebf\u8def\u7684\u4efb\u52a1\u4e0d\u80fd\u76f4\u63a5\u8df3\u8f6c\uff01");
            }
            this.doChangeState(task, CollUtil.newArrayList((Object[])new String[]{task.getTaskDefinitionKey()}), CollUtil.newArrayList((Object[])new String[]{targetKey}), delegateAssignee, null);
            return CallResult.ok();
        }
        if (!this.placedWithinParallelGateway(fullNodeMap, targetNode)) {
            if (!this.placedWithinParallelGateway(fullNodeMap, sourceNode)) {
                this.doChangeState(task, CollUtil.newArrayList((Object[])new String[]{task.getTaskDefinitionKey()}), CollUtil.newArrayList((Object[])new String[]{targetKey}), delegateAssignee, null);
            } else {
                List<String> runActivityIds = this.getCurrentActivityIds(task.getProcessInstanceId());
                this.doChangeState(task, runActivityIds, CollUtil.newArrayList((Object[])new String[]{targetKey}), delegateAssignee, null);
            }
            return CallResult.ok();
        }
        AnalyzedNode targetParanetNode = this.deduceParentParallelGatewayNode(fullNodeMap, targetNode);
        if (this.isParentOrEqualNode(targetParanetNode, sourceParentNode = this.deduceParentParallelGatewayNode(fullNodeMap, sourceNode), fullNodeMap)) {
            List<String> runActivityIds = this.getCurrentActivityIds(task.getProcessInstanceId());
            List<String> canJumpedActivityIds = runActivityIds.stream().filter(id -> this.canFlowTo((String)id, targetKey, rootNode.getAllRoads())).collect(Collectors.toList());
            if (!CollUtil.contains(canJumpedActivityIds, (Object)task.getTaskDefinitionKey())) {
                return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u539f\u4efb\u52a1\u8282\u70b9\u548c\u76ee\u6807\u4efb\u52a1\u8282\u70b9\u4f4d\u4e8e\u4e0d\u540c\u7684\u6267\u884c\u8def\u5f84\uff0c\u4e0d\u80fd\u76f4\u63a5\u8df3\u8f6c\uff01");
            }
            this.doChangeState(task, canJumpedActivityIds, CollUtil.newArrayList((Object[])new String[]{targetKey}), delegateAssignee, null);
            return CallResult.ok();
        }
        if (!StrUtil.equals((CharSequence)targetNode.getParentId(), (CharSequence)sourceNode.getStartId())) {
            return CallResult.error((String)"\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u4e0d\u80fd\u8df3\u8f6c\u5230\u6ca1\u6709\u76f4\u63a5\u4e0a\u4e0b\u7ea7\u5173\u7cfb\u7684\u5e76\u884c\u7f51\u5173\u5185\u7684\u76ee\u6807\u4efb\u52a1\uff01");
        }
        List<String> targetIds = this.getTargetActivityIds(targetNode, targetKey);
        this.doChangeState(task, CollUtil.newArrayList((Object[])new String[]{task.getTaskDefinitionKey()}), targetIds, delegateAssignee, null);
        return CallResult.ok();
    }

    private void doChangeState(org.flowable.task.api.Task task, List<String> currentIds, List<String> targetIds, String delegateAssignee, Map<String, Object> variables) {
        if (ObjectUtil.hasEmpty((Object[])new Object[]{currentIds, targetIds})) {
            throw new MyRuntimeException("\u8df3\u8f6c\u7684\u6e90\u8282\u70b9\u548c\u4efb\u52a1\u8282\u70b9\u6570\u91cf\u5747\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String processInstanceId = task.getProcessInstanceId();
        ChangeActivityStateBuilder builder = this.createChangeActivityStateBuilder(currentIds, targetIds, processInstanceId);
        if (StrUtil.isNotBlank((CharSequence)delegateAssignee)) {
            targetIds.forEach(targetId -> {
                builder.localVariable(targetId, "appointedAssignee", (Object)delegateAssignee);
                builder.localVariable(targetId, "defaultAssignee", (Object)delegateAssignee);
            });
        } else {
            targetIds.forEach(targetId -> {
                FlowTaskComment comment = this.flowTaskCommentService.getLatestFlowTaskComment(processInstanceId, (String)targetId);
                if (comment != null && StrUtil.isNotBlank((CharSequence)comment.getCreateLoginName())) {
                    builder.localVariable(targetId, "appointedAssignee", (Object)comment.getCreateLoginName());
                }
            });
        }
        if (MapUtil.isNotEmpty(variables)) {
            targetIds.forEach(targetId -> builder.localVariables(targetId, variables));
        }
        for (String targetId2 : targetIds) {
            String variableName = this.getIdentityVariableName(task.getProcessDefinitionId(), targetId2);
            if (variableName == null) continue;
            List<FlowTaskComment> comments = this.flowTaskCommentService.getFlowTaskCommentList(processInstanceId, targetId2);
            comments.stream().filter(comment -> StrUtil.isNotBlank((CharSequence)comment.getCustomBusinessData())).map(comment -> (FlowTaskCommentExtra)JSON.parseObject((String)comment.getCustomBusinessData(), FlowTaskCommentExtra.class)).filter(extra -> StrUtil.isNotBlank((CharSequence)extra.getIdentityVariableName())).findFirst().ifPresent(extra -> {
                if (StrUtil.isNotBlank((CharSequence)extra.getIdentityVariableValue())) {
                    builder.localVariable(targetId2, extra.getIdentityVariableName(), (Object)extra.getIdentityVariableValue());
                }
            });
        }
        this.addAssigneeListVariableForMultiInstance(task, targetIds, builder);
        builder.changeState();
    }

    private void addAssigneeListVariableForMultiInstance(org.flowable.task.api.Task task, List<String> targetIds, ChangeActivityStateBuilder builder) {
        for (String targetId : targetIds) {
            if (!this.isMultiInstanceTask(task.getProcessDefinitionId(), targetId)) continue;
            String multiInstanceExecId = this.getExecutionVariableStringWithSafe(task.getExecutionId(), "taskExecutionId");
            FlowMultiInstanceTrans trans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
            this.runtimeService.setVariable(task.getExecutionId(), "assigneeList", (Object)StrUtil.split((CharSequence)trans.getAssigneeList(), (CharSequence)","));
        }
    }

    private String getIdentityVariableName(String processDefinitionId, String taskKey) {
        UserTask userTask = this.getUserTask(processDefinitionId, taskKey);
        if (userTask == null) {
            return null;
        }
        String assignee = userTask.getAssignee();
        if (StrUtil.isNotBlank((CharSequence)assignee)) {
            if (this.isVariableString(assignee)) {
                return this.extractVariableName(assignee);
            }
        } else {
            FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(processDefinitionId, taskKey);
            if (StrUtil.equals((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)" + FlowConstant.TASK_APPOINTED_ASSIGNEE_VAR + ")) {
                return "appointedAssignee";
            }
        }
        return null;
    }

    private ChangeActivityStateBuilder createChangeActivityStateBuilder(List<String> currentIds, List<String> targetIds, String processInstanceId) {
        Object builder;
        if (currentIds.size() > 1 && targetIds.size() > 1) {
            builder = new CustomChangeActivityStateBuilderImpl((RuntimeServiceImpl)this.runtimeService);
            ((CustomChangeActivityStateBuilderImpl)((Object)builder)).moveActivityIdsToActivityIds(currentIds, targetIds).processInstanceId(processInstanceId);
        } else {
            builder = this.runtimeService.createChangeActivityStateBuilder().processInstanceId(processInstanceId);
            if (targetIds.size() == 1) {
                if (currentIds.size() == 1) {
                    builder.moveActivityIdTo(currentIds.get(0), targetIds.get(0));
                } else {
                    builder.moveActivityIdsToSingleActivityId(currentIds, targetIds.get(0));
                }
            } else {
                builder.moveSingleActivityIdToActivityIds(currentIds.get(0), targetIds);
            }
        }
        return builder;
    }

    private List<String> getTargetActivityIds(AnalyzedNode targetNode, String targetKey) {
        LinkedList targetIds = CollUtil.newLinkedList((Object[])new String[]{targetKey});
        for (List<AnalyzedNode.UserTaskInfo> road : targetNode.getUserTaskRoads()) {
            boolean found = false;
            for (AnalyzedNode.UserTaskInfo userTaskInfo : road) {
                if (!userTaskInfo.getTaskId().equals(targetKey)) continue;
                found = true;
                break;
            }
            if (found || !CollUtil.isNotEmpty(road)) continue;
            targetIds.add(road.get(0).getTaskId());
        }
        return targetIds;
    }

    private List<String> getCurrentActivityIds(String processInstanceId) {
        List runExecutionList = this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).list();
        return runExecutionList.stream().map(Execution::getActivityId).filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
    }

    private boolean isParentOrEqualNode(AnalyzedNode parentNode, AnalyzedNode childNode, Map<String, AnalyzedNode> fullNodeMap) {
        if (parentNode == childNode) {
            return true;
        }
        if (parentNode == null || childNode == null || childNode.getParentId() == null) {
            return false;
        }
        if (childNode.getParentId().equals(parentNode.getStartId())) {
            return true;
        }
        return this.isParentOrEqualNode(parentNode, fullNodeMap.get(childNode.getParentId()), fullNodeMap);
    }

    private boolean canFlowTo(String sourceId, String targetId, List<List<String>> allRoads) {
        if (CollUtil.isEmpty(allRoads)) {
            return false;
        }
        for (List<String> road : allRoads) {
            if (!road.contains(sourceId) || !road.contains(targetId)) continue;
            return true;
        }
        return false;
    }

    private void calculateParentParallelNodes(Map<String, AnalyzedNode> fullNodeMap, AnalyzedNode node, List<AnalyzedNode> resultList) {
        if (node.isParallelGateway()) {
            resultList.add(node);
        }
        if (StrUtil.isBlank((CharSequence)node.getParentId())) {
            return;
        }
        this.calculateParentParallelNodes(fullNodeMap, fullNodeMap.get(node.getParentId()), resultList);
    }

    private AnalyzedNode deduceParentParallelGatewayNode(Map<String, AnalyzedNode> fullNodeMap, AnalyzedNode node) {
        if (node.isParallelGateway()) {
            return node;
        }
        if (StrUtil.isBlank((CharSequence)node.getParentId())) {
            return null;
        }
        return this.deduceParentParallelGatewayNode(fullNodeMap, fullNodeMap.get(node.getParentId()));
    }

    private boolean placedWithinParallelGateway(Map<String, AnalyzedNode> fullNodeMap, AnalyzedNode node) {
        if (node.isParallelGateway()) {
            return true;
        }
        if (StrUtil.isBlank((CharSequence)node.getParentId())) {
            return false;
        }
        return this.placedWithinParallelGateway(fullNodeMap, fullNodeMap.get(node.getParentId()));
    }

    private AnalyzedNode.UserTaskInfo deduceUserTaskInfo(Collection<AnalyzedNode> nodeList, String taskId) {
        for (AnalyzedNode node : nodeList) {
            if (!CollUtil.isNotEmpty(node.getUserTaskRoads())) continue;
            for (List<AnalyzedNode.UserTaskInfo> road : node.getUserTaskRoads()) {
                AnalyzedNode.UserTaskInfo foundInfo = road.stream().filter(info -> info.getTaskId().equals(taskId)).findFirst().orElse(null);
                if (foundInfo == null) continue;
                return foundInfo;
            }
        }
        return null;
    }

    private Map<String, AnalyzedNode> expandToAnalyzedNodeMap(AnalyzedNode node) {
        HashMap fullNodeMap = MapUtil.newHashMap();
        fullNodeMap.put(node.getStartId(), node);
        if (CollUtil.isNotEmpty(node.getChildList())) {
            for (AnalyzedNode childNode : node.getChildList()) {
                fullNodeMap.putAll(this.expandToAnalyzedNodeMap(childNode));
            }
        }
        return fullNodeMap;
    }

    private void removeCandidateGroup(FlowTaskExt taskExt, org.flowable.task.api.Task task) {
        Tuple2<Set<String>, Set<String>> tuple2;
        if (StrUtil.isNotBlank((CharSequence)taskExt.getDeptIds())) {
            for (String deptId : StrUtil.split((CharSequence)taskExt.getDeptIds(), (CharSequence)",")) {
                this.taskService.deleteCandidateGroup(task.getId(), deptId);
            }
        }
        if (StrUtil.isNotBlank((CharSequence)taskExt.getRoleIds())) {
            for (String roleId : StrUtil.split((CharSequence)taskExt.getRoleIds(), (CharSequence)",")) {
                this.taskService.deleteCandidateGroup(task.getId(), roleId);
            }
        }
        if (CollUtil.isNotEmpty((Collection)((Collection)(tuple2 = this.getDeptPostIdAndPostIds(taskExt, task.getProcessInstanceId(), false)).getFirst()))) {
            for (String deptPostId : (Set)tuple2.getFirst()) {
                this.taskService.deleteCandidateGroup(task.getId(), deptPostId);
            }
        }
        if (CollUtil.isNotEmpty((Collection)((Collection)tuple2.getSecond()))) {
            for (String postId : (Set)tuple2.getSecond()) {
                this.taskService.deleteCandidateGroup(task.getId(), postId);
            }
        }
    }

    private void buildDeptPostIdAndPostIdsForPost(FlowTaskExt flowTaskExt, String processInstanceId, boolean historic, Set<String> postIdSet, Set<String> deptPostIdSet) {
        List groupDataList = JSON.parseArray((String)flowTaskExt.getDeptPostListJson(), FlowTaskPostCandidateGroup.class);
        for (FlowTaskPostCandidateGroup groupData : groupDataList) {
            switch (groupData.getType()) {
                case "allDeptPost": {
                    postIdSet.add(groupData.getPostId());
                    break;
                }
                case "deptPost": {
                    deptPostIdSet.add(groupData.getDeptPostId());
                    break;
                }
                case "selfDeptPost": {
                    Object v = this.getProcessInstanceVariable(processInstanceId, "SELF_DEPT_" + groupData.getPostId(), historic);
                    if (!ObjectUtil.isNotEmpty((Object)v)) break;
                    deptPostIdSet.add(v.toString());
                    break;
                }
                case "upDeptPost": {
                    Object v2 = this.getProcessInstanceVariable(processInstanceId, "UP_DEPT_" + groupData.getPostId(), historic);
                    if (!ObjectUtil.isNotEmpty((Object)v2)) break;
                    deptPostIdSet.add(v2.toString());
                    break;
                }
                case "siblingDeptPost": {
                    Object v3 = this.getProcessInstanceVariable(processInstanceId, "SIBLING_DEPT_" + groupData.getPostId(), historic);
                    if (!ObjectUtil.isNotEmpty((Object)v3)) break;
                    deptPostIdSet.addAll(StrUtil.split((CharSequence)v3.toString(), (CharSequence)",").stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList()));
                    break;
                }
            }
        }
    }

    private Object getProcessInstanceVariable(String processInstanceId, String variableName, boolean historic) {
        if (historic) {
            return this.getHistoricProcessInstanceVariable(processInstanceId, variableName);
        }
        return this.getProcessInstanceVariable(processInstanceId, variableName);
    }

    private void analyzeRoadPath(Map<String, AnalyzedNode> fullNodeMap, List<List<FlowElement>> roads, StartEvent startEvent) {
        LinkedList<String> stack = new LinkedList<String>();
        stack.push(startEvent.getId());
        for (List<FlowElement> road : roads) {
            int index = roads.indexOf(road);
            road.forEach(el -> {
                String lastElementId;
                if (el instanceof Gateway) {
                    if (fullNodeMap.containsKey(el.getId())) {
                        stack.push(el.getId());
                    } else {
                        this.safePollParallelGateway(fullNodeMap, stack);
                    }
                } else if (el instanceof UserTask && (lastElementId = (String)stack.peek()) != null) {
                    AnalyzedNode node = (AnalyzedNode)fullNodeMap.get(lastElementId);
                    node.getAllUserTasks().add("road" + index + "---" + el.getId());
                }
            });
        }
        this.analyzeRoadAndSplitToPath(fullNodeMap, roads);
    }

    private void analyzeRoadAndSplitToPath(Map<String, AnalyzedNode> fullGatewayMap, List<List<FlowElement>> roads) {
        HashMap allFlowElementMap = new HashMap(20);
        roads.forEach(road -> allFlowElementMap.putAll(road.stream().filter(UserTask.class::isInstance).collect(Collectors.toMap(BaseElement::getId, el -> el))));
        fullGatewayMap.values().forEach(node -> {
            Set<Object> set = new HashSet();
            for (int i = 0; i < roads.size(); ++i) {
                StringBuilder sb = new StringBuilder(128);
                for (String el : node.getAllUserTasks()) {
                    String prefix;
                    if (!StrUtil.startWith((CharSequence)el, (CharSequence)(prefix = "road" + i + "---"))) continue;
                    sb.append(StrUtil.removePrefix((CharSequence)el, (CharSequence)prefix)).append(",");
                }
                set.add(sb.toString());
            }
            set = set.stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
            int index = 0;
            for (String string : set) {
                List idList = StrUtil.split((CharSequence)string, (CharSequence)",").stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
                LinkedList<AnalyzedNode.UserTaskInfo> userTaskRoad = new LinkedList<AnalyzedNode.UserTaskInfo>();
                for (String id : idList) {
                    FlowElement el = (FlowElement)allFlowElementMap.get(id);
                    UserTask userTask = (UserTask)el;
                    userTaskRoad.add(new AnalyzedNode.UserTaskInfo(userTask.getId(), userTask.hasMultiInstanceLoopCharacteristics(), node.getStartId(), index));
                }
                ++index;
                node.getUserTaskRoads().add(userTaskRoad);
            }
        });
    }

    private void normalizeGatewayParentRelation(Map<String, AnalyzedNode> fullGatewayMap, List<List<FlowElement>> roads) {
        for (List<FlowElement> road : roads) {
            LinkedList stack = new LinkedList();
            road.stream().filter(Gateway.class::isInstance).forEach(el -> {
                if (fullGatewayMap.containsKey(el.getId())) {
                    String lastElementId = (String)stack.peek();
                    if (lastElementId != null) {
                        AnalyzedNode parentNode = (AnalyzedNode)fullGatewayMap.get(lastElementId);
                        if (!lastElementId.equals(el.getId())) {
                            ((AnalyzedNode)fullGatewayMap.get(el.getId())).setParentId(parentNode.getStartId());
                        }
                    }
                    stack.push(el.getId());
                } else {
                    this.safePollParallelGateway(fullGatewayMap, stack);
                }
            });
        }
        fullGatewayMap.values().stream().filter(node -> node.getParentId() != null).forEach(node -> {
            AnalyzedNode parentNode = (AnalyzedNode)fullGatewayMap.get(node.getParentId());
            parentNode.getChildList().add((AnalyzedNode)node);
        });
    }

    private void safePollParallelGateway(Map<String, AnalyzedNode> fullGatewayMap, Deque<String> stack) {
        AnalyzedNode lastNode;
        String lastElementId;
        while ((lastElementId = stack.poll()) != null && !(lastNode = fullGatewayMap.get(lastElementId)).isParallelGateway()) {
        }
    }

    private Map<String, AnalyzedNode> analyzeGatewayPair(List<GatewayExt> gatewayExts, Set<String> scannedSet) {
        HashMap fullGatewayMap = MapUtil.newHashMap();
        int index = 0;
        for (GatewayExt ext : gatewayExts) {
            ++index;
            if (scannedSet.contains(ext.gateway.getId())) continue;
            AnalyzedNode node = new AnalyzedNode();
            node.setStartId(ext.gateway.getId());
            node.setParallelGateway(ext.getGateway() instanceof ParallelGateway);
            fullGatewayMap.put(node.getStartId(), node);
            if (!node.isParallelGateway()) continue;
            List<GatewayExt> leftList = gatewayExts.subList(index, gatewayExts.size());
            this.findParallelGatewayEnd(leftList, ext.getPassCount(), node, fullGatewayMap, scannedSet);
        }
        return fullGatewayMap;
    }

    private void findParallelGatewayEnd(List<GatewayExt> leftList, int passCount, AnalyzedNode node, Map<String, AnalyzedNode> fullGatewayMap, Set<String> scannedSet) {
        LinkedList<GatewayExt> subList = new LinkedList<GatewayExt>();
        for (GatewayExt ext2 : leftList) {
            if (ext2.getPassCount() == passCount) {
                node.setEndId(ext2.gateway.getId());
                scannedSet.add(ext2.gateway.getId());
                if (!CollUtil.isNotEmpty(subList)) break;
                fullGatewayMap.putAll(this.analyzeGatewayPair(subList, scannedSet));
                scannedSet.addAll(subList.stream().map(subExt -> subExt.getGateway().getId()).collect(Collectors.toList()));
                break;
            }
            subList.add(ext2);
        }
    }

    private List<GatewayExt> calculateGatewayPassCount(List<List<FlowElement>> roads) {
        LinkedList<GatewayExt> gatewayExts = new LinkedList<GatewayExt>();
        for (List<FlowElement> road : roads) {
            road.stream().filter(Gateway.class::isInstance).forEach(el -> {
                GatewayExt gatewayExt = gatewayExts.stream().filter(ext -> ((GatewayExt)ext).gateway.getId().equals(el.getId())).findFirst().orElse(null);
                if (gatewayExt != null) {
                    gatewayExt.setPassCount(gatewayExt.getPassCount() + 1);
                } else {
                    gatewayExts.add(new GatewayExt((Gateway)el));
                }
            });
        }
        return gatewayExts;
    }

    private List<List<FlowElement>> findForwardRoad(FlowElement source, List<FlowElement> passRoads, Set<String> hasSequenceFlow, List<List<FlowElement>> roads) {
        List<SequenceFlow> sequenceFlows = this.getElementOutgoingFlows(source);
        if (CollUtil.isEmpty(sequenceFlows)) {
            roads.add(passRoads);
            return roads;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
            hasSequenceFlow.add(sequenceFlow.getId());
            FlowElement element = sequenceFlow.getTargetFlowElement();
            boolean pushed = false;
            if (element instanceof UserTask || element instanceof ServiceTask || element instanceof ReceiveTask || element instanceof ParallelGateway || element instanceof ExclusiveGateway) {
                passRoads.add(element);
                pushed = true;
            }
            roads = this.findForwardRoad(sequenceFlow.getTargetFlowElement(), new ArrayList<FlowElement>(passRoads), new HashSet<String>(hasSequenceFlow), roads);
            if (!pushed) continue;
            passRoads.remove(element);
        }
        return roads;
    }

    private List<List<UserTask>> findRoad(FlowElement source, List<UserTask> passRoads, Set<String> hasSequenceFlow, List<List<UserTask>> roads) {
        List<SequenceFlow> sequenceFlows;
        passRoads = passRoads == null ? new ArrayList<UserTask>() : passRoads;
        roads = roads == null ? new ArrayList<List<UserTask>>() : roads;
        HashSet<String> hashSet = hasSequenceFlow = hasSequenceFlow == null ? new HashSet<String>() : hasSequenceFlow;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            roads = this.findRoad((FlowElement)source.getSubProcess(), passRoads, hasSequenceFlow, roads);
        }
        if (CollUtil.isEmpty(sequenceFlows = this.getElementIncomingFlows(source))) {
            roads.add(passRoads);
            return roads;
        }
        for (SequenceFlow sequenceFlow : sequenceFlows) {
            if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
            hasSequenceFlow.add(sequenceFlow.getId());
            UserTask nowUserTask = null;
            if (sequenceFlow.getSourceFlowElement() instanceof UserTask && !((UserTask)sequenceFlow.getSourceFlowElement()).hasMultiInstanceLoopCharacteristics()) {
                nowUserTask = (UserTask)sequenceFlow.getSourceFlowElement();
                passRoads.add(nowUserTask);
            }
            roads = this.findRoad(sequenceFlow.getSourceFlowElement(), new ArrayList<UserTask>(passRoads), new HashSet<String>(hasSequenceFlow), roads);
            if (nowUserTask == null) continue;
            passRoads.remove(nowUserTask);
        }
        return roads;
    }

    private List<UserTask> getParentUserTaskList(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList, boolean subProcessStart) {
        List<SequenceFlow> sequenceFlows;
        if (source instanceof StartEvent && source.getSubProcess() != null) {
            userTaskList = this.getParentUserTaskList((FlowElement)source.getSubProcess(), hasSequenceFlow, userTaskList, true);
        }
        if (!subProcessStart && source instanceof SubProcess) {
            for (FlowElement element : ((SubProcess)source).getFlowElements()) {
                if (!(element instanceof EndEvent)) continue;
                source = element;
                break;
            }
        }
        if ((sequenceFlows = this.getElementIncomingFlows(source)) != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                this.findParentUserTaskListByFlow(sequenceFlow, hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    private void findParentUserTaskListByFlow(SequenceFlow sequenceFlow, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        FlowElement sourceElement = sequenceFlow.getSourceFlowElement();
        if (sourceElement instanceof UserTask) {
            userTaskList.add((UserTask)sourceElement);
            return;
        }
        this.getParentUserTaskList(sourceElement, new HashSet<String>(hasSequenceFlow), userTaskList, false);
    }

    private List<UserTask> getChildUserTaskListFromSubProcess(SubProcess subProcess, List<UserTask> userTaskList) {
        for (FlowElement e : subProcess.getFlowElements()) {
            if (!(e instanceof StartEvent)) continue;
            for (SequenceFlow sequenceFlow : ((StartEvent)e).getOutgoingFlows()) {
                FlowElement targetElement = sequenceFlow.getTargetFlowElement();
                if (!(targetElement instanceof UserTask)) continue;
                userTaskList.add((UserTask)targetElement);
            }
            return userTaskList;
        }
        return userTaskList;
    }

    private List<UserTask> getChildUserTaskList(FlowElement source, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        List<SequenceFlow> sequenceFlows = this.getElementOutgoingFlows(source);
        if (source instanceof SubProcess) {
            return this.getChildUserTaskListFromSubProcess((SubProcess)source, userTaskList);
        }
        if (source instanceof EndEvent && source.getSubProcess() != null) {
            sequenceFlows = this.getElementOutgoingFlows((FlowElement)source.getSubProcess());
        }
        if (sequenceFlows != null) {
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hasSequenceFlow.contains(sequenceFlow.getId())) continue;
                hasSequenceFlow.add(sequenceFlow.getId());
                this.findChildUserTaskListByFlow(sequenceFlow, hasSequenceFlow, userTaskList);
            }
        }
        return userTaskList;
    }

    private void findChildUserTaskListByFlow(SequenceFlow sequenceFlow, Set<String> hasSequenceFlow, List<UserTask> userTaskList) {
        FlowElement targetElement = sequenceFlow.getTargetFlowElement();
        if (targetElement instanceof UserTask) {
            userTaskList.add((UserTask)targetElement);
            return;
        }
        this.getChildUserTaskList(targetElement, new HashSet<String>(hasSequenceFlow), userTaskList);
    }

    private void handleMultiInstanceApprovalType(String executionId, String approvalType, JSONObject taskVariableData) {
        if (StrUtil.isBlank((CharSequence)approvalType)) {
            return;
        }
        if (StrUtil.equalsAny((CharSequence)approvalType, (CharSequence[])new CharSequence[]{"multi_agree", "multi_refuse", "multi_abstain"})) {
            Map variables = this.runtimeService.getVariables(executionId);
            Integer agreeCount = (Integer)variables.get("multiAgreeCount");
            Integer refuseCount = (Integer)variables.get("multiRefuseCount");
            Integer abstainCount = (Integer)variables.get("multiAbstainCount");
            Integer nrOfInstances = (Integer)variables.get("nrOfInstances");
            taskVariableData.put("multiAgreeCount", (Object)agreeCount);
            taskVariableData.put("multiRefuseCount", (Object)refuseCount);
            taskVariableData.put("multiAbstainCount", (Object)abstainCount);
            taskVariableData.put("multiNumOfInstances", (Object)nrOfInstances);
            switch (approvalType) {
                case "multi_agree": {
                    if (agreeCount == null) {
                        agreeCount = 0;
                    }
                    taskVariableData.put("multiAgreeCount", (Object)(agreeCount + 1));
                    break;
                }
                case "multi_refuse": {
                    if (refuseCount == null) {
                        refuseCount = 0;
                    }
                    taskVariableData.put("multiRefuseCount", (Object)(refuseCount + 1));
                    break;
                }
                case "multi_abstain": {
                    if (abstainCount == null) {
                        abstainCount = 0;
                    }
                    taskVariableData.put("multiAbstainCount", (Object)(abstainCount + 1));
                    break;
                }
            }
        }
    }

    private TaskQuery createQuery() {
        TaskQuery query = this.taskService.createTaskQuery().active();
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData.getTenantId() != null) {
            query.taskTenantId(tokenData.getTenantId().toString());
        } else if (StrUtil.isBlank((CharSequence)tokenData.getAppCode())) {
            query.taskWithoutTenantId();
        } else {
            query.taskTenantId(tokenData.getAppCode());
        }
        return query;
    }

    private void buildCandidateCondition(TaskQuery query, String loginName) {
        String deptPostIds;
        HashSet<String> groupIdSet = new HashSet<String>();
        TokenData tokenData = TokenData.takeFromRequest();
        Long deptId = tokenData.getDeptId();
        if (deptId != null) {
            groupIdSet.add(((Object)deptId).toString());
        }
        String roleIds = tokenData.getRoleIds();
        if (StrUtil.isNotBlank((CharSequence)tokenData.getRoleIds())) {
            groupIdSet.addAll(StrUtil.split((CharSequence)roleIds, (CharSequence)","));
        }
        String postIds = tokenData.getPostIds();
        if (StrUtil.isNotBlank((CharSequence)tokenData.getPostIds())) {
            groupIdSet.addAll(StrUtil.split((CharSequence)postIds, (CharSequence)","));
        }
        if (StrUtil.isNotBlank((CharSequence)(deptPostIds = tokenData.getDeptPostIds()))) {
            groupIdSet.addAll(StrUtil.split((CharSequence)deptPostIds, (CharSequence)","));
        }
        if (CollUtil.isNotEmpty(groupIdSet)) {
            ((TaskQuery)((TaskQuery)query.or()).taskCandidateGroupIn(groupIdSet)).taskCandidateOrAssigned(loginName).endOr();
        } else {
            query.taskCandidateOrAssigned(loginName);
        }
    }

    private String buildMutiSignAssigneeList(String operationListJson) {
        FlowTaskMultiSignAssign multiSignAssignee = null;
        List taskOperationList = JSONArray.parseArray((String)operationListJson, FlowTaskOperation.class);
        for (FlowTaskOperation taskOperation : taskOperationList) {
            if (!"multi_sign".equals(taskOperation.getType())) continue;
            multiSignAssignee = taskOperation.getMultiSignAssignee();
            break;
        }
        org.springframework.util.Assert.notNull(multiSignAssignee, (String)"multiSignAssignee can't be NULL");
        if ("USER_GROUP".equals(multiSignAssignee.getAssigneeType())) {
            return multiSignAssignee.getAssigneeList();
        }
        Set<String> usernameSet = null;
        BaseFlowIdentityExtHelper extHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        HashSet idSet = CollUtil.newHashSet((Collection)StrUtil.split((CharSequence)multiSignAssignee.getAssigneeList(), (CharSequence)","));
        switch (multiSignAssignee.getAssigneeType()) {
            case "ROLE_GROUP": {
                usernameSet = extHelper.getUsernameListByRoleIds(idSet);
                break;
            }
            case "DEPT_GROUP": {
                usernameSet = extHelper.getUsernameListByDeptIds(idSet);
                break;
            }
            case "POST_GROUP": {
                usernameSet = extHelper.getUsernameListByPostIds(idSet);
                break;
            }
            case "DEPT_POST_GROUP": {
                usernameSet = extHelper.getUsernameListByDeptPostIds(idSet);
                break;
            }
        }
        return CollUtil.isEmpty(usernameSet) ? null : CollUtil.join(usernameSet, (CharSequence)",");
    }

    private Collection<FlowElement> getAllElements(Collection<FlowElement> flowElements, Collection<FlowElement> allElements) {
        allElements = allElements == null ? new ArrayList<FlowElement>() : allElements;
        for (FlowElement flowElement : flowElements) {
            allElements.add(flowElement);
            if (!(flowElement instanceof SubProcess)) continue;
            allElements = this.getAllElements(((SubProcess)flowElement).getFlowElements(), allElements);
        }
        return allElements;
    }

    private void doChangeTask(org.flowable.task.api.Task runtimeTask) {
        Map<String, UserTask> allUserTaskMap = this.getAllUserTaskMap(runtimeTask.getProcessDefinitionId());
        UserTask userTaskModel = allUserTaskMap.get(runtimeTask.getTaskDefinitionKey());
        String completeCondition = userTaskModel.getLoopCharacteristics().getCompletionCondition();
        Execution parentExecution = this.getMultiInstanceRootExecution(runtimeTask);
        Object nrOfCompletedInstances = this.runtimeService.getVariable(parentExecution.getId(), "nrOfCompletedInstances");
        Object nrOfInstances = this.runtimeService.getVariable(parentExecution.getId(), "nrOfInstances");
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        context.setVariable("nrOfCompletedInstances", factory.createValueExpression(nrOfCompletedInstances, Integer.class));
        context.setVariable("nrOfInstances", factory.createValueExpression(nrOfInstances, Integer.class));
        ValueExpression e = factory.createValueExpression((ELContext)context, completeCondition, Boolean.class);
        Boolean ok = (Boolean)Convert.convert(Boolean.class, (Object)e.getValue((ELContext)context));
        if (BooleanUtil.isTrue((Boolean)ok)) {
            FlowElement targetKey = ((SequenceFlow)userTaskModel.getOutgoingFlows().get(0)).getTargetFlowElement();
            ChangeActivityStateBuilder builder = this.runtimeService.createChangeActivityStateBuilder().processInstanceId(runtimeTask.getProcessInstanceId()).moveActivityIdTo(userTaskModel.getId(), targetKey.getId());
            builder.localVariable(targetKey.getId(), "multiNumOfInstances", nrOfInstances);
            builder.changeState();
        }
    }

    private Execution getMultiInstanceRootExecution(org.flowable.task.api.Task runtimeTask) {
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(runtimeTask.getProcessInstanceId()).activityId(runtimeTask.getTaskDefinitionKey()).list();
        for (Execution e : executionList) {
            ExecutionEntityImpl ee = (ExecutionEntityImpl)e;
            if (!ee.isMultiInstanceRoot()) continue;
            return e;
        }
        Execution execution = (Execution)executionList.get(0);
        return (Execution)this.runtimeService.createExecutionQuery().processInstanceId(runtimeTask.getProcessInstanceId()).executionId(execution.getParentId()).singleResult();
    }

    private List<SequenceFlow> getElementIncomingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof Task) {
            sequenceFlows = ((Task)source).getIncomingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getIncomingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getIncomingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getIncomingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getIncomingFlows();
        }
        return sequenceFlows;
    }

    private List<SequenceFlow> getElementOutgoingFlows(FlowElement source) {
        List sequenceFlows = null;
        if (source instanceof Task) {
            sequenceFlows = ((Task)source).getOutgoingFlows();
        } else if (source instanceof Gateway) {
            sequenceFlows = ((Gateway)source).getOutgoingFlows();
        } else if (source instanceof SubProcess) {
            sequenceFlows = ((SubProcess)source).getOutgoingFlows();
        } else if (source instanceof StartEvent) {
            sequenceFlows = ((StartEvent)source).getOutgoingFlows();
        } else if (source instanceof EndEvent) {
            sequenceFlows = ((EndEvent)source).getOutgoingFlows();
        }
        return sequenceFlows;
    }

    private FlowableListener createListener(String eventName, String listenerClassName) {
        FlowableListener listener = new FlowableListener();
        listener.setEvent(eventName);
        listener.setImplementationType("class");
        listener.setImplementation(listenerClassName);
        return listener;
    }

    private FlowElement findFlement(Collection<FlowElement> allElements, String taskKey) {
        for (FlowElement flowElement : allElements) {
            if (!flowElement.getId().equals(taskKey)) continue;
            return flowElement;
        }
        return null;
    }

    private UserTask getBackParentUserTask(List<UserTask> parentUserTaskList, org.flowable.task.api.Task task) {
        List<FlowTaskComment> comments = this.flowTaskCommentService.getFlowTaskCommentList(task.getProcessInstanceId());
        if (CollUtil.isEmpty(comments)) {
            return null;
        }
        List reversedComments = CollUtil.reverse(comments);
        for (FlowTaskComment comment : reversedComments) {
            for (UserTask parentTask : parentUserTaskList) {
                if (!parentTask.getId().equals(comment.getTaskKey())) continue;
                return parentTask;
            }
        }
        return null;
    }

    static class GatewayExt {
        private Gateway gateway;
        private int passCount = 1;

        public GatewayExt(Gateway gateway) {
            this.gateway = gateway;
        }

        public Gateway getGateway() {
            return this.gateway;
        }

        public int getPassCount() {
            return this.passCount;
        }

        public void setGateway(Gateway gateway) {
            this.gateway = gateway;
        }

        public void setPassCount(int passCount) {
            this.passCount = passCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GatewayExt)) {
                return false;
            }
            GatewayExt other = (GatewayExt)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPassCount() != other.getPassCount()) {
                return false;
            }
            Gateway this$gateway = this.getGateway();
            Gateway other$gateway = other.getGateway();
            return !(this$gateway == null ? other$gateway != null : !this$gateway.equals(other$gateway));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GatewayExt;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPassCount();
            Gateway $gateway = this.getGateway();
            result = result * 59 + ($gateway == null ? 43 : $gateway.hashCode());
            return result;
        }

        public String toString() {
            return "FlowApiServiceImpl.GatewayExt(gateway=" + this.getGateway() + ", passCount=" + this.getPassCount() + ")";
        }

        public GatewayExt(Gateway gateway, int passCount) {
            this.gateway = gateway;
            this.passCount = passCount;
        }
    }
}

