/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowCategoryMapper;
import com.dic.bid.common.flow.model.FlowCategory;
import com.dic.bid.common.flow.service.FlowCategoryService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import com.github.pagehelper.Page;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowCategoryService")
public class FlowCategoryServiceImpl
extends BaseService<FlowCategory, Long>
implements FlowCategoryService {
    private static final Logger log = LoggerFactory.getLogger(FlowCategoryServiceImpl.class);
    @Autowired
    private FlowCategoryMapper flowCategoryMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowCategory> mapper() {
        return this.flowCategoryMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowCategory saveNew(FlowCategory flowCategory) {
        flowCategory.setCategoryId(this.idGenerator.nextLongId());
        TokenData tokenData = TokenData.takeFromRequest();
        flowCategory.setAppCode(tokenData.getAppCode());
        flowCategory.setTenantId(tokenData.getTenantId());
        flowCategory.setUpdateUserId(tokenData.getUserId());
        flowCategory.setCreateUserId(tokenData.getUserId());
        Date now = new Date();
        flowCategory.setUpdateTime(now);
        flowCategory.setCreateTime(now);
        this.flowCategoryMapper.insert(flowCategory);
        return flowCategory;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(FlowCategory flowCategory, FlowCategory originalFlowCategory) {
        TokenData tokenData = TokenData.takeFromRequest();
        flowCategory.setAppCode(tokenData.getAppCode());
        flowCategory.setTenantId(tokenData.getTenantId());
        flowCategory.setUpdateUserId(tokenData.getUserId());
        flowCategory.setCreateUserId(originalFlowCategory.getCreateUserId());
        flowCategory.setUpdateTime(new Date());
        flowCategory.setCreateTime(originalFlowCategory.getCreateTime());
        UpdateWrapper uw = this.createUpdateQueryForNullValue(flowCategory, flowCategory.getCategoryId());
        return this.flowCategoryMapper.update(flowCategory, (Wrapper)uw) == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Long categoryId) {
        return this.flowCategoryMapper.deleteById(categoryId) == 1;
    }

    @Override
    public List<FlowCategory> getFlowCategoryList(FlowCategory filter, String orderBy) {
        if (filter == null) {
            filter = new FlowCategory();
        }
        TokenData tokenData = TokenData.takeFromRequest();
        filter.setTenantId(tokenData.getTenantId());
        filter.setAppCode(tokenData.getAppCode());
        return this.flowCategoryMapper.getFlowCategoryList(filter, orderBy);
    }

    @Override
    public List<FlowCategory> getFlowCategoryListWithRelation(FlowCategory filter, String orderBy) {
        List<FlowCategory> resultList = this.getFlowCategoryList(filter, orderBy);
        int batchSize = resultList instanceof Page ? 0 : 1000;
        this.buildRelationForDataList(resultList, MyRelationParam.normal(), batchSize);
        return resultList;
    }

    @Override
    public boolean existByCode(String code) {
        FlowCategory filter = new FlowCategory();
        filter.setCode(code);
        return CollUtil.isNotEmpty(this.getFlowCategoryList(filter, null));
    }

    public List<FlowCategory> getInList(Set<Long> categoryIds) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(FlowCategory::getCategoryId, categoryIds);
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData.getAppCode() == null) {
            qw.isNull(FlowCategory::getAppCode);
        } else {
            qw.eq(FlowCategory::getAppCode, (Object)tokenData.getAppCode());
        }
        if (tokenData.getTenantId() == null) {
            qw.isNull(FlowCategory::getTenantId);
        } else {
            qw.eq(FlowCategory::getTenantId, (Object)tokenData.getTenantId());
        }
        return this.flowCategoryMapper.selectList((Wrapper)qw);
    }
}

