/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.flow.dao.FlowEntryMapper;
import com.dic.bid.common.flow.dao.FlowEntryPublishMapper;
import com.dic.bid.common.flow.dao.FlowEntryPublishVariableMapper;
import com.dic.bid.common.flow.listener.AutoSkipTaskListener;
import com.dic.bid.common.flow.listener.FlowEmptyUserExecListener;
import com.dic.bid.common.flow.listener.FlowEmptyUserHandleListener;
import com.dic.bid.common.flow.listener.FlowFinishedListener;
import com.dic.bid.common.flow.listener.FlowTaskNotifyListener;
import com.dic.bid.common.flow.listener.FlowTaskRejectBackListener;
import com.dic.bid.common.flow.listener.FlowTaskReviveListener;
import com.dic.bid.common.flow.listener.FlowTaskTimeoutListener;
import com.dic.bid.common.flow.listener.FlowUserTaskListener;
import com.dic.bid.common.flow.listener.UpdateLatestApprovalStatusListener;
import com.dic.bid.common.flow.model.FlowCategory;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowEntryPublishVariable;
import com.dic.bid.common.flow.model.FlowEntryVariable;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.object.AnalyzedNode;
import com.dic.bid.common.flow.object.FlowElementExtProperty;
import com.dic.bid.common.flow.object.FlowEntryExtensionData;
import com.dic.bid.common.flow.object.FlowTaskPostCandidateGroup;
import com.dic.bid.common.flow.object.FlowUserTaskExtData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowCategoryService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowEntryVariableService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.util.FlowRedisKeyUtil;
import com.dic.bid.common.redis.util.CommonRedisUtil;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import com.github.pagehelper.Page;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.flowable.bpmn.converter.BpmnXMLConverter;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FieldExtension;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.delegate.TaskListener;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowEntryService")
public class FlowEntryServiceImpl
extends BaseService<FlowEntry, Long>
implements FlowEntryService {
    private static final Logger log = LoggerFactory.getLogger(FlowEntryServiceImpl.class);
    @Autowired
    private FlowEntryMapper flowEntryMapper;
    @Autowired
    private FlowEntryPublishMapper flowEntryPublishMapper;
    @Autowired
    private FlowEntryPublishVariableMapper flowEntryPublishVariableMapper;
    @Autowired
    private FlowEntryVariableService flowEntryVariableService;
    @Autowired
    private FlowCategoryService flowCategoryService;
    @Autowired
    private FlowTaskExtService flowTaskExtService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private IdGeneratorWrapper idGenerator;
    @Autowired
    private CommonRedisUtil commonRedisUtil;
    private static final Integer FLOW_ENTRY_PUBLISH_TTL = 86400;

    protected BaseDaoMapper<FlowEntry> mapper() {
        return this.flowEntryMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowEntry saveNew(FlowEntry flowEntry) {
        flowEntry.setEntryId(this.idGenerator.nextLongId());
        flowEntry.setStatus(0);
        TokenData tokenData = TokenData.takeFromRequest();
        flowEntry.setAppCode(tokenData.getAppCode());
        flowEntry.setTenantId(tokenData.getTenantId());
        flowEntry.setUpdateUserId(tokenData.getUserId());
        flowEntry.setCreateUserId(tokenData.getUserId());
        Date now = new Date();
        flowEntry.setUpdateTime(now);
        flowEntry.setCreateTime(now);
        this.flowEntryMapper.insert(flowEntry);
        this.insertBuiltinEntryVariables(flowEntry.getEntryId());
        return flowEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public void publish(FlowEntry flowEntry, String initTaskInfo) throws XMLStreamException {
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryKey(flowEntry.getProcessDefinitionKey()));
        FlowCategory flowCategory = (FlowCategory)this.flowCategoryService.getById(flowEntry.getCategoryId());
        ByteArrayInputStream xmlStream = new ByteArrayInputStream(flowEntry.getBpmnXml().getBytes(StandardCharsets.UTF_8));
        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(xmlStream);
        try {
            BpmnXMLConverter converter = new BpmnXMLConverter();
            BpmnModel bpmnModel = converter.convertToBpmnModel(reader);
            bpmnModel.getMainProcess().setName(flowEntry.getProcessDefinitionName());
            bpmnModel.getMainProcess().setId(flowEntry.getProcessDefinitionKey());
            this.flowApiService.addProcessInstanceEndListener(bpmnModel, FlowFinishedListener.class);
            List<FlowTaskExt> flowTaskExtList = this.flowTaskExtService.buildTaskExtList(bpmnModel);
            if (StrUtil.isNotBlank((CharSequence)flowEntry.getExtensionData())) {
                FlowEntryExtensionData flowEntryExtensionData = (FlowEntryExtensionData)JSON.parseObject((String)flowEntry.getExtensionData(), FlowEntryExtensionData.class);
                this.mergeTaskNotifyData(flowEntryExtensionData, flowTaskExtList);
                this.processFlowTaskRevive(flowEntryExtensionData, bpmnModel);
            }
            this.processFlowTaskExtList(flowEntry, flowTaskExtList, bpmnModel);
            TokenData tokenData = TokenData.takeFromRequest();
            Deployment deploy = this.repositoryService.createDeployment().addBpmnModel(flowEntry.getProcessDefinitionKey() + ".bpmn", bpmnModel).tenantId(tokenData.getTenantId() != null ? tokenData.getTenantId().toString() : tokenData.getAppCode()).name(flowEntry.getProcessDefinitionName()).key(flowEntry.getProcessDefinitionKey()).category(flowCategory.getCode()).deploy();
            ProcessDefinition processDefinition = this.flowApiService.getProcessDefinitionByDeployId(deploy.getId());
            FlowEntryPublish flowEntryPublish = new FlowEntryPublish();
            flowEntryPublish.setEntryPublishId(this.idGenerator.nextLongId());
            flowEntryPublish.setEntryId(flowEntry.getEntryId());
            flowEntryPublish.setProcessDefinitionId(processDefinition.getId());
            flowEntryPublish.setDeployId(processDefinition.getDeploymentId());
            flowEntryPublish.setPublishVersion(processDefinition.getVersion());
            flowEntryPublish.setActiveStatus(true);
            flowEntryPublish.setMainVersion(flowEntry.getStatus().equals(0));
            flowEntryPublish.setCreateUserId(TokenData.takeFromRequest().getUserId());
            flowEntryPublish.setPublishTime(new Date());
            flowEntryPublish.setInitTaskInfo(initTaskInfo);
            flowEntryPublish.setExtensionData(flowEntry.getExtensionData());
            AnalyzedNode rootNode = this.flowApiService.analyzeBpmnRoads(processDefinition.getId());
            flowEntryPublish.setAnalyzedNodeJson(JSON.toJSONString((Object)rootNode));
            this.flowEntryPublishMapper.insert(flowEntryPublish);
            FlowEntry updatedFlowEntry = new FlowEntry();
            updatedFlowEntry.setEntryId(flowEntry.getEntryId());
            updatedFlowEntry.setStatus(1);
            updatedFlowEntry.setLatestPublishTime(new Date());
            if (flowEntry.getStatus().equals(0)) {
                updatedFlowEntry.setMainEntryPublishId(flowEntryPublish.getEntryPublishId());
            }
            this.flowEntryMapper.updateById(updatedFlowEntry);
            FlowEntryVariable flowEntryVariableFilter = new FlowEntryVariable();
            flowEntryVariableFilter.setEntryId(flowEntry.getEntryId());
            List<FlowEntryVariable> flowEntryVariableList = this.flowEntryVariableService.getFlowEntryVariableList(flowEntryVariableFilter, null);
            if (CollUtil.isNotEmpty(flowTaskExtList)) {
                flowTaskExtList.forEach(t -> t.setProcessDefinitionId(processDefinition.getId()));
                this.flowTaskExtService.saveBatch(flowTaskExtList);
            }
            this.insertEntryPublishVariables(flowEntryVariableList, flowEntryPublish.getEntryPublishId());
        }
        finally {
            if (Collections.singletonList(reader).get(0) != null) {
                reader.close();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(FlowEntry flowEntry, FlowEntry originalFlowEntry) {
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryKey(flowEntry.getProcessDefinitionKey()));
        TokenData tokenData = TokenData.takeFromRequest();
        flowEntry.setAppCode(tokenData.getAppCode());
        flowEntry.setTenantId(tokenData.getTenantId());
        flowEntry.setUpdateUserId(tokenData.getUserId());
        flowEntry.setCreateUserId(originalFlowEntry.getCreateUserId());
        flowEntry.setUpdateTime(new Date());
        flowEntry.setCreateTime(originalFlowEntry.getCreateTime());
        flowEntry.setPageId(originalFlowEntry.getPageId());
        return this.flowEntryMapper.updateById(flowEntry) == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Long entryId) {
        FlowEntry flowEntry = (FlowEntry)this.getById(entryId);
        if (flowEntry != null) {
            this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryKey(flowEntry.getProcessDefinitionKey()));
        }
        if (this.flowEntryMapper.deleteById(entryId) != 1) {
            return false;
        }
        this.flowEntryVariableService.removeByEntryId(entryId);
        return true;
    }

    @Override
    public List<FlowEntry> getFlowEntryList(FlowEntry filter, String orderBy) {
        if (filter == null) {
            filter = new FlowEntry();
        }
        TokenData tokenData = TokenData.takeFromRequest();
        filter.setTenantId(tokenData.getTenantId());
        filter.setAppCode(tokenData.getAppCode());
        return this.flowEntryMapper.getFlowEntryList(filter, orderBy);
    }

    @Override
    public List<FlowEntry> getFlowEntryListWithRelation(FlowEntry filter, String orderBy) {
        List<FlowEntry> resultList = this.getFlowEntryList(filter, orderBy);
        int batchSize = resultList instanceof Page ? 0 : 1000;
        this.buildRelationForDataList(resultList, MyRelationParam.normal(), batchSize);
        Set mainEntryPublishIdSet = resultList.stream().map(FlowEntry::getMainEntryPublishId).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(mainEntryPublishIdSet)) {
            List mainEntryPublishList = this.flowEntryPublishMapper.selectBatchIds(mainEntryPublishIdSet);
            MyModelUtil.makeOneToOneRelation(FlowEntry.class, resultList, FlowEntry::getMainEntryPublishId, (List)mainEntryPublishList, FlowEntryPublish::getEntryPublishId, (String)"mainFlowEntryPublish");
        }
        return resultList;
    }

    @Override
    public FlowEntry getFlowEntryFromCache(String processDefinitionKey) {
        String key = FlowRedisKeyUtil.makeFlowEntryKey(processDefinitionKey);
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(FlowEntry::getProcessDefinitionKey, (Object)processDefinitionKey);
        TokenData tokenData = TokenData.takeFromRequest();
        if (StrUtil.isNotBlank((CharSequence)tokenData.getAppCode())) {
            qw.eq(FlowEntry::getAppCode, (Object)tokenData.getAppCode());
        } else {
            qw.isNull(FlowEntry::getAppCode);
        }
        if (tokenData.getTenantId() != null) {
            qw.eq(FlowEntry::getTenantId, (Object)tokenData.getTenantId());
        } else {
            qw.isNull(FlowEntry::getTenantId);
        }
        return (FlowEntry)this.commonRedisUtil.getFromCacheWithQueryWrapper(key, qw, arg_0 -> ((FlowEntryMapper)this.flowEntryMapper).selectOne(arg_0), FlowEntry.class);
    }

    @Override
    public List<FlowEntryPublish> getFlowEntryPublishList(Long entryId) {
        FlowEntryPublish filter = new FlowEntryPublish();
        filter.setEntryId(entryId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)filter);
        queryWrapper.orderByDesc(FlowEntryPublish::getEntryPublishId);
        return this.flowEntryPublishMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowEntryPublish> getFlowEntryPublishList(Set<String> processDefinitionIdSet) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(FlowEntryPublish::getProcessDefinitionId, processDefinitionIdSet);
        return this.flowEntryPublishMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public FlowEntryPublish getFlowEntryPublishFromCache(Long entryPublishId) {
        String key = FlowRedisKeyUtil.makeFlowEntryPublishKey(entryPublishId);
        return (FlowEntryPublish)this.commonRedisUtil.getFromCache(key, (Serializable)entryPublishId, arg_0 -> ((FlowEntryPublishMapper)this.flowEntryPublishMapper).selectById(arg_0), FlowEntryPublish.class, FLOW_ENTRY_PUBLISH_TTL);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFlowEntryMainVersion(FlowEntry flowEntry, FlowEntryPublish newMainFlowEntryPublish) {
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryKey(flowEntry.getProcessDefinitionKey()));
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryPublishKey(newMainFlowEntryPublish.getEntryPublishId()));
        FlowEntryPublish oldMainFlowEntryPublish = (FlowEntryPublish)this.flowEntryPublishMapper.selectById(flowEntry.getMainEntryPublishId());
        if (oldMainFlowEntryPublish != null) {
            this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryPublishKey(oldMainFlowEntryPublish.getEntryPublishId()));
            oldMainFlowEntryPublish.setMainVersion(false);
            this.flowEntryPublishMapper.updateById(oldMainFlowEntryPublish);
        }
        newMainFlowEntryPublish.setMainVersion(true);
        this.flowEntryPublishMapper.updateById(newMainFlowEntryPublish);
        FlowEntry updatedEntry = new FlowEntry();
        updatedEntry.setEntryId(flowEntry.getEntryId());
        updatedEntry.setMainEntryPublishId(newMainFlowEntryPublish.getEntryPublishId());
        this.flowEntryMapper.updateById(updatedEntry);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void suspendFlowEntryPublish(FlowEntryPublish flowEntryPublish) {
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryPublishKey(flowEntryPublish.getEntryPublishId()));
        FlowEntryPublish updatedEntryPublish = new FlowEntryPublish();
        updatedEntryPublish.setEntryPublishId(flowEntryPublish.getEntryPublishId());
        updatedEntryPublish.setActiveStatus(false);
        this.flowEntryPublishMapper.updateById(updatedEntryPublish);
        this.flowApiService.suspendProcessDefinition(flowEntryPublish.getProcessDefinitionId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void activateFlowEntryPublish(FlowEntryPublish flowEntryPublish) {
        this.commonRedisUtil.evictFormCache(FlowRedisKeyUtil.makeFlowEntryPublishKey(flowEntryPublish.getEntryPublishId()));
        FlowEntryPublish updatedEntryPublish = new FlowEntryPublish();
        updatedEntryPublish.setEntryPublishId(flowEntryPublish.getEntryPublishId());
        updatedEntryPublish.setActiveStatus(true);
        this.flowEntryPublishMapper.updateById(updatedEntryPublish);
        this.flowApiService.activateProcessDefinition(flowEntryPublish.getProcessDefinitionId());
    }

    @Override
    public boolean existByProcessDefinitionKey(String processDefinitionKey) {
        FlowEntry filter = new FlowEntry();
        filter.setProcessDefinitionKey(processDefinitionKey);
        return CollUtil.isNotEmpty(this.getFlowEntryList(filter, null));
    }

    public CallResult verifyRelatedData(FlowEntry flowEntry, FlowEntry originalFlowEntry) {
        String errorMessageFormat = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5173\u8054\u7684%s\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
        if (this.needToVerify(flowEntry, originalFlowEntry, FlowEntry::getCategoryId) && !this.flowCategoryService.existId(flowEntry.getCategoryId())) {
            return CallResult.error((String)String.format(errorMessageFormat, "\u6d41\u7a0b\u7c7b\u522bId"));
        }
        return CallResult.ok();
    }

    private void insertBuiltinEntryVariables(Long entryId) {
        Date now = new Date();
        FlowEntryVariable operationTypeVariable = new FlowEntryVariable();
        operationTypeVariable.setVariableId(this.idGenerator.nextLongId());
        operationTypeVariable.setEntryId(entryId);
        operationTypeVariable.setVariableName("operationType");
        operationTypeVariable.setShowName("\u5ba1\u6279\u7c7b\u578b");
        operationTypeVariable.setVariableType(1);
        operationTypeVariable.setBuiltin(true);
        operationTypeVariable.setCreateTime(now);
        this.flowEntryVariableService.saveNew(operationTypeVariable);
        FlowEntryVariable startUserNameVariable = new FlowEntryVariable();
        startUserNameVariable.setVariableId(this.idGenerator.nextLongId());
        startUserNameVariable.setEntryId(entryId);
        startUserNameVariable.setVariableName("startUserName");
        startUserNameVariable.setShowName("\u6d41\u7a0b\u542f\u52a8\u7528\u6237");
        startUserNameVariable.setVariableType(0);
        startUserNameVariable.setBuiltin(true);
        startUserNameVariable.setCreateTime(now);
        this.flowEntryVariableService.saveNew(startUserNameVariable);
    }

    private void insertEntryPublishVariables(List<FlowEntryVariable> entryVariableList, Long entryPublishId) {
        if (CollUtil.isEmpty(entryVariableList)) {
            return;
        }
        List entryPublishVariableList = MyModelUtil.copyCollectionTo(entryVariableList, FlowEntryPublishVariable.class);
        for (FlowEntryPublishVariable variable : entryPublishVariableList) {
            variable.setVariableId(this.idGenerator.nextLongId());
            variable.setEntryPublishId(entryPublishId);
        }
        this.flowEntryPublishVariableMapper.insertList(entryPublishVariableList);
    }

    private void mergeTaskNotifyData(FlowEntryExtensionData flowEntryExtensionData, List<FlowTaskExt> flowTaskExtList) {
        if (CollUtil.isEmpty(flowEntryExtensionData.getNotifyTypes())) {
            return;
        }
        List<String> flowTaskNotifyTypes = flowEntryExtensionData.getNotifyTypes().stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toList());
        if (CollUtil.isEmpty(flowTaskNotifyTypes)) {
            return;
        }
        for (FlowTaskExt flowTaskExt : flowTaskExtList) {
            if (flowTaskExt.getExtraDataJson() == null) {
                JSONObject o = new JSONObject();
                o.put("flowNotifyTypeList", flowTaskNotifyTypes);
                flowTaskExt.setExtraDataJson(o.toJSONString());
                continue;
            }
            FlowUserTaskExtData taskExtData = (FlowUserTaskExtData)JSON.parseObject((String)flowTaskExt.getExtraDataJson(), FlowUserTaskExtData.class);
            if (CollUtil.isEmpty(taskExtData.getFlowNotifyTypeList())) {
                taskExtData.setFlowNotifyTypeList(flowTaskNotifyTypes);
            } else {
                Set notifyTypesSet = taskExtData.getFlowNotifyTypeList().stream().filter(CharSequenceUtil::isNotBlank).collect(Collectors.toSet());
                notifyTypesSet.addAll(flowTaskNotifyTypes);
                taskExtData.setFlowNotifyTypeList(new LinkedList<String>(notifyTypesSet));
            }
            flowTaskExt.setExtraDataJson(JSON.toJSONString((Object)taskExtData));
        }
    }

    private void doAddLatestApprovalStatusListener(Collection<FlowElement> elementList) {
        List sequenceFlowList = elementList.stream().filter(SequenceFlow.class::isInstance).collect(Collectors.toList());
        for (FlowElement sequenceFlow : sequenceFlowList) {
            FlowElementExtProperty extProperty = this.flowTaskExtService.buildFlowElementExt(sequenceFlow);
            if (extProperty == null || extProperty.getLatestApprovalStatus() == null) continue;
            LinkedList<FieldExtension> fieldExtensions = new LinkedList<FieldExtension>();
            FieldExtension fieldExtension = new FieldExtension();
            fieldExtension.setFieldName("latestApprovalStatus");
            fieldExtension.setStringValue(extProperty.getLatestApprovalStatus().toString());
            fieldExtensions.add(fieldExtension);
            this.flowApiService.addExecutionListener(sequenceFlow, UpdateLatestApprovalStatusListener.class, "start", fieldExtensions);
        }
        List subProcesseList = elementList.stream().filter(SubProcess.class::isInstance).map(SubProcess.class::cast).collect(Collectors.toList());
        for (SubProcess subProcess : subProcesseList) {
            this.doAddLatestApprovalStatusListener(subProcess.getFlowElements());
        }
    }

    private void calculateAllElementList(Collection<FlowElement> elements, List<FlowElement> resultList) {
        resultList.addAll(elements);
        for (FlowElement element : elements) {
            if (!(element instanceof SubProcess)) continue;
            this.calculateAllElementList(((SubProcess)element).getFlowElements(), resultList);
        }
    }

    private void processFlowTaskRevive(FlowEntryExtensionData flowEntryExtensionData, BpmnModel bpmnModel) {
        if (BooleanUtil.isTrue((Boolean)flowEntryExtensionData.getSupportRevive())) {
            List<UserTask> mainProcessUserTasks = bpmnModel.getMainProcess().getFlowElements().stream().filter(UserTask.class::isInstance).map(UserTask.class::cast).collect(Collectors.toList());
            mainProcessUserTasks.forEach(t -> this.flowApiService.addTaskCreateListener((UserTask)t, (Class<? extends TaskListener>)FlowTaskReviveListener.class));
        }
    }

    private void processFlowTaskExtList(FlowEntry flowEntry, List<FlowTaskExt> flowTaskExtList, BpmnModel bpmnModel) {
        LinkedList<FlowElement> elementList = new LinkedList<FlowElement>();
        this.calculateAllElementList(bpmnModel.getMainProcess().getFlowElements(), elementList);
        this.doAddLatestApprovalStatusListener(elementList);
        Map<String, FlowElement> elementMap = elementList.stream().filter(UserTask.class::isInstance).collect(Collectors.toMap(BaseElement::getId, c -> c));
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        for (FlowTaskExt t : flowTaskExtList) {
            UserTask userTask = (UserTask)elementMap.get(t.getTaskId());
            if (flowEntry.getBindFormType().equals(1) && StrUtil.isNotBlank((CharSequence)userTask.getFormKey())) {
                JSONObject formKeyData = JSON.parseObject((String)userTask.getFormKey());
                formKeyData.remove((Object)"formId");
                userTask.setFormKey(formKeyData.toJSONString());
            }
            this.flowApiService.addTaskCreateListener(userTask, FlowUserTaskListener.class);
            Map attributes = userTask.getAttributes();
            if (CollUtil.isNotEmpty((Collection)((Collection)attributes.get("autoSkipType")))) {
                this.flowApiService.addTaskCreateListener(userTask, AutoSkipTaskListener.class);
            }
            if (StrUtil.equals((CharSequence)t.getGroupType(), (CharSequence)"UP_DEPT_POST_LEADER")) {
                userTask.setCandidateGroups((List)CollUtil.newArrayList((Object[])new String[]{"${upDeptPostLeader}"}));
                Assert.notNull((Object)flowIdentityExtHelper);
                this.flowApiService.addTaskCreateListener(userTask, flowIdentityExtHelper.getUpDeptPostLeaderListener());
            } else if (StrUtil.equals((CharSequence)t.getGroupType(), (CharSequence)"DEPT_POST_LEADER")) {
                userTask.setCandidateGroups((List)CollUtil.newArrayList((Object[])new String[]{"${deptPostLeader}"}));
                Assert.notNull((Object)flowIdentityExtHelper);
                this.flowApiService.addTaskCreateListener(userTask, flowIdentityExtHelper.getDeptPostLeaderListener());
            } else if (StrUtil.equals((CharSequence)t.getGroupType(), (CharSequence)"POST")) {
                Assert.notNull((Object)t.getDeptPostListJson());
                List groupDataList = JSON.parseArray((String)t.getDeptPostListJson(), FlowTaskPostCandidateGroup.class);
                List<String> candidateGroupList = FlowTaskPostCandidateGroup.buildCandidateGroupList(groupDataList);
                userTask.setCandidateGroups(candidateGroupList);
            }
            this.processFlowTaskExtListener(userTask, t);
        }
    }

    private void processFlowTaskExtListener(UserTask userTask, FlowTaskExt taskExt) {
        if (StrUtil.isBlank((CharSequence)taskExt.getExtraDataJson())) {
            return;
        }
        FlowUserTaskExtData userTaskExtData = (FlowUserTaskExtData)JSON.parseObject((String)taskExt.getExtraDataJson(), FlowUserTaskExtData.class);
        if (CollUtil.isNotEmpty(userTaskExtData.getFlowNotifyTypeList())) {
            this.flowApiService.addTaskCreateListener(userTask, FlowTaskNotifyListener.class);
        }
        if (userTaskExtData.getRejectType().equals("1")) {
            this.flowApiService.addTaskCreateListener(userTask, FlowTaskRejectBackListener.class);
        }
        if (StrUtil.isNotBlank((CharSequence)userTaskExtData.getTimeoutHandleWay())) {
            this.flowApiService.addTaskCreateListener(userTask, FlowTaskTimeoutListener.class);
        }
        this.flowApiService.addExecutionListener((FlowElement)userTask, FlowEmptyUserExecListener.class, "start", null);
        this.flowApiService.addTaskCreateListener(userTask, FlowEmptyUserHandleListener.class);
    }
}

