/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowEntryVariableMapper;
import com.dic.bid.common.flow.model.FlowEntryVariable;
import com.dic.bid.common.flow.service.FlowEntryVariableService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import com.github.pagehelper.Page;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowEntryVariableService")
public class FlowEntryVariableServiceImpl
extends BaseService<FlowEntryVariable, Long>
implements FlowEntryVariableService {
    private static final Logger log = LoggerFactory.getLogger(FlowEntryVariableServiceImpl.class);
    @Autowired
    private FlowEntryVariableMapper flowEntryVariableMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowEntryVariable> mapper() {
        return this.flowEntryVariableMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowEntryVariable saveNew(FlowEntryVariable flowEntryVariable) {
        flowEntryVariable.setVariableId(this.idGenerator.nextLongId());
        flowEntryVariable.setCreateTime(new Date());
        this.flowEntryVariableMapper.insert(flowEntryVariable);
        return flowEntryVariable;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean update(FlowEntryVariable flowEntryVariable, FlowEntryVariable originalFlowEntryVariable) {
        flowEntryVariable.setCreateTime(originalFlowEntryVariable.getCreateTime());
        UpdateWrapper uw = this.createUpdateQueryForNullValue(flowEntryVariable, flowEntryVariable.getVariableId());
        return this.flowEntryVariableMapper.update(flowEntryVariable, (Wrapper)uw) == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Long variableId) {
        return this.flowEntryVariableMapper.deleteById(variableId) == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByEntryId(Long entryId) {
        this.flowEntryVariableMapper.delete((Wrapper)new LambdaQueryWrapper().eq(FlowEntryVariable::getEntryId, (Object)entryId));
    }

    @Override
    public List<FlowEntryVariable> getFlowEntryVariableList(FlowEntryVariable filter, String orderBy) {
        return this.flowEntryVariableMapper.getFlowEntryVariableList(filter, orderBy);
    }

    @Override
    public List<FlowEntryVariable> getFlowEntryVariableListWithRelation(FlowEntryVariable filter, String orderBy) {
        List<FlowEntryVariable> resultList = this.flowEntryVariableMapper.getFlowEntryVariableList(filter, orderBy);
        int batchSize = resultList instanceof Page ? 0 : 1000;
        this.buildRelationForDataList(resultList, MyRelationParam.normal(), batchSize);
        return resultList;
    }
}

