/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowMessageCandidateIdentityMapper;
import com.dic.bid.common.flow.dao.FlowMessageIdentityOperationMapper;
import com.dic.bid.common.flow.dao.FlowMessageMapper;
import com.dic.bid.common.flow.model.FlowMessage;
import com.dic.bid.common.flow.model.FlowMessageCandidateIdentity;
import com.dic.bid.common.flow.model.FlowMessageIdentityOperation;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.object.FlowTaskPostCandidateGroup;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.util.BaseBusinessDataExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowMessageService")
public class FlowMessageServiceImpl
extends BaseService<FlowMessage, Long>
implements FlowMessageService {
    private static final Logger log = LoggerFactory.getLogger(FlowMessageServiceImpl.class);
    @Autowired
    private FlowMessageMapper flowMessageMapper;
    @Autowired
    private FlowMessageCandidateIdentityMapper flowMessageCandidateIdentityMapper;
    @Autowired
    private FlowMessageIdentityOperationMapper flowMessageIdentityOperationMapper;
    @Autowired
    private FlowTaskExtService flowTaskExtService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowMessage> mapper() {
        return this.flowMessageMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowMessage saveNew(FlowMessage flowMessage) {
        flowMessage.setMessageId(this.idGenerator.nextLongId());
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData != null) {
            flowMessage.setTenantId(tokenData.getTenantId());
            flowMessage.setAppCode(tokenData.getAppCode());
            flowMessage.setCreateUserId(tokenData.getUserId());
            flowMessage.setCreateUsername(tokenData.getShowName());
            flowMessage.setUpdateUserId(tokenData.getUserId());
        }
        flowMessage.setCreateTime(new Date());
        flowMessage.setUpdateTime(flowMessage.getCreateTime());
        this.flowMessageMapper.insert(flowMessage);
        return flowMessage;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNewRemindMessage(FlowWorkOrder flowWorkOrder) {
        List<Task> taskList = this.flowApiService.getProcessInstanceActiveTaskList(flowWorkOrder.getProcessInstanceId());
        for (Task task : taskList) {
            FlowMessage filter = new FlowMessage();
            filter.setTaskId(task.getId());
            List messageList = this.flowMessageMapper.selectList((Wrapper)new QueryWrapper((Object)filter));
            if (CollUtil.isNotEmpty((Collection)messageList)) {
                for (FlowMessage flowMessage : messageList) {
                    flowMessage.setRemindCount(flowMessage.getRemindCount() + 1);
                    this.flowMessageMapper.updateById(flowMessage);
                }
                continue;
            }
            FlowMessage flowMessage = (FlowMessage)BeanUtil.copyProperties((Object)flowWorkOrder, FlowMessage.class, (String[])new String[0]);
            flowMessage.setMessageType(0);
            flowMessage.setRemindCount(1);
            flowMessage.setProcessInstanceInitiator(flowWorkOrder.getSubmitUsername());
            flowMessage.setTaskId(task.getId());
            flowMessage.setTaskName(task.getName());
            flowMessage.setTaskStartTime(task.getCreateTime());
            flowMessage.setTaskAssignee(task.getAssignee());
            flowMessage.setTaskFinished(false);
            if (TokenData.takeFromRequest() == null) {
                HashSet usernameSet = CollUtil.newHashSet((Object[])new String[]{flowWorkOrder.getSubmitUsername()});
                Map<String, String> m = this.flowCustomExtFactory.getFlowIdentityExtHelper().mapUserShowNameByLoginName(usernameSet);
                flowMessage.setCreateUsername(m.containsKey(flowWorkOrder.getSubmitUsername()) ? m.get(flowWorkOrder.getSubmitUsername()) : flowWorkOrder.getSubmitUsername());
            }
            this.saveNew(flowMessage);
            FlowTaskExt flowTaskExt = this.flowTaskExtService.getByProcessDefinitionIdAndTaskId(flowWorkOrder.getProcessDefinitionId(), task.getTaskDefinitionKey());
            if (flowTaskExt != null) {
                this.saveMessageCandidateIdentityWithMessage(flowWorkOrder.getProcessInstanceId(), flowTaskExt, task, flowMessage.getMessageId());
            }
            if (!StrUtil.isNotBlank((CharSequence)task.getAssignee())) continue;
            this.saveMessageCandidateIdentity(flowMessage.getMessageId(), "user", task.getAssignee());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNewCopyMessage(Task task, JSONObject copyDataJson) {
        if (copyDataJson.isEmpty()) {
            return;
        }
        ProcessInstance instance = this.flowApiService.getProcessInstance(task.getProcessInstanceId());
        BaseBusinessDataExtHelper helper = this.flowCustomExtFactory.getBusinessDataExtHelper();
        String businessShotData = helper.getBusinessData(instance.getProcessDefinitionKey(), instance.getProcessInstanceId(), instance.getBusinessKey());
        FlowMessage flowMessage = new FlowMessage();
        flowMessage.setMessageType(1);
        flowMessage.setRemindCount(0);
        flowMessage.setProcessDefinitionId(instance.getProcessDefinitionId());
        flowMessage.setProcessDefinitionKey(instance.getProcessDefinitionKey());
        flowMessage.setProcessDefinitionName(instance.getProcessDefinitionName());
        flowMessage.setProcessInstanceId(instance.getProcessInstanceId());
        flowMessage.setProcessInstanceInitiator(instance.getStartUserId());
        flowMessage.setTaskId(task.getId());
        flowMessage.setTaskDefinitionKey(task.getTaskDefinitionKey());
        flowMessage.setTaskName(task.getName());
        flowMessage.setTaskStartTime(task.getCreateTime());
        flowMessage.setTaskAssignee(task.getAssignee());
        flowMessage.setTaskFinished(false);
        flowMessage.setBusinessDataShot(businessShotData);
        flowMessage.setOnlineFormData(businessShotData == null);
        if (BooleanUtil.isTrue((Boolean)flowMessage.getOnlineFormData())) {
            TaskInfoVo taskInfo = (TaskInfoVo)JSON.parseObject((String)task.getFormKey(), TaskInfoVo.class);
            flowMessage.setBusinessDataShot(taskInfo.getFormId().toString());
        }
        this.saveNew(flowMessage);
        for (Map.Entry entry : copyDataJson.entrySet()) {
            if (entry.getValue() == null) continue;
            this.saveMessageCandidateIdentityList(flowMessage.getMessageId(), (String)entry.getKey(), entry.getValue().toString());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFinishedStatusByTaskId(String taskId) {
        FlowMessage flowMessage = new FlowMessage();
        flowMessage.setTaskFinished(true);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMessage::getTaskId, (Object)taskId);
        this.flowMessageMapper.update(flowMessage, (Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateFinishedStatusByProcessInstanceId(String processInstanceId) {
        FlowMessage flowMessage = new FlowMessage();
        flowMessage.setTaskFinished(true);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMessage::getProcessInstanceId, (Object)processInstanceId);
        this.flowMessageMapper.update(flowMessage, (Wrapper)queryWrapper);
    }

    @Override
    public List<FlowMessage> getRemindingMessageListByUser() {
        TokenData tokenData = TokenData.takeFromRequest();
        return this.flowMessageMapper.getRemindingMessageListByUser(tokenData.getTenantId(), tokenData.getAppCode(), tokenData.getLoginName(), this.buildGroupIdSet());
    }

    @Override
    public List<FlowMessage> getCopyMessageListByUser(Boolean read) {
        TokenData tokenData = TokenData.takeFromRequest();
        return this.flowMessageMapper.getCopyMessageListByUser(tokenData.getTenantId(), tokenData.getAppCode(), tokenData.getLoginName(), this.buildGroupIdSet(), read);
    }

    @Override
    public boolean isCandidateIdentityOnMessage(Long messageId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMessageCandidateIdentity::getMessageId, (Object)messageId);
        queryWrapper.in(FlowMessageCandidateIdentity::getCandidateId, this.buildGroupIdSet());
        return this.flowMessageCandidateIdentityMapper.selectCount((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void readCopyTask(Long messageId) {
        FlowMessageIdentityOperation operation = new FlowMessageIdentityOperation();
        operation.setId(this.idGenerator.nextLongId());
        operation.setMessageId(messageId);
        operation.setLoginName(TokenData.takeFromRequest().getLoginName());
        operation.setOperationType(0);
        operation.setOperationTime(new Date());
        this.flowMessageIdentityOperationMapper.insert(operation);
    }

    @Override
    public int countRemindingMessageListByUser() {
        TokenData tokenData = TokenData.takeFromRequest();
        return this.flowMessageMapper.countRemindingMessageListByUser(tokenData.getTenantId(), tokenData.getAppCode(), tokenData.getLoginName(), this.buildGroupIdSet());
    }

    @Override
    public int countCopyMessageByUser() {
        TokenData tokenData = TokenData.takeFromRequest();
        return this.flowMessageMapper.countCopyMessageListByUser(tokenData.getTenantId(), tokenData.getAppCode(), tokenData.getLoginName(), this.buildGroupIdSet());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByProcessInstanceId(String processInstanceId) {
        this.flowMessageCandidateIdentityMapper.deleteByProcessInstanceId(processInstanceId);
        this.flowMessageIdentityOperationMapper.deleteByProcessInstanceId(processInstanceId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMessage::getProcessInstanceId, (Object)processInstanceId);
        this.flowMessageMapper.delete((Wrapper)queryWrapper);
    }

    private Set<String> buildGroupIdSet() {
        TokenData tokenData = TokenData.takeFromRequest();
        HashSet<String> groupIdSet = new HashSet<String>(1);
        groupIdSet.add(tokenData.getLoginName());
        this.parseAndAddIdArray(groupIdSet, tokenData.getRoleIds());
        this.parseAndAddIdArray(groupIdSet, tokenData.getDeptPostIds());
        this.parseAndAddIdArray(groupIdSet, tokenData.getPostIds());
        if (tokenData.getDeptId() != null) {
            groupIdSet.add(tokenData.getDeptId().toString());
        }
        return groupIdSet;
    }

    private void parseAndAddIdArray(Set<String> groupIdSet, String idArray) {
        if (StrUtil.isNotBlank((CharSequence)idArray)) {
            if (groupIdSet == null) {
                groupIdSet = new HashSet<String>();
            }
            groupIdSet.addAll(StrUtil.split((CharSequence)idArray, (char)','));
        }
    }

    private void saveMessageCandidateIdentityWithMessage(String processInstanceId, FlowTaskExt flowTaskExt, Task task, Long messageId) {
        List<String> candidates = this.flowApiService.getCandidateUsernames(flowTaskExt, task.getId());
        if (CollUtil.isNotEmpty(candidates)) {
            this.saveMessageCandidateIdentityList(messageId, "user", CollUtil.join(candidates, (CharSequence)","));
        }
        this.saveMessageCandidateIdentityList(messageId, "role", flowTaskExt.getRoleIds());
        this.saveMessageCandidateIdentityList(messageId, "dept", flowTaskExt.getDeptIds());
        if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"UP_DEPT_POST_LEADER")) {
            Object v = this.flowApiService.getProcessInstanceVariable(processInstanceId, "upDeptPostLeader");
            if (v != null) {
                this.saveMessageCandidateIdentity(messageId, "upDeptPostLeader", v.toString());
            }
        } else if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"DEPT_POST_LEADER")) {
            Object v = this.flowApiService.getProcessInstanceVariable(processInstanceId, "deptPostLeader");
            if (v != null) {
                this.saveMessageCandidateIdentity(messageId, "deptPostLeader", v.toString());
            }
        } else if (StrUtil.equals((CharSequence)flowTaskExt.getGroupType(), (CharSequence)"POST")) {
            Assert.notBlank((CharSequence)flowTaskExt.getDeptPostListJson());
            List groupDataList = JSONArray.parseArray((String)flowTaskExt.getDeptPostListJson(), FlowTaskPostCandidateGroup.class);
            for (FlowTaskPostCandidateGroup groupData : groupDataList) {
                this.saveMessageCandidateIdentity(messageId, processInstanceId, groupData);
            }
        }
    }

    private void saveMessageCandidateIdentity(Long messageId, String processInstanceId, FlowTaskPostCandidateGroup groupData) {
        FlowMessageCandidateIdentity candidateIdentity = new FlowMessageCandidateIdentity();
        candidateIdentity.setId(this.idGenerator.nextLongId());
        candidateIdentity.setMessageId(messageId);
        candidateIdentity.setCandidateType(groupData.getType());
        switch (groupData.getType()) {
            case "allDeptPost": {
                candidateIdentity.setCandidateId(groupData.getPostId());
                this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
                break;
            }
            case "deptPost": {
                candidateIdentity.setCandidateId(groupData.getDeptPostId());
                this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
                break;
            }
            case "selfDeptPost": {
                Object v = this.flowApiService.getProcessInstanceVariable(processInstanceId, "SELF_DEPT_" + groupData.getPostId());
                if (v == null) break;
                candidateIdentity.setCandidateId(v.toString());
                this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
                break;
            }
            case "upDeptPost": {
                Object v2 = this.flowApiService.getProcessInstanceVariable(processInstanceId, "UP_DEPT_" + groupData.getPostId());
                if (v2 == null) break;
                candidateIdentity.setCandidateId(v2.toString());
                this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
                break;
            }
            case "siblingDeptPost": {
                Object v3 = this.flowApiService.getProcessInstanceVariable(processInstanceId, "SIBLING_DEPT_" + groupData.getPostId());
                if (v3 == null) break;
                List candidateIds = StrUtil.split((CharSequence)v3.toString(), (CharSequence)",");
                for (String candidateId : candidateIds) {
                    candidateIdentity.setId(this.idGenerator.nextLongId());
                    candidateIdentity.setCandidateId(candidateId);
                    this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
                }
                break;
            }
        }
    }

    private void saveMessageCandidateIdentity(Long messageId, String candidateType, String candidateId) {
        FlowMessageCandidateIdentity candidateIdentity = new FlowMessageCandidateIdentity();
        candidateIdentity.setId(this.idGenerator.nextLongId());
        candidateIdentity.setMessageId(messageId);
        candidateIdentity.setCandidateType(candidateType);
        candidateIdentity.setCandidateId(candidateId);
        this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
    }

    private void saveMessageCandidateIdentityList(Long messageId, String candidateType, String identityIds) {
        if (StrUtil.isNotBlank((CharSequence)identityIds)) {
            for (String identityId : StrUtil.split((CharSequence)identityIds, (char)',')) {
                FlowMessageCandidateIdentity candidateIdentity = new FlowMessageCandidateIdentity();
                candidateIdentity.setId(this.idGenerator.nextLongId());
                candidateIdentity.setMessageId(messageId);
                candidateIdentity.setCandidateType(candidateType);
                candidateIdentity.setCandidateId(identityId);
                this.flowMessageCandidateIdentityMapper.insert(candidateIdentity);
            }
        }
    }
}

