/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowMultiInstanceTransMapper;
import com.dic.bid.common.flow.model.FlowMultiInstanceTrans;
import com.dic.bid.common.flow.service.FlowMultiInstanceTransService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowMultiInstanceTransService")
public class FlowMultiInstanceTransServiceImpl
extends BaseService<FlowMultiInstanceTrans, Long>
implements FlowMultiInstanceTransService {
    private static final Logger log = LoggerFactory.getLogger(FlowMultiInstanceTransServiceImpl.class);
    @Autowired
    private FlowMultiInstanceTransMapper flowMultiInstanceTransMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowMultiInstanceTrans> mapper() {
        return this.flowMultiInstanceTransMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowMultiInstanceTrans saveNew(FlowMultiInstanceTrans flowMultiInstanceTrans) {
        flowMultiInstanceTrans.setId(this.idGenerator.nextLongId());
        TokenData tokenData = TokenData.takeFromRequest();
        flowMultiInstanceTrans.setCreateUserId(tokenData.getUserId());
        flowMultiInstanceTrans.setCreateLoginName(tokenData.getLoginName());
        flowMultiInstanceTrans.setCreateUsername(tokenData.getShowName());
        flowMultiInstanceTrans.setCreateTime(new Date());
        this.flowMultiInstanceTransMapper.insert(flowMultiInstanceTrans);
        return flowMultiInstanceTrans;
    }

    @Override
    public FlowMultiInstanceTrans getByExecutionId(String executionId, String taskId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMultiInstanceTrans::getExecutionId, (Object)executionId);
        queryWrapper.eq(FlowMultiInstanceTrans::getTaskId, (Object)taskId);
        return (FlowMultiInstanceTrans)this.flowMultiInstanceTransMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public FlowMultiInstanceTrans getWithAssigneeListByMultiInstanceExecId(String multiInstanceExecId) {
        if (multiInstanceExecId == null) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowMultiInstanceTrans::getMultiInstanceExecId, (Object)multiInstanceExecId);
        queryWrapper.isNotNull(FlowMultiInstanceTrans::getAssigneeList);
        return (FlowMultiInstanceTrans)this.flowMultiInstanceTransMapper.selectOne((Wrapper)queryWrapper);
    }
}

