/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowTaskCommentMapper;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.object.FlowTaskCommentExtra;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowTaskCommentService")
public class FlowTaskCommentServiceImpl
extends BaseService<FlowTaskComment, Long>
implements FlowTaskCommentService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskCommentServiceImpl.class);
    @Autowired
    private FlowTaskCommentMapper flowTaskCommentMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowTaskComment> mapper() {
        return this.flowTaskCommentMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowTaskComment saveNew(FlowTaskComment flowTaskComment) {
        flowTaskComment.setId(this.idGenerator.nextLongId());
        TokenData tokenData = TokenData.takeFromRequest();
        if (tokenData != null && flowTaskComment.getCreateUserId() == null) {
            flowTaskComment.setHeadImageUrl(tokenData.getHeadImageUrl());
            flowTaskComment.setCreateUserId(tokenData.getUserId());
            flowTaskComment.setCreateLoginName(tokenData.getLoginName());
            flowTaskComment.setCreateUsername(tokenData.getShowName());
        }
        flowTaskComment.setCreateTime(new Date());
        this.flowTaskCommentMapper.insert(flowTaskComment);
        FlowTaskComment.setToRequest(flowTaskComment);
        return flowTaskComment;
    }

    @Override
    public List<FlowTaskComment> getFlowTaskCommentList(String processInstanceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.orderByAsc(FlowTaskComment::getId);
        return this.flowTaskCommentMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskComment> getFlowTaskCommentList(String processInstanceId, String taskKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.eq(FlowTaskComment::getTaskKey, (Object)taskKey);
        queryWrapper.orderByDesc(FlowTaskComment::getId);
        return this.flowTaskCommentMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskComment> getFlowTaskCommentListByTaskIds(Set<String> taskIdSet) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().in(FlowTaskComment::getTaskId, taskIdSet);
        queryWrapper.orderByDesc(FlowTaskComment::getId);
        return this.flowTaskCommentMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public FlowTaskComment getLatestFlowTaskComment(String processInstanceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.orderByDesc(FlowTaskComment::getId);
        IPage pageData = this.flowTaskCommentMapper.selectPage((IPage)new Page(1L, 1L), (Wrapper)queryWrapper);
        return CollUtil.isEmpty((Collection)pageData.getRecords()) ? null : (FlowTaskComment)pageData.getRecords().get(0);
    }

    @Override
    public FlowTaskComment getLatestFlowTaskComment(String processInstanceId, String taskDefinitionKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.eq(FlowTaskComment::getTaskKey, (Object)taskDefinitionKey);
        queryWrapper.orderByDesc(FlowTaskComment::getId);
        IPage pageData = this.flowTaskCommentMapper.selectPage((IPage)new Page(1L, 1L), (Wrapper)queryWrapper);
        return CollUtil.isEmpty((Collection)pageData.getRecords()) ? null : (FlowTaskComment)pageData.getRecords().get(0);
    }

    @Override
    public FlowTaskComment getFirstFlowTaskComment(String processInstanceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.orderByAsc(FlowTaskComment::getId);
        IPage pageData = this.flowTaskCommentMapper.selectPage((IPage)new Page(1L, 1L), (Wrapper)queryWrapper);
        return CollUtil.isEmpty((Collection)pageData.getRecords()) ? null : (FlowTaskComment)pageData.getRecords().get(0);
    }

    @Override
    public List<FlowTaskComment> getFlowTaskCommentListByExecutionId(String processInstanceId, String taskId, String executionId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getProcessInstanceId, (Object)processInstanceId);
        queryWrapper.eq(FlowTaskComment::getTaskId, (Object)taskId);
        queryWrapper.eq(FlowTaskComment::getExecutionId, (Object)executionId);
        queryWrapper.orderByAsc(FlowTaskComment::getCreateTime);
        return this.flowTaskCommentMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskComment> getFlowTaskCommentListByMultiInstanceExecId(String multiInstanceExecId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskComment::getMultiInstanceExecId, (Object)multiInstanceExecId);
        return this.flowTaskCommentMapper.selectList((Wrapper)queryWrapper);
    }

    @Override
    public String getRefectBackTypeTargetKey(FlowTaskComment comment) {
        String result = null;
        if (StrUtil.isNotBlank((CharSequence)comment.getCustomBusinessData())) {
            FlowTaskCommentExtra extra = (FlowTaskCommentExtra)JSON.parseObject((String)comment.getCustomBusinessData(), FlowTaskCommentExtra.class);
            result = extra.getRejectBackTargetTaskKey();
        }
        return result;
    }
}

