/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.exception.MyRuntimeException;
import com.dic.bid.common.core.object.Tuple2;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowTaskExtMapper;
import com.dic.bid.common.flow.model.FlowEntryVariable;
import com.dic.bid.common.flow.model.FlowMultiInstanceTrans;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskExt;
import com.dic.bid.common.flow.object.FlowElementExtProperty;
import com.dic.bid.common.flow.object.FlowTaskMultiSignAssign;
import com.dic.bid.common.flow.object.FlowUserTaskExtData;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryVariableService;
import com.dic.bid.common.flow.service.FlowMultiInstanceTransService;
import com.dic.bid.common.flow.service.FlowTaskCommentService;
import com.dic.bid.common.flow.service.FlowTaskExtService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.task.api.TaskInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowTaskExtService")
public class FlowTaskExtServiceImpl
extends BaseService<FlowTaskExt, String>
implements FlowTaskExtService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskExtServiceImpl.class);
    @Autowired
    private FlowTaskExtMapper flowTaskExtMapper;
    @Autowired
    private FlowEntryVariableService flowEntryVariableService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowMultiInstanceTransService flowMultiInstanceTransService;
    @Autowired
    private FlowTaskCommentService flowTaskCommentService;
    private static final String ID = "id";
    private static final String TYPE = "type";
    private static final String LABEL = "label";
    private static final String NAME = "name";
    private static final String VALUE = "value";

    protected BaseDaoMapper<FlowTaskExt> mapper() {
        return this.flowTaskExtMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveBatch(List<FlowTaskExt> flowTaskExtList) {
        if (CollUtil.isNotEmpty(flowTaskExtList)) {
            this.flowTaskExtMapper.insertList(flowTaskExtList);
        }
    }

    @Override
    public FlowTaskExt getByProcessDefinitionIdAndTaskId(String processDefinitionId, String taskId) {
        FlowTaskExt filter = new FlowTaskExt();
        filter.setProcessDefinitionId(processDefinitionId);
        filter.setTaskId(taskId);
        return (FlowTaskExt)this.flowTaskExtMapper.selectOne((Wrapper)new QueryWrapper((Object)filter));
    }

    @Override
    public List<FlowTaskExt> getByProcessDefinitionId(String processDefinitionId) {
        FlowTaskExt filter = new FlowTaskExt();
        filter.setProcessDefinitionId(processDefinitionId);
        return this.flowTaskExtMapper.selectList((Wrapper)new QueryWrapper((Object)filter));
    }

    @Override
    public List<FlowUserInfoVo> getCandidateUserInfoList(String processInstanceId, FlowTaskExt flowTaskExt, TaskInfo taskInfo, boolean isMultiInstanceTask, boolean historic) {
        List<FlowUserInfoVo> userInfoList;
        List<String> assigneeList;
        LinkedList<FlowUserInfoVo> resultUserMapList = new LinkedList<FlowUserInfoVo>();
        if (!isMultiInstanceTask && this.buildTransferUserList(taskInfo, resultUserMapList)) {
            return resultUserMapList;
        }
        HashSet<String> loginNameSet = new HashSet<String>();
        this.buildFlowUserInfoListByDeptAndRoleIds(flowTaskExt, loginNameSet, resultUserMapList);
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        HashSet<String> usernameSet = new HashSet<String>();
        switch (flowTaskExt.getGroupType()) {
            case "ASSIGNEE": {
                if (isMultiInstanceTask) break;
                usernameSet.add(taskInfo.getAssignee());
                break;
            }
            case "DEPT_POST_LEADER": {
                String deptPostLeaderId = this.flowApiService.getExecutionVariableStringWithSafe(taskInfo.getExecutionId(), "deptPostLeader");
                List<FlowUserInfoVo> userInfoList2 = flowIdentityExtHelper.getUserInfoListByDeptPostIds(CollUtil.newHashSet((Object[])new String[]{deptPostLeaderId}));
                this.buildUserMapList(userInfoList2, loginNameSet, resultUserMapList);
                break;
            }
            case "UP_DEPT_POST_LEADER": {
                String upDeptPostLeaderId = this.flowApiService.getExecutionVariableStringWithSafe(taskInfo.getExecutionId(), "upDeptPostLeader");
                List<FlowUserInfoVo> upUserInfoList = flowIdentityExtHelper.getUserInfoListByDeptPostIds(CollUtil.newHashSet((Object[])new String[]{upDeptPostLeaderId}));
                this.buildUserMapList(upUserInfoList, loginNameSet, resultUserMapList);
                break;
            }
        }
        List<String> candidateUsernames = this.flowApiService.getCandidateUsernames(flowTaskExt, taskInfo.getId());
        if (CollUtil.isNotEmpty(candidateUsernames)) {
            usernameSet.addAll(candidateUsernames);
        }
        if (isMultiInstanceTask && CollUtil.isNotEmpty(assigneeList = this.getAssigneeList(taskInfo.getExecutionId(), taskInfo.getId()))) {
            usernameSet.addAll(assigneeList);
        }
        if (CollUtil.isNotEmpty(usernameSet)) {
            List<FlowUserInfoVo> userInfoList3 = flowIdentityExtHelper.getUserInfoListByUsernameSet(usernameSet);
            this.buildUserMapList(userInfoList3, loginNameSet, resultUserMapList);
        }
        Tuple2<Set<String>, Set<String>> tuple2 = this.flowApiService.getDeptPostIdAndPostIds(flowTaskExt, processInstanceId, historic);
        Set postIdSet = (Set)tuple2.getSecond();
        Set deptPostIdSet = (Set)tuple2.getFirst();
        if (CollUtil.isNotEmpty((Collection)postIdSet)) {
            userInfoList = flowIdentityExtHelper.getUserInfoListByPostIds(postIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
        if (CollUtil.isNotEmpty((Collection)deptPostIdSet)) {
            userInfoList = flowIdentityExtHelper.getUserInfoListByDeptPostIds(deptPostIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
        return this.reorderSequenceMultiInstanceUserList(flowTaskExt, usernameSet, resultUserMapList);
    }

    @Override
    public List<FlowUserInfoVo> getCandidateUserInfoList(String processInstanceId, String executionId, FlowTaskExt flowTaskExt) {
        List<FlowUserInfoVo> userInfoList;
        List candidateUsernames;
        LinkedList<FlowUserInfoVo> resultUserMapList = new LinkedList<FlowUserInfoVo>();
        HashSet<String> loginNameSet = new HashSet<String>();
        this.buildFlowUserInfoListByDeptAndRoleIds(flowTaskExt, loginNameSet, resultUserMapList);
        HashSet<String> usernameSet = new HashSet<String>();
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        switch (flowTaskExt.getGroupType()) {
            case "DEPT_POST_LEADER": {
                String deptPostLeaderId = this.flowApiService.getExecutionVariableStringWithSafe(executionId, "deptPostLeader");
                List<FlowUserInfoVo> userInfoList2 = flowIdentityExtHelper.getUserInfoListByDeptPostIds(CollUtil.newHashSet((Object[])new String[]{deptPostLeaderId}));
                this.buildUserMapList(userInfoList2, loginNameSet, resultUserMapList);
                break;
            }
            case "UP_DEPT_POST_LEADER": {
                String upDeptPostLeaderId = this.flowApiService.getExecutionVariableStringWithSafe(executionId, "upDeptPostLeader");
                List<FlowUserInfoVo> upUserInfoList = flowIdentityExtHelper.getUserInfoListByDeptPostIds(CollUtil.newHashSet((Object[])new String[]{upDeptPostLeaderId}));
                this.buildUserMapList(upUserInfoList, loginNameSet, resultUserMapList);
                break;
            }
        }
        if (StrUtil.isBlank((CharSequence)flowTaskExt.getCandidateUsernames())) {
            candidateUsernames = Collections.emptyList();
        } else if (!StrUtil.equals((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)"${appointedAssignee}")) {
            candidateUsernames = StrUtil.split((CharSequence)flowTaskExt.getCandidateUsernames(), (CharSequence)",");
        } else {
            String v = this.flowApiService.getExecutionVariableStringWithSafe(executionId, "appointedAssignee");
            List list = candidateUsernames = v == null ? null : StrUtil.split((CharSequence)v.toString(), (CharSequence)",");
        }
        if (CollUtil.isNotEmpty(candidateUsernames)) {
            usernameSet.addAll(candidateUsernames);
        }
        if (CollUtil.isNotEmpty(usernameSet)) {
            List<FlowUserInfoVo> userInfoList3 = flowIdentityExtHelper.getUserInfoListByUsernameSet(usernameSet);
            this.buildUserMapList(userInfoList3, loginNameSet, resultUserMapList);
        }
        Tuple2<Set<String>, Set<String>> tuple2 = this.flowApiService.getDeptPostIdAndPostIds(flowTaskExt, processInstanceId, false);
        Set postIdSet = (Set)tuple2.getSecond();
        Set deptPostIdSet = (Set)tuple2.getFirst();
        if (CollUtil.isNotEmpty((Collection)postIdSet)) {
            userInfoList = flowIdentityExtHelper.getUserInfoListByPostIds(postIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
        if (CollUtil.isNotEmpty((Collection)deptPostIdSet)) {
            userInfoList = flowIdentityExtHelper.getUserInfoListByDeptPostIds(deptPostIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
        return resultUserMapList;
    }

    private void buildUserMapList(List<FlowUserInfoVo> userInfoList, Set<String> loginNameSet, List<FlowUserInfoVo> userMapList) {
        if (CollUtil.isEmpty(userInfoList)) {
            return;
        }
        for (FlowUserInfoVo userInfo : userInfoList) {
            if (loginNameSet.contains(userInfo.getLoginName())) continue;
            loginNameSet.add(userInfo.getLoginName());
            userMapList.add(userInfo);
        }
    }

    @Override
    public FlowTaskExt buildTaskExtByUserTask(UserTask userTask) {
        JSONObject candidateGroupObject;
        List<JSONObject> copyList;
        List<JSONObject> deptPostList;
        JSONObject assigneeListObject;
        List<JSONObject> variableList;
        Map extensionMap;
        JSONObject extraDataJson;
        FlowTaskExt flowTaskExt = new FlowTaskExt();
        flowTaskExt.setTaskId(userTask.getId());
        String formKey = userTask.getFormKey();
        if (StrUtil.isNotBlank((CharSequence)formKey)) {
            TaskInfoVo taskInfoVo = (TaskInfoVo)JSON.parseObject((String)formKey, TaskInfoVo.class);
            flowTaskExt.setGroupType(taskInfoVo.getGroupType());
        }
        if ((extraDataJson = this.buildFlowTaskExtensionData(userTask)) != null) {
            flowTaskExt.setExtraDataJson(extraDataJson.toJSONString());
        }
        if (MapUtil.isEmpty((Map)(extensionMap = userTask.getExtensionElements()))) {
            return flowTaskExt;
        }
        List<JSONObject> operationList = this.buildOperationListExtensionElement(extensionMap);
        if (CollUtil.isNotEmpty(operationList)) {
            flowTaskExt.setOperationListJson(JSON.toJSONString(operationList));
        }
        if (CollUtil.isNotEmpty(variableList = this.buildVariableListExtensionElement(extensionMap))) {
            flowTaskExt.setVariableListJson(JSON.toJSONString(variableList));
        }
        if ((assigneeListObject = this.buildAssigneeListExtensionElement(extensionMap)) != null) {
            flowTaskExt.setAssigneeListJson(JSON.toJSONString((Object)assigneeListObject));
        }
        if ((deptPostList = this.buildDeptPostListExtensionElement(extensionMap)) != null) {
            flowTaskExt.setDeptPostListJson(JSON.toJSONString(deptPostList));
        }
        if ((copyList = this.buildCopyListExtensionElement(extensionMap)) != null) {
            flowTaskExt.setCopyListJson(JSON.toJSONString(copyList));
        }
        if ((candidateGroupObject = this.buildUserCandidateGroupsExtensionElement(extensionMap)) != null) {
            String type = candidateGroupObject.getString(TYPE);
            String value = candidateGroupObject.getString(VALUE);
            switch (type) {
                case "DEPT": {
                    flowTaskExt.setDeptIds(value);
                    break;
                }
                case "ROLE": {
                    flowTaskExt.setRoleIds(value);
                    break;
                }
                case "USERS": {
                    flowTaskExt.setCandidateUsernames(value);
                    break;
                }
            }
        }
        return flowTaskExt;
    }

    @Override
    public List<FlowTaskExt> buildTaskExtList(BpmnModel bpmnModel) {
        List processList = bpmnModel.getProcesses();
        LinkedList<FlowTaskExt> flowTaskExtList = new LinkedList<FlowTaskExt>();
        for (Process process : processList) {
            for (FlowElement element : process.getFlowElements()) {
                this.doBuildTaskExtList(element, flowTaskExtList);
            }
        }
        return flowTaskExtList;
    }

    @Override
    public List<JSONObject> buildOperationListExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        List<ExtensionElement> formOperationElements = this.getMyExtensionElementList(extensionMap, "operationList", "formOperation");
        if (CollUtil.isEmpty(formOperationElements)) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        for (ExtensionElement e : formOperationElements) {
            JSONObject operationJsonData = new JSONObject();
            operationJsonData.put(ID, (Object)e.getAttributeValue(null, ID));
            operationJsonData.put(LABEL, (Object)e.getAttributeValue(null, LABEL));
            operationJsonData.put(TYPE, (Object)e.getAttributeValue(null, TYPE));
            operationJsonData.put("showOrder", (Object)e.getAttributeValue(null, "showOrder"));
            operationJsonData.put("latestApprovalStatus", (Object)e.getAttributeValue(null, "latestApprovalStatus"));
            String multiSignAssignee = e.getAttributeValue(null, "multiSignAssignee");
            if (StrUtil.isNotBlank((CharSequence)multiSignAssignee)) {
                operationJsonData.put("multiSignAssignee", JSON.parseObject((String)multiSignAssignee, FlowTaskMultiSignAssign.class));
            }
            resultList.add(operationJsonData);
        }
        return resultList;
    }

    @Override
    public List<JSONObject> buildVariableListExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        List<ExtensionElement> formVariableElements = this.getMyExtensionElementList(extensionMap, "variableList", "formVariable");
        if (CollUtil.isEmpty(formVariableElements)) {
            return Collections.emptyList();
        }
        HashSet<Long> variableIdSet = new HashSet<Long>();
        for (ExtensionElement e : formVariableElements) {
            String id = e.getAttributeValue(null, ID);
            variableIdSet.add(Long.parseLong(id));
        }
        List variableList = this.flowEntryVariableService.getInList(variableIdSet);
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        for (FlowEntryVariable variable : variableList) {
            resultList.add((JSONObject)JSON.toJSON((Object)variable));
        }
        return resultList;
    }

    @Override
    public FlowElementExtProperty buildFlowElementExt(FlowElement element) {
        JSONObject propertiesData = this.buildFlowElementExtToJson(element);
        return propertiesData == null ? null : (FlowElementExtProperty)propertiesData.toJavaObject(FlowElementExtProperty.class);
    }

    @Override
    public JSONObject buildFlowElementExtToJson(FlowElement element) {
        Map extensionMap = element.getExtensionElements();
        List<ExtensionElement> propertiesElements = this.getMyExtensionElementList(extensionMap, "properties", "property");
        if (CollUtil.isEmpty(propertiesElements)) {
            return null;
        }
        JSONObject propertiesData = new JSONObject();
        for (ExtensionElement e : propertiesElements) {
            String name = e.getAttributeValue(null, NAME);
            String value = e.getAttributeValue(null, VALUE);
            propertiesData.put(name, (Object)value);
        }
        return propertiesData;
    }

    private List<FlowUserInfoVo> reorderSequenceMultiInstanceUserList(FlowTaskExt flowTaskExt, Set<String> usernameSet, List<FlowUserInfoVo> resultUserMapList) {
        if (CollUtil.isEmpty(resultUserMapList) || StrUtil.isBlank((CharSequence)flowTaskExt.getExtraDataJson())) {
            return resultUserMapList;
        }
        FlowUserTaskExtData taskExtData = (FlowUserTaskExtData)JSON.parseObject((String)flowTaskExt.getExtraDataJson(), FlowUserTaskExtData.class);
        if (BooleanUtil.isFalse((Boolean)taskExtData.getSequenceMultiInstance())) {
            return resultUserMapList;
        }
        LinkedList<FlowUserInfoVo> resultList = new LinkedList<FlowUserInfoVo>();
        Map<String, FlowUserInfoVo> resultMap = resultUserMapList.stream().collect(Collectors.toMap(FlowUserInfoVo::getLoginName, c -> c));
        for (String username : usernameSet) {
            FlowUserInfoVo userInfoVo = resultMap.get(username);
            if (userInfoVo == null) continue;
            resultList.add(userInfoVo);
        }
        return resultList;
    }

    private void doBuildTaskExtList(FlowElement element, List<FlowTaskExt> flowTaskExtList) {
        if (element instanceof UserTask) {
            FlowTaskExt flowTaskExt = this.buildTaskExtByUserTask((UserTask)element);
            flowTaskExtList.add(flowTaskExt);
        } else if (element instanceof SubProcess) {
            Collection flowElements = ((SubProcess)element).getFlowElements();
            for (FlowElement element1 : flowElements) {
                this.doBuildTaskExtList(element1, flowTaskExtList);
            }
        }
    }

    private void buildFlowUserInfoListByDeptAndRoleIds(FlowTaskExt flowTaskExt, Set<String> loginNameSet, List<FlowUserInfoVo> resultUserMapList) {
        List<FlowUserInfoVo> userInfoList;
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getDeptIds())) {
            HashSet deptIdSet = CollUtil.newHashSet((Collection)StrUtil.split((CharSequence)flowTaskExt.getDeptIds(), (char)','));
            userInfoList = flowIdentityExtHelper.getUserInfoListByDeptIds(deptIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
        if (StrUtil.isNotBlank((CharSequence)flowTaskExt.getRoleIds())) {
            HashSet roleIdSet = CollUtil.newHashSet((Collection)StrUtil.split((CharSequence)flowTaskExt.getRoleIds(), (char)','));
            userInfoList = flowIdentityExtHelper.getUserInfoListByRoleIds(roleIdSet);
            this.buildUserMapList(userInfoList, loginNameSet, resultUserMapList);
        }
    }

    private void buildFlowTaskTimeoutExtensionData(Map<String, List<ExtensionAttribute>> attributeMap, JSONObject extraDataJson) {
        List<ExtensionAttribute> timeoutHandleWayAttributes = attributeMap.get("timeoutHandleWay");
        if (CollUtil.isNotEmpty(timeoutHandleWayAttributes)) {
            String handleWay = timeoutHandleWayAttributes.get(0).getValue();
            extraDataJson.put("timeoutHandleWay", (Object)handleWay);
            List<ExtensionAttribute> timeoutHoursAttributes = attributeMap.get("timeoutHours");
            if (CollUtil.isEmpty(timeoutHoursAttributes)) {
                throw new MyRuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u4efb\u52a1\u8d85\u65f6\u5c0f\u65f6\u6570\uff01");
            }
            Integer timeoutHours = Integer.valueOf(timeoutHoursAttributes.get(0).getValue());
            extraDataJson.put("timeoutHours", (Object)timeoutHours);
            if (StrUtil.equals((CharSequence)handleWay, (CharSequence)"autoComplete")) {
                List<ExtensionAttribute> defaultAssigneeAttributes = attributeMap.get("defaultAssignee");
                if (CollUtil.isEmpty(defaultAssigneeAttributes)) {
                    throw new MyRuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u8d85\u65f6\u4efb\u52a1\u5904\u7406\u4eba\uff01");
                }
                extraDataJson.put("defaultAssignee", (Object)defaultAssigneeAttributes.get(0).getValue());
            }
        }
    }

    private void buildFlowTaskEmptyUserExtensionData(Map<String, List<ExtensionAttribute>> attributeMap, JSONObject extraDataJson) {
        List<ExtensionAttribute> emptyUserHandleWayAttributes = attributeMap.get("emptyUserHandleWay");
        if (CollUtil.isNotEmpty(emptyUserHandleWayAttributes)) {
            String handleWay = emptyUserHandleWayAttributes.get(0).getValue();
            extraDataJson.put("emptyUserHandleWay", (Object)handleWay);
            if (StrUtil.equals((CharSequence)handleWay, (CharSequence)"toAssignee")) {
                List<ExtensionAttribute> emptyUserToAssigneeAttributes = attributeMap.get("emptyUserToAssignee");
                if (CollUtil.isEmpty(emptyUserToAssigneeAttributes)) {
                    throw new MyRuntimeException("\u6ca1\u6709\u8bbe\u7f6e\u7a7a\u5ba1\u6279\u4eba\u7684\u6307\u5b9a\u5904\u7406\u4eba\uff01");
                }
                extraDataJson.put("emptyUserToAssignee", (Object)emptyUserToAssigneeAttributes.get(0).getValue());
            }
        }
    }

    private JSONObject buildFlowTaskExtensionData(UserTask userTask) {
        List sendMsgTypeAttributes;
        JSONObject extraDataJson = this.buildFlowElementExtToJson((FlowElement)userTask);
        Map attributeMap = userTask.getAttributes();
        if (MapUtil.isEmpty((Map)attributeMap)) {
            return extraDataJson;
        }
        if (extraDataJson == null) {
            extraDataJson = new JSONObject();
        }
        this.buildFlowTaskTimeoutExtensionData(attributeMap, extraDataJson);
        this.buildFlowTaskEmptyUserExtensionData(attributeMap, extraDataJson);
        List rejectTypeAttributes = (List)attributeMap.get("rejectType");
        if (CollUtil.isNotEmpty((Collection)rejectTypeAttributes)) {
            extraDataJson.put("rejectType", (Object)((ExtensionAttribute)rejectTypeAttributes.get(0)).getValue());
        }
        if (CollUtil.isNotEmpty((Collection)(sendMsgTypeAttributes = (List)attributeMap.get("sendMessageType")))) {
            ExtensionAttribute attribute = (ExtensionAttribute)sendMsgTypeAttributes.get(0);
            extraDataJson.put("flowNotifyTypeList", (Object)StrUtil.split((CharSequence)attribute.getValue(), (CharSequence)","));
        }
        if (userTask.getLoopCharacteristics() != null) {
            extraDataJson.put("multiInstance", (Object)true);
            extraDataJson.put("sequenceMultiInstance", (Object)userTask.getLoopCharacteristics().isSequential());
        }
        return extraDataJson;
    }

    private JSONObject buildUserCandidateGroupsExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        JSONObject jsonData = null;
        List<ExtensionElement> elementCandidateGroupsList = extensionMap.get("userCandidateGroups");
        if (CollUtil.isEmpty(elementCandidateGroupsList)) {
            return jsonData;
        }
        jsonData = new JSONObject();
        ExtensionElement ee = elementCandidateGroupsList.get(0);
        jsonData.put(TYPE, (Object)ee.getAttributeValue(null, TYPE));
        jsonData.put(VALUE, (Object)ee.getAttributeValue(null, VALUE));
        return jsonData;
    }

    private JSONObject buildAssigneeListExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        JSONObject jsonData = null;
        List<ExtensionElement> elementAssigneeList = extensionMap.get("assigneeList");
        if (CollUtil.isEmpty(elementAssigneeList)) {
            return jsonData;
        }
        ExtensionElement ee = elementAssigneeList.get(0);
        Map childExtensionMap = ee.getChildElements();
        if (MapUtil.isEmpty((Map)childExtensionMap)) {
            return jsonData;
        }
        List assigneeElements = (List)childExtensionMap.get("assignee");
        if (CollUtil.isEmpty((Collection)assigneeElements)) {
            return jsonData;
        }
        JSONArray assigneeIdArray = new JSONArray();
        for (ExtensionElement e : assigneeElements) {
            assigneeIdArray.add((Object)e.getAttributeValue(null, ID));
        }
        jsonData = new JSONObject();
        String assigneeType = ee.getAttributeValue(null, TYPE);
        jsonData.put("assigneeType", (Object)assigneeType);
        jsonData.put("assigneeList", (Object)assigneeIdArray);
        return jsonData;
    }

    private List<JSONObject> buildDeptPostListExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        List<ExtensionElement> deptPostElements = this.getMyExtensionElementList(extensionMap, "deptPostList", "deptPost");
        if (CollUtil.isEmpty(deptPostElements)) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        for (ExtensionElement e : deptPostElements) {
            String deptPostId;
            JSONObject deptPostJsonData = new JSONObject();
            deptPostJsonData.put(ID, (Object)e.getAttributeValue(null, ID));
            deptPostJsonData.put(TYPE, (Object)e.getAttributeValue(null, TYPE));
            String postId = e.getAttributeValue(null, "postId");
            if (postId != null) {
                deptPostJsonData.put("postId", (Object)postId);
            }
            if ((deptPostId = e.getAttributeValue(null, "deptPostId")) != null) {
                deptPostJsonData.put("deptPostId", (Object)deptPostId);
            }
            resultList.add(deptPostJsonData);
        }
        return resultList;
    }

    private List<JSONObject> buildCopyListExtensionElement(Map<String, List<ExtensionElement>> extensionMap) {
        List<ExtensionElement> copyElements = this.getMyExtensionElementList(extensionMap, "copyItemList", "copyItem");
        if (CollUtil.isEmpty(copyElements)) {
            return Collections.emptyList();
        }
        LinkedList<JSONObject> resultList = new LinkedList<JSONObject>();
        for (ExtensionElement e : copyElements) {
            JSONObject copyJsonData = new JSONObject();
            String type = e.getAttributeValue(null, TYPE);
            copyJsonData.put(TYPE, (Object)type);
            if (!StrUtil.equalsAny((CharSequence)type, (CharSequence[])new CharSequence[]{"deptPostLeader", "upDeptPostLeader", "user", "role", "dept", "deptPost", "allDeptPost", "siblingDeptPost", "selfDeptPost", "upDeptPost"})) {
                throw new MyRuntimeException("Invalid TYPE [" + type + " ] for CopyItenList Extension!");
            }
            String id = e.getAttributeValue(null, ID);
            if (StrUtil.isNotBlank((CharSequence)id)) {
                copyJsonData.put(ID, (Object)id);
            }
            resultList.add(copyJsonData);
        }
        return resultList;
    }

    private List<ExtensionElement> getMyExtensionElementList(Map<String, List<ExtensionElement>> extensionMap, String rootName, String childName) {
        if (extensionMap == null) {
            return Collections.emptyList();
        }
        List<ExtensionElement> elementList = extensionMap.get(rootName);
        if (CollUtil.isEmpty(elementList)) {
            return Collections.emptyList();
        }
        if (StrUtil.isBlank((CharSequence)childName)) {
            return elementList;
        }
        ExtensionElement ee = elementList.get(0);
        Map childExtensionMap = ee.getChildElements();
        if (MapUtil.isEmpty((Map)childExtensionMap)) {
            return Collections.emptyList();
        }
        List childrenElements = (List)childExtensionMap.get(childName);
        if (CollUtil.isEmpty((Collection)childrenElements)) {
            return Collections.emptyList();
        }
        return childrenElements;
    }

    private List<String> getAssigneeList(String executionId, String taskId) {
        FlowMultiInstanceTrans flowMultiInstanceTrans = this.flowMultiInstanceTransService.getByExecutionId(executionId, taskId);
        String multiInstanceExecId = flowMultiInstanceTrans == null ? this.flowApiService.getTaskVariableStringWithSafe(taskId, "taskExecutionId") : flowMultiInstanceTrans.getMultiInstanceExecId();
        flowMultiInstanceTrans = this.flowMultiInstanceTransService.getWithAssigneeListByMultiInstanceExecId(multiInstanceExecId);
        return flowMultiInstanceTrans == null ? null : StrUtil.split((CharSequence)flowMultiInstanceTrans.getAssigneeList(), (CharSequence)",");
    }

    private boolean buildTransferUserList(TaskInfo taskInfo, List<FlowUserInfoVo> resultUserMapList) {
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        List<FlowTaskComment> taskCommentList = this.flowTaskCommentService.getFlowTaskCommentListByExecutionId(taskInfo.getProcessInstanceId(), taskInfo.getId(), taskInfo.getExecutionId());
        if (CollUtil.isEmpty(taskCommentList)) {
            return false;
        }
        FlowTaskComment transferComment = null;
        for (int i = taskCommentList.size() - 1; i >= 0; --i) {
            FlowTaskComment comment = taskCommentList.get(i);
            if (!StrUtil.equalsAny((CharSequence)comment.getApprovalType(), (CharSequence[])new CharSequence[]{"transfer", "intervene"})) continue;
            transferComment = comment;
            break;
        }
        if (transferComment == null || StrUtil.isBlank((CharSequence)transferComment.getDelegateAssignee())) {
            return false;
        }
        HashSet<String> loginNameSet = new HashSet<String>(StrUtil.split((CharSequence)transferComment.getDelegateAssignee(), (CharSequence)","));
        resultUserMapList.addAll(flowIdentityExtHelper.getUserInfoListByUsernameSet(loginNameSet));
        return true;
    }
}

