/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowTaskTimeoutJobMapper;
import com.dic.bid.common.flow.model.FlowTaskComment;
import com.dic.bid.common.flow.model.FlowTaskTimeoutJob;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.object.FlowApiOption;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowMessageService;
import com.dic.bid.common.flow.service.FlowTaskTimeoutJobService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.FlowUserInfoVo;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Date;
import java.util.List;
import org.flowable.task.api.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowTaskTimeoutJobService")
public class FlowTaskTimeoutJobServiceImpl
extends BaseService<FlowTaskTimeoutJob, Long>
implements FlowTaskTimeoutJobService {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskTimeoutJobServiceImpl.class);
    @Autowired
    private FlowTaskTimeoutJobMapper flowTaskTimeoutJobMapper;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowMessageService flowMessageService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowTaskTimeoutJob> mapper() {
        return this.flowTaskTimeoutJobMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNew(FlowTaskTimeoutJob job) {
        Date now = new Date();
        job.setId(this.idGenerator.nextLongId());
        job.setCreateTime(now);
        job.setUpdateTime(now);
        job.setExecTime((Date)DateUtil.offsetHour((Date)now, (int)job.getTimeoutHours()));
        job.setStatus(0);
        this.flowTaskTimeoutJobMapper.insert(job);
    }

    @Override
    public void executeJob(FlowTaskTimeoutJob job, Task task) {
        try {
            if (job.getHandleWay().equals("sendMessage")) {
                FlowWorkOrder workOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(task.getProcessInstanceId());
                if (workOrder != null) {
                    this.flowMessageService.saveNewRemindMessage(workOrder);
                }
            } else {
                FlowTaskComment comment = new FlowTaskComment();
                comment.setProcessInstanceId(task.getProcessInstanceId());
                comment.setExecutionId(task.getExecutionId());
                comment.setTaskKey(task.getTaskDefinitionKey());
                comment.setTaskName(task.getName());
                comment.setTaskId(task.getId());
                comment.setApprovalType("timeout_auto_complete");
                comment.setTaskComment("\u4efb\u52a1\u8d85\u65f6\u81ea\u52a8\u5ba1\u6279");
                comment.setCreateLoginName(job.getDefaultAssignee());
                BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
                List<FlowUserInfoVo> userInfoList = flowIdentityExtHelper.getUserInfoListByUsernameSet(CollUtil.newHashSet((Object[])new String[]{job.getDefaultAssignee()}));
                if (CollUtil.isNotEmpty(userInfoList)) {
                    FlowUserInfoVo userInfo = userInfoList.get(0);
                    comment.setCreateUserId(userInfo.getUserId());
                    comment.setCreateUsername(userInfo.getShowName());
                }
                FlowApiOption option = new FlowApiOption();
                option.setDeleteTimeoutTaskJob(false);
                this.flowApiService.completeTask(task, comment, new JSONObject(), option);
            }
            job.setStatus(1);
        }
        catch (Exception e) {
            log.error("Failed to call FlowTaskTimeoutJobServiceImpl.executeJob", (Throwable)e);
            job.setStatus(2);
            job.setErrorMessage(e.getClass().getName());
        }
        job.setUpdateTime(new Date());
        this.flowTaskTimeoutJobMapper.updateById(job);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByTaskId(String taskId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskTimeoutJob::getStatus, (Object)0);
        queryWrapper.eq(FlowTaskTimeoutJob::getTaskId, (Object)taskId);
        this.flowTaskTimeoutJobMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByProcessInstanceId(String processInstanceId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.ne(FlowTaskTimeoutJob::getStatus, (Object)2);
        queryWrapper.eq(FlowTaskTimeoutJob::getProcessInstanceId, (Object)processInstanceId);
        this.flowTaskTimeoutJobMapper.delete((Wrapper)queryWrapper);
    }

    @Override
    public List<FlowTaskTimeoutJob> getExecutableList() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowTaskTimeoutJob::getStatus, (Object)0);
        queryWrapper.le(FlowTaskTimeoutJob::getExecTime, (Object)new Date());
        return this.flowTaskTimeoutJobMapper.selectList((Wrapper)queryWrapper);
    }
}

