/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowTransProducerMapper;
import com.dic.bid.common.flow.model.FlowTransProducer;
import com.dic.bid.common.flow.service.FlowTransProducerService;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowTransProducerService")
public class FlowTransProducerServiceImpl
extends BaseService<FlowTransProducer, Long>
implements FlowTransProducerService {
    private static final Logger log = LoggerFactory.getLogger(FlowTransProducerServiceImpl.class);
    @Autowired
    private FlowTransProducerMapper flowTransProducerMapper;

    protected BaseDaoMapper<FlowTransProducer> mapper() {
        return this.flowTransProducerMapper;
    }

    @Override
    public List<FlowTransProducer> getListByProcessInstanceIds(Set<String> processInstanceIds) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(FlowTransProducer::getProcessInstanceId, processInstanceIds);
        qw.orderByDesc(FlowTransProducer::getTransId);
        return this.flowTransProducerMapper.selectList((Wrapper)qw);
    }

    @Override
    public FlowTransProducer getByProcessInstanceIdAndTaskId(String processInstanceId, String taskId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(FlowTransProducer::getProcessInstanceId, (Object)processInstanceId);
        qw.eq(FlowTransProducer::getTaskId, (Object)taskId);
        String appCode = TokenData.takeFromRequest().getAppCode();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            qw.isNull(FlowTransProducer::getAppCode);
        } else {
            qw.eq(FlowTransProducer::getAppCode, (Object)appCode);
        }
        return (FlowTransProducer)this.flowTransProducerMapper.selectOne((Wrapper)qw);
    }

    @Override
    public void deleteByProcessInstanceId(String processInstanceId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(FlowTransProducer::getProcessInstanceId, (Object)processInstanceId);
        String appCode = TokenData.takeFromRequest().getAppCode();
        if (StrUtil.isBlank((CharSequence)appCode)) {
            qw.isNull(FlowTransProducer::getAppCode);
        } else {
            qw.eq(FlowTransProducer::getAppCode, (Object)appCode);
        }
        this.flowTransProducerMapper.delete((Wrapper)qw);
    }
}

