/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.flow.dao.FlowVariableLogMapper;
import com.dic.bid.common.flow.model.FlowVariableLog;
import com.dic.bid.common.flow.service.FlowVariableLogService;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowVariableLogService")
public class FlowVariableLogServiceImpl
extends BaseService<FlowVariableLog, Long>
implements FlowVariableLogService {
    private static final Logger log = LoggerFactory.getLogger(FlowVariableLogServiceImpl.class);
    @Autowired
    private FlowVariableLogMapper flowVariableLogMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;

    protected BaseDaoMapper<FlowVariableLog> mapper() {
        return this.flowVariableLogMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveNew(FlowVariableLog o) {
        o.setId(this.idGenerator.nextLongId());
        o.setCreateTime(new Date());
        this.flowVariableLogMapper.insert(o);
    }

    @Override
    public Map<String, String> getVariableMap(String processInstanceId, List<String> taskKeys) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(FlowVariableLog::getProcessInstanceId, (Object)processInstanceId);
        qw.in(FlowVariableLog::getTaskKey, taskKeys);
        qw.orderByDesc(FlowVariableLog::getId);
        List dataList = this.flowVariableLogMapper.selectList((Wrapper)qw);
        return dataList.stream().collect(Collectors.toMap(FlowVariableLog::getTaskKey, FlowVariableLog::getVariableData, (existOne, newOne) -> existOne));
    }
}

