/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dic.bid.common.core.annotation.DisableDataFilter;
import com.dic.bid.common.core.annotation.MyDataSourceResolver;
import com.dic.bid.common.core.base.dao.BaseDaoMapper;
import com.dic.bid.common.core.base.service.BaseService;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.ColumnEncodedRule;
import com.dic.bid.common.core.object.GlobalThreadLocal;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.MyRelationParam;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.DefaultDataSourceResolver;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.dao.FlowWorkOrderExtMapper;
import com.dic.bid.common.flow.dao.FlowWorkOrderMapper;
import com.dic.bid.common.flow.dto.FlowWorkOrderDto;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.model.FlowWorkOrderExt;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.util.FlowOperationHelper;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import com.dic.bid.common.redis.util.CommonRedisUtil;
import com.dic.bid.common.sequence.wrapper.IdGeneratorWrapper;
import com.github.pagehelper.page.PageMethod;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.flowable.engine.runtime.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@MyDataSourceResolver(resolver=DefaultDataSourceResolver.class, intArg=1010)
@Service(value="flowWorkOrderService")
public class FlowWorkOrderServiceImpl
extends BaseService<FlowWorkOrder, Long>
implements FlowWorkOrderService {
    private static final Logger log = LoggerFactory.getLogger(FlowWorkOrderServiceImpl.class);
    @Autowired
    private FlowWorkOrderMapper flowWorkOrderMapper;
    @Autowired
    private FlowWorkOrderExtMapper flowWorkOrderExtMapper;
    @Autowired
    private IdGeneratorWrapper idGenerator;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private CommonRedisUtil commonRedisUtil;
    @Autowired
    private FlowOperationHelper flowOperationHelper;

    protected BaseDaoMapper<FlowWorkOrder> mapper() {
        return this.flowWorkOrderMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder saveNew(ProcessInstance instance, Object dataId, Long onlineTableId, String tableName) {
        FlowWorkOrder flowWorkOrder = this.createWith(instance);
        flowWorkOrder.setWorkOrderCode(this.generateWorkOrderCode(instance.getProcessDefinitionKey()));
        flowWorkOrder.setBusinessKey(dataId.toString());
        flowWorkOrder.setOnlineTableId(onlineTableId);
        flowWorkOrder.setTableName(tableName);
        flowWorkOrder.setFlowStatus(0);
        this.doSafeSave(flowWorkOrder, instance);
        return flowWorkOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FlowWorkOrder saveNewWithDraft(ProcessInstance instance, Long onlineTableId, String tableName, String masterData, String slaveData) {
        FlowWorkOrder flowWorkOrder = this.createWith(instance);
        flowWorkOrder.setWorkOrderCode(this.generateWorkOrderCode(instance.getProcessDefinitionKey()));
        flowWorkOrder.setOnlineTableId(onlineTableId);
        flowWorkOrder.setTableName(tableName);
        flowWorkOrder.setFlowStatus(FlowTaskStatus.DRAFT);
        JSONObject draftData = new JSONObject();
        if (masterData != null) {
            draftData.put("masterData", (Object)masterData);
        }
        if (slaveData != null) {
            draftData.put("slaveData", (Object)slaveData);
        }
        FlowWorkOrderExt flowWorkOrderExt = (FlowWorkOrderExt)BeanUtil.copyProperties((Object)flowWorkOrder, FlowWorkOrderExt.class, (String[])new String[0]);
        flowWorkOrderExt.setId(this.idGenerator.nextLongId());
        flowWorkOrderExt.setDraftData(JSON.toJSONString((Object)draftData));
        this.flowWorkOrderExtMapper.insert(flowWorkOrderExt);
        this.doSafeSave(flowWorkOrder, instance);
        return flowWorkOrder;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateDraft(Long workOrderId, String masterData, String slaveData) {
        JSONObject draftData = new JSONObject();
        if (masterData != null) {
            draftData.put("masterData", (Object)masterData);
        }
        if (slaveData != null) {
            draftData.put("slaveData", (Object)slaveData);
        }
        FlowWorkOrderExt flowWorkOrderExt = new FlowWorkOrderExt();
        flowWorkOrderExt.setDraftData(JSON.toJSONString((Object)draftData));
        flowWorkOrderExt.setUpdateTime(new Date());
        this.flowWorkOrderExtMapper.update(flowWorkOrderExt, (Wrapper)new LambdaQueryWrapper().eq(FlowWorkOrderExt::getWorkOrderId, (Object)workOrderId));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean remove(Long workOrderId) {
        return this.flowWorkOrderMapper.deleteById(workOrderId) == 1;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeByProcessInstanceId(String processInstanceId) {
        FlowWorkOrder filter = new FlowWorkOrder();
        filter.setProcessInstanceId(processInstanceId);
        super.removeBy((Object)filter);
    }

    @Override
    public List<FlowWorkOrder> getFlowWorkOrderList(FlowWorkOrder filter, String orderBy) {
        if (filter == null) {
            filter = new FlowWorkOrder();
        }
        TokenData tokenData = TokenData.takeFromRequest();
        filter.setTenantId(tokenData.getTenantId());
        filter.setAppCode(tokenData.getAppCode());
        return this.flowWorkOrderMapper.getFlowWorkOrderList(filter, orderBy);
    }

    @Override
    public List<FlowWorkOrder> getFlowWorkOrderListWithRelation(FlowWorkOrder filter, String orderBy) {
        List<FlowWorkOrder> resultList = this.getFlowWorkOrderList(filter, orderBy);
        this.buildRelationForDataList(resultList, MyRelationParam.dictOnly());
        return resultList;
    }

    @Override
    public FlowWorkOrder getFlowWorkOrderByProcessInstanceId(String processInstanceId) {
        FlowWorkOrder filter = new FlowWorkOrder();
        filter.setProcessInstanceId(processInstanceId);
        return (FlowWorkOrder)this.flowWorkOrderMapper.selectOne((Wrapper)new QueryWrapper((Object)filter));
    }

    @Override
    public boolean existByBusinessKey(String tableName, Object businessKey, boolean unfinished) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowWorkOrder::getBusinessKey, (Object)businessKey.toString());
        queryWrapper.eq(FlowWorkOrder::getTableName, (Object)tableName);
        if (unfinished) {
            queryWrapper.notIn(FlowWorkOrder::getFlowStatus, new Object[]{3, FlowTaskStatus.CANCELLED, FlowTaskStatus.STOPPED});
        }
        return this.flowWorkOrderMapper.selectCount((Wrapper)queryWrapper) > 0L;
    }

    @Override
    public boolean existUnfinished(String processDefinitionKey, Object businessKey) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowWorkOrder::getBusinessKey, (Object)businessKey.toString());
        queryWrapper.eq(FlowWorkOrder::getProcessDefinitionKey, (Object)processDefinitionKey);
        queryWrapper.notIn(FlowWorkOrder::getFlowStatus, new Object[]{3, FlowTaskStatus.CANCELLED, FlowTaskStatus.STOPPED});
        return this.flowWorkOrderMapper.selectCount((Wrapper)queryWrapper) > 0L;
    }

    @Override
    @DisableDataFilter
    @Transactional(rollbackFor={Exception.class})
    public void updateFlowStatusByProcessInstanceId(String processInstanceId, Integer flowStatus) {
        if (flowStatus == null) {
            return;
        }
        FlowWorkOrder flowWorkOrder = new FlowWorkOrder();
        flowWorkOrder.setFlowStatus(flowStatus);
        if (3 != flowStatus) {
            flowWorkOrder.setUpdateTime(new Date());
            flowWorkOrder.setUpdateUserId(TokenData.takeFromRequest().getUserId());
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(FlowWorkOrder::getProcessInstanceId, (Object)processInstanceId);
        this.flowWorkOrderMapper.update(flowWorkOrder, (Wrapper)queryWrapper);
    }

    @Override
    @DisableDataFilter
    @Transactional(rollbackFor={Exception.class})
    public void updateLatestApprovalStatusByProcessInstanceId(String processInstanceId, Integer approvalStatus) {
        if (approvalStatus == null) {
            return;
        }
        FlowWorkOrder flowWorkOrder = this.getFlowWorkOrderByProcessInstanceId(processInstanceId);
        flowWorkOrder.setLatestApprovalStatus(approvalStatus);
        flowWorkOrder.setUpdateTime(new Date());
        flowWorkOrder.setUpdateUserId(TokenData.takeFromRequest().getUserId());
        this.flowWorkOrderMapper.updateById(flowWorkOrder);
        if (flowWorkOrder.getOnlineTableId() != null) {
            this.flowCustomExtFactory.getOnlineBusinessDataExtHelper().updateFlowStatus(flowWorkOrder);
        } else {
            this.flowCustomExtFactory.getBusinessDataExtHelper().updateFlowStatus(flowWorkOrder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasDataPermOnFlowWorkOrder(String processInstanceId) {
        long count;
        boolean originalFlag = GlobalThreadLocal.setDataFilter((boolean)true);
        try {
            FlowWorkOrder filter = new FlowWorkOrder();
            filter.setProcessInstanceId(processInstanceId);
            count = this.flowWorkOrderMapper.selectCount((Wrapper)new QueryWrapper((Object)filter));
        }
        finally {
            GlobalThreadLocal.setDataFilter((boolean)originalFlag);
        }
        return count > 0L;
    }

    @Override
    public void fillUserShowNameByLoginName(List<FlowWorkOrderVo> dataList) {
        BaseFlowIdentityExtHelper identityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        Set<String> loginNameSet = dataList.stream().map(FlowWorkOrderVo::getSubmitUsername).collect(Collectors.toSet());
        if (CollUtil.isEmpty(loginNameSet)) {
            return;
        }
        Map<String, String> userNameMap = identityExtHelper.mapUserShowNameByLoginName(loginNameSet);
        dataList.forEach(workOrder -> {
            if (StrUtil.isNotBlank((CharSequence)workOrder.getSubmitUsername())) {
                workOrder.setUserShowName((String)userNameMap.get(workOrder.getSubmitUsername()));
            }
        });
    }

    @Override
    public FlowWorkOrderExt getFlowWorkOrderExtByWorkOrderId(Long workOrderId) {
        return (FlowWorkOrderExt)this.flowWorkOrderExtMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(FlowWorkOrderExt::getWorkOrderId, (Object)workOrderId));
    }

    @Override
    public List<FlowWorkOrderExt> getFlowWorkOrderExtByWorkOrderIds(Set<Long> workOrderIds) {
        return this.flowWorkOrderExtMapper.selectList((Wrapper)new LambdaQueryWrapper().in(FlowWorkOrderExt::getWorkOrderId, workOrderIds));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CallResult removeDraft(FlowWorkOrder flowWorkOrder) {
        CallResult r = this.flowApiService.stopProcessInstance(flowWorkOrder.getProcessInstanceId(), "\u64a4\u9500\u8349\u7a3f", true);
        if (!r.isSuccess()) {
            return r;
        }
        this.flowWorkOrderMapper.deleteById(flowWorkOrder.getWorkOrderId());
        return CallResult.ok();
    }

    @Override
    public MyPageData<FlowWorkOrderVo> getPagedWorkOrderListAndBuildData(FlowWorkOrderDto flowWorkOrderDtoFilter, MyPageParam pageParam, MyOrderParam orderParam, String processDefinitionKey) {
        PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize(), (boolean)pageParam.getCount());
        String orderBy = MyOrderParam.buildOrderBy((MyOrderParam)orderParam, FlowWorkOrder.class);
        FlowWorkOrder filter = this.flowOperationHelper.makeWorkOrderFilter(flowWorkOrderDtoFilter, processDefinitionKey);
        List<FlowWorkOrder> flowWorkOrderList = this.getFlowWorkOrderList(filter, orderBy);
        MyPageData resultData = MyPageUtil.makeResponseData(flowWorkOrderList, FlowWorkOrderVo.class);
        if (CollUtil.isEmpty((Collection)resultData.getDataList())) {
            return resultData;
        }
        this.flowOperationHelper.buildWorkOrderApprovalStatus(processDefinitionKey, resultData.getDataList());
        this.fillUserShowNameByLoginName(resultData.getDataList());
        this.flowOperationHelper.buildWorkOrderTaskInfo(resultData.getDataList());
        return resultData;
    }

    private FlowWorkOrder createWith(ProcessInstance instance) {
        TokenData tokenData = TokenData.takeFromRequest();
        Date now = new Date();
        FlowWorkOrder flowWorkOrder = new FlowWorkOrder();
        flowWorkOrder.setWorkOrderId(this.idGenerator.nextLongId());
        flowWorkOrder.setProcessDefinitionKey(instance.getProcessDefinitionKey());
        flowWorkOrder.setProcessDefinitionName(instance.getProcessDefinitionName());
        flowWorkOrder.setProcessDefinitionId(instance.getProcessDefinitionId());
        flowWorkOrder.setProcessInstanceId(instance.getId());
        flowWorkOrder.setSubmitUsername(tokenData.getLoginName());
        flowWorkOrder.setDeptId(tokenData.getDeptId());
        flowWorkOrder.setAppCode(tokenData.getAppCode());
        flowWorkOrder.setTenantId(tokenData.getTenantId());
        flowWorkOrder.setCreateUserId(tokenData.getUserId());
        flowWorkOrder.setUpdateUserId(tokenData.getUserId());
        flowWorkOrder.setCreateTime(now);
        flowWorkOrder.setUpdateTime(now);
        flowWorkOrder.setDeletedFlag(1);
        return flowWorkOrder;
    }

    private String generateWorkOrderCode(String processDefinitionKey) {
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(processDefinitionKey);
        if (StrUtil.isBlank((CharSequence)flowEntry.getEncodedRule())) {
            return null;
        }
        ColumnEncodedRule rule = (ColumnEncodedRule)JSON.parseObject((String)flowEntry.getEncodedRule(), ColumnEncodedRule.class);
        if (rule.getIdWidth() == null) {
            rule.setIdWidth(Integer.valueOf(10));
        }
        return this.commonRedisUtil.generateTransId(rule.getPrefix(), rule.getPrecisionTo(), rule.getMiddle(), rule.getIdWidth().intValue());
    }

    private void recalculateWorkOrderCode(String processDefinitionKey) {
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(processDefinitionKey);
        if (StrUtil.isBlank((CharSequence)flowEntry.getEncodedRule())) {
            return;
        }
        ColumnEncodedRule rule = (ColumnEncodedRule)JSON.parseObject((String)flowEntry.getEncodedRule(), ColumnEncodedRule.class);
        if (rule.getIdWidth() == null) {
            rule.setIdWidth(Integer.valueOf(10));
        }
        String prefix = this.commonRedisUtil.calculateTransIdPrefix(rule.getPrefix(), rule.getPrecisionTo(), rule.getMiddle());
        String maxWorkOrderCode = this.flowWorkOrderMapper.getMaxWorkOrderCodeByPrefix(prefix + "%");
        String maxValue = StrUtil.removePrefix((CharSequence)maxWorkOrderCode, (CharSequence)prefix);
        this.commonRedisUtil.initTransId(prefix, Long.valueOf(maxValue));
    }

    private void doSafeSave(FlowWorkOrder flowWorkOrder, ProcessInstance instance) {
        try {
            this.flowWorkOrderMapper.insert(flowWorkOrder);
        }
        catch (DuplicateKeyException e) {
            if (this.flowWorkOrderMapper.getCountByWorkOrderCode(flowWorkOrder.getWorkOrderCode()) == 0) {
                throw e;
            }
            log.info("WorkOrderCode [{}] exists and recalculate.", (Object)flowWorkOrder.getWorkOrderCode());
            this.recalculateWorkOrderCode(instance.getProcessDefinitionKey());
            flowWorkOrder.setWorkOrderCode(this.generateWorkOrderCode(instance.getProcessDefinitionKey()));
            this.flowWorkOrderMapper.insert(flowWorkOrder);
        }
    }
}

