/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.timer;

import cn.hutool.core.collection.CollUtil;
import com.dic.bid.common.flow.model.FlowTaskTimeoutJob;
import com.dic.bid.common.flow.service.FlowTaskTimeoutJobService;
import java.util.List;
import javax.annotation.PostConstruct;
import org.flowable.engine.TaskService;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@EnableScheduling
@Component
public class FlowTaskTimeoutTimer {
    private static final Logger log = LoggerFactory.getLogger(FlowTaskTimeoutTimer.class);
    @Autowired
    private FlowTaskTimeoutJobService flowTaskTimeoutJobService;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private TaskService taskService;
    private RLock distLock;

    @PostConstruct
    public void init() {
        this.distLock = this.redissonClient.getLock("FLOW_TASK_TIMEOUT_TIMEER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Scheduled(cron="0 0/5 * * * ?")
    public void execute() {
        if (!this.distLock.tryLock()) {
            return;
        }
        try {
            List<FlowTaskTimeoutJob> jobList = this.flowTaskTimeoutJobService.getExecutableList();
            if (CollUtil.isEmpty(jobList)) {
                return;
            }
            for (FlowTaskTimeoutJob job : jobList) {
                TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().active().taskId(job.getTaskId());
                Task task = (Task)query.singleResult();
                if (task == null) continue;
                this.flowTaskTimeoutJobService.executeJob(job, task);
            }
        }
        catch (Exception e) {
            log.error("Failed to call FlowTaskTimeoutTimer.execute", (Throwable)e);
        }
        finally {
            this.distLock.unlock();
        }
    }
}

