/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.util;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.flow.base.service.BaseFlowService;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseBusinessDataExtHelper {
    private static final Logger log = LoggerFactory.getLogger(BaseBusinessDataExtHelper.class);
    private final Map<String, BaseFlowService<?, ?>> serviceMap = MapUtil.newHashMap();

    public synchronized void doRegister(String processDefinitionKey, BaseFlowService<?, ?> service) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)processDefinitionKey));
        Assert.notNull(service);
        this.serviceMap.put(processDefinitionKey, service);
    }

    public void triggerSync(FlowWorkOrder workOrder) {
        BaseFlowService<?, ?> service = this.serviceMap.get(workOrder.getProcessDefinitionKey());
        if (service != null) {
            try {
                service.syncBusinessData(workOrder);
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to call syncBusinessData with processDefinitionKey {%s}, businessKey {%s}", workOrder.getProcessDefinitionKey(), workOrder.getBusinessKey());
                log.error(errorMessage, (Throwable)e);
                throw e;
            }
        }
    }

    public void updateFlowStatus(FlowWorkOrder workOrder) {
        BaseFlowService<?, ?> service = this.serviceMap.get(workOrder.getProcessDefinitionKey());
        if (service != null && workOrder.getBusinessKey() != null) {
            try {
                service.updateFlowStatus(workOrder);
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to call updateFlowStatus with processDefinitionKey {%s}, businessKey {%s}", workOrder.getProcessDefinitionKey(), workOrder.getBusinessKey());
                log.error(errorMessage, (Throwable)e);
                throw e;
            }
        }
    }

    public void deleteBusinessData(FlowWorkOrder workOrder) {
        BaseFlowService<?, ?> service = this.serviceMap.get(workOrder.getProcessDefinitionKey());
        if (service != null) {
            try {
                service.removeByWorkOrder(workOrder);
            }
            catch (Exception e) {
                String errorMessage = String.format("Failed to call deleteBusinessData with processDefinitionKey {%s}, businessKey {%s}", workOrder.getProcessDefinitionKey(), workOrder.getBusinessKey());
                log.error(errorMessage, (Throwable)e);
                throw e;
            }
        }
    }

    public String getBusinessData(String processDefinitionKey, String processInstanceId, String businessKey) {
        BaseFlowService<?, ?> service = this.serviceMap.get(processDefinitionKey);
        return service == null ? null : service.getBusinessData(processInstanceId, businessKey);
    }

    public String getNormalizedDraftData(String processDefinitionKey, String processInstanceId, JSONObject masterData, JSONObject slaveData) {
        BaseFlowService<?, ?> service = this.serviceMap.get(processDefinitionKey);
        return service == null ? null : service.getNormalizedDraftData(processInstanceId, masterData, slaveData);
    }
}

