/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.flow.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.constant.ErrorCodeEnum;
import com.dic.bid.common.core.object.CallResult;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.object.TokenData;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.flow.constant.FlowTaskStatus;
import com.dic.bid.common.flow.dto.FlowTaskCommentDto;
import com.dic.bid.common.flow.dto.FlowWorkOrderDto;
import com.dic.bid.common.flow.model.FlowEntry;
import com.dic.bid.common.flow.model.FlowEntryPublish;
import com.dic.bid.common.flow.model.FlowWorkOrder;
import com.dic.bid.common.flow.object.FlowEntryExtensionData;
import com.dic.bid.common.flow.object.FlowRuntimeObject;
import com.dic.bid.common.flow.service.FlowApiService;
import com.dic.bid.common.flow.service.FlowEntryService;
import com.dic.bid.common.flow.service.FlowWorkOrderService;
import com.dic.bid.common.flow.util.BaseFlowIdentityExtHelper;
import com.dic.bid.common.flow.util.FlowCustomExtFactory;
import com.dic.bid.common.flow.vo.FlowWorkOrderVo;
import com.dic.bid.common.flow.vo.TaskInfoVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskInfo;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FlowOperationHelper {
    private static final Logger log = LoggerFactory.getLogger(FlowOperationHelper.class);
    @Autowired
    private FlowEntryService flowEntryService;
    @Autowired
    private FlowApiService flowApiService;
    @Autowired
    private FlowWorkOrderService flowWorkOrderService;
    @Autowired
    private FlowCustomExtFactory flowCustomExtFactory;

    public ResponseResult<FlowEntry> verifyAndGetFlowEntry(String processDefinitionKey) {
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(processDefinitionKey);
        if (flowEntry == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (!flowEntry.getStatus().equals(1)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u6d41\u7a0b\u5c1a\u672a\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowEntryPublish flowEntryPublish = this.flowEntryService.getFlowEntryPublishFromCache(flowEntry.getMainEntryPublishId());
        flowEntry.setMainFlowEntryPublish(flowEntryPublish);
        return ResponseResult.success((Object)flowEntry);
    }

    public ResponseResult<FlowEntryPublish> verifyAndGetFlowEntryPublish(String processDefinitionKey) {
        ResponseResult<FlowEntry> flowEntryResult = this.verifyAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        FlowEntryPublish flowEntryPublish = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish();
        ResponseResult<TaskInfoVo> taskInfoResult = this.verifyAndGetInitialTaskInfo(flowEntryPublish, false);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        return ResponseResult.success((Object)flowEntryPublish);
    }

    public ResponseResult<FlowEntry> verifyFullAndGetFlowEntry(String processDefinitionKey) {
        ResponseResult<FlowEntry> flowEntryResult = this.verifyAndGetFlowEntry(processDefinitionKey);
        if (!flowEntryResult.isSuccess()) {
            return ResponseResult.errorFrom(flowEntryResult);
        }
        FlowEntryPublish flowEntryPublish = ((FlowEntry)flowEntryResult.getData()).getMainFlowEntryPublish();
        if (BooleanUtil.isFalse((Boolean)flowEntryPublish.getActiveStatus())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u5bf9\u8c61\u5df2\u88ab\u6302\u8d77\uff0c\u4e0d\u80fd\u542f\u52a8\u65b0\u6d41\u7a0b\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        ResponseResult<TaskInfoVo> taskInfoResult = this.verifyAndGetInitialTaskInfo(flowEntryPublish, true);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        return flowEntryResult;
    }

    public ResponseResult<Task> verifySubmitAndGetTask(String processInstanceId, String taskId, FlowTaskCommentDto flowTaskComment) {
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        ResponseResult<TaskInfoVo> taskInfoResult = this.verifyAndGetRuntimeTaskInfo(task);
        if (!taskInfoResult.isSuccess()) {
            return ResponseResult.errorFrom(taskInfoResult);
        }
        CallResult assigneeVerifyResult = this.flowApiService.verifyAssigneeOrCandidateAndClaim(task);
        if (!assigneeVerifyResult.isSuccess()) {
            return ResponseResult.errorFrom((CallResult)assigneeVerifyResult);
        }
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        if (StrUtil.isBlank((CharSequence)instance.getBusinessKey())) {
            return ResponseResult.success((Object)task);
        }
        if (flowTaskComment != null && StrUtil.equals((CharSequence)flowTaskComment.getApprovalType(), (CharSequence)"transfer") && StrUtil.isBlank((CharSequence)flowTaskComment.getDelegateAssignee())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u52a0\u7b7e\u6216\u8f6c\u529e\u4efb\u52a1\u6307\u6d3e\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)task);
    }

    public ResponseResult<FlowRuntimeObject> verifySubmitWithGetInstanceAndTask(String processInstanceId, String taskId, FlowTaskCommentDto flowTaskComment, String processDefinitionKey) {
        ResponseResult<Task> taskResult = this.verifySubmitAndGetTask(processInstanceId, taskId, flowTaskComment);
        if (!taskResult.isSuccess()) {
            return ResponseResult.errorFrom(taskResult);
        }
        ProcessInstance instance = this.flowApiService.getProcessInstance(processInstanceId);
        if (!StrUtil.equals((CharSequence)instance.getProcessDefinitionKey(), (CharSequence)processDefinitionKey)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u6d41\u7a0b\u6807\u8bc6\u4e0e\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9!";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        FlowRuntimeObject o = new FlowRuntimeObject();
        o.setTask((Task)taskResult.getData());
        o.setInstance(instance);
        return ResponseResult.success((Object)o);
    }

    public ResponseResult<HistoricProcessInstance> verifyAndGetHistoricProcessInstance(String processInstanceId, String taskId) {
        HistoricProcessInstance instance = this.flowApiService.getHistoricProcessInstance(processInstanceId);
        if (instance == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u7684\u6d41\u7a0b\u5b9e\u4f8bId\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        String loginName = TokenData.takeFromRequest().getLoginName();
        if (StrUtil.isBlank((CharSequence)taskId)) {
            if (!StrUtil.equals((CharSequence)loginName, (CharSequence)instance.getStartUserId()) && !this.flowWorkOrderService.hasDataPermOnFlowWorkOrder(processInstanceId)) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u5386\u53f2\u6d41\u7a0b\u7684\u53d1\u8d77\u4eba\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d\uff0c\u6216\u8005\u6ca1\u6709\u67e5\u770b\u8be5\u5de5\u5355\u8be6\u60c5\u7684\u6570\u636e\u6743\u9650\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        } else {
            HistoricTaskInstance taskInstance = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId);
            if (taskInstance == null) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u7684\u4efb\u52a1Id\u5e76\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
            if (!StrUtil.equals((CharSequence)loginName, (CharSequence)taskInstance.getAssignee()) && !this.flowWorkOrderService.hasDataPermOnFlowWorkOrder(processInstanceId)) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5386\u53f2\u4efb\u52a1\u7684\u6307\u6d3e\u4eba\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u5339\u914d\uff0c\u6216\u8005\u6ca1\u6709\u67e5\u770b\u8be5\u5de5\u5355\u8be6\u60c5\u7684\u6570\u636e\u6743\u9650\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        }
        return ResponseResult.success((Object)instance);
    }

    public ResponseResult<HistoricProcessInstance> verifyAndGetHistoricProcessInstance(String processInstanceId, String taskId, String processDefinitionKey) {
        ResponseResult<HistoricProcessInstance> instanceResult = this.verifyAndGetHistoricProcessInstance(processInstanceId, taskId);
        if (!instanceResult.isSuccess()) {
            return ResponseResult.errorFrom(instanceResult);
        }
        HistoricProcessInstance instance = (HistoricProcessInstance)instanceResult.getData();
        if (!StrUtil.equals((CharSequence)instance.getProcessDefinitionKey(), (CharSequence)processDefinitionKey)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u6c42\u6d41\u7a0b\u6807\u8bc6\u4e0e\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5339\u914d\uff0c\u8bf7\u6838\u5bf9\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)instance);
    }

    public ResponseResult<TaskInfoVo> verifyAndGetRuntimeTaskInfo(Task task) {
        if (task == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u7684\u4efb\u52a1Id\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!this.flowApiService.isAssigneeOrCandidate((TaskInfo)task)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u4e0d\u662f\u6307\u6d3e\u4eba\u4e5f\u4e0d\u662f\u5019\u9009\u4eba\u4e4b\u4e00\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (StrUtil.isBlank((CharSequence)task.getFormKey())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u4efb\u52a1\u7684formKey\u5c5e\u6027\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u6d41\u7a0b\u56fe\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)JSON.parseObject((String)task.getFormKey(), TaskInfoVo.class);
        taskInfo.setTaskKey(task.getTaskDefinitionKey());
        return ResponseResult.success((Object)taskInfo);
    }

    public ResponseResult<TaskInfoVo> verifyAndGetInitialTaskInfo(FlowEntryPublish flowEntryPublish, boolean checkStarter) {
        if (StrUtil.isBlank((CharSequence)flowEntryPublish.getInitTaskInfo())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u53d1\u5e03\u7684\u6570\u636e\u4e2d\uff0c\u6ca1\u6709\u5305\u542b\u521d\u59cb\u4efb\u52a1\u4fe1\u606f\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        TaskInfoVo taskInfo = (TaskInfoVo)JSON.parseObject((String)flowEntryPublish.getInitTaskInfo(), TaskInfoVo.class);
        if (checkStarter) {
            String loginName = TokenData.takeFromRequest().getLoginName();
            if (!StrUtil.equalsAny((CharSequence)taskInfo.getAssignee(), (CharSequence[])new CharSequence[]{loginName, "${startUserName}"})) {
                String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8be5\u5de5\u4f5c\u6d41\u7b2c\u4e00\u4e2a\u7528\u6237\u4efb\u52a1\u7684\u6307\u6d3e\u4eba\u5e76\u975e\u5f53\u524d\u7528\u6237\uff0c\u4e0d\u80fd\u6267\u884c\u8be5\u64cd\u4f5c\uff01";
                return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
            }
        }
        return ResponseResult.success((Object)taskInfo);
    }

    public ResponseResult<Void> verifyUploadOrDownloadPermission(String processInstanceId, String taskId) {
        if (this.flowApiService.isProcessInstanceStarter(processInstanceId)) {
            return ResponseResult.success();
        }
        if (StrUtil.isBlank((CharSequence)taskId)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\u4e0b\u8f7d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        Task task = this.flowApiService.getProcessInstanceActiveTask(processInstanceId, taskId);
        if (task == null && (task = this.flowApiService.getHistoricTaskInstance(processInstanceId, taskId)) == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6307\u5b9a\u4efb\u52a1Id\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        if (!this.flowApiService.isAssigneeOrCandidate((TaskInfo)task)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u7528\u6237\u5e76\u975e\u6307\u6d3e\u4eba\u6216\u5019\u9009\u4eba\uff0c\u56e0\u6b64\u6ca1\u6709\u6743\u9650\u4e0b\u8f7d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_NOT_EXIST, (String)errorMessage);
        }
        return ResponseResult.success();
    }

    public FlowWorkOrder makeWorkOrderFilter(FlowWorkOrderDto filterDto, String processDefinitionKey) {
        FlowWorkOrder filter = (FlowWorkOrder)MyModelUtil.copyTo((Object)filterDto, FlowWorkOrder.class);
        if (filter == null) {
            filter = new FlowWorkOrder();
        }
        filter.setProcessDefinitionKey(processDefinitionKey);
        BaseFlowIdentityExtHelper flowIdentityExtHelper = this.flowCustomExtFactory.getFlowIdentityExtHelper();
        if (BooleanUtil.isFalse((Boolean)flowIdentityExtHelper.supprtDataPerm())) {
            filter.setCreateUserId(TokenData.takeFromRequest().getUserId());
        }
        return filter;
    }

    public void buildWorkOrderTaskInfo(List<FlowWorkOrderVo> flowWorkOrderVoList) {
        if (CollUtil.isEmpty(flowWorkOrderVoList)) {
            return;
        }
        Set<String> definitionIdSet = flowWorkOrderVoList.stream().map(FlowWorkOrderVo::getProcessDefinitionId).collect(Collectors.toSet());
        List<FlowEntryPublish> flowEntryPublishList = this.flowEntryService.getFlowEntryPublishList(definitionIdSet);
        Map<String, FlowEntryPublish> flowEntryPublishMap = flowEntryPublishList.stream().collect(Collectors.toMap(FlowEntryPublish::getProcessDefinitionId, c -> c));
        for (FlowWorkOrderVo flowWorkOrderVo : flowWorkOrderVoList) {
            FlowEntryPublish flowEntryPublish = flowEntryPublishMap.get(flowWorkOrderVo.getProcessDefinitionId());
            flowWorkOrderVo.setInitTaskInfo(flowEntryPublish.getInitTaskInfo());
        }
        List<String> unfinishedProcessInstanceIds = flowWorkOrderVoList.stream().filter(c -> !c.getFlowStatus().equals(3)).map(FlowWorkOrderVo::getProcessInstanceId).collect(Collectors.toList());
        if (CollUtil.isEmpty(unfinishedProcessInstanceIds)) {
            return;
        }
        List<Task> taskList = this.flowApiService.getTaskListByProcessInstanceIds(unfinishedProcessInstanceIds);
        Map<String, List<Task>> taskMap = taskList.stream().collect(Collectors.groupingBy(TaskInfo::getProcessInstanceId));
        for (FlowWorkOrderVo flowWorkOrderVo : flowWorkOrderVoList) {
            List<Task> instanceTaskList = taskMap.get(flowWorkOrderVo.getProcessInstanceId());
            if (instanceTaskList == null) continue;
            JSONArray taskArray = new JSONArray();
            for (Task task : instanceTaskList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskName", (Object)task.getName());
                jsonObject.put("taskKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("assignee", (Object)task.getAssignee());
                taskArray.add((Object)jsonObject);
            }
            flowWorkOrderVo.setRuntimeTaskInfoList(taskArray);
        }
    }

    public <T, K> void buildWorkOrderBusinessData(List<FlowWorkOrderVo> workOrderVoList, List<T> dataList, Function<T, K> idGetter) {
        if (CollUtil.isEmpty(dataList)) {
            return;
        }
        Map<K, Object> dataMap = dataList.stream().collect(Collectors.toMap(idGetter, c -> c));
        K id = idGetter.apply(dataList.get(0));
        for (FlowWorkOrderVo flowWorkOrderVo : workOrderVoList) {
            Object data;
            if (StrUtil.isBlank((CharSequence)flowWorkOrderVo.getBusinessKey())) continue;
            Object dataId = flowWorkOrderVo.getBusinessKey();
            if (id instanceof Long) {
                dataId = Long.valueOf(flowWorkOrderVo.getBusinessKey());
            } else if (id instanceof Integer) {
                dataId = Integer.valueOf(flowWorkOrderVo.getBusinessKey());
            }
            if ((data = dataMap.get(dataId)) == null) continue;
            flowWorkOrderVo.setMasterData(BeanUtil.beanToMap((Object)data, (String[])new String[0]));
        }
    }

    public ResponseResult<FlowWorkOrder> verifyAndGetFlowWorkOrderWithDraft(String processDefinitionKey, String processInstanceId) {
        FlowWorkOrder flowWorkOrder = this.flowWorkOrderService.getFlowWorkOrderByProcessInstanceId(processInstanceId);
        if (flowWorkOrder == null) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u5173\u8054\u7684\u5de5\u5355\u4e0d\u5b58\u5728\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!flowWorkOrder.getFlowStatus().equals(FlowTaskStatus.DRAFT)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u5f53\u524d\u6d41\u7a0b\u5de5\u5355\u5e76\u4e0d\u5904\u4e8e\u8349\u7a3f\u4fdd\u5b58\u72b6\u6001\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (!flowWorkOrder.getCreateUserId().equals(TokenData.takeFromRequest().getUserId())) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u8349\u7a3f\u6570\u636e\u4fdd\u5b58\u7528\u6237\u4e0e\u5f53\u524d\u7528\u6237\u4e0d\u4e00\u81f4\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        if (processDefinitionKey != null && !flowWorkOrder.getProcessDefinitionKey().equals(processDefinitionKey)) {
            String errorMessage = "\u6570\u636e\u9a8c\u8bc1\u5931\u8d25\uff0c\u6d41\u7a0b\u5b9e\u4f8b\u548c\u6d41\u7a0b\u5b9a\u4e49\u6807\u8bc6\u4e0d\u5339\u914d\uff01";
            return ResponseResult.error((ErrorCodeEnum)ErrorCodeEnum.DATA_VALIDATED_FAILED, (String)errorMessage);
        }
        return ResponseResult.success((Object)flowWorkOrder);
    }

    public void buildWorkOrderApprovalStatus(String processDefinitionKey, List<FlowWorkOrderVo> workOrderVoList) {
        FlowEntry flowEntry = this.flowEntryService.getFlowEntryFromCache(processDefinitionKey);
        if (StrUtil.isBlank((CharSequence)flowEntry.getExtensionData())) {
            return;
        }
        FlowEntryExtensionData extensionData = (FlowEntryExtensionData)JSON.parseObject((String)flowEntry.getExtensionData(), FlowEntryExtensionData.class);
        if (CollUtil.isEmpty(extensionData.getApprovalStatusDict())) {
            return;
        }
        HashMap<Integer, String> dictMap = new HashMap<Integer, String>(extensionData.getApprovalStatusDict().size());
        for (Map<String, String> m : extensionData.getApprovalStatusDict()) {
            dictMap.put(Integer.valueOf(m.get("id")), m.get("name"));
        }
        for (FlowWorkOrderVo workOrderVo : workOrderVoList) {
            String name;
            if (workOrderVo.getLatestApprovalStatus() == null || (name = (String)dictMap.get(workOrderVo.getLatestApprovalStatus())) == null) continue;
            HashMap lastestApprovalStatusDictMap = MapUtil.newHashMap();
            lastestApprovalStatusDictMap.put("id", workOrderVo.getLatestApprovalStatus());
            lastestApprovalStatusDictMap.put("name", name);
            workOrderVo.setLatestApprovalStatusDictMap(lastestApprovalStatusDictMap);
        }
    }
}

