/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.sequence.generator;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.RandomUtil;
import com.dic.bid.common.core.util.IpUtil;
import com.dic.bid.common.sequence.generator.MyIdGenerator;
import com.dic.bid.common.sequence.generator.SnowflakeZookeeperHolder;
import com.google.common.base.Preconditions;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeIdGenerator
implements MyIdGenerator {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeIdGenerator.class);
    private static final long TWEPOCH = 1288834974657L;
    private static final long WORKER_ID_BITS = 10L;
    private static final long MAX_WORKER_ID = 1023L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private static final Random RANDOM = RandomUtil.getRandom();

    public SnowflakeIdGenerator(String zkAddress, int idPort, String zkPath) {
        Preconditions.checkArgument((this.timeGen() > 1288834974657L ? 1 : 0) != 0, (Object)"Snowflake not support twepoch greater than currentTime");
        String ip = IpUtil.getFirstLocalIpAddress();
        SnowflakeZookeeperHolder holder = new SnowflakeZookeeperHolder(ip, String.valueOf(idPort), zkAddress, zkPath);
        log.info("twepoch:{} ,ip:{} ,zkAddress:{} port:{}", new Object[]{1288834974657L, ip, zkAddress, idPort});
        boolean initFlag = holder.init();
        Preconditions.checkArgument((boolean)initFlag, (Object)"Snowflake Id Gen is not init ok");
        this.workerId = holder.getWorkerId();
        log.info("START SUCCESS USE ZK WORKERID-{}", (Object)this.workerId);
        Preconditions.checkArgument((this.workerId >= 0L && this.workerId <= 1023L ? 1 : 0) != 0, (Object)"WorkerId must (>= 0 and <=> 1023");
    }

    @Override
    public synchronized String nextStringId() {
        return String.valueOf(this.nextLongId());
    }

    @Override
    public synchronized long nextLongId() {
        long timestamp = this.timeGen();
        int maxGap = 10;
        if (timestamp < this.lastTimestamp) {
            long offset = this.lastTimestamp - timestamp;
            if (offset <= (long)maxGap) {
                if (!ThreadUtil.sleep((long)(offset << 1))) {
                    log.error("Thread is interrupted while synchronizing to LastTimeStamp.");
                    throw new SnowflakeGenerateException("Thread is interrupted while synchronizing to LastTimeStamp..");
                }
                timestamp = this.timeGen();
                if (timestamp < this.lastTimestamp) {
                    log.error("CurrentTime is less than LastTimeStamp too much (> 10ms) after synchronized.");
                    throw new SnowflakeGenerateException("CurrentTime is less than LastTimeStamp too much (> 10ms) after synchronized.");
                }
            } else {
                log.error("CurrentTime is less than LastTimeStamp too much (> 10ms).");
                throw new SnowflakeGenerateException("CurrentTime is less than LastTimeStamp too much (> 10ms).");
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                this.sequence = RANDOM.nextInt(100);
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = RANDOM.nextInt(100);
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1288834974657L << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return System.currentTimeMillis();
    }

    public static class SnowflakeGenerateException
    extends RuntimeException {
        public SnowflakeGenerateException(String msg, Throwable e) {
            super(msg, e);
        }

        public SnowflakeGenerateException(String msg) {
            super(msg);
        }
    }
}

