/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.sequence.generator;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.retry.RetryUntilElapsed;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnowflakeZookeeperHolder {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeZookeeperHolder.class);
    private static final int CONNECTION_TIMEOUT_MS = 100000;
    private static final int SESSION_TIMEOUT_MS = 60000;
    private String zkAddressNode = null;
    private String listenAddress;
    private int workerId;
    private String ip;
    private String port;
    private String connectionString;
    private String pathForever;
    private final String cachePath;
    private long lastUpdateTime;

    public SnowflakeZookeeperHolder(String ip, String port, String connectionString, String zkPath) {
        this.ip = ip;
        this.port = port;
        this.listenAddress = ip + ":" + port;
        this.connectionString = connectionString;
        this.pathForever = "/snowflake/" + zkPath + "/forever";
        this.cachePath = System.getProperty("java.io.tmpdir") + File.separator + zkPath + "/leafconf/{port}/workerID.properties";
    }

    public boolean init() {
        try {
            String[] nodeKey;
            CuratorFramework curator = this.createWithOptions(this.connectionString, (RetryPolicy)new RetryUntilElapsed(1000, 4));
            curator.start();
            Stat stat = (Stat)curator.checkExists().forPath(this.pathForever);
            if (stat == null) {
                this.zkAddressNode = this.createNode(curator);
                this.updateLocalWorkerId(this.workerId);
                this.scheduledUploadData(curator, this.zkAddressNode);
                return true;
            }
            HashMap nodeMap = Maps.newHashMap();
            HashMap realNode = Maps.newHashMap();
            List keys = (List)curator.getChildren().forPath(this.pathForever);
            for (String key : keys) {
                nodeKey = key.split("-");
                realNode.put(nodeKey[0], key);
                nodeMap.put(nodeKey[0], Integer.parseInt(nodeKey[1]));
            }
            Integer workerid = (Integer)nodeMap.get(this.listenAddress);
            if (workerid != null) {
                this.zkAddressNode = this.pathForever + "/" + (String)realNode.get(this.listenAddress);
                this.workerId = workerid;
                if (!this.checkInitTimeStamp(curator, this.zkAddressNode)) {
                    throw new CheckLastTimeException("Init timestamp check error,forever node timestamp greater than this node time");
                }
            } else {
                String newNode;
                this.zkAddressNode = newNode = this.createNode(curator);
                nodeKey = newNode.split("-");
                this.workerId = Integer.parseInt(nodeKey[1]);
            }
            this.doService(curator);
            this.updateLocalWorkerId(this.workerId);
        }
        catch (Exception e) {
            log.error("Start node ERROR", (Throwable)e);
            try (FileInputStream in = new FileInputStream(new File(this.cachePath.replace("{port}", this.port + "")));){
                Properties properties = new Properties();
                properties.load(in);
                this.workerId = Integer.parseInt(properties.getProperty("workerId"));
                log.warn("START FAILED ,use local node file properties workerID-{}", (Object)this.workerId);
            }
            catch (Exception e1) {
                log.error("Read file error ", (Throwable)e1);
                return false;
            }
        }
        return true;
    }

    private void doService(CuratorFramework curator) {
        this.scheduledUploadData(curator, this.zkAddressNode);
    }

    private void scheduledUploadData(CuratorFramework curator, String zkAddressNode) {
        ScheduledThreadPoolExecutor executorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("schedule-upload-time-%d").daemon(true).build());
        executorService.scheduleWithFixedDelay(() -> this.updateNewData(curator, zkAddressNode), 1L, 3L, TimeUnit.SECONDS);
    }

    private boolean checkInitTimeStamp(CuratorFramework curator, String zkAddressNode) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        byte[] bytes = (byte[])curator.getData().forPath(zkAddressNode);
        Endpoint endPoint = (Endpoint)mapper.readValue(new String(bytes), Endpoint.class);
        return endPoint.getTimestamp() <= System.currentTimeMillis();
    }

    private String createNode(CuratorFramework curator) throws Exception {
        try {
            return (String)((ACLBackgroundPathAndBytesable)curator.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT_SEQUENTIAL)).forPath(this.pathForever + "/" + this.listenAddress + "-", this.buildData().getBytes());
        }
        catch (Exception e) {
            log.error("create node error msg {} ", (Object)e.getMessage());
            throw e;
        }
    }

    private void updateNewData(CuratorFramework curator, String path) {
        try {
            if (System.currentTimeMillis() < this.lastUpdateTime) {
                return;
            }
            curator.setData().forPath(path, this.buildData().getBytes());
            this.lastUpdateTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            log.info("update init data error path is {} error is {}", (Object)path, (Object)e);
        }
    }

    private String buildData() throws JsonProcessingException {
        Endpoint endpoint = new Endpoint(this.ip, this.port, System.currentTimeMillis());
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)endpoint);
    }

    private void updateLocalWorkerId(int workId) {
        File leafConfFile = new File(this.cachePath.replace("{port}", this.port));
        boolean exists = leafConfFile.exists();
        log.info("file exists status is {}", (Object)exists);
        if (exists) {
            try {
                FileUtils.writeStringToFile((File)leafConfFile, (String)("workId=" + workId), (Charset)StandardCharsets.UTF_8, (boolean)false);
                log.info("update file cache workId is {}", (Object)workId);
            }
            catch (IOException e) {
                log.error("update file cache error ", (Throwable)e);
            }
        } else {
            try {
                boolean mkdirs = leafConfFile.getParentFile().mkdirs();
                log.info("init local file cache create parent dis status is {}, worker id is {}", (Object)mkdirs, (Object)workId);
                if (mkdirs) {
                    if (leafConfFile.createNewFile()) {
                        FileUtils.writeStringToFile((File)leafConfFile, (String)("workId=" + workId), (Charset)StandardCharsets.UTF_8, (boolean)false);
                        log.info("local file cache workId is {}", (Object)workId);
                    }
                } else {
                    log.warn("create parent dir error===");
                }
            }
            catch (IOException e) {
                log.warn("craete workId conf file error", (Throwable)e);
            }
        }
    }

    private CuratorFramework createWithOptions(String connectionString, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.builder().connectString(connectionString).retryPolicy(retryPolicy).connectionTimeoutMs(100000).sessionTimeoutMs(60000).build();
    }

    public String getZkAddressNode() {
        return this.zkAddressNode;
    }

    public String getListenAddress() {
        return this.listenAddress;
    }

    public int getWorkerId() {
        return this.workerId;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public String getConnectionString() {
        return this.connectionString;
    }

    public String getPathForever() {
        return this.pathForever;
    }

    public String getCachePath() {
        return this.cachePath;
    }

    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setZkAddressNode(String zkAddressNode) {
        this.zkAddressNode = zkAddressNode;
    }

    public void setListenAddress(String listenAddress) {
        this.listenAddress = listenAddress;
    }

    public void setWorkerId(int workerId) {
        this.workerId = workerId;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public void setPathForever(String pathForever) {
        this.pathForever = pathForever;
    }

    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnowflakeZookeeperHolder)) {
            return false;
        }
        SnowflakeZookeeperHolder other = (SnowflakeZookeeperHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWorkerId() != other.getWorkerId()) {
            return false;
        }
        if (this.getLastUpdateTime() != other.getLastUpdateTime()) {
            return false;
        }
        String this$zkAddressNode = this.getZkAddressNode();
        String other$zkAddressNode = other.getZkAddressNode();
        if (this$zkAddressNode == null ? other$zkAddressNode != null : !this$zkAddressNode.equals(other$zkAddressNode)) {
            return false;
        }
        String this$listenAddress = this.getListenAddress();
        String other$listenAddress = other.getListenAddress();
        if (this$listenAddress == null ? other$listenAddress != null : !this$listenAddress.equals(other$listenAddress)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$connectionString = this.getConnectionString();
        String other$connectionString = other.getConnectionString();
        if (this$connectionString == null ? other$connectionString != null : !this$connectionString.equals(other$connectionString)) {
            return false;
        }
        String this$pathForever = this.getPathForever();
        String other$pathForever = other.getPathForever();
        if (this$pathForever == null ? other$pathForever != null : !this$pathForever.equals(other$pathForever)) {
            return false;
        }
        String this$cachePath = this.getCachePath();
        String other$cachePath = other.getCachePath();
        return !(this$cachePath == null ? other$cachePath != null : !this$cachePath.equals(other$cachePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SnowflakeZookeeperHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWorkerId();
        long $lastUpdateTime = this.getLastUpdateTime();
        result = result * 59 + (int)($lastUpdateTime >>> 32 ^ $lastUpdateTime);
        String $zkAddressNode = this.getZkAddressNode();
        result = result * 59 + ($zkAddressNode == null ? 43 : $zkAddressNode.hashCode());
        String $listenAddress = this.getListenAddress();
        result = result * 59 + ($listenAddress == null ? 43 : $listenAddress.hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $connectionString = this.getConnectionString();
        result = result * 59 + ($connectionString == null ? 43 : $connectionString.hashCode());
        String $pathForever = this.getPathForever();
        result = result * 59 + ($pathForever == null ? 43 : $pathForever.hashCode());
        String $cachePath = this.getCachePath();
        result = result * 59 + ($cachePath == null ? 43 : $cachePath.hashCode());
        return result;
    }

    public String toString() {
        return "SnowflakeZookeeperHolder(zkAddressNode=" + this.getZkAddressNode() + ", listenAddress=" + this.getListenAddress() + ", workerId=" + this.getWorkerId() + ", ip=" + this.getIp() + ", port=" + this.getPort() + ", connectionString=" + this.getConnectionString() + ", pathForever=" + this.getPathForever() + ", cachePath=" + this.getCachePath() + ", lastUpdateTime=" + this.getLastUpdateTime() + ")";
    }

    public static class CheckLastTimeException
    extends RuntimeException {
        public CheckLastTimeException(String msg) {
            super(msg);
        }
    }

    static class Endpoint {
        private String ip;
        private String port;
        private long timestamp;

        public String getIp() {
            return this.ip;
        }

        public String getPort() {
            return this.port;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTimestamp() != other.getTimestamp()) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$port = this.getPort();
            String other$port = other.getPort();
            return !(this$port == null ? other$port != null : !this$port.equals(other$port));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Endpoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $timestamp = this.getTimestamp();
            result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $port = this.getPort();
            result = result * 59 + ($port == null ? 43 : $port.hashCode());
            return result;
        }

        public String toString() {
            return "SnowflakeZookeeperHolder.Endpoint(ip=" + this.getIp() + ", port=" + this.getPort() + ", timestamp=" + this.getTimestamp() + ")";
        }

        public Endpoint(String ip, String port, long timestamp) {
            this.ip = ip;
            this.port = port;
            this.timestamp = timestamp;
        }

        public Endpoint() {
        }
    }
}

