/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.tenant.report.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.report.controller.ReportDatasetController;
import com.dic.bid.common.report.dto.ReportDatasetDto;
import com.dic.bid.common.report.object.ReportResultSet;
import com.dic.bid.common.report.vo.ReportDatasetColumnVo;
import com.dic.bid.common.report.vo.ReportDatasetVo;
import com.dic.bid.common.tenant.annotation.SwitchTenantCommonDatasource;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SwitchTenantCommonDatasource
@Tag(name="\u79df\u6237\u62a5\u8868\u6253\u5370\u6570\u636e\u96c6\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-report.urlPrefix}/tenantReportDataset"})
public class TenantReportDatasetController
extends ReportDatasetController {
    private static final Logger log = LoggerFactory.getLogger(TenantReportDatasetController.class);

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody ReportDatasetDto reportDatasetDto) {
        return super.add(reportDatasetDto);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody ReportDatasetDto reportDatasetDto) {
        return super.update(reportDatasetDto);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody(required=true) Long datasetId) {
        return super.delete(datasetId);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<ReportDatasetVo>> list(@MyRequestBody ReportDatasetDto reportDatasetDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        return super.list(reportDatasetDtoFilter, orderParam, pageParam);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @PostMapping(value={"/listByIds"})
    public ResponseResult<List<ReportDatasetVo>> listByIds(@MyRequestBody Set<Long> datasetIds) {
        return super.listByIds(datasetIds);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<ReportDatasetVo> view(@RequestParam Long datasetId) {
        return super.view(datasetId);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @PostMapping(value={"/sync"})
    public ResponseResult<List<ReportDatasetColumnVo>> sync(@MyRequestBody(required=true) Long datasetId) {
        return super.sync(datasetId);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @PostMapping(value={"/previewDataset"})
    public ResponseResult<ReportResultSet<Map<String, Object>>> previewDataset(@MyRequestBody(required=true) Long datasetId, @MyRequestBody MyPageParam pageParam) {
        return super.previewDataset(datasetId, pageParam);
    }

    @SaCheckPermission(value={"tenantReportDataset.all"})
    @PostMapping(value={"/listDataWithColumn"})
    public ResponseResult<List<Map<String, Object>>> listDataWithColumn(@MyRequestBody(required=true) Long datasetId, @MyRequestBody(required=true) Long columnId) {
        return super.listDataWithColumn(datasetId, columnId);
    }

    @GetMapping(value={"/listDict"})
    public ResponseResult<List<Map<String, Object>>> listDict(@ParameterObject ReportDatasetDto filter) {
        return super.listDict(filter);
    }

    @GetMapping(value={"/listDictByIds"})
    public ResponseResult<List<Map<String, Object>>> listDictByIds(@RequestParam List<Long> dictIds) {
        return super.listDictByIds(dictIds);
    }
}

