/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.tenant.report.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.annotation.NoAuthInterface;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.dbutil.object.SqlTableColumn;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.report.controller.ReportDblinkController;
import com.dic.bid.common.report.dto.ReportDblinkDto;
import com.dic.bid.common.report.vo.ReportDblinkVo;
import com.dic.bid.common.tenant.annotation.SwitchTenantCommonDatasource;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SwitchTenantCommonDatasource
@Tag(name="\u79df\u6237\u62a5\u8868\u6253\u5370\u6570\u636e\u5e93\u94fe\u63a5\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-report.urlPrefix}/tenantReportDblink"})
public class TenantReportDblinkController
extends ReportDblinkController {
    private static final Logger log = LoggerFactory.getLogger(TenantReportDblinkController.class);

    @ApiOperationSupport(ignoreParameters={"reportDblinkDto.dblinkId"})
    @SaCheckPermission(value={"tenantReportDblink.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody ReportDblinkDto reportDblinkDto) {
        return super.add(reportDblinkDto);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody ReportDblinkDto reportDblinkDto) {
        return super.update(reportDblinkDto);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long dblinkId) {
        return super.delete(dblinkId);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<ReportDblinkVo>> list(@MyRequestBody ReportDblinkDto reportDblinkDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        return super.list(reportDblinkDtoFilter, orderParam, pageParam);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<ReportDblinkVo> view(@RequestParam Long dblinkId) {
        return super.view(dblinkId);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @GetMapping(value={"/listAllTables"})
    public ResponseResult<List<String>> listAllTables(@RequestParam Long dblinkId) {
        return super.listAllTables(dblinkId);
    }

    @SaCheckPermission(value={"tenantReportDblink.all"})
    @GetMapping(value={"/listTableColumn"})
    public ResponseResult<List<SqlTableColumn>> listAllTables(@RequestParam Long dblinkId, @RequestParam String tableName) {
        return super.listAllTables(dblinkId, tableName);
    }

    @GetMapping(value={"/listDict"})
    public ResponseResult<List<Map<String, Object>>> listDict(@ParameterObject ReportDblinkDto filter) {
        return super.listDict(filter);
    }

    @NoAuthInterface
    @GetMapping(value={"/testConnection"})
    public ResponseResult<Void> testConnection(@RequestParam Long dblinkId) {
        return super.testConnection(dblinkId);
    }
}

