/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.tenant.report.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.core.util.MyModelUtil;
import com.dic.bid.common.core.util.MyPageUtil;
import com.dic.bid.common.dict.dto.GlobalDictDto;
import com.dic.bid.common.dict.model.TenantGlobalDict;
import com.dic.bid.common.dict.service.TenantGlobalDictService;
import com.dic.bid.common.dict.vo.GlobalDictVo;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.report.controller.ReportDictController;
import com.dic.bid.common.report.dto.ReportDictDto;
import com.dic.bid.common.report.dto.ReportDictFilterDto;
import com.dic.bid.common.report.vo.ReportDictVo;
import com.dic.bid.common.tenant.annotation.SwitchTenantCommonDatasource;
import com.github.pagehelper.Page;
import com.github.pagehelper.page.PageMethod;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.api.annotations.ParameterObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SwitchTenantCommonDatasource
@Tag(name="\u79df\u6237\u62a5\u8868\u6253\u5370\u5b57\u5178\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-report.urlPrefix}/tenantReportDict"})
public class TenantReportDictController
extends ReportDictController {
    private static final Logger log = LoggerFactory.getLogger(TenantReportDictController.class);
    @Autowired
    private TenantGlobalDictService tenantGlobalDictService;

    @ApiOperationSupport(ignoreParameters={"reportDictDto.dictId"})
    @SaCheckPermission(value={"tenantReportDict.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody ReportDictDto reportDictDto) {
        return super.add(reportDictDto);
    }

    @SaCheckPermission(value={"tenantReportDict.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody ReportDictDto reportDictDto) {
        return super.update(reportDictDto);
    }

    @SaCheckPermission(value={"tenantReportDict.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long dictId) {
        return super.delete(dictId);
    }

    @SaCheckPermission(value={"tenantReportDict.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<ReportDictVo>> list(@MyRequestBody ReportDictDto reportDictDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        return super.list(reportDictDtoFilter, orderParam, pageParam);
    }

    @SaCheckPermission(value={"tenantReportDict.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<ReportDictVo> view(@RequestParam Long dictId) {
        return super.view(dictId);
    }

    @PostMapping(value={"/listAllGlobalDict"})
    public ResponseResult<MyPageData<GlobalDictVo>> listAllGlobalDict(@MyRequestBody GlobalDictDto globalDictDtoFilter, @MyRequestBody MyPageParam pageParam) {
        if (pageParam != null) {
            PageMethod.startPage((int)pageParam.getPageNum(), (int)pageParam.getPageSize());
        }
        TenantGlobalDict filter = (TenantGlobalDict)MyModelUtil.copyTo((Object)globalDictDtoFilter, TenantGlobalDict.class);
        List dictList = this.tenantGlobalDictService.getGlobalDictList(filter, null);
        List dictVoList = MyModelUtil.copyCollectionTo((Collection)dictList, GlobalDictVo.class);
        long totalCount = 0L;
        if (dictList instanceof Page) {
            totalCount = ((Page)dictList).getTotal();
        }
        return ResponseResult.success((Object)MyPageUtil.makeResponseData((List)dictVoList, (Long)totalCount));
    }

    @PostMapping(value={"/listDictData"})
    public ResponseResult<List<Map<String, Object>>> listDictData(@MyRequestBody(required=true) Long dictId, @MyRequestBody List<ReportDictFilterDto> filterDtoList) {
        return super.listDictData(dictId, filterDtoList);
    }

    @GetMapping(value={"/listDict"})
    public ResponseResult<List<Map<String, Object>>> listDict(@ParameterObject ReportDictDto filter) {
        return super.listDict(filter);
    }
}

