/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.tenant.report.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.report.controller.ReportPageController;
import com.dic.bid.common.report.dto.ReportPageDto;
import com.dic.bid.common.report.vo.ReportPageVo;
import com.dic.bid.common.tenant.annotation.SwitchTenantCommonDatasource;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SwitchTenantCommonDatasource
@Tag(name="\u79df\u6237\u62a5\u8868\u6253\u5370\u9875\u9762\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-report.urlPrefix}/tenantReportPage"})
public class TenantReportPageController
extends ReportPageController {
    private static final Logger log = LoggerFactory.getLogger(TenantReportPageController.class);

    @ApiOperationSupport(ignoreParameters={"reportPageDto.pageId"})
    @SaCheckPermission(value={"tenantReportPage.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody ReportPageDto reportPageDto) {
        return super.add(reportPageDto);
    }

    @SaCheckPermission(value={"tenantReportPage.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody ReportPageDto reportPageDto) {
        return super.update(reportPageDto);
    }

    @SaCheckPermission(value={"tenantReportPage.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long pageId) {
        return super.delete(pageId);
    }

    @SaCheckPermission(value={"tenantReportPage.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<ReportPageVo>> list(@MyRequestBody ReportPageDto reportPageDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        return super.list(reportPageDtoFilter, orderParam, pageParam);
    }

    @SaCheckPermission(value={"tenantReportPage.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<ReportPageVo> view(@RequestParam Long pageId) {
        return super.view(pageId);
    }
}

