/*
 * Decompiled with CFR 0.152.
 */
package com.dic.bid.common.tenant.report.controller;

import cn.dev33.satoken.annotation.SaCheckPermission;
import cn.dev33.satoken.annotation.SaIgnore;
import com.alibaba.fastjson.JSONObject;
import com.dic.bid.common.core.annotation.MyRequestBody;
import com.dic.bid.common.core.object.MyOrderParam;
import com.dic.bid.common.core.object.MyPageData;
import com.dic.bid.common.core.object.MyPageParam;
import com.dic.bid.common.core.object.ResponseResult;
import com.dic.bid.common.log.annotation.OperationLog;
import com.dic.bid.common.report.controller.ReportPrintController;
import com.dic.bid.common.report.dto.ReportPrintDto;
import com.dic.bid.common.report.object.ReportPrintParam;
import com.dic.bid.common.report.vo.ReportPrintVo;
import com.dic.bid.common.tenant.annotation.SwitchTenantCommonDatasource;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@SwitchTenantCommonDatasource
@Tag(name="\u79df\u6237\u62a5\u8868\u6253\u5370\u6253\u5370\u63a5\u53e3")
@RestController
@RequestMapping(value={"${common-report.urlPrefix}/tenantReportPrint"})
public class TenantReportPrintController
extends ReportPrintController {
    private static final Logger log = LoggerFactory.getLogger(TenantReportPrintController.class);

    @ApiOperationSupport(ignoreParameters={"reportPrintDto.printId"})
    @SaCheckPermission(value={"tenantReportPrint.all"})
    @OperationLog(type=10)
    @PostMapping(value={"/add"})
    public ResponseResult<Long> add(@MyRequestBody ReportPrintDto reportPrintDto) {
        return super.add(reportPrintDto);
    }

    @SaCheckPermission(value={"tenantReportPrint.all"})
    @OperationLog(type=15)
    @PostMapping(value={"/update"})
    public ResponseResult<Void> update(@MyRequestBody ReportPrintDto reportPrintDto) {
        return super.update(reportPrintDto);
    }

    @SaCheckPermission(value={"tenantReportPrint.all"})
    @OperationLog(type=20)
    @PostMapping(value={"/delete"})
    public ResponseResult<Void> delete(@MyRequestBody Long printId) {
        return super.delete(printId);
    }

    @SaCheckPermission(value={"tenantReportPrint.all"})
    @PostMapping(value={"/list"})
    public ResponseResult<MyPageData<ReportPrintVo>> list(@MyRequestBody ReportPrintDto reportPrintDtoFilter, @MyRequestBody MyOrderParam orderParam, @MyRequestBody MyPageParam pageParam) {
        return super.list(reportPrintDtoFilter, orderParam, pageParam);
    }

    @PostMapping(value={"/listAll"})
    public ResponseResult<JSONObject> listAll() {
        return super.listAll();
    }

    @SaCheckPermission(value={"tenantReportPrint.all"})
    @GetMapping(value={"/view"})
    public ResponseResult<ReportPrintVo> view(@RequestParam Long printId) {
        return super.view(printId);
    }

    @SaIgnore
    @PostMapping(value={"/preview"})
    public void preview(@MyRequestBody(required=true) Long printId, @MyRequestBody(required=true) ReportPrintParam printParam, @MyRequestBody(required=true) Integer renderType) throws IOException {
        super.preview(printId, printParam, renderType);
    }

    @GetMapping(value={"/print"})
    public void print(@RequestParam String printToken) throws IOException {
        super.print(printToken);
    }
}

