/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.comp.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dicchina.comp.domain.AssemblyPublic;
import com.dicchina.comp.domain.AssemblyPublicDetail;
import com.dicchina.comp.func.api.IAssemblyPublicDetailService;
import com.dicchina.comp.mapper.AssemblyPublicDetailMapper;
import com.dicchina.comp.mapper.AssemblyPublicMapper;
import com.dicchina.core.util.StringUtils;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AssemblyPublicDetailServiceImpl
implements IAssemblyPublicDetailService {
    private static final Logger log = LoggerFactory.getLogger(AssemblyPublicDetailServiceImpl.class);
    @Autowired
    private AssemblyPublicDetailMapper assemblyPublicDetailMapper;
    @Autowired
    private AssemblyPublicMapper assemblyPublicMapper;

    public AssemblyPublicDetail selectAssemblyPublicDetailById(Long id) {
        return this.assemblyPublicDetailMapper.selectAssemblyPublicDetailById(id);
    }

    public Map<String, Object> selectAssemblyPublicDetailByAssemblyPublicId(Long assemblyPublicId) {
        return this.assemblyPublicDetailMapper.selectAssemblyPublicDetailByAssemblyPublicId(assemblyPublicId);
    }

    public List<AssemblyPublicDetail> selectAssemblyPublicDetailList(AssemblyPublicDetail assemblyPublicDetail) {
        return this.assemblyPublicDetailMapper.selectAssemblyPublicDetailList(assemblyPublicDetail);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void bachInsertAssemblyPublicDetail(JSONObject jsonObject) throws Exception {
        Long parentId = jsonObject.getLong("parentId");
        String fixedType = jsonObject.getString("fixedType");
        JSONArray data = jsonObject.getJSONArray("data");
        for (Object object : data) {
            JSONObject object1 = JSONObject.parseObject((String)object.toString());
            this.insertAssemblyPublicDetail(parentId, fixedType, object1.getString("id"), object1.getString("code"), object1.getString("name"), null, null);
        }
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int insertAssemblyPublicDetail(Long parentId, String fixedType, String assemblyRelId, String assemblyRelCode, String assemblyRelName, String callMode, String callValue) throws ValidationException {
        if (StringUtils.isBlank((CharSequence)fixedType)) {
            throw new ValidationException("\u56fa\u5b9a\u5206\u7c7b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (parentId == null) {
            throw new ValidationException("\u7ec4\u4ef6\u4e0a\u7ea7\u5206\u7c7bID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)assemblyRelId)) {
            throw new ValidationException("\u7ec4\u4ef6\u5173\u8054\u5bf9\u8c61ID\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)assemblyRelCode)) {
            throw new ValidationException("\u7ec4\u4ef6\u5173\u8054\u5bf9\u8c61code\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)assemblyRelName)) {
            throw new ValidationException("\u7ec4\u4ef6\u5173\u8054\u5bf9\u8c61\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String assemblyCode = assemblyRelCode;
        List paramAssemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicByFixedTypeAndCode(fixedType, assemblyRelCode, null);
        if (paramAssemblyPublic != null && !paramAssemblyPublic.isEmpty()) {
            assemblyCode = "assembly_" + RandomStringUtils.randomAlphanumeric((int)7);
        }
        AssemblyPublicDetail paraMassemblyPublicDetail = new AssemblyPublicDetail();
        paraMassemblyPublicDetail.setAssemblyRelId(assemblyRelId);
        paraMassemblyPublicDetail.setFixedType(fixedType);
        List assemblyPublicDetailList = this.assemblyPublicDetailMapper.selectAssemblyPublicDetailList(paraMassemblyPublicDetail);
        if (assemblyPublicDetailList == null || assemblyPublicDetailList.isEmpty()) {
            AssemblyPublic assemblyPublic = new AssemblyPublic();
            assemblyPublic.setFixedType(fixedType);
            assemblyPublic.setCode(assemblyCode);
            assemblyPublic.setName(assemblyRelName);
            assemblyPublic.setParentId(parentId);
            assemblyPublic.setCreateTime(new Date());
            this.assemblyPublicMapper.insertAssemblyPublic(assemblyPublic);
            AssemblyPublicDetail assemblyPublicDetail = new AssemblyPublicDetail();
            assemblyPublicDetail.setAssemblyCode(assemblyPublic.getCode());
            assemblyPublicDetail.setAssemblyName(assemblyPublic.getName());
            assemblyPublicDetail.setAssemblyPublicId(assemblyPublic.getId());
            assemblyPublicDetail.setAssemblyRelId(assemblyRelId);
            assemblyPublicDetail.setAssemblyRelCode(assemblyRelCode);
            assemblyPublicDetail.setAssemblyRelName(assemblyRelName);
            assemblyPublicDetail.setAssemblyState("01");
            assemblyPublicDetail.setCallMode(callMode);
            assemblyPublicDetail.setCallValue(callValue);
            return this.assemblyPublicDetailMapper.insertAssemblyPublicDetail(assemblyPublicDetail);
        }
        return 0;
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int updateAssemblyPublicDetail(JSONObject jsonObject) throws Exception {
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("fixedType"))) {
            throw new ValidationException("\u56fa\u5b9a\u5206\u7c7b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("parentId"))) {
            throw new ValidationException("\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("assemblyCode"))) {
            throw new ValidationException("\u7ec4\u4ef6\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)jsonObject.getString("assemblyName"))) {
            throw new ValidationException("\u7ec4\u4ef6\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        List paramAssemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicByFixedTypeAndCode(jsonObject.getString("fixedType"), jsonObject.getString("assemblyCode"), jsonObject.getLong("assemblyPublicId"));
        if (paramAssemblyPublic != null && !paramAssemblyPublic.isEmpty()) {
            throw new ValidationException("\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        AssemblyPublic assemblyPublic = null;
        if (jsonObject.getLong("assemblyPublicId") != null) {
            assemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicById(jsonObject.getLong("assemblyPublicId"));
            if (assemblyPublic == null) {
                throw new ValidationException("\u7ec4\u4ef6\u6811ID\u9519\u8bef");
            }
        } else {
            assemblyPublic = new AssemblyPublic();
        }
        assemblyPublic.setCode(jsonObject.getString("assemblyCode"));
        assemblyPublic.setName(jsonObject.getString("assemblyName"));
        assemblyPublic.setFixedType(jsonObject.getString("fixedType"));
        assemblyPublic.setParentId(jsonObject.getLong("parentId"));
        assemblyPublic.setGmtModified(new Date());
        if (assemblyPublic.getId() == null) {
            assemblyPublic.setGmtCreate(new Date());
            this.assemblyPublicMapper.insertAssemblyPublic(assemblyPublic);
        } else {
            this.assemblyPublicMapper.updateAssemblyPublic(assemblyPublic);
        }
        AssemblyPublicDetail assemblyPublicDetail = new AssemblyPublicDetail();
        AssemblyPublicDetail paraMassemblyPublicDetail = new AssemblyPublicDetail();
        paraMassemblyPublicDetail.setAssemblyPublicId(assemblyPublic.getId());
        List assemblyPublicDetailList = this.assemblyPublicDetailMapper.selectAssemblyPublicDetailList(paraMassemblyPublicDetail);
        if (assemblyPublicDetailList != null && !assemblyPublicDetailList.isEmpty()) {
            assemblyPublicDetail = (AssemblyPublicDetail)assemblyPublicDetailList.get(0);
        }
        assemblyPublicDetail.setAssemblyCode(jsonObject.getString("assemblyCode"));
        assemblyPublicDetail.setAssemblyName(jsonObject.getString("assemblyName"));
        assemblyPublicDetail.setAssemblyPublicId(assemblyPublic.getId());
        assemblyPublicDetail.setAssemblyRelId(jsonObject.getString("assemblyRelId"));
        assemblyPublicDetail.setAssemblyRelCode(jsonObject.getString("assemblyRelCode"));
        assemblyPublicDetail.setAssemblyRelName(jsonObject.getString("assemblyRelName"));
        assemblyPublicDetail.setAssemblyState(jsonObject.getString("assemblyState"));
        assemblyPublicDetail.setCallMode(jsonObject.getString("callMode"));
        assemblyPublicDetail.setCallValue(jsonObject.getString("callValue"));
        if (assemblyPublicDetail.getId() != null) {
            return this.assemblyPublicDetailMapper.updateAssemblyPublicDetail(assemblyPublicDetail);
        }
        return this.assemblyPublicDetailMapper.insertAssemblyPublicDetail(assemblyPublicDetail);
    }

    public int deleteAssemblyPublicDetailByIds(Long[] ids) {
        return this.assemblyPublicDetailMapper.deleteAssemblyPublicDetailByIds(ids);
    }

    public int deleteAssemblyPublicDetailById(Long id) {
        return this.assemblyPublicDetailMapper.deleteAssemblyPublicDetailById(id);
    }

    public JSONArray getRelAssemblySelect(String fixedType, String assemblyPublicId) {
        JSONArray result = new JSONArray();
        JSONArray jsonArray = new JSONArray();
        String assemblyRelIds = this.assemblyPublicDetailMapper.selectAssemblyRelIds(fixedType, assemblyPublicId);
        if (assemblyRelIds != null) {
            for (Object object : jsonArray) {
                JSONObject jsonObject;
                if (object == null || assemblyRelIds.indexOf((jsonObject = JSONObject.parseObject((String)object.toString())).getString("id")) != -1) continue;
                result.add((Object)jsonObject);
            }
            return result;
        }
        return jsonArray;
    }
}

