/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.comp.service;

import com.alibaba.fastjson.JSONObject;
import com.dicchina.comp.domain.AssemblyPublic;
import com.dicchina.comp.func.api.IAssemblyPublicService;
import com.dicchina.comp.mapper.AssemblyPublicDetailMapper;
import com.dicchina.comp.mapper.AssemblyPublicMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AssemblyPublicServiceImpl
implements IAssemblyPublicService {
    @Autowired
    private AssemblyPublicMapper assemblyPublicMapper;
    @Autowired
    private AssemblyPublicDetailMapper assemblyPublicDetailMapper;

    public List<Map<String, Object>> selectAssemblyPublicTree(String data) {
        List list = this.assemblyPublicMapper.selectAssemblyPublicTree(JSONObject.parseObject((String)data));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        ArrayList<String> parentIds = new ArrayList<String>();
        for (Map map : list) {
            if (map.get("parentId") != null && StringUtils.isNotBlank((CharSequence)map.get("parentId").toString())) {
                if (parentIds.contains(map.get("parentId").toString())) continue;
                parentIds.add(map.get("parentId").toString());
                continue;
            }
            if (parentIds.contains(map.get("id").toString())) continue;
            parentIds.add(map.get("id").toString());
        }
        for (String parentId : parentIds) {
            AssemblyPublic assemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicById(Long.valueOf(parentId));
            if (assemblyPublic == null) continue;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", assemblyPublic.getId());
            map.put("code", assemblyPublic.getCode());
            map.put("name", assemblyPublic.getName());
            map.put("parentId", assemblyPublic.getParentId());
            map.put("children", this.getChildren(list, parentId));
            result.add(map);
        }
        return result;
    }

    private List<Map<String, Object>> getChildren(List<Map<String, Object>> list, String parentId) {
        ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            if (map.get("parentId") == null || !parentId.equals(map.get("parentId").toString())) continue;
            children.add(map);
        }
        return children;
    }

    public AssemblyPublic selectAssemblyPublicById(Long id) {
        return this.assemblyPublicMapper.selectAssemblyPublicById(id);
    }

    public List<AssemblyPublic> selectAssemblyPublicList(AssemblyPublic assemblyPublic) {
        return this.assemblyPublicMapper.selectAssemblyPublicList(assemblyPublic);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int insertAssemblyPublic(AssemblyPublic assemblyPublic) throws Exception {
        if (assemblyPublic.getParentId() != null && StringUtils.isBlank((CharSequence)assemblyPublic.getFixedType())) {
            throw new ValidationException("\u56fa\u5b9a\u5206\u7c7b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        List paramAssemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicByFixedTypeAndCode(assemblyPublic.getFixedType(), assemblyPublic.getCode(), null);
        if (paramAssemblyPublic != null && !paramAssemblyPublic.isEmpty()) {
            throw new ValidationException("\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        assemblyPublic.setGmtCreate(new Date());
        assemblyPublic.setGmtModified(new Date());
        return this.assemblyPublicMapper.insertAssemblyPublic(assemblyPublic);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int updateAssemblyPublic(AssemblyPublic assemblyPublic) throws Exception {
        List paramAssemblyPublic;
        if (StringUtils.isNotBlank((CharSequence)assemblyPublic.getCode()) && (paramAssemblyPublic = this.assemblyPublicMapper.selectAssemblyPublicByFixedTypeAndCode(assemblyPublic.getFixedType(), assemblyPublic.getCode(), assemblyPublic.getId())) != null && !paramAssemblyPublic.isEmpty()) {
            throw new ValidationException("\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        assemblyPublic.setGmtModified(new Date());
        return this.assemblyPublicMapper.updateAssemblyPublic(assemblyPublic);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int deleteAssemblyPublicByIds(Long[] ids) {
        return this.assemblyPublicMapper.deleteAssemblyPublicByIds(ids);
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int deleteAssemblyPublicById(Long id) throws Exception {
        AssemblyPublic paramAssemblyPublic = new AssemblyPublic();
        paramAssemblyPublic.setParentId(id);
        List assemblyPublicList = this.assemblyPublicMapper.selectAssemblyPublicList(paramAssemblyPublic);
        if (assemblyPublicList != null && !assemblyPublicList.isEmpty()) {
            throw new ValidationException("\u5f53\u524d\u5206\u7c7b\u4e0b\u5b58\u5728\u7ec4\u4ef6\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        Map map = this.assemblyPublicDetailMapper.selectAssemblyPublicDetailByAssemblyPublicId(id);
        return this.assemblyPublicMapper.deleteAssemblyPublicById(id);
    }
}

