/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.comp.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dicchina.comp.domain.AssemblyPublic;
import com.dicchina.comp.domain.AssemblyPublicDetail;
import com.dicchina.comp.mapper.AssemblyPublicDetailMapper;
import com.dicchina.comp.mapper.AssemblyPublicMapper;
import com.dicchina.comp.rpc.api.IAssemblyService;
import com.dicchina.comp.service.AssemblyPublicDetailServiceImpl;
import java.util.Date;
import java.util.List;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="assemblyService")
@Transactional(readOnly=true)
public class AssemblyServiceImpl
implements IAssemblyService {
    @Autowired
    AssemblyPublicDetailMapper assemblyPublicDetailMapper;
    @Autowired
    AssemblyPublicDetailServiceImpl assemblyPublicDetailService;
    @Autowired
    AssemblyPublicMapper assemblyPublicMapper;

    public JSONArray selectAssemblyListByFixedType(String fixedType) {
        JSONArray jsonArray = new JSONArray();
        AssemblyPublicDetail paramAssemblyPublicDetail = new AssemblyPublicDetail();
        paramAssemblyPublicDetail.setFixedType(fixedType);
        List list = this.assemblyPublicDetailMapper.selectAssemblyPublicDetailList(paramAssemblyPublicDetail);
        for (AssemblyPublicDetail assemblyPublicDetail : list) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)assemblyPublicDetail.getId());
            jsonObject.put("code", (Object)assemblyPublicDetail.getAssemblyRelCode());
            jsonObject.put("name", (Object)assemblyPublicDetail.getAssemblyName());
            jsonArray.add((Object)jsonObject);
        }
        return jsonArray;
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int registerAssembly(String fixedType, String id, String code, String name, String callMode, String callValue) throws Exception {
        if (StringUtils.isBlank((CharSequence)fixedType)) {
            throw new ValidationException("\u56fa\u5b9a\u5206\u7c7b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        AssemblyPublic paramAssemblyPublic = new AssemblyPublic();
        paramAssemblyPublic.setCode("other");
        paramAssemblyPublic.setParentId(Long.valueOf(-1L));
        List assemblyPublicList = this.assemblyPublicMapper.selectAssemblyPublicList(paramAssemblyPublic);
        if (assemblyPublicList == null || assemblyPublicList.isEmpty()) {
            AssemblyPublic assemblyPublic = new AssemblyPublic();
            assemblyPublic.setName("\u672a\u5206\u7c7b");
            assemblyPublic.setCode("other");
            assemblyPublic.setCreateTime(new Date());
            this.assemblyPublicMapper.insertAssemblyPublic(assemblyPublic);
            return this.assemblyPublicDetailService.insertAssemblyPublicDetail(assemblyPublic.getId(), fixedType, id, code, name, callMode, callValue);
        }
        return this.assemblyPublicDetailService.insertAssemblyPublicDetail(((AssemblyPublic)assemblyPublicList.get(0)).getId(), fixedType, id, code, name, callMode, callValue);
    }

    public int deleteAssemblyPublicDetailById(Long id) {
        AssemblyPublicDetail assemblyPublicDetail = this.assemblyPublicDetailMapper.selectAssemblyPublicDetailById(id);
        if (assemblyPublicDetail != null) {
            this.assemblyPublicMapper.deleteAssemblyPublicById(assemblyPublicDetail.getAssemblyPublicId());
            return this.assemblyPublicDetailMapper.deleteAssemblyPublicDetailById(id);
        }
        return 0;
    }

    public List<AssemblyPublicDetail> selectAssemblyPublicDetailList(AssemblyPublicDetail assemblyPublicDetail) {
        return this.assemblyPublicDetailService.selectAssemblyPublicDetailList(assemblyPublicDetail);
    }
}

