/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.aspectj;

import com.dicchina.core.annotation.AutoGenegrateId;
import com.dicchina.core.util.SnowflakeIdWorker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class IdGengerateAspect {
    public static final SnowflakeIdWorker idWorker = new SnowflakeIdWorker(0L, 0L);

    public static void genegrateIdFilter(JoinPoint joinPoint, String name) {
        Object params = joinPoint.getArgs()[0];
        Class<?> aClass = params.getClass();
        try {
            Field declaredField = aClass.getDeclaredField(name);
            if (declaredField == null) {
                throw new RuntimeException("\u6ce8\u89e3[" + name + "] \u7684\u57df\u5728\u5b9e\u4f53\u7c7b\u4e2d\u4e0d\u5b58\u5728");
            }
            declaredField.setAccessible(true);
            declaredField.set(params, idWorker.nextId());
            joinPoint.getArgs()[0] = params;
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    @Pointcut(value="@annotation(com.dicchina.core.annotation.AutoGenegrateId)")
    public void genegrateIdPointCut() {
    }

    @Before(value="genegrateIdPointCut()")
    public void doBefore(JoinPoint point) throws Throwable {
        this.handleGenegrateId(point);
    }

    protected void handleGenegrateId(JoinPoint joinPoint) {
        AutoGenegrateId controllerAutoGenegrateId = this.getAnnotationLog(joinPoint);
        if (controllerAutoGenegrateId == null) {
            return;
        }
        IdGengerateAspect.genegrateIdFilter(joinPoint, controllerAutoGenegrateId.name());
    }

    private AutoGenegrateId getAnnotationLog(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature)signature;
        Method method = methodSignature.getMethod();
        if (method != null) {
            return method.getAnnotation(AutoGenegrateId.class);
        }
        return null;
    }
}

