/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.base.controller;

import com.alibaba.fastjson.JSONObject;
import com.dicchina.core.base.domain.AjaxResult;
import com.dicchina.core.base.page.PageDomain;
import com.dicchina.core.base.page.TableDataInfo;
import com.dicchina.core.base.page.TableSupport;
import com.dicchina.core.util.DateUtils;
import com.dicchina.core.util.StringUtils;
import com.dicchina.core.util.sql.SqlUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;

public class BaseController {
    protected final Logger logger = LoggerFactory.getLogger(BaseController.class);

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Date.class, (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                this.setValue(DateUtils.parseDate(text));
            }
        });
    }

    protected void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
            String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
            PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy);
        }
    }

    protected TableDataInfo getDataTable(List<?> list) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setRows(list);
        rspData.setTotal(new PageInfo(list).getTotal());
        return rspData;
    }

    protected AjaxResult toAjax(int rows) {
        return rows > 0 ? AjaxResult.success() : AjaxResult.error();
    }

    public String redirect(String url) {
        return StringUtils.format("redirect:{}", url);
    }

    protected void startPage(String data) {
        if (StringUtils.isNotEmpty(data)) {
            JSONObject object = JSONObject.parseObject((String)data);
            int pageNum = object.getIntValue("pageNum");
            int pageSize = object.getIntValue("pageSize");
            if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
                PageHelper.startPage((int)pageNum, (int)pageSize, null);
            }
        }
    }

    protected TableDataInfo getJsonDataTable(List<JSONObject> list) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setRows(list);
        if (StringUtils.isNotEmpty(list)) {
            JSONObject o = list.get(0);
            rspData.setTotal(o.getLongValue("total"));
        } else {
            rspData.setTotal(new PageInfo(list).getTotal());
        }
        return rspData;
    }

    public TableDataInfo getCurrentPageList(List<JSONObject> list, JSONObject json) {
        ArrayList<JSONObject> respList = new ArrayList<JSONObject>();
        if (list != null && list.size() > 0 && json != null && json.getInteger("pageNum") != null && json.getInteger("pageSize") != null) {
            int pageNum = json.getInteger("pageNum");
            int pageSize = json.getInteger("pageSize");
            int minRecord = 0;
            int maxRecord = 0;
            if (pageNum == 1) {
                if (list.size() >= pageSize) {
                    for (int i = 0; i < pageSize; ++i) {
                        respList.add(list.get(i));
                    }
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        respList.add(list.get(i));
                    }
                }
            } else if (pageNum * pageSize >= list.size()) {
                minRecord = (pageNum - 1) * pageSize;
                maxRecord = list.size();
                for (int i = minRecord; i < maxRecord; ++i) {
                    respList.add(list.get(i));
                }
            } else {
                minRecord = (pageNum - 1) * pageSize;
                maxRecord = pageNum * pageSize;
                for (int i = minRecord; i < maxRecord; ++i) {
                    respList.add(list.get(i));
                }
            }
        }
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setRows(respList);
        rspData.setTotal(list.size());
        return rspData;
    }
}

