/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.jackson;

import com.dicchina.core.jackson.SetNullStringJsonSerializer;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public class HoSerializerModifier
extends BeanSerializerModifier {
    private JsonSerializer<Object> nullJsonSerializer = new SetNullStringJsonSerializer();

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        beanProperties.forEach(writer -> {
            if (this.isSetNullStringType((BeanPropertyWriter)writer)) {
                writer.assignNullSerializer(this.defaultNullArrayJsonSerializer());
            }
        });
        return beanProperties;
    }

    private boolean isSetNullStringType(BeanPropertyWriter writer) {
        JavaType type = writer.getType();
        return type.isTypeOrSubTypeOf(String.class) || type.isTypeOrSubTypeOf(Integer.class) || type.isTypeOrSubTypeOf(Long.class) || type.isTypeOrSubTypeOf(Double.class) || type.isTypeOrSubTypeOf(Date.class) || type.isTypeOrSubTypeOf(LocalDateTime.class) || type.isTypeOrSubTypeOf(LocalDate.class) || type.isTypeOrSubTypeOf(BigDecimal.class);
    }

    private JsonSerializer<Object> defaultNullArrayJsonSerializer() {
        return this.nullJsonSerializer;
    }
}

