/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.util;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.dicchina.core.util.RedisUtil;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class BittyId {
    private final String WORKER = "SNOWFLAKE:WORKER:";
    private final long f = 31L;
    @Resource
    private RedisUtil redis;
    private Snowflake snowflake = null;

    public String nrc() {
        if (this.snowflake == null) {
            SnowflakeMoudle m = this.getSnowflakeModule();
            this.snowflake = IdUtil.createSnowflake((long)m.workerId, (long)m.dataCenterId);
        }
        return this.snowflake.nextIdStr();
    }

    public String code() {
        return Long.toString(this.snowflake.nextId(), 32).toUpperCase();
    }

    private SnowflakeMoudle getSnowflakeModule() {
        Long id = this.redis.incr("SNOWFLAKE:WORKER:");
        long dataCenterId = id / 31L;
        long workerId = id - 31L * dataCenterId;
        if (dataCenterId > 31L) {
            this.redis.incrReset("SNOWFLAKE:WORKER:");
            return this.getSnowflakeModule();
        }
        return new SnowflakeMoudle(workerId, dataCenterId);
    }

    public class SnowflakeMoudle {
        private Long workerId;
        private Long dataCenterId;

        public Long getWorkerId() {
            return this.workerId;
        }

        public Long getDataCenterId() {
            return this.dataCenterId;
        }

        public void setWorkerId(Long workerId) {
            this.workerId = workerId;
        }

        public void setDataCenterId(Long dataCenterId) {
            this.dataCenterId = dataCenterId;
        }

        public SnowflakeMoudle(Long workerId, Long dataCenterId) {
            this.workerId = workerId;
            this.dataCenterId = dataCenterId;
        }
    }
}

