/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.util;

import com.dicchina.core.util.CommonUtil;
import org.apache.commons.lang3.StringUtils;

public class DesensitizationUtil {
    public static String left(String fullName, int index) {
        if (CommonUtil.isBlank(fullName)) {
            return "";
        }
        String name = StringUtils.left((String)fullName, (int)index);
        return StringUtils.rightPad((String)name, (int)StringUtils.length((CharSequence)fullName), (String)"*");
    }

    public static String around(String name, int index, int end) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return "";
        }
        return StringUtils.left((String)name, (int)index).concat(StringUtils.removeStart((String)StringUtils.leftPad((String)StringUtils.right((String)name, (int)end), (int)StringUtils.length((CharSequence)name), (String)"*"), (String)"***"));
    }

    public static String right(String num, int end) {
        if (StringUtils.isBlank((CharSequence)num)) {
            return "";
        }
        return StringUtils.leftPad((String)StringUtils.right((String)num, (int)end), (int)StringUtils.length((CharSequence)num), (String)"*");
    }

    public static String mobileEncrypt(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile) || mobile.length() != 11) {
            return mobile;
        }
        return mobile.replaceAll("(\\d{3})\\d{4}(\\d{4})", "$1****$2");
    }

    public static String idEncrypt(String id) {
        if (StringUtils.isEmpty((CharSequence)id) || id.length() < 8) {
            return id;
        }
        return id.replaceAll("(?<=\\w{3})\\w(?=\\w{4})", "*");
    }

    public static String idPassport(String id) {
        if (StringUtils.isEmpty((CharSequence)id) || id.length() < 8) {
            return id;
        }
        return id.substring(0, 2) + new String(new char[id.length() - 5]).replace("\u0000", "*") + id.substring(id.length() - 3);
    }

    public static String idPassport(String id, int sensitiveSize) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return "";
        }
        int length = StringUtils.length((CharSequence)id);
        return StringUtils.rightPad((String)StringUtils.left((String)id, (int)(length - sensitiveSize)), (int)length, (String)"*");
    }
}

