/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.stereotype.Component;

@Component
public class RedisUtil {
    private static final Logger log = LoggerFactory.getLogger(RedisUtil.class);
    @Resource
    private RedisTemplate<String, String> redis;

    public boolean lock(String key, long timeout) {
        return this.setNX(key, key, timeout);
    }

    public void unlock(String key) {
        this.deleteRedis(key);
    }

    public Long incr(String key, long timeout) {
        return (Long)this.redis.execute(connection -> {
            Long i = connection.incr(key.getBytes());
            connection.expire(key.getBytes(), timeout);
            connection.close();
            return i;
        });
    }

    public Long incr(String key) {
        return (Long)this.redis.execute(connection -> {
            Long i = connection.incr(key.getBytes());
            connection.close();
            return i;
        });
    }

    public void incrReset(String key) {
        this.redis.execute(connection -> {
            connection.del((byte[][])new byte[][]{key.getBytes()});
            connection.close();
            return null;
        });
    }

    private Boolean setNX(String key, String value, long timeout) {
        Boolean res = false;
        try {
            if (this.getExpire(key) == -1L) {
                this.deleteRedis(key);
            }
            res = (Boolean)this.redis.execute(connection -> {
                Boolean t = connection.setNX(key.getBytes(), value.getBytes());
                if (t != null && t.booleanValue()) {
                    connection.expire(key.getBytes(), timeout);
                }
                connection.close();
                return t;
            });
        }
        catch (Exception e) {
            log.error("setNX redis error, key : {}", (Object)key);
        }
        return res;
    }

    public void setRedisForHash(String key, Map<?, ?> value, long timeout, TimeUnit unit) {
        this.redis.opsForHash().putAll((Object)key, value);
        this.redis.expire((Object)key, timeout, unit);
    }

    public void setRedisForSet(String key, Set<String> value, long timeout, TimeUnit unit) {
        value.forEach(v -> this.redis.opsForSet().add((Object)key, (Object[])new String[]{v}));
        this.redis.expire((Object)key, timeout, unit);
    }

    public void setRedisForSet(String key, Set<String> value) {
        value.forEach(v -> this.redis.opsForSet().add((Object)key, (Object[])new String[]{v}));
    }

    public void reSetRedis(String key, String value) {
        Long m = this.redis.getExpire((Object)key, TimeUnit.MINUTES);
        if (m > 0L) {
            this.redis.opsForValue().set((Object)key, (Object)value, m.longValue(), TimeUnit.MINUTES);
        }
    }

    public Set<String> getRedisKeys(String pattern) {
        return this.redis.keys((Object)(pattern + "*"));
    }

    public String getRedis(String key) {
        return (String)this.redis.opsForValue().get((Object)key);
    }

    public String getRedisFallBack(String key) {
        log.warn("Redis\u964d\u7ea7\u5904\u7406!!!key={}", (Object)key);
        return null;
    }

    public Map getRedisForHash(String key) {
        return this.redis.opsForHash().entries((Object)key);
    }

    public Set<String> getRedisForSet(String key) {
        return this.redis.opsForSet().members((Object)key);
    }

    public void deleteRedis(String key) {
        this.redis.delete((Object)key);
    }

    public void deleteRedis(Collection<String> keys) {
        this.redis.delete(keys);
    }

    public void deleteRedisBatch(String pattern) {
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            this.redis.delete((Object)key);
        });
    }

    public void expiredRedisBatch(String pattern) {
        this.scan(pattern, item -> {
            String key = new String((byte[])item, StandardCharsets.UTF_8);
            String content = (String)this.redis.opsForValue().get((Object)key);
            this.redis.opsForValue().set((Object)key, (Object)content, 100L, TimeUnit.MILLISECONDS);
        });
    }

    private void scan(String pattern, Consumer<byte[]> consumer) {
        this.redis.execute(connection -> {
            try (Cursor cursor = connection.scan(ScanOptions.scanOptions().count(Long.MAX_VALUE).match(pattern).build());){
                cursor.forEachRemaining(consumer);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            return null;
        });
    }

    public void setRedis(String key, String value) {
        this.redis.opsForValue().set((Object)key, (Object)value);
    }

    public Long getExpire(String key, TimeUnit timeUnit) {
        return this.redis.getExpire((Object)key, timeUnit);
    }

    public Long getExpire(String key) {
        return this.redis.getExpire((Object)key);
    }

    public void setRedis(String key, String value, long timeout, TimeUnit unit) {
        this.redis.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public Long increment(String key, long number) {
        return this.redis.opsForValue().increment((Object)key, number);
    }

    public Long decrement(String key, long number) {
        return this.redis.opsForValue().decrement((Object)key, number);
    }

    public synchronized String getSendSequenceId(String keyName, int length) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateStr = sdf.format(new Date());
        String redisKey = keyName + dateStr;
        if (this.redis.hasKey((Object)redisKey).booleanValue()) {
            this.redis.opsForValue().increment((Object)redisKey);
        } else {
            this.redis.opsForValue().set((Object)redisKey, (Object)"1", 1L, TimeUnit.DAYS);
        }
        return this.getNullBit(dateStr, (String)this.redis.opsForValue().get((Object)redisKey), length);
    }

    public String getNullBit(String dateStr, String str, int length) {
        if (str != null) {
            int minus = length - str.length();
            for (int x = 0; x < minus; ++x) {
                str = "0" + str;
            }
        }
        return dateStr + "_" + str;
    }

    public synchronized String getOrderSequenceId(String keyName, int length) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateStr = sdf.format(new Date());
        String redisKey = keyName + dateStr;
        if (this.redis.hasKey((Object)redisKey).booleanValue()) {
            this.redis.opsForValue().increment((Object)redisKey);
        } else {
            this.redis.opsForValue().set((Object)redisKey, (Object)"1", 1L, TimeUnit.DAYS);
        }
        return this.getOrderNullBit(dateStr, (String)this.redis.opsForValue().get((Object)redisKey), length);
    }

    public String getOrderNullBit(String dateStr, String str, int length) {
        if (str != null) {
            int minus = length - str.length();
            for (int x = 0; x < minus; ++x) {
                str = "0" + str;
            }
        }
        return dateStr + str;
    }
}

