/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.base.page;

import com.alibaba.fastjson.JSONObject;
import com.dicchina.core.base.page.PageDomain;
import com.dicchina.core.base.page.TableDataInfo;
import com.dicchina.core.base.page.TableSupport;
import com.dicchina.core.util.StringUtils;
import com.dicchina.core.util.sql.SqlUtil;
import com.github.pagehelper.PageInfo;

public final class PageHelper {
    private static final String DEFAULT_PAGE_NUM = "1";
    private static final String DEFAULT_PAGE_SIZE = "10";

    public static void startPage() {
        PageDomain pageDomain = TableSupport.buildPageRequest();
        Integer pageNum = pageDomain.getPageNum();
        Integer pageSize = pageDomain.getPageSize();
        if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
            String orderBy = SqlUtil.escapeOrderBySql(pageDomain.getOrderBy());
            com.github.pagehelper.PageHelper.startPage((int)pageNum, (int)pageSize, (String)orderBy);
        }
    }

    public static void starPageByDefault(JSONObject paramJson) {
        if (paramJson != null) {
            String pageNum = paramJson.getString("pageNum");
            pageNum = StringUtils.isNotEmpty(pageNum) ? pageNum : DEFAULT_PAGE_NUM;
            String pageSize = paramJson.getString("pageSize");
            pageSize = StringUtils.isNotEmpty(pageSize) ? pageSize : DEFAULT_PAGE_SIZE;
            PageHelper.startPage(pageNum, pageSize);
        } else {
            PageHelper.startPage(DEFAULT_PAGE_NUM, DEFAULT_PAGE_SIZE);
        }
    }

    public static void startPage(String pageNum, String pageSize) {
        if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
            String orderBy = SqlUtil.escapeOrderBySql("");
            PageHelper.startPage(pageNum, pageSize, orderBy);
        }
    }

    public static void startPage(String pageNum, String pageSize, String orderBy) {
        if (StringUtils.isNotNull(pageNum) && StringUtils.isNotNull(pageSize)) {
            com.github.pagehelper.PageHelper.startPage((int)Integer.parseInt(pageNum), (int)Integer.parseInt(pageSize), (String)orderBy);
        }
    }

    public static TableDataInfo getTableDataInfo(PageInfo<?> pageInfo) {
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setRows(pageInfo.getList());
        rspData.setTotal(pageInfo.getTotal());
        return rspData;
    }
}

