/*
 * Decompiled with CFR 0.152.
 */
package com.dicchina.core.util;

import com.dicchina.core.base.text.StrFormatter;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Map;

public class StringUtils
extends org.apache.commons.lang3.StringUtils {
    public static final DecimalFormat NF4 = new DecimalFormat("#####0.0000");
    private static final String NULLSTR = "";
    private static final char SEPARATOR = '_';
    private static final String NULL_STRING = "";
    private static final DecimalFormat NF = new DecimalFormat("#####0.00");

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StringUtils.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !StringUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Object[] objects) {
        return StringUtils.isNull(objects) || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !StringUtils.isEmpty(objects);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return StringUtils.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StringUtils.isEmpty(map);
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isNull(str) || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isNotNull(Object object) {
        return !StringUtils.isNull(object);
    }

    public static boolean isArray(Object object) {
        return StringUtils.isNotNull(object) && object.getClass().isArray();
    }

    public static String trim(String str) {
        return str == null ? "" : str.trim();
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return "";
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return "";
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return "";
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return "";
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static String format(String template, Object ... params) {
        if (StringUtils.isEmpty(params) || StringUtils.isEmpty(template)) {
            return template;
        }
        return StrFormatter.format(template, params);
    }

    public static String toUnderScoreCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean preCharIsUpperCase = true;
        boolean curreCharIsUpperCase = true;
        boolean nexteCharIsUpperCase = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            preCharIsUpperCase = i > 0 ? Character.isUpperCase(str.charAt(i - 1)) : false;
            curreCharIsUpperCase = Character.isUpperCase(c);
            if (i < str.length() - 1) {
                nexteCharIsUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (preCharIsUpperCase && curreCharIsUpperCase && !nexteCharIsUpperCase) {
                sb.append('_');
            } else if (i != 0 && !preCharIsUpperCase && curreCharIsUpperCase) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return "";
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static String killNull(Object o, String ds) {
        if (o instanceof Double) {
            return o != null ? String.valueOf(o) : ds;
        }
        return o != null ? o.toString() : ds;
    }

    public static String killNull(Object o) {
        return StringUtils.killNull(o, "");
    }

    public static String killNull(Double o, String ds) {
        if (o != null) {
            return NF.format(o);
        }
        return ds;
    }

    public static String killNull(Double o) {
        return StringUtils.killNull(o, "");
    }

    public static String killNull(double o) {
        if (o != 0.0) {
            return NF.format(o);
        }
        return "";
    }

    public static String killNull(BigDecimal o) {
        return StringUtils.killNull(o, "");
    }

    public static String killNull(BigDecimal o, DecimalFormat df) {
        if (o == null) {
            return "";
        }
        return NF4.format(o.doubleValue());
    }

    public static String killNull(BigDecimal o, String nullString) {
        if (o != null) {
            return NF.format(o.doubleValue());
        }
        if ("".equals(nullString)) {
            return "";
        }
        return "0";
    }

    public static String killNull(long o) {
        return String.valueOf(o);
    }

    public static boolean isEmpty(Object emptyObect) {
        boolean result = true;
        if (emptyObect == null) {
            return true;
        }
        result = emptyObect instanceof String ? emptyObect.toString().trim().length() == 0 || "null".equals(emptyObect.toString().trim()) : (emptyObect instanceof Collection ? ((Collection)emptyObect).size() == 0 : emptyObect == null || emptyObect.toString().trim().length() < 1);
        return result;
    }
}

