/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class CommUtils {
    public static boolean isEmpty(String st) {
        return null == st || "".equals(st);
    }

    public static boolean isNotEmpty(String st) {
        return !CommUtils.isEmpty(st);
    }

    public static String toStr(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString().trim();
    }

    public static int toInt(Object obj) {
        try {
            if (obj == null || obj.toString().equals("")) {
                return 0;
            }
            return Integer.parseInt(obj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static String getDateString(Date source, String format) {
        if (source == null) {
            return "";
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            return formatter.format(source);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static Date getDateString(String date, String format) {
        try {
            if (CommUtils.isEmpty(date)) {
                return null;
            }
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            return formatter.parse(date);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getDateAfterMonth(Date date, int month) {
        if (CommUtils.isNull(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, month);
        return new SimpleDateFormat("yyyy-MM-dd").format(cal.getTime());
    }

    public static Long getDateAfterHour(Date date, int hour) {
        if (CommUtils.isNull(date)) {
            return 0L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        long time = cal.getTimeInMillis() + (long)(hour * 60 * 60 * 1000);
        return time;
    }

    public static Long getCurrDateTimeInMillis(Date date) {
        if (CommUtils.isNull(date)) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getTimeInMillis();
    }

    public static String getRandom(int count) {
        Random random = new Random();
        String strNum = "";
        while ((strNum = strNum + random.nextInt(10)).length() != count) {
        }
        return strNum;
    }

    public static String encodeUrl(String encodeURL, String charsetEncode) {
        String url = "";
        if (CommUtils.isEmpty(encodeURL) || CommUtils.isEmpty(charsetEncode)) {
            return url;
        }
        try {
            url = URLEncoder.encode(encodeURL, charsetEncode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static String encodeUrl(String encodeURL) {
        return CommUtils.encodeUrl(encodeURL, "utf-8");
    }

    public static String decodeUrl(String decodeURL, String charsetEncode) {
        String url = "";
        if (CommUtils.isEmpty(decodeURL) || CommUtils.isEmpty(charsetEncode)) {
            return url;
        }
        try {
            url = URLDecoder.decode(decodeURL, charsetEncode);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return url;
    }

    public static String decodeUrl(String decodeURL) {
        return CommUtils.decodeUrl(decodeURL, "utf-8");
    }

    public static String getWebRootPath() {
        String classPath = Thread.currentThread().getContextClassLoader().getResource("/").getPath();
        int webinf = classPath.indexOf("WEB-INF");
        return classPath.substring(0, webinf);
    }

    public static String escapeHtml(String str) {
        if (CommUtils.isEmpty(str)) {
            return "";
        }
        str = str.trim();
        str = str.replaceAll("&", "&amp;");
        str = str.replaceAll("\"", "&quot;");
        str = str.replaceAll(" ", "&nbsp;");
        str = str.replaceAll("\\*", "&#42;");
        str = str.replaceAll("<", "&lt;");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("'", "&#039;");
        str = str.replaceAll("\r\n", "<br/>");
        str = str.replaceAll("\n", "<br/>");
        str = str.replaceAll("\r", "<br/>");
        str = str.replaceAll("\\(", "&#40;");
        str = str.replaceAll("\\)", "&#41;");
        str = str.replaceAll("\\{", "&#123;");
        str = str.replaceAll("\\}", "&#125;");
        str = str.replaceAll("\\[", "&#91;");
        str = str.replaceAll("\\]", "&#93;");
        str = str.replaceAll("style", "");
        return str;
    }

    public static String rhtml(String content) {
        if (StringUtils.isBlank((String)content)) {
            return content;
        }
        String html = content;
        html = StringUtils.replace((String)html, (String)"&amp;", (String)"&");
        html = StringUtils.replace((String)html, (String)"&lt;", (String)"<");
        html = StringUtils.replace((String)html, (String)"&gt;", (String)">");
        html = StringUtils.replace((String)html, (String)"&nbsp;", (String)" ");
        html = StringUtils.replace((String)html, (String)"<!--#if-->", (String)"</#if>");
        return html;
    }

    public static boolean isNull(Object obj) {
        if (obj == null) {
            return true;
        }
        String szTmp = obj.toString();
        return szTmp.equals("") || szTmp.equalsIgnoreCase("null");
    }

    public static String getRealRemoteIP(HttpServletRequest request) {
        String ret = "";
        String cdnSrcIp = request.getHeader("Cdn-Src-Ip");
        if (cdnSrcIp == null) {
            String ipNginx = request.getHeader("X_REAL_IP");
            String ip = null;
            ip = ipNginx != null ? ipNginx : request.getRemoteAddr();
            if (ip != null) {
                ret = ip;
            }
        } else {
            ret = cdnSrcIp.trim();
        }
        if (ret.startsWith("0:0:0:0:")) {
            ret = "127.0.0.1";
        }
        return ret;
    }

    public static int getPwdIntensiion(String pwd) {
        int score = 0;
        Pattern p1 = Pattern.compile("[a-z]+");
        Pattern p2 = Pattern.compile("[A-Z]+");
        Pattern p3 = Pattern.compile("\\d+");
        Pattern p4 = Pattern.compile("[!,@,#,$,%,^,&,*,?,_,~]+");
        Matcher m1 = p1.matcher(pwd);
        Matcher m2 = p2.matcher(pwd);
        Matcher m3 = p3.matcher(pwd);
        Matcher m4 = p4.matcher(pwd);
        if (pwd.length() > 2) {
            if (m1.find() && m3.find() && pwd.length() > 13) {
                score += 5;
            }
            if (m2.find() && m3.find()) {
                score += 7;
            }
            if (m1.find() && m2.find()) {
                score += 7;
            }
            if (m1.find() && m2.find() && m3.find()) {
                score += 10;
            }
            if (m4.find()) {
                score += 15;
            }
            if (m1.find() && m3.find() && pwd.length() > 12) {
                score += 10;
            }
            if (m2.find() && m3.find() && pwd.length() > 12) {
                score += 10;
            }
        }
        if (score < 5) {
            return 0;
        }
        if (score >= 5 && score < 20) {
            return 1;
        }
        if (score >= 20) {
            return 2;
        }
        return 0;
    }

    public static String getUserOsInfo(HttpServletRequest request) {
        String Agent = request.getHeader("User-Agent");
        StringTokenizer st = new StringTokenizer(Agent, ";");
        st.nextToken();
        String userbrowser = st.nextToken();
        String useros = st.nextToken();
        return useros;
    }
}

