/*
 * Decompiled with CFR 0.152.
 */
package com.dragon.tools.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookiesUtil {
    private static int iDefaultValidSecond = -1;

    public static void crossDomainPut(HttpServletResponse response, String name, String value) {
        CookiesUtil.setP3PHeader(response);
        CookiesUtil.put(response, name, value, "/", iDefaultValidSecond);
    }

    public static void crossDomainPut(HttpServletResponse response, String name, String value, int ttl) {
        CookiesUtil.setP3PHeader(response);
        CookiesUtil.put(response, name, value, ttl);
    }

    private static void setP3PHeader(HttpServletResponse response) {
        response.setHeader("P3P", "CP=\"CURa ADMa DEVa PSAo PSDo OUR BUS UNI PUR INT DEM STA PRE COM NAV OTC NOI DSP COR\"");
    }

    public static void put(HttpServletResponse response, String name, String value) {
        CookiesUtil.put(response, name, value, "/", iDefaultValidSecond);
    }

    public static void put(HttpServletResponse response, String name, String value, int ttl) {
        CookiesUtil.put(response, name, value, "/", ttl);
    }

    public static void put(HttpServletResponse response, String name, String value, String path, int ttl) {
        try {
            Cookie cookie = new Cookie(name, CookiesUtil.encode(value));
            cookie.setPath(path);
            cookie.setMaxAge(ttl);
            response.addCookie(cookie);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String get(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return "";
        }
        String result = "";
        try {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(name)) continue;
                result = cookies[i].getValue();
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return CookiesUtil.decode(result);
    }

    public static void remove(HttpServletResponse response, String name) {
        CookiesUtil.put(response, name, null, 0);
    }

    public static void removeAll(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            try {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = new Cookie(cookies[i].getName(), null);
                    cookie.setPath("/");
                    cookie.setMaxAge(0);
                    response.addCookie(cookie);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String encode(String value) {
        String result = "";
        if (!CookiesUtil.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static String decode(String value) {
        String result = "";
        if (!CookiesUtil.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().equals("");
    }
}

